/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sabre.getReservation;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.gds.model.AircraftSeatReservationParameters;
import com.gridnine.xtrip.common.gds.model.FareDetails;
import com.gridnine.xtrip.common.gds.model.GdsTraveller;
import com.gridnine.xtrip.common.gds.model.OBFeesInfo;
import com.gridnine.xtrip.common.gds.sabre.helpers.SabreHelper;
import com.gridnine.xtrip.common.gds.sabre.helpers.SabreRemarksSearchContext;
import com.gridnine.xtrip.common.incidents.IncidentsLog;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.Segment;
import com.gridnine.xtrip.common.model.booking.air.SegmentTariff;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.gds.ExtendedLuggageInfo;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.parsers.model.IBusParsersContextKeys;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.XCloneHelper;
import com.gridnine.xtrip.common.util.XCloneable;
import com.gridnine.xtrip.common.util.XSSerializable;
import com.gridnine.xtrip.common.xml.XSUtil;
import com.gridnine.xtrip.server.gds.helper.GDSHelper;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.gds.sabre.IBusGdsSabreContextKeys;
import com.gridnine.xtrip.server.gds.sabre.getReservation.GetReservationHelper;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.sabre.ns.ticketing.pqs.PriceQuoteDetails;
import com.sabre.ns.ticketing.pqs.PriceQuoteDetailsSegmentInfo;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.time.FastDateFormat;

public class GetReservationProductParser
extends BaseProcessor {
    private static final FastDateFormat DF = FastDateFormat.getInstance((String)"yyyy-MM-dd");

    public void process(MessageContext ctx) throws Exception {
        Reservation reservation = (Reservation)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION);
        Map endorsements = (Map)ctx.getMandatoryObject((Enum)IBusGdsSabreContextKeys.ENDORSEMENTS);
        PriceQuoteDetails pq = (PriceQuoteDetails)ctx.getMandatoryObject((Enum)IBusGdsSabreContextKeys.PRICE_QUOTE);
        GdsTraveller gdsTraveller = (GdsTraveller)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.GDS_TRAVELLER);
        Traveller traveller = (Traveller)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.TRAVELLER);
        Product productTemplate = (Product)ctx.getMandatoryObject((Enum)IBusGdsSabreContextKeys.PRODUCT_TEMPLATE);
        List segments = (List)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.SEGMENTS);
        Map nameNumbers = (Map)ctx.getMandatoryObject((Enum)IBusGdsSabreContextKeys.NAME_NUMBERS);
        String fareCalcLine = (String)ctx.getMandatoryObject((Enum)IBusParsersContextKeys.CALCULATION_LINE);
        Map cabinInfo = (Map)ctx.getMandatoryObject((Enum)IBusGdsSabreContextKeys.CABIN_INFO);
        Map luggageInfo = (Map)ctx.getMandatoryObject((Enum)IBusGdsSabreContextKeys.LUGGAGE_INFO);
        Map cabinLuggageInfo = (Map)ctx.getMandatoryObject((Enum)IBusGdsSabreContextKeys.CABIN_LUGGAGE_INFO);
        Product product = this.parseProduct(pq, gdsTraveller, traveller, productTemplate, segments, nameNumbers, fareCalcLine, endorsements, cabinInfo, luggageInfo, cabinLuggageInfo);
        product.setReservation(reservation);
        reservation.getProducts().add(product);
        ctx.putObject((Enum)IBusGdsContextKeys.PRODUCT, (Object)product);
    }

    private Product parseProduct(PriceQuoteDetails pq, GdsTraveller gdsTraveller, Traveller traveller, Product productTemplate, List<Segment> segments, Map<String, String> nameNumbers, String fareCalcLine, Map<String, String> endorsements, Map<String, List<String>> cabinInfo, Map<String, Map<List<String>, ExtendedLuggageInfo>> luggageInfo, Map<String, Map<List<String>, ExtendedLuggageInfo>> cabinLuggageInfo) throws Exception {
        String passengerTypeCode = SabreHelper.getNativeCode((DictionaryReference)gdsTraveller.getPassengerType());
        List flightSegments = pq.getSegmentInfoList();
        Product product = (Product)XCloneHelper.clone((XCloneable)productTemplate, (boolean)true);
        String nameNumber = nameNumbers.get(gdsTraveller.getTravellerUid());
        product.setGdsId(nameNumber);
        ProductHandler.of((BaseProduct)product).setOrReplaceTraveller((BaseProduct)product, traveller);
        product.setPassengerType(gdsTraveller.getPassengerType());
        product.setPrivateFare(pq.getFareInfo().getFareIndicators().getPrivateFareType() != null);
        product.setFareCalculationData(fareCalcLine);
        product.setEndorsement(GetReservationHelper.buildProductEndorsement(pq, endorsements.get(traveller.getUid())));
        if (pq.getMiscellaneousInfo() != null && pq.getMiscellaneousInfo().getTourNumber() != null) {
            product.setFareOverlay(GetReservationHelper.parseFareOverlay(pq));
            product.setTourCode(pq.getMiscellaneousInfo().getTourNumber().getString());
        }
        List segmentTariffs = GDSHelper.buildSegmentTariffs(segments, (String)fareCalcLine);
        for (SegmentTariff st : segmentTariffs) {
            product.getSegmentTariffs().add(XCloneHelper.clone((XCloneable)st, (boolean)true));
        }
        Iterator<String> cabinsItr = cabinInfo.get(SabreHelper.getNativeCode((DictionaryReference)product.getPassengerType())).iterator();
        Map<List<String>, ExtendedLuggageInfo> ptcLuggageInfo = luggageInfo.get(passengerTypeCode);
        Map<List<String>, ExtendedLuggageInfo> ptcCabinLuggageInfo = cabinLuggageInfo.get(passengerTypeCode);
        for (SegmentTariff st : product.getSegmentTariffs()) {
            for (Segment s : st.getSegments()) {
                for (AircraftSeatReservationParameters seatParams : gdsTraveller.getSeatsReservationParameters()) {
                    if (!s.getGdsId().equals(seatParams.getSegmentId())) continue;
                    s.setSeatNo(seatParams.getSeatNumber());
                    break;
                }
                PriceQuoteDetailsSegmentInfo flightSegment = flightSegments.stream().filter(seg -> seg.getNumber().toString().equals(s.getGdsId())).findFirst().get();
                LocalDateTime inputDate = LocalDateTime.parse(flightSegment.getFlight().getDeparture().getDateTime());
                if (!SabreHelper.isCertComplianceMode() && !MiscUtil.equals((Object)s.getStartDate(), (Object)Date.from(inputDate.atZone(ZoneId.systemDefault()).toInstant()))) {
                    throw new Xeption(L10nResourcesManager.createL10nMessage((String)"\u041d\u0435 \u043f\u043e\u0434\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u043e \u0432\u0440\u0435\u043c\u044f \u0432\u044b\u043b\u0435\u0442\u0430 \u043d\u0430 \u043e\u0434\u043d\u043e\u043c \u0438\u0437 \u0441\u0435\u0433\u043c\u0435\u043d\u0442\u043e\u0432. \u041d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u043e \u0441\u0434\u0435\u043b\u0430\u0442\u044c \u043d\u043e\u0432\u044b\u0439 \u043f\u043e\u0438\u0441\u043a \u0440\u0435\u0439\u0441\u043e\u0432", (Object[])new Object[0]), null, "itin and pq departure time miscompare", null);
                }
                if (flightSegment.getBaggage() != null && flightSegment.getBaggage().getAllowance() != null) {
                    s.setLuggageInfo(GetReservationHelper.prepareLuggageInfo(flightSegment.getBaggage()));
                }
                Map<String, String> data = GetReservationHelper.getBrandIds(pq);
                String brandId = data.getOrDefault(s.getGdsId(), null);
                GDSHelper.setBrandId((Segment)s, (String)brandId);
                s.setFareBasis(flightSegment.getFareBasis());
                s.setNotValidBefore((Date)flightSegment.getNotValidBefore());
                s.setNotValidAfter((Date)flightSegment.getNotValidAfter());
                SabreRemarksSearchContext ctx = new SabreRemarksSearchContext();
                ctx.setSegNumber(s.getGdsId());
                ctx.setPType(passengerTypeCode);
                s.setRemarksSearchContext(XSUtil.toString((XSSerializable)ctx));
                s.setServiceClass(SabreHelper.cabin2ClassOfService((String)cabinsItr.next()));
                if (ptcLuggageInfo == null && ptcCabinLuggageInfo == null) continue;
                try {
                    List<String> key = Arrays.asList(SabreHelper.getNativeCode((DictionaryReference)s.getAirline()), DF.format(s.getStartDate()), s.getFlightNo(), SabreHelper.getNativeCode((DictionaryReference)s.getDepartureLocation()), SabreHelper.getNativeCode((DictionaryReference)s.getArriveLocation()));
                    if (s.getFareDetails() == null) {
                        s.setFareDetails(new FareDetails());
                    }
                    if (ptcLuggageInfo != null) {
                        s.getFareDetails().setLuggageInfo(ptcLuggageInfo.get(key));
                    }
                    if (ptcCabinLuggageInfo == null) continue;
                    s.getFareDetails().setCabinLuggageInfo(ptcCabinLuggageInfo.get(key));
                }
                catch (Exception ex) {
                    IncidentsLog.reportException((String)"failed populating luggage/cabin luggage info", (Throwable)ex);
                }
            }
        }
        Money m = new Money();
        m.setCurrency(pq.getFareInfo().getBaseFare().getCurrencyCode());
        m.setValue(new BigDecimal(pq.getFareInfo().getBaseFare().getString()));
        AirProductHelper.setBaseFare((Product)product, (Money)m);
        AirProductHelper.setEquivalentFare((Product)product, (BigDecimal)GetReservationHelper.parseEquivalentFare(pq));
        if (product.getGdsCurrency() == null) {
            product.setGdsCurrency(pq.getFareInfo().getTotalFare().getCurrencyCode());
        }
        for (GetReservationHelper.TaxAbstraction ta : GetReservationHelper.parseTaxes(pq.getFareInfo().getTaxInfo())) {
            product.getTaxes().add(ta.toProductTax());
        }
        OBFeesInfo obFeesInfo = new OBFeesInfo();
        if (GetReservationHelper.parseObFeesInfo(pq, obFeesInfo)) {
            product.setObFeesInfo(obFeesInfo);
        }
        return product;
    }
}

