/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sabre.getReservation;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.gds.sabre.helpers.SabreHelper;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.server.gds.sabre.core.IbusGdsSabreCoreContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.sabre.webservices.pnrbuilder.v119.GetReservationRQ;
import com.sabre.webservices.pnrbuilder.v119.ReturnOptionsPNRB;
import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;

public class GetReservationRQBuilder
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        Reservation reservation = (Reservation)ctx.getObject((Enum)IBusMidofficeContextKeys.RESERVATION);
        GetReservationRQ request = reservation != null ? this.buildRequest(reservation) : this.buildRequest();
        ctx.putObject((Enum)IbusGdsSabreCoreContextKeys.SABRE_WS_REQUEST_PAYLOAD, (Object)request);
        ctx.putObject((Enum)IbusGdsSabreCoreContextKeys.SABRE_WS_SERVICE_ACTION_CODE, (Object)"getReservationRQ");
    }

    private GetReservationRQ buildRequest(Reservation reservation) {
        GetReservationRQ request = new GetReservationRQ();
        request.setVersion("1.19.11");
        ReturnOptionsPNRB ro = new ReturnOptionsPNRB();
        ro.setViewName("Full");
        ro.setResponseFormat("STL");
        ro.setPriceQuoteServiceVersion("4.1.0");
        ro.setSubjectAreas(new ReturnOptionsPNRB.SubjectAreas());
        ro.getSubjectAreas().setSubjectAreaList(new ArrayList());
        ro.getSubjectAreas().getSubjectAreaList().add("PRICE_QUOTE");
        ro.getSubjectAreas().getSubjectAreaList().add("REMARK_ACTION_CODE");
        ro.getSubjectAreas().getSubjectAreaList().add("ADD_ACCOUNTING_LINE_NAME_NUMBER");
        ro.getSubjectAreas().getSubjectAreaList().add("ACCOUNTING_LINE");
        request.setReturnOptions(ro);
        if (reservation != null) {
            String recordLocator = SabreHelper.getRecordLocator((Reservation)reservation);
            if (StringUtils.isBlank((String)recordLocator)) {
                throw Xeption.forAdmin((String)"\u0412 \u0431\u0440\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0438 \u043d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d PNR, \u043e\u043f\u0435\u0440\u0430\u0446\u0438\u044f \u043d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u0430", (Object[])new Object[0]);
            }
            request.setLocator(recordLocator);
            request.setRequestType("Stateful");
        }
        return request;
    }

    private GetReservationRQ buildRequest() {
        GetReservationRQ request = new GetReservationRQ();
        request.setVersion("1.19.11");
        ReturnOptionsPNRB ro = new ReturnOptionsPNRB();
        ro.setViewName("Full");
        ro.setResponseFormat("STL");
        ro.setPriceQuoteServiceVersion("4.1.0");
        ro.setSubjectAreas(new ReturnOptionsPNRB.SubjectAreas());
        ro.getSubjectAreas().setSubjectAreaList(new ArrayList());
        ro.getSubjectAreas().getSubjectAreaList().add("PRICE_QUOTE");
        ro.getSubjectAreas().getSubjectAreaList().add("REMARK_ACTION_CODE");
        request.setReturnOptions(ro);
        request.setRequestType("Stateful");
        return request;
    }
}

