/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sabre.getReservation;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.gds.helper.PccHelper;
import com.gridnine.xtrip.common.gds.model.Flight;
import com.gridnine.xtrip.common.gds.model.GDSParameters;
import com.gridnine.xtrip.common.gds.sabre.helpers.SabreHelper;
import com.gridnine.xtrip.common.gds.sabre.model.SabreGdsAccount;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.RecordLocatorType;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.ReservationRemark;
import com.gridnine.xtrip.common.model.booking.SalesOriginContent;
import com.gridnine.xtrip.common.model.booking.SalesOriginProvider;
import com.gridnine.xtrip.common.model.booking.StatisticalData;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.common.model.dict.TariffType;
import com.gridnine.xtrip.common.model.gds.SpecialTariff;
import com.gridnine.xtrip.common.model.helpers.CommonReservationGdsNameInfoHelper;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.gds.sabre.IBusGdsSabreContextKeys;
import com.gridnine.xtrip.server.gds.sabre.core.IbusGdsSabreCoreContextKeys;
import com.gridnine.xtrip.server.gds.sabre.getReservation.GetReservationHelper;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.sabre.ns.ticketing.pqs.PriceQuoteDetails;
import com.sabre.webservices.pnrbuilder.v119.GetReservationRSType;
import com.sabre.webservices.pnrbuilder.v119.RemarkPNRB;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class GetReservationReservationParser
extends BaseProcessor {
    public void process(MessageContext ctx) {
        Flight flight = (Flight)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.FLIGHT);
        GetReservationRSType response = (GetReservationRSType)ctx.getMandatoryObject((Enum)IbusGdsSabreCoreContextKeys.SABRE_WS_RESPONSE_PAYLOAD);
        EntityContainer gdsAccountCtr = (EntityContainer)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.GDS_ACCOUNT);
        GDSParameters gdsParameters = (GDSParameters)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.GDS_PARAMETERS);
        StatisticalData statData = (StatisticalData)ctx.getObject((Enum)IBusGdsContextKeys.STATISTICAL_DATA);
        EntityReference specialTariffRef = flight.getSpecialTariff();
        Reservation reservation = this.parseReservation(response, flight, gdsParameters, statData, (EntityReference<SpecialTariff>)specialTariffRef, (EntityContainer<SabreGdsAccount>)gdsAccountCtr, ctx);
        ctx.putObject((Enum)IBusMidofficeContextKeys.RESERVATION, (Object)reservation);
    }

    private Reservation parseReservation(GetReservationRSType response, Flight flight, GDSParameters gdsParameters, StatisticalData statData, EntityReference<SpecialTariff> specialTariffRef, EntityContainer<SabreGdsAccount> gdsAccountCtr, MessageContext ctx) {
        Date now = new Date();
        Reservation reservation = new Reservation();
        reservation.setAccountCode(flight.getAccountCode());
        reservation.setCorporateId(flight.getCorporateId());
        reservation.setSabreSmartPricePricing(flight.isSabreSmartPricePricing());
        reservation.getGdsNameInfo().setOnlineGdsAccount(gdsAccountCtr.toReference());
        reservation.setSpecialTariff(specialTariffRef);
        reservation.setPricingDate(now);
        CommonReservationGdsNameInfoHelper.setRecordLocator((Reservation)reservation, (GdsName)GdsName.SABRE, (RecordLocatorType)RecordLocatorType.DEFAULT, (String)response.getReservation().getBookingDetails().getRecordLocator());
        reservation.setRefreshFromGdsDate(now);
        reservation.setResDate(now);
        Object bookingPcc = PccHelper.getBookingPccCode((GDSParameters)gdsParameters);
        if (StringUtils.isBlank((String)bookingPcc)) {
            bookingPcc = ((SabreGdsAccount)gdsAccountCtr.getEntity()).getPrimaryPCC();
        }
        CommonReservationGdsNameInfoHelper.setBookingPcc((Reservation)reservation, (GdsName)GdsName.SABRE, (String)bookingPcc);
        if (response.getReservation().getRemarks() != null && response.getReservation().getRemarks().getRemarkList() != null) {
            for (RemarkPNRB remark : response.getReservation().getRemarks().getRemarkList()) {
                ReservationRemark rr = new ReservationRemark();
                rr.setRemarkText(GetReservationHelper.getRemarkText(remark));
                reservation.getReservationRemarks().add(rr);
            }
        }
        Product productTemplate = new Product();
        productTemplate.setSalesOriginContent(SalesOriginContent.SABRE);
        productTemplate.setSalesOriginProvider(SalesOriginProvider.SABRE);
        List<PriceQuoteDetails> validPQs = GetReservationHelper.getValidPriceQuotes(response);
        if (validPQs.isEmpty()) {
            throw Xeption.forEndUser((String)"\u0420\u0430\u0437\u0440\u044b\u0432 \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u044f \u0441 \u0441\u0438\u0441\u0442\u0435\u043c\u043e\u0439 \u0431\u0440\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f. \u041f\u043e\u0432\u0442\u043e\u0440\u0438\u0442\u0435 \u0437\u0430\u043f\u0440\u043e\u0441 \u0447\u0435\u0440\u0435\u0437 \u043d\u0435\u0441\u043a\u043e\u043b\u044c\u043a\u043e \u043c\u0438\u043d\u0443\u0442", (Object[])new Object[0]);
        }
        DictionaryReference carrierRef = SabreHelper.resolveNativeCode(Airline.class, (String)((String)validPQs.get(0).getMiscellaneousInfo().getValidatingCarrierList().get(0)));
        productTemplate.setBlankOwnerRef(gdsParameters.getBlankOwner());
        productTemplate.setCarrier(carrierRef);
        productTemplate.setProductCategory(ProductCategory.AIR);
        productTemplate.setTariffType(TariffType.REGULAR);
        if (statData != null) {
            productTemplate.setStatisticalData(statData);
        }
        if (!StringUtils.isBlank((String)reservation.getAccountCode()) || !StringUtils.isBlank((String)reservation.getCorporateId())) {
            productTemplate.getTripartiteContractDetails().setIssuedUnder3d(true);
        }
        ctx.putObject((Enum)IBusGdsSabreContextKeys.PRODUCT_TEMPLATE, (Object)productTemplate);
        return reservation;
    }
}

