/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sabre.getReservation;

import com.gridnine.xtrip.common.gds.helper.FlightHelper;
import com.gridnine.xtrip.common.gds.model.Flight;
import com.gridnine.xtrip.common.gds.model.FlightSegment;
import com.gridnine.xtrip.common.gds.sabre.helpers.SabreHelper;
import com.gridnine.xtrip.common.model.booking.air.Segment;
import com.gridnine.xtrip.common.model.dict.Aircraft;
import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.CodeSystem;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GeoLocation;
import com.gridnine.xtrip.common.model.dict.MealServiceIndicator;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.gds.sabre.IBusGdsSabreContextKeys;
import com.gridnine.xtrip.server.gds.sabre.core.IbusGdsSabreCoreContextKeys;
import com.gridnine.xtrip.server.gds.sabre.getReservation.GetReservationHelper;
import com.gridnine.xtrip.server.gds.sabre.searchFlights.SabreCustomPropertiesHelper;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.sabre.webservices.pnrbuilder.v119.AirType;
import com.sabre.webservices.pnrbuilder.v119.GetReservationRSType;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import org.apache.commons.lang.StringUtils;

public class GetReservationSegmentsParser
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        GetReservationRSType response = (GetReservationRSType)ctx.getMandatoryObject((Enum)IbusGdsSabreCoreContextKeys.SABRE_WS_RESPONSE_PAYLOAD);
        Flight flight = (Flight)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.FLIGHT);
        Map segmentGdsIds = (Map)ctx.getMandatoryObject((Enum)IBusGdsSabreContextKeys.SEGMENT_GDS_IDS);
        List<Segment> segments = this.parseSegments(response, flight, segmentGdsIds);
        ctx.putObject((Enum)IBusGdsContextKeys.SEGMENTS, segments);
    }

    private List<Segment> parseSegments(GetReservationRSType response, Flight flight, Map<String, String> segmentGdsIds) throws Exception {
        ArrayList<Segment> segments = new ArrayList<Segment>();
        int i = 0;
        List flightSegments = FlightHelper.getSegments((Flight)flight);
        for (AirType air : GetReservationHelper.getAirs(response)) {
            Set items;
            Segment s = new Segment();
            DictionaryReference marketingAirline = SabreHelper.resolveNativeCode(Airline.class, (String)air.getMarketingAirlineCode());
            s.setAirline(marketingAirline);
            Matcher airlineLocatorMatcher = GetReservationHelper.PATTERN_SUPPLIER_REF.matcher(air.getAirlineRefId());
            if (airlineLocatorMatcher.matches()) {
                s.setAirlineLocator(airlineLocatorMatcher.group(1));
            }
            DictionaryReference locationBegin = SabreHelper.resolveNativeCode(GeoLocation.class, (String)air.getDepartureAirport());
            s.setDepartureLocation(locationBegin);
            s.setDepartCityCode(GetReservationHelper.getCityCode((DictionaryReference<GeoLocation>)locationBegin));
            s.setDepartTerminal(air.getDepartureTerminalCode());
            DictionaryReference locationEnd = SabreHelper.resolveNativeCode(GeoLocation.class, (String)air.getArrivalAirport());
            s.setArriveLocation(locationEnd);
            s.setArriveCityCode(GetReservationHelper.getCityCode((DictionaryReference<GeoLocation>)locationEnd));
            s.setArriveTerminal(air.getArrivalTerminalCode());
            s.setBoard(SabreHelper.resolveNativeCode(Aircraft.class, (String)air.getEquipmentType()));
            s.setClassOfSvcCode(air.getResBookDesigCode());
            DictionaryReference<Airline> operatingAirline = GetReservationHelper.getOperatingAirline(air);
            if (operatingAirline != null) {
                if (!MiscUtil.equals(operatingAirline, (Object)marketingAirline)) {
                    s.setCodeShare(true);
                }
                s.setCodeShareCarrier(operatingAirline);
            } else {
                s.setCodeShareCarrier(marketingAirline);
            }
            s.setDefaultCodeSystem(CodeSystem.IATA);
            s.setStartDate(GetReservationHelper.getActualDepartureTime(air));
            s.setEndDate(GetReservationHelper.getActualArrivalTime(air));
            if (air.getElapsedTime() != null) {
                s.setFlightDuration(Integer.valueOf(GetReservationHelper.getTravelDuration(air.getElapsedTime())));
            }
            s.setFlightNo(GetReservationHelper.getFlightNumber(air));
            if (air.getMealList() != null && air.getMealList().size() > 0 && !(items = DictHelper.getDictionaryItemsByCode(MealServiceIndicator.class, (String)((AirType.Meal)air.getMealList().get(0)).getCode())).isEmpty()) {
                s.setMealServiceIndicator((DictionaryReference)((MealServiceIndicator)items.iterator().next()).toReference());
            }
            if (!StringUtils.isBlank((String)air.getStopQuantity())) {
                s.setNoOfStops(Integer.valueOf(air.getStopQuantity()));
            }
            s.setGdsId(segmentGdsIds.get(((FlightSegment)flightSegments.get(i)).getUid()));
            s.setStarting(((FlightSegment)flightSegments.get(i)).isStarting());
            s.setMarriageGrp(SabreCustomPropertiesHelper.getMarriageGrp((FlightSegment)flightSegments.get(i)));
            s.setStatus(air.getActionCode());
            s.addTechStopInfos(GetReservationHelper.readTechStops(air));
            s.setFlightDistanceMiles(Integer.valueOf(air.getAirMilesFlown()));
            s.setOperatingAirlineCompanyShortName(((FlightSegment)flightSegments.get(i)).getOperatingAirlineCompanyShortName());
            segments.add(s);
            ++i;
        }
        return segments;
    }
}

