/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sabre.modifyRemark;

import com.gridnine.xtrip.common.model.redapp.sws.Remark;
import com.gridnine.xtrip.server.gds.sabre.IBusGdsSabreContextKeys;
import com.gridnine.xtrip.server.gds.sabre.core.IbusGdsSabreCoreContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.sabre.webservices.sabrexml.ModifyRemarkRQ;
import java.math.BigInteger;
import java.sql.Date;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class ModifyRemarkRQBuilder
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        List remarks = (List)ctx.getObject((Enum)IBusGdsSabreContextKeys.UPDATE_REMARKS);
        if (remarks == null || remarks.isEmpty()) {
            return;
        }
        ModifyRemarkRQ request = new ModifyRemarkRQ();
        request.setVersion("2.1.2");
        request.setTimeStamp(Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant()));
        request.setRemarkList(remarks.stream().map(ModifyRemarkRQBuilder::convertRemark2sws).collect(Collectors.toList()));
        ctx.putObject((Enum)IbusGdsSabreCoreContextKeys.SABRE_WS_REQUEST_PAYLOAD, (Object)request);
        ctx.putObject((Enum)IbusGdsSabreCoreContextKeys.SABRE_WS_SERVICE_ACTION_CODE, (Object)"ModifyRemarkLLSRQ");
    }

    private static ModifyRemarkRQ.Remark convertRemark2sws(Remark remark) {
        ModifyRemarkRQ.Remark result = new ModifyRemarkRQ.Remark();
        result.setCode(remark.getCode());
        if (remark.getText() != null) {
            String text = remark.getText().replaceAll("@", "//").replaceAll("_", ".UN.");
            result.setText(text);
        }
        result.setType(ModifyRemarkRQ.Remark.Type.convert((String)Optional.ofNullable(remark.getType()).map(Enum::toString).orElse(null)));
        result.setNumber(new BigInteger(remark.getRph()));
        return result;
    }
}

