/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sabre.passengerDetails;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.gds.sabre.helpers.SabreHelper;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.dict.CommunicationType;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.profile.Communication;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.PersonCommunication;
import com.gridnine.xtrip.server.gds.sabre.core.IbusGdsSabreCoreContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.sabre.services.sp.pd.v35.PassengerDetailsRQ;
import org.apache.commons.lang.StringUtils;

public class PassengerDetailsAddAgentCommunicationsProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) {
        SalesContext salesContext = (SalesContext)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.SALES_CONTEXT);
        Person agent = (Person)EntityStorage.get().resolve(salesContext.getAgent()).getEntity();
        if (agent != null) {
            PassengerDetailsRQ request = (PassengerDetailsRQ)ctx.getMandatoryObject((Enum)IbusGdsSabreCoreContextKeys.SABRE_WS_REQUEST_PAYLOAD);
            PassengerDetailsRQ.TravelItineraryAddInfoRQ.CustomerInfo customerInfo = request.getTravelItineraryAddInfoRQ().getCustomerInfo();
            for (PersonCommunication comm : agent.getCommunications()) {
                if (!comm.isSendToGds()) continue;
                if (comm.getType() == CommunicationType.EMAIL) {
                    PassengerDetailsRQ.TravelItineraryAddInfoRQ.CustomerInfo.Email email = new PassengerDetailsRQ.TravelItineraryAddInfoRQ.CustomerInfo.Email();
                    email.setType(PassengerDetailsRQ.TravelItineraryAddInfoRQ.CustomerInfo.Email.Type.BC);
                    email.setAddress(ProfileHelper.normalizeCommunicationPart((String)comm.getSense()).replaceAll("_", "=="));
                    if (!StringUtils.isBlank((String)comm.getRemarks())) {
                        email.setShortText(comm.getRemarks());
                    } else {
                        email.setShortText("/");
                    }
                    customerInfo.getEmailList().add(email);
                    continue;
                }
                if (!SabreHelper.COMMUNICATION_TYPES.containsKey(comm.getType())) continue;
                if (customerInfo.getContactNumbers() == null) {
                    customerInfo.setContactNumbers(new PassengerDetailsRQ.TravelItineraryAddInfoRQ.CustomerInfo.ContactNumbers());
                }
                PassengerDetailsRQ.TravelItineraryAddInfoRQ.CustomerInfo.ContactNumbers.ContactNumber cn = new PassengerDetailsRQ.TravelItineraryAddInfoRQ.CustomerInfo.ContactNumbers.ContactNumber();
                cn.setPhoneUseType("A");
                String phone = SabreHelper.buildPhoneNumber((Communication)comm);
                if (!SabreHelper.checkPhoneNumber((String)phone)) {
                    throw Xeption.forEndUser((String)"\u043d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u044b\u0439 \u043d\u043e\u043c\u0435\u0440 \u0442\u0435\u043b\u0435\u0444\u043e\u043d\u0430 \u0430\u0433\u0435\u043d\u0442\u0430: {0}", (Object[])new Object[]{phone});
                }
                cn.setPhone(phone);
                customerInfo.getContactNumbers().getContactNumberList().add(cn);
            }
        }
    }
}

