/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sabre.passengerDetails;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.server.gds.sabre.IBusGdsSabreContextKeys;
import com.gridnine.xtrip.server.gds.sabre.core.IbusGdsSabreCoreContextKeys;
import com.gridnine.xtrip.server.gds.sabre.passengerDetails.PassengerDetailsHelper;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.sabre.services.sp.pd.v35.PassengerDetailsRQ;

public class PassengerDetailsAddChldProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        DictionaryReference passengerType = (DictionaryReference)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.PASSENGER_TYPE);
        if (DictHelper.isChildPassengerCategory((DictionaryReference)DictHelper.findPrimaryCategory((DictionaryReference)passengerType))) {
            PassengerDetailsRQ request = (PassengerDetailsRQ)ctx.getMandatoryObject((Enum)IbusGdsSabreCoreContextKeys.SABRE_WS_REQUEST_PAYLOAD);
            Traveller traveller = (Traveller)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.TRAVELLER);
            String nameNumber = (String)ctx.getMandatoryObject((Enum)IBusGdsSabreContextKeys.NAME_NUMBER);
            PassengerDetailsHelper.addSsr("CHLD", null, nameNumber, PassengerDetailsAddChldProcessor.buildChldText(traveller), request.getSpecialReqDetails().getSpecialServiceRQ().getServiceList());
        }
    }

    private static String buildChldText(Traveller traveller) {
        return PassengerDetailsHelper.DF_SSR.format(traveller.getPassport().getBirthday()).toUpperCase();
    }
}

