/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sabre.passengerDetails;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.gds.sabre.helpers.SabreHelper;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.Customer;
import com.gridnine.xtrip.common.model.dict.CommunicationType;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.profile.Communication;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.system.Metadata;
import com.gridnine.xtrip.common.model.system.MetadataKey;
import com.gridnine.xtrip.server.gds.sabre.core.IbusGdsSabreCoreContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.sabre.services.sp.pd.v35.PassengerDetailsRQ;
import java.util.Optional;
import org.apache.commons.lang.StringUtils;

public class PassengerDetailsAddCustomerCommunicationsProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        Customer customer = (Customer)ctx.getObject((Enum)IBusMidofficeContextKeys.CUSTOMER);
        if (customer != null) {
            PassengerDetailsRQ request = (PassengerDetailsRQ)ctx.getMandatoryObject((Enum)IbusGdsSabreCoreContextKeys.SABRE_WS_REQUEST_PAYLOAD);
            SalesContext salesContext = (SalesContext)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.SALES_CONTEXT);
            PassengerDetailsRQ.TravelItineraryAddInfoRQ.CustomerInfo customerInfo = request.getTravelItineraryAddInfoRQ().getCustomerInfo();
            for (Communication comm : customer.getCommunications()) {
                if (comm.getType() == CommunicationType.EMAIL) {
                    PassengerDetailsRQ.TravelItineraryAddInfoRQ.CustomerInfo.Email email = new PassengerDetailsRQ.TravelItineraryAddInfoRQ.CustomerInfo.Email();
                    if (this.isAddEmailType(salesContext)) {
                        email.setType(PassengerDetailsRQ.TravelItineraryAddInfoRQ.CustomerInfo.Email.Type.CC);
                    }
                    email.setAddress(ProfileHelper.normalizeCommunicationPart((String)comm.getSense()).replaceAll("_", "=="));
                    if (!StringUtils.isBlank((String)comm.getRemarks())) {
                        email.setShortText(comm.getRemarks());
                    } else {
                        email.setShortText("/");
                    }
                    customerInfo.getEmailList().add(email);
                    continue;
                }
                if (!SabreHelper.COMMUNICATION_TYPES.keySet().contains(comm.getType())) continue;
                if (customerInfo.getContactNumbers() == null) {
                    customerInfo.setContactNumbers(new PassengerDetailsRQ.TravelItineraryAddInfoRQ.CustomerInfo.ContactNumbers());
                }
                PassengerDetailsRQ.TravelItineraryAddInfoRQ.CustomerInfo.ContactNumbers.ContactNumber cn = new PassengerDetailsRQ.TravelItineraryAddInfoRQ.CustomerInfo.ContactNumbers.ContactNumber();
                cn.setPhoneUseType((String)SabreHelper.COMMUNICATION_TYPES.get(comm.getType()));
                String phone = SabreHelper.buildPhoneNumber((Communication)comm);
                if (!SabreHelper.checkPhoneNumber((String)phone)) {
                    throw Xeption.forEndUser((String)"\u043d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u044b\u0439 \u043d\u043e\u043c\u0435\u0440 \u0442\u0435\u043b\u0435\u0444\u043e\u043d\u0430 \u043f\u043e\u043a\u0443\u043f\u0430\u0442\u0435\u043b\u044f: {0}", (Object[])new Object[]{phone});
                }
                cn.setPhone(phone);
                customerInfo.getContactNumbers().getContactNumberList().add(cn);
            }
        }
    }

    private boolean isAddEmailType(SalesContext salesContext) {
        EntityReference subagencyRef = salesContext.getSubagency();
        Organization subagency = (Organization)EntityStorage.get().resolve(subagencyRef).getEntity();
        Optional<Metadata> metadata = subagency.getMetadata().stream().filter(md -> MetadataKey.REMOVE_TYPE_FROM_AGENT_EMAIL_IN_SABRE.name().equals(md.getKey().getCode())).findFirst();
        return !metadata.isPresent() || Boolean.TRUE != metadata.get().getValue();
    }
}

