/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sabre.passengerDetails;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.gds.sabre.helpers.SabreHelper;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.server.gds.sabre.core.IbusGdsSabreCoreContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.sabre.services.sp.pd.v35.PassengerDetailsRQ;
import java.util.Map;
import java.util.regex.Pattern;

public class PassengerDetailsAddCustomerIdentifierProcessor
extends BaseProcessor {
    Pattern customPattern;

    public void configure(Map<String, String> parameters) {
        super.configure(parameters);
        String customPatternStr = parameters.get("custom_pattern");
        if (customPatternStr != null) {
            this.customPattern = Pattern.compile(customPatternStr);
        }
    }

    public void process(MessageContext ctx) throws Exception {
        SalesContext salesContext = (SalesContext)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.SALES_CONTEXT);
        PassengerDetailsRQ request = (PassengerDetailsRQ)ctx.getMandatoryObject((Enum)IbusGdsSabreCoreContextKeys.SABRE_WS_REQUEST_PAYLOAD);
        String dkNumber = ((Organization)EntityStorage.get().resolve(salesContext.getClient()).getEntity()).getCode();
        if (this.customPattern != null) {
            if (this.customPattern.matcher(dkNumber).matches()) {
                request.getTravelItineraryAddInfoRQ().getCustomerInfo().setCustomerIdentifier(dkNumber);
            }
        } else if (SabreHelper.isValidDkNumber((String)dkNumber, (boolean)((Organization)EntityStorage.get().resolve(salesContext.getSubagency()).getEntity()).isWeakerDkNumberValidation())) {
            request.getTravelItineraryAddInfoRQ().getCustomerInfo().setCustomerIdentifier(dkNumber);
        }
    }
}

