/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sabre.passengerDetails;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.gds.model.DocaAddressType;
import com.gridnine.xtrip.common.gds.model.DocaInformation;
import com.gridnine.xtrip.common.gds.sabre.helpers.SabreHelper;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.gds.sabre.core.IbusGdsSabreCoreContextKeys;
import com.gridnine.xtrip.server.gds.sabre.passengerDetails.PassengerDetailsHelper;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.sabre.services.sp.pd.v35.PassengerDetailsRQ;

public class PassengerDetailsAddDocaProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        DictionaryReference passengerType = (DictionaryReference)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.PASSENGER_TYPE);
        PassengerDetailsRQ request = (PassengerDetailsRQ)ctx.getMandatoryObject((Enum)IbusGdsSabreCoreContextKeys.SABRE_WS_REQUEST_PAYLOAD);
        DocaInformation docaInfo = (DocaInformation)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.DOCA_INFORMATION);
        String nameNumber = PassengerDetailsHelper.getMajorNameNumber(ctx);
        PassengerDetailsRQ.SpecialReqDetails.SpecialServiceRQ.AdvancePassenger ap = new PassengerDetailsRQ.SpecialReqDetails.SpecialServiceRQ.AdvancePassenger();
        PassengerDetailsRQ.SpecialReqDetails.SpecialServiceRQ.AdvancePassenger.ResidentDestinationAddress rda = new PassengerDetailsRQ.SpecialReqDetails.SpecialServiceRQ.AdvancePassenger.ResidentDestinationAddress();
        rda.setType(PassengerDetailsAddDocaProcessor.docaAddressTypeToString(docaInfo.getType()));
        rda.setCity(docaInfo.getCity());
        rda.setCountry(SabreHelper.getCountryNativeCode((DictionaryReference)docaInfo.getCountry()));
        rda.setState(docaInfo.getStateProvince());
        rda.setStreet(docaInfo.getStreet());
        rda.setZip(docaInfo.getZipPostalCode());
        ap.setResidentDestinationAddress(rda);
        PassengerDetailsRQ.SpecialReqDetails.SpecialServiceRQ.AdvancePassenger.PersonName pn = new PassengerDetailsRQ.SpecialReqDetails.SpecialServiceRQ.AdvancePassenger.PersonName();
        pn.setNameNumber(nameNumber);
        pn.setLapChild(Boolean.valueOf(DictHelper.isInfantPassengerType((DictionaryReference)passengerType)));
        ap.setPersonName(pn);
        request.getSpecialReqDetails().getSpecialServiceRQ().getAdvancePassengerList().add(ap);
    }

    private static String docaAddressTypeToString(DocaAddressType type) {
        switch (type) {
            case DESTINATION: {
                return "D";
            }
            case RESIDENCE: {
                return "R";
            }
        }
        throw Xeption.forDeveloper((String)"unexpected doca address type", (Object[])new Object[]{type});
    }
}

