/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sabre.passengerDetails;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.gds.model.DocoInformation;
import com.gridnine.xtrip.common.gds.sabre.helpers.SabreHelper;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.gds.sabre.core.IbusGdsSabreCoreContextKeys;
import com.gridnine.xtrip.server.gds.sabre.passengerDetails.PassengerDetailsHelper;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.sabre.services.sp.pd.v35.PassengerDetailsRQ;
import java.sql.Date;

public class PassengerDetailsAddDocoProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        DictionaryReference passengerType = (DictionaryReference)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.PASSENGER_TYPE);
        DocoInformation docoInfo = (DocoInformation)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.DOCO_INFORMATION);
        PassengerDetailsRQ request = (PassengerDetailsRQ)ctx.getMandatoryObject((Enum)IbusGdsSabreCoreContextKeys.SABRE_WS_REQUEST_PAYLOAD);
        String nameNumber = PassengerDetailsHelper.getMajorNameNumber(ctx);
        PassengerDetailsRQ.SpecialReqDetails.SpecialServiceRQ.AdvancePassenger ap = new PassengerDetailsRQ.SpecialReqDetails.SpecialServiceRQ.AdvancePassenger();
        PassengerDetailsRQ.SpecialReqDetails.SpecialServiceRQ.AdvancePassenger.Document doc = new PassengerDetailsRQ.SpecialReqDetails.SpecialServiceRQ.AdvancePassenger.Document();
        doc.setNumber(docoInfo.getVisaNumber());
        doc.setType("V");
        PassengerDetailsRQ.SpecialReqDetails.SpecialServiceRQ.AdvancePassenger.Document.Visa visa = new PassengerDetailsRQ.SpecialReqDetails.SpecialServiceRQ.AdvancePassenger.Document.Visa();
        visa.setIssueDate(new Date(docoInfo.getVisaIssueDate().getTime()));
        visa.setExpirationDate(new Date(docoInfo.getVisaExpirationDate().getTime()));
        if (docoInfo.getVisaApplicableCountry() != null) {
            visa.setApplicableCountry(SabreHelper.getCountryNativeCode((DictionaryReference)docoInfo.getVisaApplicableCountry()));
        }
        visa.setPlaceOfBirth(PassengerDetailsAddDocoProcessor.getPlaceOfBirth(docoInfo));
        visa.setPlaceOfIssue(docoInfo.getVisaIssuePlace());
        doc.setVisa(visa);
        ap.setDocument(doc);
        PassengerDetailsRQ.SpecialReqDetails.SpecialServiceRQ.AdvancePassenger.PersonName pn = new PassengerDetailsRQ.SpecialReqDetails.SpecialServiceRQ.AdvancePassenger.PersonName();
        pn.setNameNumber(nameNumber);
        pn.setLapChild(Boolean.valueOf(DictHelper.isInfantPassengerType((DictionaryReference)passengerType)));
        ap.setPersonName(pn);
        request.getSpecialReqDetails().getSpecialServiceRQ().getAdvancePassengerList().add(ap);
    }

    private static String getPlaceOfBirth(DocoInformation docoInfo) {
        StringBuilder sb = new StringBuilder();
        if (!TextUtil.isBlank((String)docoInfo.getPlaceOfBirthCity())) {
            sb.append(docoInfo.getPlaceOfBirthCity());
            if (!TextUtil.isBlank((String)docoInfo.getPlaceOfBirthState())) {
                sb.append(' ');
                sb.append(docoInfo.getPlaceOfBirthState());
            }
        }
        if (docoInfo.getPlaceOfBirthCountry() != null) {
            if (sb.length() > 0) {
                sb.append(' ');
            }
            sb.append(SabreHelper.getCountryNativeCode((DictionaryReference)docoInfo.getPlaceOfBirthCountry()));
        }
        return sb.toString();
    }
}

