/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sabre.passengerDetails;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.gds.helper.FlightHelper;
import com.gridnine.xtrip.common.gds.model.Flight;
import com.gridnine.xtrip.common.gds.model.FlightSegment;
import com.gridnine.xtrip.common.gds.sabre.helpers.SabreHelper;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.PassengerType;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.Segment;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.PassportType;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.profile.Passport;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.gds.sabre.core.IbusGdsSabreCoreContextKeys;
import com.gridnine.xtrip.server.gds.sabre.passengerDetails.PassengerDetailsHelper;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.sabre.services.sp.pd.v35.PassengerDetailsRQ;
import java.sql.Date;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;

public class PassengerDetailsAddDocsProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        java.util.Date lastSegmentStartDate = null;
        Flight flight = (Flight)ctx.getObject((Enum)IBusGdsContextKeys.FLIGHT);
        if (flight != null) {
            List segments = FlightHelper.getSegments((Flight)flight);
            lastSegmentStartDate = ((FlightSegment)segments.get(segments.size() - 1)).getDateBegin();
        } else {
            Product product = (Product)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.PRODUCT);
            List segments = AirProductHelper.getSegments((Collection)product.getSegmentTariffs());
            lastSegmentStartDate = ((Segment)segments.get(segments.size() - 1)).getStartDate();
        }
        Collection travellers = (Collection)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.TRAVELLERS);
        Traveller traveller = (Traveller)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.TRAVELLER);
        if (!StringUtils.isBlank((String)traveller.getPassport().getNumber())) {
            boolean isUniqueNumber = travellers.stream().filter(t -> t.getPassport().getNumber().equals(traveller.getPassport().getNumber())).collect(Collectors.toList()).size() == 1;
            DictionaryReference passengerType = (DictionaryReference)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.PASSENGER_TYPE);
            PassengerDetailsRQ request = (PassengerDetailsRQ)ctx.getMandatoryObject((Enum)IbusGdsSabreCoreContextKeys.SABRE_WS_REQUEST_PAYLOAD);
            String nameNumber = PassengerDetailsHelper.getMajorNameNumber(ctx);
            PassengerDetailsRQ.SpecialReqDetails.SpecialServiceRQ.AdvancePassenger ap = new PassengerDetailsRQ.SpecialReqDetails.SpecialServiceRQ.AdvancePassenger();
            PassengerDetailsRQ.SpecialReqDetails.SpecialServiceRQ.AdvancePassenger.Document doc = new PassengerDetailsRQ.SpecialReqDetails.SpecialServiceRQ.AdvancePassenger.Document();
            doc.setExpirationDate(new Date(PassengerDetailsAddDocsProcessor.getExpired(traveller.getPassport(), lastSegmentStartDate).getTime()));
            doc.setNumber(traveller.getPassport().getNumber());
            doc.setType(SabreHelper.isSu((DictionaryReference)flight.getCarrier()) ? SabreHelper.buildPassportTypeSu((PassportType)traveller.getPassport().getType()) : SabreHelper.buildPassportType((PassportType)traveller.getPassport().getType()));
            doc.setIssueCountry(SabreHelper.getCountryNativeCode((DictionaryReference)traveller.getPassport().getCitizenship()));
            doc.setNationalityCountry(SabreHelper.getCountryNativeCode((DictionaryReference)traveller.getPassport().getCitizenship()));
            ap.setDocument(doc);
            PassengerDetailsRQ.SpecialReqDetails.SpecialServiceRQ.AdvancePassenger.PersonName pn = new PassengerDetailsRQ.SpecialReqDetails.SpecialServiceRQ.AdvancePassenger.PersonName();
            if (!isUniqueNumber && DictHelper.isAdultPassengerTypeCategory((DictionaryReference)passengerType)) {
                pn.setDocumentHolder(Boolean.TRUE);
            }
            pn.setDateOfBirth(new Date(traveller.getPassport().getBirthday().getTime()));
            pn.setGender(PassengerDetailsAddDocsProcessor.getGender(traveller.getPassport(), (DictionaryReference<PassengerType>)passengerType));
            pn.setNameNumber(nameNumber);
            if (traveller.getPassport().getLastName().length() > 30) {
                pn.setSurname(traveller.getPassport().getLastName().substring(0, 30));
            } else {
                pn.setSurname(traveller.getPassport().getLastName());
            }
            String givenName = !StringUtils.isBlank((String)traveller.getPassport().getMiddleName()) ? String.format("%s %s", traveller.getPassport().getFirstName(), traveller.getPassport().getMiddleName()) : traveller.getPassport().getFirstName();
            pn.setGivenName(givenName.length() > 30 ? givenName.substring(0, 30) : givenName);
            if (!StringUtils.isBlank((String)traveller.getPassport().getSecondName())) {
                if (traveller.getPassport().getSecondName().length() > 30) {
                    pn.setMiddleName(traveller.getPassport().getSecondName().substring(0, 30));
                } else {
                    pn.setMiddleName(traveller.getPassport().getSecondName());
                }
            }
            ap.setPersonName(pn);
            request.getSpecialReqDetails().getSpecialServiceRQ().getAdvancePassengerList().add(ap);
        }
    }

    private static Date getExpired(Passport passport, java.util.Date lastSegmentStartDate) {
        switch (passport.getType()) {
            case INTERNAL: 
            case BIRTHDAY_NOTIFICATION: {
                return new Date(MiscUtil.addYearsToDate((java.util.Date)lastSegmentStartDate, (int)1).getTime());
            }
        }
        return new Date(passport.getExpired().getTime());
    }

    private static PassengerDetailsRQ.SpecialReqDetails.SpecialServiceRQ.AdvancePassenger.PersonName.Gender getGender(Passport passport, DictionaryReference<PassengerType> passengerType) {
        switch (passport.getGender()) {
            case MALE: {
                if (DictHelper.isInfantPassengerType(passengerType)) {
                    return PassengerDetailsRQ.SpecialReqDetails.SpecialServiceRQ.AdvancePassenger.PersonName.Gender.MI;
                }
                return PassengerDetailsRQ.SpecialReqDetails.SpecialServiceRQ.AdvancePassenger.PersonName.Gender.M;
            }
            case FEMALE: {
                if (DictHelper.isInfantPassengerType(passengerType)) {
                    return PassengerDetailsRQ.SpecialReqDetails.SpecialServiceRQ.AdvancePassenger.PersonName.Gender.FI;
                }
                return PassengerDetailsRQ.SpecialReqDetails.SpecialServiceRQ.AdvancePassenger.PersonName.Gender.F;
            }
        }
        throw Xeption.forDeveloper((String)"unexpected gender {1}", (Object[])new Object[]{passport.getGender()});
    }
}

