/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sabre.passengerDetails;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.gds.sabre.helpers.SabreHelper;
import com.gridnine.xtrip.common.model.booking.PassengerType;
import com.gridnine.xtrip.common.model.booking.PassengerTypeValue;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.dict.DictPredifinedValueProvider;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.profile.Passport;
import com.gridnine.xtrip.server.gds.sabre.IBusGdsSabreContextKeys;
import com.gridnine.xtrip.server.gds.sabre.core.IbusGdsSabreCoreContextKeys;
import com.gridnine.xtrip.server.gds.sabre.passengerDetails.PassengerDetailsHelper;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.sabre.services.sp.pd.v35.PassengerDetailsRQ;

public class PassengerDetailsAddInftProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        DictionaryReference passengerType = (DictionaryReference)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.PASSENGER_TYPE);
        SabreHelper.SabreAviaParametersProvider parametersProvider = (SabreHelper.SabreAviaParametersProvider)ctx.getMandatoryObject((Enum)IBusGdsSabreContextKeys.AVIA_PARAMETERS_PROVIDER);
        if (DictHelper.isEqualsPredifinedValue((DictionaryReference)passengerType, (DictPredifinedValueProvider[])new DictPredifinedValueProvider[]{PassengerTypeValue.INFANT, PassengerTypeValue.INFANT_WITH_SITE})) {
            PassengerDetailsRQ request = (PassengerDetailsRQ)ctx.getMandatoryObject((Enum)IbusGdsSabreCoreContextKeys.SABRE_WS_REQUEST_PAYLOAD);
            Traveller traveller = (Traveller)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.TRAVELLER);
            String nameNumber = PassengerDetailsHelper.getMajorNameNumber(ctx);
            PassengerDetailsHelper.addSsr("INFT", null, nameNumber, PassengerDetailsAddInftProcessor.buildInftText((DictionaryReference<PassengerType>)passengerType, traveller, parametersProvider), request.getSpecialReqDetails().getSpecialServiceRQ().getServiceList());
        }
    }

    private static String buildInftText(DictionaryReference<PassengerType> passengerType, Traveller traveller, SabreHelper.SabreAviaParametersProvider parametersProvider) {
        StringBuilder sb = new StringBuilder(40);
        sb.append(SabreHelper.buildSurname((Passport)traveller.getPassport(), (boolean)true));
        sb.append('/');
        String givenName = SabreHelper.buildGivenName((Passport)traveller.getPassport(), passengerType, (SabreHelper.SabreAviaParametersProvider)parametersProvider);
        int idx = givenName.indexOf(42);
        if (idx != -1) {
            givenName = givenName.substring(0, idx);
        }
        sb.append(givenName);
        sb.append('/');
        sb.append(PassengerDetailsHelper.DF_SSR.format(traveller.getPassport().getBirthday()).toUpperCase());
        if (DictHelper.isEqualsPredifinedValue(passengerType, (DictPredifinedValueProvider[])new DictPredifinedValueProvider[]{PassengerTypeValue.INFANT_WITH_SITE})) {
            sb.append("/OS");
        }
        return sb.toString();
    }
}

