/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sabre.passengerDetails;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.Multimaps;
import com.gridnine.xtrip.common.gds.model.Flight;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.gds.sabre.IBusGdsSabreContextKeys;
import com.gridnine.xtrip.server.gds.sabre.core.IbusGdsSabreCoreContextKeys;
import com.gridnine.xtrip.server.gds.sabre.passengerDetails.PassengerDetailsHelper;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.sabre.services.sp.pd.v35.PassengerDetailsRQ;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.TreeSet;
import org.apache.commons.lang.StringUtils;

public class PassengerDetailsAddNotADupeProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        Map nameNumbers = (Map)ctx.getMandatoryObject((Enum)IBusGdsSabreContextKeys.NAME_NUMBERS);
        ImmutableListMultimap mmap = Multimaps.index(nameNumbers.values(), (Function)new Function<String, String>(){

            public String apply(String nameNumber) {
                return nameNumber.substring(0, nameNumber.indexOf(46));
            }
        });
        ArrayList<String> paxStrings = new ArrayList<String>();
        for (String key : new TreeSet(mmap.keySet())) {
            Collection value = mmap.get((Object)key);
            if (value.size() <= 1) continue;
            ArrayList sortedValue = new ArrayList(value);
            Collections.sort(sortedValue);
            paxStrings.add("PAX" + StringUtils.join(sortedValue, (String)"-PAX"));
        }
        if (paxStrings.isEmpty()) {
            return;
        }
        PassengerDetailsRQ request = (PassengerDetailsRQ)ctx.getMandatoryObject((Enum)IbusGdsSabreCoreContextKeys.SABRE_WS_REQUEST_PAYLOAD);
        Flight flight = (Flight)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.FLIGHT);
        for (String paxString : paxStrings) {
            StringBuilder sb = new StringBuilder();
            sb.append("THE SAME NAMES ");
            sb.append(paxString);
            sb.append(". NOT A DUPE");
            PassengerDetailsHelper.addOsi("YY", null, sb.toString(), request.getSpecialReqDetails().getSpecialServiceRQ().getServiceList());
        }
    }
}

