/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sabre.passengerDetails;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.gds.sabre.helpers.SabreHelper;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.dict.CommunicationType;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.MessageHelper;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.profile.Communication;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.OrganizationType;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.gds.sabre.core.IbusGdsSabreCoreContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.sabre.services.sp.pd.v35.PassengerDetailsRQ;
import java.util.HashSet;
import org.apache.commons.lang.StringUtils;

public class PassengerDetailsAddOrganizationCommunicationsProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) {
        EntityReference orgRef = (EntityReference)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.ORGANIZATION);
        EntityContainer orgCont = EntityStorage.get().resolve(orgRef);
        if (orgCont == null) {
            return;
        }
        boolean isAgency = PassengerDetailsAddOrganizationCommunicationsProcessor.isAgency((EntityContainer<Organization>)orgCont);
        if (!isAgency && !PassengerDetailsAddOrganizationCommunicationsProcessor.isCorporateClient((EntityContainer<Organization>)orgCont)) {
            throw Xeption.forDeveloper((String)"Not allowed organization type", (Object[])new Object[0]);
        }
        PassengerDetailsRQ request = (PassengerDetailsRQ)ctx.getMandatoryObject((Enum)IbusGdsSabreCoreContextKeys.SABRE_WS_REQUEST_PAYLOAD);
        SalesContext salesContext = (SalesContext)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.SALES_CONTEXT);
        PassengerDetailsRQ.TravelItineraryAddInfoRQ.CustomerInfo customerInfo = request.getTravelItineraryAddInfoRQ().getCustomerInfo();
        HashSet<String> emails = new HashSet<String>();
        HashSet<String> phones = new HashSet<String>();
        for (Communication comm : ((Organization)orgCont.getEntity()).getCommunications()) {
            String phone;
            if (comm.getType() == CommunicationType.EMAIL) {
                if (StringUtils.isBlank((String)comm.getSense())) {
                    ctx.addMessage(MessageHelper.createWarningMessage((String)"\u043f\u0440\u043e\u0438\u0433\u043d\u043e\u0440\u0438\u0440\u043e\u0432\u0430\u043d \u043f\u0443\u0441\u0442\u043e\u0439 e-mail \u0438\u0437 \u043f\u0440\u043e\u0444\u0438\u043b\u044f {0}", (Object[])new Object[]{orgRef}));
                    continue;
                }
                String address = ProfileHelper.normalizeCommunicationPart((String)comm.getSense()).replaceAll("_", "==");
                if (!emails.add(address)) continue;
                PassengerDetailsRQ.TravelItineraryAddInfoRQ.CustomerInfo.Email email = new PassengerDetailsRQ.TravelItineraryAddInfoRQ.CustomerInfo.Email();
                if (SabreHelper.isIncludeBCEmailType((SalesContext)salesContext)) {
                    if (isAgency) {
                        email.setType(PassengerDetailsRQ.TravelItineraryAddInfoRQ.CustomerInfo.Email.Type.BC);
                    } else {
                        email.setType(PassengerDetailsRQ.TravelItineraryAddInfoRQ.CustomerInfo.Email.Type.CC);
                    }
                }
                email.setAddress(address);
                if (!StringUtils.isBlank((String)comm.getRemarks()) && !TextUtil.containsCyrillicLetter((String)comm.getRemarks())) {
                    email.setShortText(comm.getRemarks().replace("-", ""));
                }
                customerInfo.getEmailList().add(email);
                continue;
            }
            if (!SabreHelper.COMMUNICATION_TYPES_AGENCY.containsKey(comm.getType()) || StringUtils.isBlank((String)(phone = SabreHelper.buildPhoneNumber((Communication)comm)))) continue;
            if (!SabreHelper.checkPhoneNumber((String)phone)) {
                throw Xeption.forEndUser((String)"\u043d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u044b\u0439 \u043d\u043e\u043c\u0435\u0440 \u0442\u0435\u043b\u0435\u0444\u043e\u043d\u0430 \u043e\u0440\u0433\u0430\u043d\u0438\u0437\u0430\u0446\u0438\u0438 {0}: {1}", (Object[])new Object[]{orgRef, phone});
            }
            if (!phones.add(phone)) continue;
            if (customerInfo.getContactNumbers() == null) {
                customerInfo.setContactNumbers(new PassengerDetailsRQ.TravelItineraryAddInfoRQ.CustomerInfo.ContactNumbers());
            }
            PassengerDetailsRQ.TravelItineraryAddInfoRQ.CustomerInfo.ContactNumbers.ContactNumber cn = new PassengerDetailsRQ.TravelItineraryAddInfoRQ.CustomerInfo.ContactNumbers.ContactNumber();
            if (isAgency) {
                cn.setPhoneUseType("A");
            } else {
                cn.setPhoneUseType("B");
            }
            cn.setPhone(phone);
            customerInfo.getContactNumbers().getContactNumberList().add(cn);
        }
    }

    private static boolean isCorporateClient(EntityContainer<Organization> orgCont) {
        return ((Organization)orgCont.getEntity()).getTypes().contains(OrganizationType.CORPORATE_CLIENT);
    }

    private static boolean isAgency(EntityContainer<Organization> orgCont) {
        return ((Organization)orgCont.getEntity()).getTypes().contains(OrganizationType.AGENCY);
    }
}

