/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sabre.passengerDetails;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.gds.sabre.helpers.SabreHelper;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.dict.CommunicationType;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.profile.Communication;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.server.gds.sabre.core.IbusGdsSabreCoreContextKeys;
import com.gridnine.xtrip.server.gds.sabre.passengerDetails.PassengerDetailsHelper;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.sabre.services.sp.pd.v35.PassengerDetailsRQ;

public class PassengerDetailsAddOsiCTCAgentAndSubAgencyProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) {
        String text;
        PassengerDetailsRQ request = (PassengerDetailsRQ)ctx.getMandatoryObject((Enum)IbusGdsSabreCoreContextKeys.SABRE_WS_REQUEST_PAYLOAD);
        SalesContext salesContext = (SalesContext)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.SALES_CONTEXT);
        EntityContainer subgencyCon = EntityStorage.get().resolve(salesContext.getSubagency());
        EntityContainer agentCon = EntityStorage.get().resolve(salesContext.getAgent());
        for (Communication comm : ((Organization)subgencyCon.getEntity()).getCommunications()) {
            text = this.buildOsiCTCxText(comm);
            if (text == null) continue;
            PassengerDetailsHelper.addOsi("YY", null, text, request.getSpecialReqDetails().getSpecialServiceRQ().getServiceList());
        }
        for (Communication comm : ((Person)agentCon.getEntity()).getCommunications()) {
            if (!comm.isSendToGds() || (text = this.buildOsiCTCxText(comm)) == null) continue;
            PassengerDetailsHelper.addOsi("YY", null, text, request.getSpecialReqDetails().getSpecialServiceRQ().getServiceList());
        }
    }

    private String buildOsiCTCxText(Communication comm) {
        StringBuilder sb = new StringBuilder(48);
        sb.append("CTC");
        if (SabreHelper.COMMUNICATION_TYPES.containsKey(comm.getType())) {
            sb.append("A");
            sb.append(' ');
            sb.append(ProfileHelper.normalizeCommunicationPart((String)comm.getCountryCode()));
            sb.append(ProfileHelper.normalizeCommunicationPart((String)comm.getCityCode()));
            sb.append(ProfileHelper.normalizeCommunicationPart((String)comm.getSense()));
        } else if (comm.getType() == CommunicationType.EMAIL) {
            sb.append("E ");
            sb.append(PassengerDetailsAddOsiCTCAgentAndSubAgencyProcessor.buildEmail(comm));
        } else {
            return null;
        }
        return sb.toString();
    }

    private static String buildEmail(Communication comm) {
        return ProfileHelper.normalizeCommunicationPart((String)comm.getSense()).replaceAll("_", "..").replaceAll("@", "//").replaceAll("-", "./");
    }
}

