/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sabre.passengerDetails;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.gds.model.Flight;
import com.gridnine.xtrip.common.gds.sabre.helpers.SabreHelper;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.dict.CommunicationType;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.profile.Communication;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.gds.sabre.IBusGdsSabreContextKeys;
import com.gridnine.xtrip.server.gds.sabre.core.IbusGdsSabreCoreContextKeys;
import com.gridnine.xtrip.server.gds.sabre.passengerDetails.PassengerDetailsHelper;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.sabre.services.sp.pd.v35.PassengerDetailsRQ;
import org.apache.commons.lang.StringUtils;

public class PassengerDetailsAddOsiCTCxProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) {
        Traveller traveller = (Traveller)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.TRAVELLER);
        String nameNumber = (String)ctx.getMandatoryObject((Enum)IBusGdsSabreContextKeys.NAME_NUMBER);
        PassengerDetailsRQ request = (PassengerDetailsRQ)ctx.getMandatoryObject((Enum)IbusGdsSabreCoreContextKeys.SABRE_WS_REQUEST_PAYLOAD);
        Flight flight = (Flight)ctx.getObject((Enum)IBusGdsContextKeys.FLIGHT);
        DictionaryReference passengerType = (DictionaryReference)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.PASSENGER_TYPE);
        String cityCode = this.getDepartureCityCodeFromFirstSegment(flight);
        for (Communication comm : traveller.getCommunications()) {
            String text = this.buildOsiCTCxText(comm, cityCode);
            if (text == null) continue;
            PassengerDetailsHelper.addOsi("YY", nameNumber, text, request.getSpecialReqDetails().getSpecialServiceRQ().getServiceList());
        }
        if (!DictHelper.isInfantPassengerType((DictionaryReference)passengerType)) {
            if (traveller.getCommunications().stream().noneMatch(c -> c.getType() == CommunicationType.EMAIL)) {
                PassengerDetailsHelper.addOsi("YY", nameNumber, "CTCE REFUSED", request.getSpecialReqDetails().getSpecialServiceRQ().getServiceList());
            } else {
                PassengerDetailsHelper.addOsi("YY", nameNumber, "IN THE PNR IN COMPLIANCE WITH THE RESOLUTIONS GOVERNING RESERVATIONS PROCEDURES", request.getSpecialReqDetails().getSpecialServiceRQ().getServiceList());
            }
        }
    }

    private String buildOsiCTCxText(Communication comm, String cityCode) {
        StringBuilder sb = new StringBuilder(48);
        sb.append("CTC");
        if (SabreHelper.COMMUNICATION_TYPES.containsKey(comm.getType())) {
            sb.append((String)SabreHelper.COMMUNICATION_TYPES.get(comm.getType()));
            sb.append(' ');
            if (!StringUtils.isBlank((String)cityCode)) {
                sb.append(cityCode);
                sb.append(' ');
            }
            sb.append(ProfileHelper.normalizeCommunicationPart((String)comm.getCountryCode()));
            sb.append(ProfileHelper.normalizeCommunicationPart((String)comm.getCityCode()));
            sb.append(ProfileHelper.normalizeCommunicationPart((String)comm.getSense()));
        } else if (comm.getType() == CommunicationType.EMAIL) {
            sb.append("E ");
            sb.append(PassengerDetailsAddOsiCTCxProcessor.buildEmail(comm));
        } else {
            return null;
        }
        return sb.toString();
    }

    private static String buildEmail(Communication comm) {
        StringBuilder sb = new StringBuilder(25);
        sb.append(ProfileHelper.normalizeCommunicationPart((String)comm.getSense()).replaceAll("_", "..").replaceAll("@", "//").replaceAll("-", "./"));
        return sb.toString();
    }

    protected String getDepartureCityCodeFromFirstSegment(Flight flight) {
        return null;
    }
}

