/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sabre.passengerDetails;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.model.booking.PassengerTypeValue;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.dict.DictPredifinedValueProvider;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.server.gds.sabre.IBusGdsSabreContextKeys;
import com.gridnine.xtrip.server.gds.sabre.core.IbusGdsSabreCoreContextKeys;
import com.gridnine.xtrip.server.gds.sabre.passengerDetails.PassengerDetailsHelper;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.sabre.services.sp.pd.v35.PassengerDetailsRQ;
import java.util.Collection;
import org.apache.commons.lang.StringUtils;

public class PassengerDetailsAddOsiForInfantsProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        DictionaryReference passengerType = (DictionaryReference)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.PASSENGER_TYPE);
        Traveller traveller = (Traveller)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.TRAVELLER);
        if (!StringUtils.isBlank((String)traveller.getPassport().getNumber()) && DictHelper.isEqualsPredifinedValue((DictionaryReference)passengerType, (DictPredifinedValueProvider[])new DictPredifinedValueProvider[]{PassengerTypeValue.INFANT, PassengerTypeValue.INFANT_WITH_SITE})) {
            PassengerDetailsRQ request = (PassengerDetailsRQ)ctx.getMandatoryObject((Enum)IbusGdsSabreCoreContextKeys.SABRE_WS_REQUEST_PAYLOAD);
            String nameNumber = (String)ctx.getMandatoryObject((Enum)IBusGdsSabreContextKeys.NAME_NUMBER);
            Collection marketingCarrierCodes = (Collection)ctx.getMandatoryObject((Enum)IBusGdsSabreContextKeys.MARKETING_CARRIER_CODES);
            for (String code : marketingCarrierCodes) {
                PassengerDetailsHelper.addOsi(code, nameNumber, PassengerDetailsAddOsiForInfantsProcessor.buildOsiForInfantText(traveller), request.getSpecialReqDetails().getSpecialServiceRQ().getServiceList());
            }
        }
    }

    private static String buildOsiForInfantText(Traveller traveller) {
        StringBuilder sb = new StringBuilder(32);
        sb.append("PSPT");
        sb.append(traveller.getPassport().getNumber());
        sb.append("/DOB");
        sb.append(PassengerDetailsHelper.DF_SSR.format(traveller.getPassport().getBirthday()));
        return sb.toString();
    }
}

