/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sabre.passengerDetails;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.gds.model.Flight;
import com.gridnine.xtrip.common.gds.model.GdsReservationCreationParameters;
import com.gridnine.xtrip.common.gds.model.GdsTraveller;
import com.gridnine.xtrip.common.gds.sabre.helpers.SabreHelper;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.profile.Passport;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.gds.sabre.IBusGdsSabreContextKeys;
import com.gridnine.xtrip.server.gds.sabre.core.IbusGdsSabreCoreContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.sabre.services.sp.pd.v35.PassengerDetailsRQ;
import java.util.Collection;
import java.util.HashMap;

public class PassengerDetailsAddPersonNamesProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        Flight flight = (Flight)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.FLIGHT);
        GdsReservationCreationParameters parameters = (GdsReservationCreationParameters)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION_CREATION_PARAMETERS);
        Collection travellers = (Collection)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.TRAVELLERS);
        PassengerDetailsRQ request = (PassengerDetailsRQ)ctx.getMandatoryObject((Enum)IbusGdsSabreCoreContextKeys.SABRE_WS_REQUEST_PAYLOAD);
        HashMap<String, String> nameNumbers = new HashMap<String, String>();
        int i = 1;
        for (GdsTraveller gdsTraveller : parameters.getGdsTravellers()) {
            String nameNumber = String.format("%s.1", Integer.toString(i));
            nameNumbers.put(gdsTraveller.getTravellerUid(), nameNumber);
            Traveller traveller = (Traveller)CollectionUtil.find((Iterable)travellers, (String)gdsTraveller.getTravellerUid());
            String passengerType = SabreHelper.getNativeCode((DictionaryReference)gdsTraveller.getPassengerType());
            PassengerDetailsRQ.TravelItineraryAddInfoRQ.CustomerInfo.PersonName pn = new PassengerDetailsRQ.TravelItineraryAddInfoRQ.CustomerInfo.PersonName();
            pn.setGivenName(SabreHelper.buildGivenName((Passport)traveller.getPassport(), (DictionaryReference)gdsTraveller.getPassengerType(), (SabreHelper.SabreAviaParametersProvider)new SabreHelper.FlightParametersProvider(flight, traveller.getPassport())));
            pn.setInfant(Boolean.valueOf(DictHelper.isInfantPassengerType((DictionaryReference)gdsTraveller.getPassengerType())));
            pn.setNameNumber(nameNumber);
            pn.setPassengerType(passengerType);
            pn.setSurname(SabreHelper.buildSurname((Passport)traveller.getPassport(), (boolean)true));
            request.getTravelItineraryAddInfoRQ().getCustomerInfo().getPersonNameList().add(pn);
            ++i;
        }
        ctx.putObject((Enum)IBusGdsSabreContextKeys.NAME_NUMBERS, nameNumbers);
    }
}

