/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sabre.passengerDetails;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.gds.helper.PccHelper;
import com.gridnine.xtrip.common.gds.model.Flight;
import com.gridnine.xtrip.common.model.profile.Pcc;
import com.gridnine.xtrip.common.model.profile.PccParameterName;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.gds.sabre.core.IbusGdsSabreCoreContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.sabre.services.sp.pd.v35.PassengerDetailsRQ;
import org.apache.commons.lang.StringUtils;

public class PassengerDetailsAddQueueIdentifierProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        Pcc pcc = (Pcc)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.PCC);
        Flight flight = (Flight)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.FLIGHT);
        PassengerDetailsRQ request = (PassengerDetailsRQ)ctx.getMandatoryObject((Enum)IbusGdsSabreCoreContextKeys.SABRE_WS_REQUEST_PAYLOAD);
        boolean docoDocaNeeded = flight.getVisaRequirements().size() > 0;
        PccParameterName pccParameterName = docoDocaNeeded ? PccParameterName.SABRE_DOCO_DOCA_QUEUE : PccParameterName.COMMON_BOOKING_QUEUE;
        String queueNumber = PccHelper.getPccParameter((Pcc)pcc, (PccParameterName)pccParameterName);
        if (!StringUtils.isBlank((String)queueNumber)) {
            PassengerDetailsRQ.PostProcessing.QueuePlaceRQ queuePlaceRQ = request.getPostProcessing().getQueuePlaceRQ();
            if (queuePlaceRQ == null) {
                queuePlaceRQ = new PassengerDetailsRQ.PostProcessing.QueuePlaceRQ();
                PassengerDetailsRQ.PostProcessing.QueuePlaceRQ.QueueInfo info = new PassengerDetailsRQ.PostProcessing.QueuePlaceRQ.QueueInfo();
                queuePlaceRQ.setQueueInfo(info);
                request.getPostProcessing().setQueuePlaceRQ(queuePlaceRQ);
            }
            PassengerDetailsRQ.PostProcessing.QueuePlaceRQ.QueueInfo.QueueIdentifier qi = new PassengerDetailsRQ.PostProcessing.QueuePlaceRQ.QueueInfo.QueueIdentifier();
            qi.setPseudoCityCode(pcc.getCode());
            qi.setNumber(queueNumber);
            qi.setPrefatoryInstructionCode("11");
            request.getPostProcessing().getQueuePlaceRQ().getQueueInfo().getQueueIdentifierList().add(qi);
        }
    }
}

