/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sabre.passengerDetails;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.gds.helper.FlightHelper;
import com.gridnine.xtrip.common.gds.model.Flight;
import com.gridnine.xtrip.common.gds.model.FlightSegment;
import com.gridnine.xtrip.common.gds.model.FlightSegmentTariff;
import com.gridnine.xtrip.common.gds.model.GdsReservationCreationParameters;
import com.gridnine.xtrip.common.gds.model.GdsTraveller;
import com.gridnine.xtrip.common.gds.sabre.helpers.SabreHelper;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.gds.sabre.core.IbusGdsSabreCoreContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.sabre.services.sp.pd.v35.PassengerDetailsRQ;
import java.math.BigInteger;
import java.util.Date;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class PassengerDetailsAddRetentionSegmentProcessor
extends BaseProcessor {
    private static DateTimeFormatter DF_MISC_SEGMENT = DateTimeFormat.forPattern((String)"MM-dd");

    public void process(MessageContext ctx) throws Exception {
        Flight flight = (Flight)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.FLIGHT);
        Date lastArrivalTime = FlightHelper.getLastArrivalTime((Flight)flight);
        DateTime plus179Days = DateTime.now();
        if (lastArrivalTime.after((plus179Days = plus179Days.plusDays(179)).toDate())) {
            return;
        }
        PassengerDetailsRQ request = (PassengerDetailsRQ)ctx.getMandatoryObject((Enum)IbusGdsSabreCoreContextKeys.SABRE_WS_REQUEST_PAYLOAD);
        GdsReservationCreationParameters parameters = (GdsReservationCreationParameters)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION_CREATION_PARAMETERS);
        int totalSeats = 0;
        for (GdsTraveller gdsTraveller : parameters.getGdsTravellers()) {
            if (DictHelper.isInfantPassengerType((DictionaryReference)gdsTraveller.getPassengerType())) continue;
            ++totalSeats;
        }
        PassengerDetailsRQ.MiscSegmentSellRQ miscSegmentSellReq = new PassengerDetailsRQ.MiscSegmentSellRQ();
        miscSegmentSellReq.setMiscSegmentDepartureDateTime(DF_MISC_SEGMENT.print((ReadableInstant)plus179Days));
        miscSegmentSellReq.setMiscSegmentNumberInParty(new BigInteger(Integer.toString(totalSeats)));
        miscSegmentSellReq.setMiscSegmentStatus("GK");
        miscSegmentSellReq.setMiscSegmentType(PassengerDetailsRQ.MiscSegmentSellRQ.Type.OTH);
        miscSegmentSellReq.setMiscSegmentText("RETENTION SEGMENT");
        miscSegmentSellReq.setMiscSegmentOriginLocation(SabreHelper.getNativeCode((DictionaryReference)((FlightSegment)((FlightSegmentTariff)flight.getSegmentTariffs().get(0)).getSegments().get(0)).getLocationBegin()));
        miscSegmentSellReq.setMiscSegmentVendorPrefs(SabreHelper.getNativeCode((DictionaryReference)flight.getCarrier()));
        request.setMiscSegmentSellRQ(miscSegmentSellReq);
    }
}

