/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sabre.passengerDetails;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.gds.helper.GdsDictHelper;
import com.gridnine.xtrip.common.gds.model.GdsTraveller;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.dict.CommunicationType;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.profile.Communication;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.gds.sabre.IBusGdsSabreContextKeys;
import com.gridnine.xtrip.server.gds.sabre.core.IbusGdsSabreCoreContextKeys;
import com.gridnine.xtrip.server.gds.sabre.passengerDetails.PassengerDetailsHelper;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.sabre.services.sp.pd.v35.PassengerDetailsRQ;

public class PassengerDetailsAddSsrCTCxProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        GdsTraveller gdsTraveller = (GdsTraveller)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.GDS_TRAVELLER);
        Traveller traveller = (Traveller)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.TRAVELLER);
        String nameNumber = (String)ctx.getMandatoryObject((Enum)IBusGdsSabreContextKeys.NAME_NUMBER);
        PassengerDetailsRQ request = (PassengerDetailsRQ)ctx.getMandatoryObject((Enum)IbusGdsSabreCoreContextKeys.SABRE_WS_REQUEST_PAYLOAD);
        boolean hasCtcx = false;
        for (Communication comm : traveller.getCommunications()) {
            MiscUtil.Pair<String, String> data = PassengerDetailsAddSsrCTCxProcessor.buildSsrCTCxText(comm);
            if (data == null) continue;
            hasCtcx = true;
            PassengerDetailsHelper.addSsr((String)data.getFirst(), null, nameNumber, (String)data.getSecond(), request.getSpecialReqDetails().getSpecialServiceRQ().getServiceList());
        }
        if (!hasCtcx && !GdsDictHelper.isWithoutSeat((DictionaryReference)gdsTraveller.getPassengerType())) {
            PassengerDetailsHelper.addSsr("CTCR", null, nameNumber, "REFUSED TO PROVIDE INFORMATION", request.getSpecialReqDetails().getSpecialServiceRQ().getServiceList());
        }
    }

    private static MiscUtil.Pair<String, String> buildSsrCTCxText(Communication comm) {
        if (comm.getType() == CommunicationType.MOBILE || comm.getType() == CommunicationType.CELL) {
            StringBuilder sb = new StringBuilder(48);
            sb.append(ProfileHelper.normalizeCommunicationPart((String)comm.getCountryCode()));
            sb.append(ProfileHelper.normalizeCommunicationPart((String)comm.getCityCode()));
            sb.append(ProfileHelper.normalizeCommunicationPart((String)comm.getSense()));
            return new MiscUtil.Pair((Object)"CTCM", (Object)sb.toString());
        }
        if (comm.getType() == CommunicationType.EMAIL) {
            return new MiscUtil.Pair((Object)"CTCE", (Object)PassengerDetailsAddSsrCTCxProcessor.buildEmail(comm));
        }
        return null;
    }

    private static String buildEmail(Communication comm) {
        StringBuilder sb = new StringBuilder(25);
        sb.append(ProfileHelper.normalizeCommunicationPart((String)comm.getSense()).replaceAll("_", "..").replaceAll("@", "//").replaceAll("-", "./"));
        return sb.toString();
    }
}

