/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sabre.passengerDetails;

import com.gridnine.xtrip.server.gds.sabre.core.IbusGdsSabreCoreContextKeys;
import com.gridnine.xtrip.server.gds.sabre.passengerDetails.PassengerDetailsHelper;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.sabre.services.sp.pd.v35.PassengerDetailsRQ;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.commons.lang.time.FastDateFormat;

public class PassengerDetailsAddTimeLimitRemarkProcessor
extends BaseProcessor {
    private static final FastDateFormat DF = FastDateFormat.getInstance((String)"ddMMMyy HHmm", (Locale)Locale.ENGLISH);

    public void process(MessageContext ctx) throws Exception {
        Date newTimeLimit = PassengerDetailsHelper.getTimelimitForRemark(ctx);
        PassengerDetailsRQ request = (PassengerDetailsRQ)ctx.getMandatoryObject((Enum)IbusGdsSabreCoreContextKeys.SABRE_WS_REQUEST_PAYLOAD);
        if (request.getSpecialReqDetails() == null) {
            request.setSpecialReqDetails(new PassengerDetailsRQ.SpecialReqDetails());
        }
        if (request.getSpecialReqDetails().getAddRemarkRQ() == null) {
            request.getSpecialReqDetails().setAddRemarkRQ(new PassengerDetailsRQ.SpecialReqDetails.AddRemarkRQ());
        }
        PassengerDetailsRQ.SpecialReqDetails.AddRemarkRQ.Remark remark = new PassengerDetailsRQ.SpecialReqDetails.AddRemarkRQ.Remark();
        remark.setType(PassengerDetailsRQ.SpecialReqDetails.AddRemarkRQ.Remark.Type.GENERAL);
        remark.setText(PassengerDetailsAddTimeLimitRemarkProcessor.buildText(newTimeLimit));
        request.getSpecialReqDetails().getAddRemarkRQ().getRemarkList().add(remark);
    }

    private static String buildText(Date timeLimit) {
        return "X/-IBE AUTO CANCEL/" + DF.format(timeLimit).toUpperCase() + " " + TimeZone.getDefault().getID().toUpperCase();
    }
}

