/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sabre.passengerDetails;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.gds.sabre.helpers.SabreHelper;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.dict.CommunicationType;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.profile.Communication;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.system.Metadata;
import com.gridnine.xtrip.common.model.system.MetadataKey;
import com.gridnine.xtrip.server.gds.sabre.IBusGdsSabreContextKeys;
import com.gridnine.xtrip.server.gds.sabre.core.IbusGdsSabreCoreContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.sabre.services.sp.pd.v35.PassengerDetailsRQ;
import java.util.Optional;
import org.apache.commons.lang.StringUtils;

public class PassengerDetailsAddTravellerCommunicationsProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        PassengerDetailsRQ request = (PassengerDetailsRQ)ctx.getMandatoryObject((Enum)IbusGdsSabreCoreContextKeys.SABRE_WS_REQUEST_PAYLOAD);
        PassengerDetailsRQ.TravelItineraryAddInfoRQ.CustomerInfo customerInfo = request.getTravelItineraryAddInfoRQ().getCustomerInfo();
        Traveller traveller = (Traveller)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.TRAVELLER);
        String nameNumber = (String)ctx.getMandatoryObject((Enum)IBusGdsSabreContextKeys.NAME_NUMBER);
        SalesContext salesContext = (SalesContext)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.SALES_CONTEXT);
        for (Communication comm : traveller.getCommunications()) {
            if (comm.getType() == CommunicationType.EMAIL) {
                PassengerDetailsRQ.TravelItineraryAddInfoRQ.CustomerInfo.Email email = new PassengerDetailsRQ.TravelItineraryAddInfoRQ.CustomerInfo.Email();
                email.setAddress(ProfileHelper.normalizeCommunicationPart((String)comm.getSense()).replaceAll("_", "=="));
                if (this.isAddNameNumber(salesContext)) {
                    email.setNameNumber(nameNumber);
                }
                if (!StringUtils.isBlank((String)comm.getRemarks())) {
                    email.setShortText(comm.getRemarks());
                }
                customerInfo.getEmailList().add(email);
                continue;
            }
            if (!SabreHelper.COMMUNICATION_TYPES.keySet().contains(comm.getType())) continue;
            if (customerInfo.getContactNumbers() == null) {
                customerInfo.setContactNumbers(new PassengerDetailsRQ.TravelItineraryAddInfoRQ.CustomerInfo.ContactNumbers());
            }
            PassengerDetailsRQ.TravelItineraryAddInfoRQ.CustomerInfo.ContactNumbers.ContactNumber cn = new PassengerDetailsRQ.TravelItineraryAddInfoRQ.CustomerInfo.ContactNumbers.ContactNumber();
            cn.setPhoneUseType((String)SabreHelper.COMMUNICATION_TYPES.get(comm.getType()));
            cn.setPhone(SabreHelper.buildPhoneNumber((Communication)comm));
            cn.setNameNumber(nameNumber);
            customerInfo.getContactNumbers().getContactNumberList().add(cn);
        }
    }

    private boolean isAddNameNumber(SalesContext salesContext) {
        EntityReference subagencyRef = salesContext.getSubagency();
        Organization subagency = (Organization)EntityStorage.get().resolve(subagencyRef).getEntity();
        Optional<Metadata> metadata = subagency.getMetadata().stream().filter(md -> MetadataKey.REMOVE_PASSENGER_BINDING_FROM_PASSENGER_EMAIL_IN_SABRE.name().equals(md.getKey().getCode())).findFirst();
        return !metadata.isPresent() || Boolean.TRUE != metadata.get().getValue();
    }
}

