/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sabre.passengerDetails;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.profile.Communication;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.RiskManagementCompany;
import com.gridnine.xtrip.server.gds.sabre.core.IbusGdsSabreCoreContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.sabre.services.sp.pd.v35.PassengerDetailsRQ;
import java.util.regex.Pattern;

public class PassengerDetailsAddTravellerIjetRemarks
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        SalesContext salesContext = (SalesContext)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.SALES_CONTEXT);
        Organization client = (Organization)EntityStorage.get().resolve(salesContext.getClient()).getEntity();
        if (!client.getRiskManagementCompanies().contains(RiskManagementCompany.IJET)) {
            return;
        }
        PassengerDetailsRQ request = (PassengerDetailsRQ)ctx.getMandatoryObject((Enum)IbusGdsSabreCoreContextKeys.SABRE_WS_REQUEST_PAYLOAD);
        Traveller traveller = (Traveller)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.TRAVELLER);
        for (Communication comm : traveller.getCommunications()) {
            switch (comm.getType()) {
                case MOBILE: {
                    this.addPhoneRemark(request, comm);
                    break;
                }
                case EMAIL: {
                    this.addEmailRemark(request, comm);
                    break;
                }
            }
        }
    }

    private void addPhoneRemark(PassengerDetailsRQ request, Communication comm) {
        StringBuilder sb = new StringBuilder();
        sb.append("IJET PHONE/");
        sb.append(ProfileHelper.normalizeCommunicationPart((String)comm.getCountryCode()));
        sb.append(' ');
        sb.append(ProfileHelper.normalizeCommunicationPart((String)comm.getCityCode()));
        sb.append('-');
        sb.append(ProfileHelper.normalizeCommunicationPart((String)comm.getSense()));
        this.addRemark(request, sb.toString());
    }

    private void addEmailRemark(PassengerDetailsRQ request, Communication comm) {
        StringBuilder sb = new StringBuilder();
        sb.append("IJET EMAIL/");
        sb.append(PassengerDetailsAddTravellerIjetRemarks.formatEmail(ProfileHelper.normalizeCommunicationPart((String)comm.getSense())));
        this.addRemark(request, sb.toString());
    }

    private static String formatEmail(String email) {
        return email.replaceAll(Pattern.quote("@"), "//").replaceAll(Pattern.quote("_"), "..").replaceAll(Pattern.quote("-"), "./");
    }

    private void addRemark(PassengerDetailsRQ request, String text) {
        PassengerDetailsRQ.SpecialReqDetails.AddRemarkRQ.Remark remark = new PassengerDetailsRQ.SpecialReqDetails.AddRemarkRQ.Remark();
        remark.setType(PassengerDetailsRQ.SpecialReqDetails.AddRemarkRQ.Remark.Type.ALPHA_CODED);
        remark.setCode("E");
        remark.setText(text);
        request.getSpecialReqDetails().getAddRemarkRQ().getRemarkList().add(remark);
    }
}

