/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sabre.passengerDetails;

import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.gds.sabre.core.IbusGdsSabreCoreContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.sabre.services.sp.pd.v35.PassengerDetailsRQ;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class PassengerDetailsFixDuplicateNamesProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        PassengerDetailsRQ rq = (PassengerDetailsRQ)ctx.getObject((Enum)IbusGdsSabreCoreContextKeys.SABRE_WS_REQUEST_PAYLOAD);
        List personNames = rq.getTravelItineraryAddInfoRQ().getCustomerInfo().getPersonNameList();
        Map<String, List<PassengerDetailsRQ.TravelItineraryAddInfoRQ.CustomerInfo.PersonName>> data = personNames.stream().collect(Collectors.groupingBy(PassengerDetailsFixDuplicateNamesProcessor::buildNameField));
        data.values().stream().filter(l -> l.size() > 1).forEach(l -> {
            if (l.size() > 2) {
                throw Xeption.forEndUser((String)"BOOKING_FOR_THREE_ORE_MORE_SAME_PASSENGERS_NAMES_NOT_SUPPORTED", (Object[])new Object[0]);
            }
            PassengerDetailsRQ.TravelItineraryAddInfoRQ.CustomerInfo.PersonName pn = (PassengerDetailsRQ.TravelItineraryAddInfoRQ.CustomerInfo.PersonName)l.get(0);
            String givenName = pn.getGivenName();
            pn.setGivenName(givenName.substring(0, givenName.lastIndexOf(32)));
        });
    }

    private static String buildNameField(PassengerDetailsRQ.TravelItineraryAddInfoRQ.CustomerInfo.PersonName personName) {
        StringBuilder sb = new StringBuilder();
        if (Boolean.TRUE.equals(personName.getInfant())) {
            sb.append("I/");
        }
        sb.append(MiscUtil.guarded((String)personName.getSurname()).toUpperCase());
        sb.append('/');
        sb.append(MiscUtil.guarded((String)personName.getGivenName()).toUpperCase());
        return sb.toString();
    }
}

