/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sabre.passengerDetails;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.gds.helper.FlightHelper;
import com.gridnine.xtrip.common.gds.helper.PccHelper;
import com.gridnine.xtrip.common.gds.model.Flight;
import com.gridnine.xtrip.common.gds.model.FlightSegment;
import com.gridnine.xtrip.common.gds.model.FlightSegmentTariff;
import com.gridnine.xtrip.common.gds.model.GDSParameters;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.ExpiryWarningTime;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.TimeLimitType;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.Segment;
import com.gridnine.xtrip.common.model.booking.air.SegmentTariff;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.profile.Pcc;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.gds.helper.GDSHelper;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.gds.rules.proxy.GDSParametersActions;
import com.gridnine.xtrip.server.gds.sabre.IBusGdsSabreContextKeys;
import com.gridnine.xtrip.server.gds.sabre.getReservation.GetReservationHelper;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.sabre.services.sp.pd.v35.PassengerDetailsRQ;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.FastDateFormat;

public class PassengerDetailsHelper {
    public static final FastDateFormat DF_SSR = FastDateFormat.getInstance((String)"ddMMMyy", (Locale)Locale.ENGLISH);
    private static final FastDateFormat DF_XML = FastDateFormat.getInstance((String)"MM-dd'T'HH:mm", (Locale)Locale.ENGLISH);

    public static void addSsr(String ssrCode, String segmentNumber, String nameNumber, String text, Collection<PassengerDetailsRQ.SpecialReqDetails.SpecialServiceRQ.Service> services) {
        PassengerDetailsHelper.addService(ssrCode, segmentNumber, null, nameNumber, text, services);
    }

    public static void addOsi(String airlineCode, String nameNumber, String text, Collection<PassengerDetailsRQ.SpecialReqDetails.SpecialServiceRQ.Service> services) {
        PassengerDetailsHelper.addService("OSI", null, airlineCode, nameNumber, text, services);
    }

    private static void addService(String ssrCode, String segmentNumber, String airlineCode, String nameNumber, String text, Collection<PassengerDetailsRQ.SpecialReqDetails.SpecialServiceRQ.Service> services) {
        if (StringUtils.isBlank((String)ssrCode)) {
            throw Xeption.forDeveloper((String)"SSR_Code can't be blank", (Object[])new Object[0]);
        }
        PassengerDetailsRQ.SpecialReqDetails.SpecialServiceRQ.Service service = new PassengerDetailsRQ.SpecialReqDetails.SpecialServiceRQ.Service();
        service.setSSRCode(ssrCode);
        if (!StringUtils.isBlank((String)segmentNumber)) {
            service.setSegmentNumber(segmentNumber);
        }
        PassengerDetailsRQ.SpecialReqDetails.SpecialServiceRQ.Service.VendorPrefs vp = new PassengerDetailsRQ.SpecialReqDetails.SpecialServiceRQ.Service.VendorPrefs();
        if (!StringUtils.isBlank((String)airlineCode)) {
            vp.setAirlineCode(airlineCode);
        }
        service.setVendorPrefs(vp);
        if (nameNumber != null) {
            PassengerDetailsRQ.SpecialReqDetails.SpecialServiceRQ.Service.PersonName pn = new PassengerDetailsRQ.SpecialReqDetails.SpecialServiceRQ.Service.PersonName();
            pn.setNameNumber(nameNumber);
            service.setPersonName(pn);
        }
        service.setText(text);
        services.add(service);
    }

    public static String getMajorNameNumber(MessageContext ctx) {
        DictionaryReference passengerType = (DictionaryReference)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.PASSENGER_TYPE);
        if (!DictHelper.isInfantPassengerType((DictionaryReference)passengerType)) {
            return (String)ctx.getMandatoryObject((Enum)IBusGdsSabreContextKeys.NAME_NUMBER);
        }
        Traveller traveller = (Traveller)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.TRAVELLER);
        Map associations = (Map)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.INFANT_TO_MAJOR_ASSOCIATIONS);
        String majorTravellerUid = (String)associations.get(traveller.getUid());
        Map nameNumbers = (Map)ctx.getMandatoryObject((Enum)IBusGdsSabreContextKeys.NAME_NUMBERS);
        return (String)nameNumbers.get(majorTravellerUid);
    }

    public static PassengerDetailsRQ.TravelItineraryAddInfoRQ.AgencyInfo.Ticketing build7TAWBlock(MessageContext ctx) {
        GDSParameters gdsParameters = (GDSParameters)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.GDS_PARAMETERS);
        Date timelimitFor7TAW = PassengerDetailsHelper.getTimelimitFor7Taw(ctx);
        PassengerDetailsRQ.TravelItineraryAddInfoRQ.AgencyInfo.Ticketing ticketing = new PassengerDetailsRQ.TravelItineraryAddInfoRQ.AgencyInfo.Ticketing();
        ticketing.setTicketType("7TAW");
        if (timelimitFor7TAW != null) {
            ticketing.setTicketTimeLimit(DF_XML.format(timelimitFor7TAW));
        }
        ticketing.setPseudoCityCode(PccHelper.getTicketingPccCode((GDSParameters)gdsParameters));
        return ticketing;
    }

    public static Date getTimelimitForRemark(MessageContext ctx) throws Exception {
        Date resDate;
        Date pqTimeLimit;
        Date startDate;
        DictionaryReference departureLocation;
        FlightSegment seg0;
        Date newPqTimeLimit = GetReservationHelper.getConvertedLastTicketingDate(ctx);
        Flight flight = (Flight)ctx.getObject((Enum)IBusGdsContextKeys.FLIGHT);
        Reservation reservation = (Reservation)ctx.getObject((Enum)IBusMidofficeContextKeys.RESERVATION);
        GDSParametersActions actions = (GDSParametersActions)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.GDS_PARAMETERS_ACTIONS);
        if (reservation == null || reservation.getProducts().isEmpty()) {
            seg0 = (FlightSegment)FlightHelper.getSegments((Flight)flight).get(0);
            departureLocation = seg0.getLocationBegin();
            startDate = seg0.getDateBegin();
            pqTimeLimit = flight.getPqTimeLimit();
            resDate = new Date();
        } else {
            seg0 = (Segment)((SegmentTariff)((Product)GDSHelper.getProducts((Reservation)reservation).get(0)).getSegmentTariffs().get(0)).getSegments().get(0);
            departureLocation = seg0.getDepartureLocation();
            startDate = seg0.getStartDate();
            pqTimeLimit = reservation.getPqTimeLimit();
            resDate = Optional.ofNullable(reservation.getResDate()).orElse(new Date());
        }
        Date newTimeLimit = FlightHelper.calculateTimeLimit((TimeLimitType)actions.getTimeLimitType(), (int)actions.getTimeForTimeLimit(), (Date)Optional.ofNullable(newPqTimeLimit).orElse(pqTimeLimit), (DictionaryReference)departureLocation, (Date)startDate, (Date)resDate);
        return MiscUtil.clearTime((Date)newTimeLimit, (boolean)false, (boolean)false, (boolean)true, (boolean)true);
    }

    public static Date getTimelimitFor7Taw(MessageContext ctx) {
        Date now;
        LocalDate firstTravelDate;
        List expiryWarningTimes;
        EntityReference salesPointRef;
        Flight flight = (Flight)ctx.getObject((Enum)IBusGdsContextKeys.FLIGHT);
        if (flight != null) {
            SalesContext salesContext = (SalesContext)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.SALES_CONTEXT);
            salesPointRef = salesContext.getSalesPoint();
            expiryWarningTimes = flight.getTimeLimitExpiryWarningTime();
            firstTravelDate = PassengerDetailsHelper.getLocalDate(((FlightSegment)((FlightSegmentTariff)flight.getSegmentTariffs().get(0)).getSegments().get(0)).getDateBegin());
        } else {
            Reservation reservation = (Reservation)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION);
            Product product = (Product)AirProductHelper.getAirProductsList((Reservation)reservation).get(0);
            salesPointRef = product.getSalesPoint();
            expiryWarningTimes = reservation.getTimeLimitExpiryWarningTime();
            firstTravelDate = PassengerDetailsHelper.getLocalDate(((Segment)((SegmentTariff)product.getSegmentTariffs().get(0)).getSegments().get(0)).getStartDate());
        }
        GDSParameters gdsParameters = (GDSParameters)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.GDS_PARAMETERS);
        Pcc ticketingPcc = PccHelper.getTicketingPcc((GDSParameters)gdsParameters, (EntityReference)salesPointRef, (GdsName)GdsName.SABRE);
        Date minExpiryWarningTime = expiryWarningTimes.stream().map(ExpiryWarningTime::getTimeLimitExpiryWarningTime).min(Comparator.naturalOrder()).orElseThrow(() -> Xeption.forAdmin((String)"EXPIRATION_TIME_LIMIT_WARNING_NOT_CONFIGURED", (Object[])new Object[0]));
        Date result = MiscUtil.clearTime((Date)GDSHelper.convertTimelimitToPcc((Date)minExpiryWarningTime, (Pcc)ticketingPcc), (boolean)false, (boolean)true, (boolean)true, (boolean)true);
        if (PassengerDetailsHelper.getLocalDate(result).isAfter(firstTravelDate)) {
            result = Date.from(firstTravelDate.minusDays(1L).atTime(23, 0).atZone(ZoneId.systemDefault()).toInstant());
        }
        return ChronoUnit.MINUTES.between((now = GDSHelper.convertTimelimitToPcc((Date)new Date(), (Pcc)ticketingPcc)).toInstant(), result.toInstant()) > 5L ? result : null;
    }

    private static LocalDate getLocalDate(Date date) {
        return date.toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime().toLocalDate();
    }
}

