/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sabre.passengerDetails;

import com.gridnine.xtrip.server.gds.sabre.core.IbusGdsSabreCoreContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.sabre.services.sp.pd.v35.PassengerDetailsRQ;
import java.util.Map;

public class PassengerDetailsRQBuilder
extends BaseProcessor {
    private boolean buildTravelItineraryAddInfoRQ = true;
    private boolean buildSpecialServiceRQ = true;
    private boolean buildAddRemarkRQ = true;
    private boolean redisplayReservation = true;

    public void configure(Map<String, String> parameters) {
        if (parameters.containsKey("travelItineraryAddInfoRQ")) {
            this.buildTravelItineraryAddInfoRQ = Boolean.parseBoolean(parameters.get("travelItineraryAddInfoRQ"));
        }
        if (parameters.containsKey("specialServiceRQ")) {
            this.buildSpecialServiceRQ = Boolean.parseBoolean(parameters.get("specialServiceRQ"));
        }
        if (parameters.containsKey("addRemarkRQ")) {
            this.buildAddRemarkRQ = Boolean.parseBoolean(parameters.get("addRemarkRQ"));
        }
        if (parameters.containsKey("redisplayReservation")) {
            this.redisplayReservation = Boolean.parseBoolean(parameters.get("redisplayReservation"));
        }
    }

    public void process(MessageContext ctx) throws Exception {
        PassengerDetailsRQ request = this.buildRequest();
        ctx.putObject((Enum)IbusGdsSabreCoreContextKeys.SABRE_WS_REQUEST_PAYLOAD, (Object)request);
        ctx.putObject((Enum)IbusGdsSabreCoreContextKeys.SABRE_WS_SERVICE_ACTION_CODE, (Object)"PassengerDetailsRQ");
    }

    private PassengerDetailsRQ buildRequest() {
        PassengerDetailsRQ request = new PassengerDetailsRQ();
        request.setVersion("3.5.0");
        request.setHaltOnError(Boolean.TRUE);
        if (this.buildTravelItineraryAddInfoRQ) {
            PassengerDetailsRQ.TravelItineraryAddInfoRQ travelItineraryAddInfoRQ = new PassengerDetailsRQ.TravelItineraryAddInfoRQ();
            PassengerDetailsRQ.TravelItineraryAddInfoRQ.CustomerInfo customerInfo = new PassengerDetailsRQ.TravelItineraryAddInfoRQ.CustomerInfo();
            travelItineraryAddInfoRQ.setCustomerInfo(customerInfo);
            request.setTravelItineraryAddInfoRQ(travelItineraryAddInfoRQ);
        }
        if (this.buildSpecialServiceRQ || this.buildAddRemarkRQ) {
            PassengerDetailsRQ.SpecialReqDetails specialReqDetails = new PassengerDetailsRQ.SpecialReqDetails();
            if (this.buildSpecialServiceRQ) {
                PassengerDetailsRQ.SpecialReqDetails.SpecialServiceRQ specialServiceReq = new PassengerDetailsRQ.SpecialReqDetails.SpecialServiceRQ();
                specialReqDetails.setSpecialServiceRQ(specialServiceReq);
            }
            if (this.buildAddRemarkRQ) {
                PassengerDetailsRQ.SpecialReqDetails.AddRemarkRQ addRemarkRQ = new PassengerDetailsRQ.SpecialReqDetails.AddRemarkRQ();
                specialReqDetails.setAddRemarkRQ(addRemarkRQ);
            }
            request.setSpecialReqDetails(specialReqDetails);
        }
        PassengerDetailsRQ.PostProcessing postProcessing = new PassengerDetailsRQ.PostProcessing();
        if (this.redisplayReservation) {
            postProcessing.setRedisplayReservation(new PassengerDetailsRQ.PostProcessing.RedisplayReservation());
        }
        request.setPostProcessing(postProcessing);
        return request;
    }
}

