/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sabre.passivesegments;

import com.gridnine.xtrip.common.model.dict.SpecialServiceRequestCategory;
import com.gridnine.xtrip.common.model.gds.sabre.ProfileSynchronizationUtil;
import com.gridnine.xtrip.common.model.gds.sabre.SabreProfileLineDataProxy;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.profile.SabreProfileCommand2Osi;
import com.gridnine.xtrip.common.model.profile.SabreProfileCommand4SSR;
import com.gridnine.xtrip.common.model.profile.SabreProfileLine;
import com.gridnine.xtrip.common.model.profile.SabreProfileLineServiceType;
import com.gridnine.xtrip.common.util.TextUtil;
import com.sabre.services.sp.pd.v35.PassengerDetailsRQ;
import java.util.Collections;
import java.util.List;
import java.util.TreeMap;

public class PassivePassengerDetailsProfileRemarksHelper {
    public static void addAdditionalProfileLines(PassengerDetailsRQ request, List<SabreProfileLine> additionalProfileLines) {
        TreeMap remarksMap = new TreeMap();
        boolean needServiceTypeInRemarkBody = true;
        ProfileSynchronizationUtil.addGeneralRemarks(additionalProfileLines, (String)"AAA", (boolean)needServiceTypeInRemarkBody, remarksMap);
        for (SabreProfileLineServiceType serviceType : SabreProfileLineServiceType.values()) {
            for (SabreProfileLineDataProxy proxy : ProfileSynchronizationUtil.createRemarkList(remarksMap, (String)ProfileSynchronizationUtil.getLineServiceTypeString((SabreProfileLineServiceType)serviceType), (String)"AAA", (boolean)false)) {
                PassivePassengerDetailsProfileRemarksHelper.addAlphaCodedRemark(request, proxy);
            }
        }
        for (SabreProfileLineDataProxy proxy : ProfileSynchronizationUtil.createRemarkList(remarksMap, (String)"AAA", (String)"AAA", (boolean)false)) {
            PassivePassengerDetailsProfileRemarksHelper.addAlphaCodedRemark(request, proxy);
        }
    }

    public static void addSabreFreeTextRemarks(PassengerDetailsRQ request, List<String> sabreFreeTextRemarks) {
        for (SabreProfileLineDataProxy proxy : ProfileSynchronizationUtil.createFreeTextRemarksList(sabreFreeTextRemarks)) {
            PassivePassengerDetailsProfileRemarksHelper.addGeneralRemark(request, proxy);
        }
    }

    public static void addSabreAdditionalCommand2Lines(PassengerDetailsRQ request, List<SabreProfileCommand2Osi> sabreAdditionalCommand2Lines) {
        for (SabreProfileLineDataProxy proxy : ProfileSynchronizationUtil.createSabreAdditionalCommands(Collections.emptyList(), sabreAdditionalCommand2Lines, Collections.emptyList(), Collections.emptyList())) {
            PassivePassengerDetailsProfileRemarksHelper.addOsi(request, proxy);
        }
    }

    public static void addSabreAdditionalCommand4Lines(PassengerDetailsRQ request, List<SabreProfileCommand4SSR> sabreAdditionalCommand4Lines) {
        for (SabreProfileLineDataProxy proxy : ProfileSynchronizationUtil.createSabreAdditionalCommands(Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), sabreAdditionalCommand4Lines)) {
            PassivePassengerDetailsProfileRemarksHelper.addSsr(request, proxy);
        }
    }

    public static void addSsr(PassengerDetailsRQ request, SabreProfileLineDataProxy proxy) {
        if ("P".equals(proxy.getLineType())) {
            return;
        }
        PassengerDetailsRQ.SpecialReqDetails.SpecialServiceRQ.Service service = new PassengerDetailsRQ.SpecialReqDetails.SpecialServiceRQ.Service();
        service.setSSRCode(proxy.getLine().contains("/") ? proxy.getLine().substring(1, proxy.getLine().indexOf(47)) : proxy.getLine().substring(1));
        service.setText(proxy.getLine().contains("/") ? proxy.getLine().substring(proxy.getLine().indexOf(47) + 1) : null);
        request.getSpecialReqDetails().getSpecialServiceRQ().getServiceList().add(service);
    }

    public static void addOsi(PassengerDetailsRQ request, SabreProfileLineDataProxy proxy) {
        if ("P".equals(proxy.getLineType())) {
            return;
        }
        PassengerDetailsRQ.SpecialReqDetails.SpecialServiceRQ.Service service = new PassengerDetailsRQ.SpecialReqDetails.SpecialServiceRQ.Service();
        service.setSSRCode("OSI");
        PassengerDetailsRQ.SpecialReqDetails.SpecialServiceRQ.Service.VendorPrefs vendorPrefs = new PassengerDetailsRQ.SpecialReqDetails.SpecialServiceRQ.Service.VendorPrefs();
        vendorPrefs.setAirlineCode(proxy.getLine().substring(5, 7));
        service.setVendorPrefs(vendorPrefs);
        service.setText(proxy.getLine().substring(8));
        request.getSpecialReqDetails().getSpecialServiceRQ().getServiceList().add(service);
    }

    public static void addAlphaCodedRemark(PassengerDetailsRQ request, SabreProfileLineDataProxy proxy) {
        if ("P".equals(proxy.getLineType())) {
            return;
        }
        PassengerDetailsRQ.SpecialReqDetails.AddRemarkRQ.Remark remark = new PassengerDetailsRQ.SpecialReqDetails.AddRemarkRQ.Remark();
        remark.setType(PassengerDetailsRQ.SpecialReqDetails.AddRemarkRQ.Remark.Type.ALPHA_CODED);
        remark.setCode(proxy.getLine().substring(1, 2));
        remark.setText(proxy.getLine().substring(3));
        request.getSpecialReqDetails().getAddRemarkRQ().getRemarkList().add(remark);
    }

    public static void addGeneralRemark(PassengerDetailsRQ request, SabreProfileLineDataProxy proxy) {
        if ("P".equals(proxy.getLineType())) {
            return;
        }
        PassengerDetailsRQ.SpecialReqDetails.AddRemarkRQ.Remark remark = new PassengerDetailsRQ.SpecialReqDetails.AddRemarkRQ.Remark();
        remark.setType(PassengerDetailsRQ.SpecialReqDetails.AddRemarkRQ.Remark.Type.GENERAL);
        remark.setText(proxy.getLine().substring(1));
        request.getSpecialReqDetails().getAddRemarkRQ().getRemarkList().add(remark);
    }

    public static void addItineraryRemark(PassengerDetailsRQ request, SabreProfileLineDataProxy proxy) {
        if ("P".equals(proxy.getLineType())) {
            return;
        }
        PassengerDetailsRQ.SpecialReqDetails.AddRemarkRQ.Remark remark = new PassengerDetailsRQ.SpecialReqDetails.AddRemarkRQ.Remark();
        remark.setType(PassengerDetailsRQ.SpecialReqDetails.AddRemarkRQ.Remark.Type.ITINERARY);
        remark.setText(proxy.getLine().substring(2));
        request.getSpecialReqDetails().getAddRemarkRQ().getRemarkList().add(remark);
    }

    public static void removeMealSsr(PassengerDetailsRQ request) {
        request.getSpecialReqDetails().getSpecialServiceRQ().getServiceList().removeIf(service -> {
            String code = service.getSSRCode();
            if (TextUtil.isBlank((String)code)) {
                return false;
            }
            return DictHelper.getSpecialServiceRequestsByCategory((SpecialServiceRequestCategory)SpecialServiceRequestCategory.MEALS).stream().anyMatch(dict -> dict.getCodeVariants().values().stream().anyMatch(codeVariant -> TextUtil.isSame((String)code, (String)codeVariant, (boolean)true)));
        });
    }
}

