/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sabre.passivesegments;

import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.l10n.model.LocaleManager;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.helpers.MessageHelper;
import com.gridnine.xtrip.common.model.l10n.Messages;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.gds.sabre.IBusGdsSabreContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseAdvice;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.sabre.services.sp.pd.v35.PassengerDetailsRQ;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

public class SabrePassiveSegmentsEndTransactionAdvice
extends BaseAdvice {
    private static final Pattern remarkIllegalSymbols = Pattern.compile("[()!%$]");

    public void before(MessageContext ctx) throws Exception {
        Integer endTransactionCount = (Integer)ctx.getObject((Enum)IBusGdsSabreContextKeys.PASSIVE_SEGMENTS_END_TRANSACTION_COUNT);
        if (endTransactionCount == null) {
            ctx.putObject((Enum)IBusGdsSabreContextKeys.PASSIVE_SEGMENTS_END_TRANSACTION_COUNT, (Object)1);
        } else {
            ctx.putObject((Enum)IBusGdsSabreContextKeys.PASSIVE_SEGMENTS_END_TRANSACTION_COUNT, (Object)(endTransactionCount + 1));
        }
    }

    public boolean handleException(Throwable e, MessageContext ctx) {
        String remarksWithIllegalCharacters;
        L10nResourcesManager l10nResourcesManager;
        String s;
        List remarks = (List)ctx.getObject((Enum)IBusGdsSabreContextKeys.PASSIVE_SEGMENTS_REMARKS_TO_ADD_PARTIAL);
        Set errors = (Set)ctx.getObject((Enum)IBusGdsSabreContextKeys.PASSIVE_SEGMENTS_RESPONSE_ERRORS);
        Set warnings = (Set)ctx.getObject((Enum)IBusGdsSabreContextKeys.PASSIVE_SEGMENTS_RESPONSE_WARNINGS);
        String requestType = (String)ctx.getMandatoryObject((Enum)IBusGdsSabreContextKeys.PASSIVE_SEGMENTS_REQUEST_TYPE);
        Integer endTransactionCount = (Integer)ctx.getObject((Enum)IBusGdsSabreContextKeys.PASSIVE_SEGMENTS_END_TRANSACTION_COUNT);
        String msg = e.getMessage();
        if (e instanceof Xeption && ((Xeption)e).getEndUserMessage() != null && !TextUtil.isBlank((String)(s = (l10nResourcesManager = LocaleManager.get().getL10nResourceManager()).getMessage(((Xeption)e).getEndUserMessage())))) {
            msg = s;
        }
        if (StringUtils.isBlank((String)(remarksWithIllegalCharacters = this.getRemarksWithIllegalCharacters(remarks)))) {
            errors.add(MessageHelper.createErrorMessage((String)Messages.sabrePassiveSegmentsPassengerDetailsException, (Object[])new Object[]{msg}));
        } else {
            errors.add(MessageHelper.createErrorMessage((String)Messages.sabrePassiveSegmentsRemarksIllegalSymbolsException, (Object[])new Object[]{remarksWithIllegalCharacters}));
        }
        ctx.putObject((Enum)IBusGdsSabreContextKeys.PASSIVE_SEGMENTS_RESPONSE_STATUS, (Object)"ERROR");
        return true;
    }

    private String getRemarksWithIllegalCharacters(List<PassengerDetailsRQ.SpecialReqDetails.AddRemarkRQ.Remark> remarks) {
        if (remarks == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("\n");
        for (PassengerDetailsRQ.SpecialReqDetails.AddRemarkRQ.Remark remark : remarks) {
            if (!remarkIllegalSymbols.matcher(remark.getText()).find()) continue;
            sb.append(remark.getText());
            sb.append("\n");
        }
        return sb.toString();
    }
}

