/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sabre.passivesegments;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.gds.sabre.SabrePassiveSegmentsAccessSettings;
import com.gridnine.xtrip.common.gds.sabre.model.SabreGdsAccount;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.IntegrationBusException;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.MessageHelper;
import com.gridnine.xtrip.common.model.l10n.Messages;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.PersonIndex;
import com.gridnine.xtrip.common.model.system.BasicSystemSettingsIndex;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.XSerializable;
import com.gridnine.xtrip.server.gds.sabre.IBusGdsSabreContextKeys;
import com.gridnine.xtrip.server.ibus.IntegrationBusAdapter;
import com.gridnine.xtrip.server.ibus.IntegrationBusFacade;
import com.gridnine.xtrip.server.model.synchronization.SynchronizationHandler;
import com.gridnine.xtrip.server.model.synchronization.SynchronizationRequest;
import com.gridnine.xtrip.server.model.synchronization.SynchronizationResponse;
import com.gridnine.xtrip.server.model.synchronization.sabrepassive.SabrePassiveSegmentsRequest;
import com.gridnine.xtrip.server.model.synchronization.sabrepassive.SabrePassiveSegmentsResponse;
import com.gridnine.xtrip.server.model.synchronization.sabrepassive.SabrePassiveSegmentsResponseType;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.jibx.ws.soap.SoapFaultException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SabrePassiveSegmentsHandler
implements SynchronizationHandler<SabrePassiveSegmentsRequest, SabrePassiveSegmentsResponse> {
    protected final transient Logger log = LoggerFactory.getLogger(this.getClass());

    public String getOperationId() {
        return "sabre-passive-segments";
    }

    public SynchronizationResponse<SabrePassiveSegmentsResponse> process(SynchronizationRequest<SabrePassiveSegmentsRequest> request) throws Exception {
        SynchronizationResponse result = new SynchronizationResponse();
        SabrePassiveSegmentsResponse synchResponse = new SabrePassiveSegmentsResponse();
        result.setData((XSerializable)synchResponse);
        if (request == null || request.getData() == null || ((SabrePassiveSegmentsRequest)request.getData()).getRequestType() == null) {
            this.log.error("process() : request is null or request.getData() is null or request.getData().getRequestType() is null. UNKNOWN status is set.");
            synchResponse.setResponseType(SabrePassiveSegmentsResponseType.ERROR);
            return result;
        }
        LinkedHashSet<Object> messages = new LinkedHashSet<Object>();
        SabrePassiveSegmentsRequest synchRequest = (SabrePassiveSegmentsRequest)request.getData();
        SabrePassiveSegmentsAccessSettings accessSettings = SabrePassiveSegmentsHandler.getSabrePassiveSegmentsAccessSettings();
        SalesContext salesContext = null;
        if (accessSettings == null || !accessSettings.isActive()) {
            messages.add(MessageHelper.createErrorMessage((String)Messages.sabrePassiveSegmentsAccessNotFoundOrNotActive, (Object[])new Object[0]));
            this.log.error("Sabre Passive Segments Access settings not found or not active");
            synchResponse.setResponseType(SabrePassiveSegmentsResponseType.ERROR);
        } else if (accessSettings.getGdsAccount() == null) {
            messages.add(MessageHelper.createErrorMessage((String)Messages.sabrePassiveSegmentsAccessGDSAccountNotSet, (Object[])new Object[0]));
            this.log.error("Reservation system account is not set in Sabre Passive segments Access settings");
            synchResponse.setResponseType(SabrePassiveSegmentsResponseType.ERROR);
        } else {
            salesContext = SabrePassiveSegmentsHandler.createSalesContext();
        }
        if (salesContext == null) {
            synchResponse.setResponseType(SabrePassiveSegmentsResponseType.ERROR);
        } else {
            Map<String, Object> data = this.prepareIbusContext(synchRequest, salesContext, (EntityReference<SabreGdsAccount>)accessSettings.getGdsAccount());
            try {
                SabrePassiveSegmentsHandler.getAdapter("gds:sabre:passive-segments:create-passive-segments-route").processSync(data);
                String status = (String)data.get(IBusGdsSabreContextKeys.PASSIVE_SEGMENTS_RESPONSE_STATUS.name());
                if ("ERROR".equals(status)) {
                    synchResponse.setResponseType(SabrePassiveSegmentsResponseType.ERROR);
                } else if ("WARNING".equals(status)) {
                    synchResponse.setResponseType(SabrePassiveSegmentsResponseType.WARNING);
                } else {
                    synchResponse.setResponseType(SabrePassiveSegmentsResponseType.SUCCESS);
                }
                synchResponse.setResponsePNR((String)data.get(IBusGdsSabreContextKeys.PASSIVE_SEGMENTS_REQUEST_PNR.name()));
                synchResponse.setResponsePCC((String)data.get(IBusGdsSabreContextKeys.PASSIVE_SEGMENTS_REQUEST_PCC.name()));
                Collection iBusMessages = ((Map)data.get("messages")).values();
                if (iBusMessages != null) {
                    messages.addAll(iBusMessages);
                }
                if (data.get(IBusGdsSabreContextKeys.PASSIVE_SEGMENTS_RESPONSE_ERRORS.name()) != null && "ERROR".equals(status)) {
                    messages.addAll((Collection)data.get(IBusGdsSabreContextKeys.PASSIVE_SEGMENTS_RESPONSE_ERRORS.name()));
                }
                if (data.get(IBusGdsSabreContextKeys.PASSIVE_SEGMENTS_RESPONSE_WARNINGS.name()) != null) {
                    messages.addAll((Collection)data.get(IBusGdsSabreContextKeys.PASSIVE_SEGMENTS_RESPONSE_WARNINGS.name()));
                }
            }
            catch (IntegrationBusException ibe) {
                this.log.error("process() : exception happened: " + ibe.toString());
                if (ibe.getCause() instanceof SoapFaultException && ibe.getMessage().contains("Authentication failed")) {
                    EntityContainer gdsAccountCont = (EntityContainer)data.get(IBusMidofficeContextKeys.GDS_ACCOUNT.name());
                    String ipcc = gdsAccountCont != null ? ((SabreGdsAccount)gdsAccountCont.getEntity()).getPrimaryPCC() : "";
                    messages.add(MessageHelper.createErrorMessage((String)Messages.sabreProfilesIPCCConnectionFailed, (Object[])new Object[]{ipcc}));
                }
                messages.add(MessageHelper.createExceptonMessage((String)Messages.sabrePassiveSegmentsGeneralException, (Throwable)ibe, (Object[])new Object[0]));
            }
        }
        synchResponse.getMessages().addAll(messages);
        result.setDate(new Date());
        return result;
    }

    public static SabrePassiveSegmentsAccessSettings getSabrePassiveSegmentsAccessSettings() {
        SabrePassiveSegmentsAccessSettings res = null;
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)BasicSystemSettingsIndex.Property.installationId.name(), (Object)"sabre-passive-segments-access-settings-uid"));
        List indices = EntityStorage.get().search(BasicSystemSettingsIndex.class, query).getData();
        if (indices == null) {
            return res;
        }
        for (BasicSystemSettingsIndex ind : indices) {
            EntityContainer setCont = EntityStorage.get().resolve(ind.getSource());
            if (setCont == null || !(setCont.getEntity() instanceof SabrePassiveSegmentsAccessSettings) || !((SabrePassiveSegmentsAccessSettings)setCont.getEntity()).isActive()) continue;
            res = (SabrePassiveSegmentsAccessSettings)setCont.getEntity();
            break;
        }
        return res;
    }

    private Map<String, Object> prepareIbusContext(SabrePassiveSegmentsRequest synchRequest, SalesContext salesContext, EntityReference<SabreGdsAccount> gdsAccount) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        EntityContainer gdsAccountCont = EntityStorage.get().resolve(gdsAccount);
        data.put(IBusGdsSabreContextKeys.PASSIVE_SEGMENTS_REQUEST.name(), synchRequest);
        data.put(IBusGdsSabreContextKeys.PASSIVE_SEGMENTS_REQUEST_TYPE.name(), synchRequest.getRequestType().name());
        data.put(IBusMidofficeContextKeys.GDS_ACCOUNT.name(), gdsAccountCont);
        data.put(IBusMidofficeContextKeys.SALES_CONTEXT.name(), salesContext);
        data.put(IBusGdsSabreContextKeys.PASSIVE_SEGMENTS_REQUEST_PCC.name(), synchRequest.getPcc());
        data.put(IBusGdsSabreContextKeys.RESULT_PCC.name(), synchRequest.getPcc());
        data.put(IBusGdsSabreContextKeys.PASSIVE_SEGMENTS_BOOKING_FILE_CONTAINER_UID.name(), synchRequest.getBookingFileContainerUid());
        data.put(IBusGdsSabreContextKeys.PASSIVE_SEGMENTS_PRODUCTS_UIDS.name(), synchRequest.getProductUids());
        return data;
    }

    public static SalesContext createSalesContext() {
        EntityReference<Person> customerRef = SabrePassiveSegmentsHandler.findOrCreateCustomer();
        SalesContext salesContext = new SalesContext();
        salesContext.setCustomer(customerRef);
        salesContext.setAgent(customerRef);
        return salesContext;
    }

    private static EntityReference<Person> findOrCreateCustomer() {
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)PersonIndex.Property.loginName.name(), (Object)"system"));
        List lst = EntityStorage.get().search(PersonIndex.class, query).getData();
        EntityReference agent = null;
        if (!lst.isEmpty()) {
            agent = ((PersonIndex)lst.get(0)).getSource();
        }
        return agent;
    }

    private static IntegrationBusAdapter getAdapter(String adapterId) throws Exception {
        IntegrationBusAdapter adapter = IntegrationBusFacade.get().getRequestReplyAdapter(adapterId);
        if (adapter == null) {
            throw new IllegalArgumentException(String.format("no adapter with id '%s' found", adapterId));
        }
        return adapter;
    }
}

