/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sabre.passivesegments;

import com.gridnine.xtrip.common.model.helpers.MessageHelper;
import com.gridnine.xtrip.common.model.l10n.Messages;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.gds.sabre.IBusGdsSabreContextKeys;
import com.gridnine.xtrip.server.gds.sabre.core.IbusGdsSabreCoreContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.model.synchronization.sabrepassive.SabrePassiveSegmentsRequest;
import com.gridnine.xtrip.server.model.synchronization.sabrepassive.SabrePassiveSegmentsRequestType;
import com.sabre.services.sp.pd.v35.PassengerDetailsRS;
import com.sabre.services.stlmessagecommon.v0201.MessageCondition;
import com.sabre.services.stlpayload.v0201.ProblemInformation;
import com.sabre.services.stlpayload.v0201.SystemSpecificResults;
import java.util.LinkedHashSet;
import java.util.Set;

public class SabrePassiveSegmentsPassengerDetailsRSParser
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        boolean noPnrBefore;
        PassengerDetailsRS response = (PassengerDetailsRS)ctx.getMandatoryObject((Enum)IbusGdsSabreCoreContextKeys.SABRE_WS_RESPONSE_PAYLOAD);
        Set errors = (Set)ctx.getMandatoryObject((Enum)IBusGdsSabreContextKeys.PASSIVE_SEGMENTS_RESPONSE_ERRORS);
        Set warnings = (Set)ctx.getMandatoryObject((Enum)IBusGdsSabreContextKeys.PASSIVE_SEGMENTS_RESPONSE_WARNINGS);
        SabrePassiveSegmentsRequest synchRequest = (SabrePassiveSegmentsRequest)ctx.getMandatoryObject(IBusGdsSabreContextKeys.PASSIVE_SEGMENTS_REQUEST.name());
        LinkedHashSet<Message> localErrors = new LinkedHashSet<Message>();
        LinkedHashSet<Message> localWarnings = new LinkedHashSet<Message>();
        String code = "";
        if (response.getApplicationResults().getErrorList() != null) {
            for (ProblemInformation pi : response.getApplicationResults().getErrorList()) {
                if (pi.getSystemSpecificResultList() == null) continue;
                for (SystemSpecificResults ssr : pi.getSystemSpecificResultList()) {
                    if (ssr.getMessageList() == null) continue;
                    for (MessageCondition mc : ssr.getMessageList()) {
                        if (!TextUtil.isBlank((String)mc.getCode())) {
                            code = mc.getCode();
                        }
                        localErrors.add(MessageHelper.createErrorMessage((String)Messages.sabrePassiveSegmentsEndTransactionError, (Object[])new Object[]{code, mc.getString()}));
                    }
                }
            }
        }
        if (response.getApplicationResults().getWarningList() != null) {
            for (ProblemInformation pi : response.getApplicationResults().getWarningList()) {
                if (pi.getSystemSpecificResultList() == null) continue;
                for (SystemSpecificResults ssr : pi.getSystemSpecificResultList()) {
                    if (ssr.getMessageList() == null) continue;
                    for (MessageCondition mc : ssr.getMessageList()) {
                        if (!TextUtil.isBlank((String)mc.getCode())) {
                            code = mc.getCode();
                        }
                        if (this.isWarningMessage(mc.getString())) {
                            localWarnings.add(MessageHelper.createWarningMessage((String)Messages.sabrePassiveSegmentsEndTransactionError, (Object[])new Object[]{code, mc.getString()}));
                            continue;
                        }
                        localErrors.add(MessageHelper.createErrorMessage((String)Messages.sabrePassiveSegmentsEndTransactionError, (Object[])new Object[]{code, mc.getString()}));
                    }
                }
            }
        }
        String pnr = response.getItineraryRef() != null ? response.getItineraryRef().getID() : null;
        String previouslyObtainedPnr = (String)ctx.getObject((Enum)IBusGdsSabreContextKeys.PASSIVE_SEGMENTS_REQUEST_PNR);
        boolean bl = noPnrBefore = TextUtil.isBlank((String)previouslyObtainedPnr) && synchRequest.getRequestType() == SabrePassiveSegmentsRequestType.CREATE_PASSIVE_SEGMENTS_NEW_RESERVATION || synchRequest.getRequestType() == SabrePassiveSegmentsRequestType.CREATE_PASSIVE_SEGMENTS_EXISTING_RESERVATION;
        if (!TextUtil.isBlank((String)pnr)) {
            synchRequest.setPnr(pnr);
            ctx.putObject((Enum)IBusGdsSabreContextKeys.PASSIVE_SEGMENTS_REQUEST_PNR, (Object)pnr);
        }
        errors.addAll(localErrors);
        warnings.addAll(localWarnings);
        ctx.putObject((Enum)IBusGdsSabreContextKeys.PASSIVE_SEGMENTS_RESPONSE_STATUS, (Object)(TextUtil.isBlank((String)pnr) && noPnrBefore ? "ERROR" : (localWarnings.size() > 0 || localErrors.size() > 0 ? "WARNING" : "OK")));
    }

    private boolean isWarningMessage(String message) {
        return !TextUtil.isBlank((String)message) && message.contains("UNABLE TO VERIFY MCT FOR SEG");
    }
}

