/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sabre.passivesegments;

import com.gridnine.xtrip.common.model.booking.passive.SabrePassiveAccountingLineData;
import com.gridnine.xtrip.common.model.booking.passive.SabrePassiveAccountingLineType;
import com.gridnine.xtrip.common.model.booking.passive.SabrePassivePassengerData;
import com.gridnine.xtrip.common.model.booking.passive.SabrePassiveSegmentData;
import com.gridnine.xtrip.common.model.helpers.MessageHelper;
import com.gridnine.xtrip.common.model.l10n.Messages;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.gds.sabre.IBusGdsSabreContextKeys;
import com.gridnine.xtrip.server.gds.sabre.core.IbusGdsSabreCoreContextKeys;
import com.gridnine.xtrip.server.gds.sabre.passivesegments.SabrePassiveSegmentsUtil;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.model.synchronization.sabrepassive.SabrePassiveSegmentsRequest;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class SabrePassiveSegmentsPrepareAccountingLinesProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        List existedTravelers = (List)ctx.getMandatoryObject((Enum)IBusGdsSabreContextKeys.PASSIVE_SEGMENTS_RESPONSE_TRAVELERS);
        String vatTaxCommandRS = (String)ctx.getMandatoryObject((Enum)IbusGdsSabreCoreContextKeys.SABRE_COMMAND_RESPONSE);
        boolean isVatTaxNeeded = vatTaxCommandRS.contains("VAT ON");
        SabrePassiveSegmentsRequest request = (SabrePassiveSegmentsRequest)ctx.getMandatoryObject((Enum)IBusGdsSabreContextKeys.PASSIVE_SEGMENTS_REQUEST);
        List segmentsToCreate = request.getPassiveDataList().stream().flatMap(data -> data.getSegments().stream()).collect(Collectors.toList());
        Map<String, List<String>> existedSegments = SabrePassiveSegmentsUtil.createSegmentsMap((List)ctx.getMandatoryObject((Enum)IBusGdsSabreContextKeys.PASSIVE_SEGMENTS_RESPONSE_SEGMENTS));
        Set warnings = (Set)ctx.getMandatoryObject((Enum)IBusGdsSabreContextKeys.PASSIVE_SEGMENTS_RESPONSE_WARNINGS);
        int originalWarningsSize = warnings.size();
        request.getPassiveDataList().stream().flatMap(l -> l.getAccountingLines().stream()).forEach(line -> {
            if (line.getType() == SabrePassiveAccountingLineType.AIR) {
                this.prepareAirAccountingLine((SabrePassiveAccountingLineData)line, existedTravelers, warnings, isVatTaxNeeded);
            } else {
                this.prepareOtherAccountingLine((SabrePassiveAccountingLineData)line, segmentsToCreate, existedSegments, warnings);
            }
        });
        if (originalWarningsSize != warnings.size()) {
            ctx.putObject((Enum)IBusGdsSabreContextKeys.PASSIVE_SEGMENTS_RESPONSE_STATUS, (Object)"WARNING");
        }
    }

    private void prepareOtherAccountingLine(SabrePassiveAccountingLineData line, List<SabrePassiveSegmentData> segmentsToCreate, Map<String, List<String>> existedSegments, Set<Message> warnings) {
        String segmentNumber = SabrePassiveSegmentsUtil.getSegmentNumber(line.getRelatedSegmentUid(), segmentsToCreate, existedSegments);
        if (TextUtil.nonBlank((String)segmentNumber)) {
            line.setCreationCommand(String.format(line.getCreationCommand(), segmentNumber));
        } else {
            line.setCreationCommand(null);
            warnings.add(MessageHelper.createErrorMessage((String)Messages.sabrePassiveSegmentsSegmentNumberAccLineError, (Object[])new Object[]{line.getTicketNumber()}));
        }
    }

    private void prepareAirAccountingLine(SabrePassiveAccountingLineData line, List<SabrePassivePassengerData> createdTravelers, Set<Message> warnings, boolean isVatTaxNeeded) {
        SabrePassivePassengerData sabreTraveler = this.findTraveler(createdTravelers, line.getTravelerFirstName(), line.getTravelerLastName());
        if (sabreTraveler != null) {
            line.setCreationCommand(String.format(line.getCreationCommand(), isVatTaxNeeded ? "C0/" : "", sabreTraveler.getNameNumber()));
        } else {
            line.setCreationCommand(null);
            warnings.add(MessageHelper.createErrorMessage((String)Messages.sabrePassiveSegmentsTravelerNumberAccLineError, (Object[])new Object[]{line.getTravelerLastName() + " " + line.getTravelerFirstName(), line.getTicketNumber()}));
        }
    }

    private SabrePassivePassengerData findTraveler(List<SabrePassivePassengerData> createdTravelers, String firstName, String lastName) {
        return createdTravelers.stream().filter(t -> t.getFirstName().equalsIgnoreCase(firstName) && t.getLastName().equalsIgnoreCase(lastName)).findFirst().orElse(null);
    }
}

