/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sabre.passivesegments;

import com.gridnine.xtrip.common.model.booking.passive.SabrePassiveAccountingLineData;
import com.gridnine.xtrip.common.model.booking.passive.SabrePassiveAccountingLineType;
import com.gridnine.xtrip.common.model.booking.passive.SabrePassiveRemarkData;
import com.gridnine.xtrip.common.model.booking.passive.SabrePassiveSegmentData;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.gds.sabre.IBusGdsSabreContextKeys;
import com.gridnine.xtrip.server.gds.sabre.passivesegments.SabrePassiveSegmentsUtil;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.model.synchronization.sabrepassive.SabrePassiveSegmentsRequest;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class SabrePassiveSegmentsPrepareRemoveProcessor
extends BaseProcessor {
    private final List<String> NON_S_REMARK_PREFIXES = new ArrayList<String>(){
        {
            this.add("X*PA");
            this.add("X*PR");
            this.add("X*PH");
            this.add("X*BR");
            this.add("TICKET-");
        }
    };
    private final String BOOKING_NUMBER_REMARK_PREFIX = "X*BR";

    public void process(MessageContext ctx) throws Exception {
        SabrePassiveSegmentsRequest synchRequest = (SabrePassiveSegmentsRequest)ctx.getMandatoryObject(IBusGdsSabreContextKeys.PASSIVE_SEGMENTS_REQUEST.name());
        List<SabrePassiveSegmentData> segmentsToCreate = synchRequest.getPassiveDataList().stream().flatMap(data -> data.getSegments().stream()).collect(Collectors.toList());
        List currentSegments = (List)ctx.getObject((Enum)IBusGdsSabreContextKeys.PASSIVE_SEGMENTS_RESPONSE_SEGMENTS);
        List currentRemarks = (List)ctx.getObject((Enum)IBusGdsSabreContextKeys.PASSIVE_SEGMENTS_RESPONSE_REMARKS);
        List existedLines = (List)ctx.getObject((Enum)IBusGdsSabreContextKeys.PASSIVE_SEGMENTS_RESPONSE_ACCOUNTING_LINES);
        List<String> segmentNumbers = this.prepareSegmentsToRemove(currentSegments, segmentsToCreate);
        Set<String> ticketNumbers = this.prepareTicketNumbersFromSRemarksToRemove(segmentNumbers, currentRemarks);
        List<String> xRemarksToRemove = this.getXRemarks(ticketNumbers, currentRemarks);
        List<SabrePassiveAccountingLineData> accountingLinesToCreate = synchRequest.getPassiveDataList().stream().flatMap(data -> data.getAccountingLines().stream()).collect(Collectors.toList());
        List<String> accountingLinesNumbers = this.prepareAccountingLinesToRemove(existedLines, accountingLinesToCreate);
        ctx.putObject((Enum)IBusGdsSabreContextKeys.PASSIVE_SEGMENTS_X_REMARKS_TO_REMOVE, xRemarksToRemove);
        ctx.putObject((Enum)IBusGdsSabreContextKeys.PASSIVE_SEGMENTS_SEGMENTS_TO_REMOVE, segmentNumbers);
        ctx.putObject((Enum)IBusGdsSabreContextKeys.PASSIVE_SEGMENTS_ACCOUNTING_LINES_TO_REMOVE, accountingLinesNumbers);
    }

    private List<String> prepareAccountingLinesToRemove(List<SabrePassiveAccountingLineData> oldLines, List<SabrePassiveAccountingLineData> newLines) {
        return oldLines.stream().filter(l -> this.isAccountingLineShouldBeRemoved((SabrePassiveAccountingLineData)l, newLines)).sorted(Comparator.comparingInt(SabrePassiveAccountingLineData::getRph).reversed()).map(SabrePassiveAccountingLineData::getRph).map(String::valueOf).collect(Collectors.toList());
    }

    private String retrieveTicketNumber(SabrePassiveAccountingLineData line) {
        String result = null;
        if (line.getType() == SabrePassiveAccountingLineType.AIR) {
            result = line.getTicketNumber();
        } else if (line.getType() == SabrePassiveAccountingLineType.RAILWAY) {
            if (line.getFreeText() != null && line.getFreeText().contains(" ")) {
                int index = line.getFreeText().indexOf(" ");
                result = line.getFreeText().substring(0, index);
            } else {
                result = line.getFreeText();
            }
        } else if (line.getType() == SabrePassiveAccountingLineType.HOTEL) {
            result = line.getFreeText();
        }
        return result;
    }

    private boolean isAccountingLineShouldBeRemoved(SabrePassiveAccountingLineData line, List<SabrePassiveAccountingLineData> newLines) {
        return newLines.stream().filter(l -> l.getType() == line.getType()).map(SabrePassiveAccountingLineData::getTicketNumber).filter(Objects::nonNull).anyMatch(t -> {
            String ticketNumber = this.retrieveTicketNumber(line);
            if (ticketNumber != null && ticketNumber.contains("XXXXXXXX")) {
                return t.endsWith(ticketNumber.replaceAll("X", ""));
            }
            return t.equalsIgnoreCase(ticketNumber);
        });
    }

    private List<String> prepareSegmentsToRemove(List<SabrePassiveSegmentData> currentSegments, List<SabrePassiveSegmentData> segmentsToCreate) {
        ArrayList<String> segmentNumbers = new ArrayList<String>();
        Map<String, List<String>> segMap = SabrePassiveSegmentsUtil.createSegmentsMap(currentSegments);
        for (SabrePassiveSegmentData seg : segmentsToCreate) {
            String key = SabrePassiveSegmentsUtil.buildSegmentKey(seg);
            if (TextUtil.isBlank((String)key) || !segMap.containsKey(key) || segMap.get(key).isEmpty()) continue;
            List<String> list = segMap.get(key);
            String res = list.get(0);
            list.remove(0);
            segmentNumbers.add(res);
        }
        return segmentNumbers;
    }

    private Set<String> prepareTicketNumbersFromSRemarksToRemove(List<String> segmentNumbers, List<SabrePassiveRemarkData> remarks) {
        HashSet<String> ticketNumbers = new HashSet<String>();
        remarks.stream().filter(rem -> !TextUtil.isBlank((String)rem.getSegmentNumber()) && segmentNumbers.contains(rem.getSegmentNumber()) && rem.getText().contains("TICKET-") || rem.getText().contains("CNF-")).forEach(rem -> {
            List<String> numbers = this.parseTicketNumbersFromRemark(rem.getText());
            ticketNumbers.addAll(numbers.stream().filter(number -> !TextUtil.isBlank((String)number)).collect(Collectors.toList()));
        });
        return ticketNumbers;
    }

    private List<String> parseTicketNumbersFromRemark(String remark) {
        ArrayList<String> res = new ArrayList<String>();
        Pattern p1 = Pattern.compile(".*TICKET-([A-Z0-9]{3})([A-Z0-9]{6,11})(\\-([0-9]{2}))?.*");
        Pattern p2 = Pattern.compile(".*CNF-([0-9]+).*");
        Matcher m1 = p1.matcher(remark);
        Matcher m2 = p2.matcher(remark);
        if (m1.matches()) {
            String possibleCarrier = m1.group(1);
            String mainNumber = m1.group(2);
            String conjNumber = m1.group(4);
            res.add(possibleCarrier + mainNumber);
            if (!TextUtil.isBlank((String)conjNumber)) {
                Long mainNumberLong = Long.valueOf(mainNumber);
                int conjNumberInt = Integer.valueOf(conjNumber);
                int diff = Math.abs(conjNumberInt - (int)(mainNumberLong % 100L));
                for (int i = 1; i <= diff; ++i) {
                    Long conjNumberLong = mainNumberLong + (long)i;
                    String conjNumberStr = conjNumberLong.toString();
                    while (conjNumberStr.length() < mainNumber.length()) {
                        conjNumberStr = "0" + conjNumberStr;
                    }
                    res.add(possibleCarrier + conjNumberStr);
                }
            }
        } else if (m2.matches()) {
            String mainNumber = m2.group(1);
            res.add(mainNumber);
        }
        return res;
    }

    private List<String> getXRemarks(Set<String> ticketNumbers, List<SabrePassiveRemarkData> remarks) {
        ArrayList<String> res = new ArrayList<String>();
        for (SabrePassiveRemarkData remark : remarks) {
            if (!TextUtil.isBlank((String)remark.getSegmentNumber()) || remark.getText() == null || !this.NON_S_REMARK_PREFIXES.stream().anyMatch(s -> remark.getText().startsWith((String)s)) || !ticketNumbers.stream().anyMatch(s -> remark.getText().contains((CharSequence)s)) && !remark.getText().startsWith("X*BR")) continue;
            res.add(remark.getRph());
        }
        return res;
    }
}

