/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sabre.passivesegments;

import com.gridnine.xtrip.common.model.booking.passive.SabrePassiveRemarkData;
import com.gridnine.xtrip.common.model.booking.passive.SabrePassiveRemarkType;
import com.gridnine.xtrip.common.model.booking.passive.SabrePassiveSegmentData;
import com.gridnine.xtrip.common.model.helpers.MessageHelper;
import com.gridnine.xtrip.common.model.l10n.Messages;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.gds.sabre.IBusGdsSabreContextKeys;
import com.gridnine.xtrip.server.gds.sabre.passivesegments.SabrePassiveSegmentsUtil;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.model.synchronization.sabrepassive.SabrePassiveSegmentsRequest;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class SabrePassiveSegmentsPrepareSRemarksProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        SabrePassiveSegmentsRequest passiveRequest = (SabrePassiveSegmentsRequest)ctx.getMandatoryObject((Enum)IBusGdsSabreContextKeys.PASSIVE_SEGMENTS_REQUEST);
        List currentSegments = (List)ctx.getMandatoryObject((Enum)IBusGdsSabreContextKeys.PASSIVE_SEGMENTS_RESPONSE_SEGMENTS);
        List<SabrePassiveSegmentData> segmentsToCreate = passiveRequest.getPassiveDataList().stream().flatMap(data -> data.getSegments().stream()).collect(Collectors.toList());
        Map<String, List<String>> segMap = SabrePassiveSegmentsUtil.createSegmentsMap(currentSegments);
        List remarks = passiveRequest.getPassiveDataList().stream().flatMap(data -> data.getRemarks().stream()).filter(remark -> SabrePassiveRemarkType.CROSS_S == remark.getType() || SabrePassiveRemarkType.DOT_S == remark.getType()).collect(Collectors.toList());
        boolean hasWarnings = false;
        for (SabrePassiveRemarkData remark2 : remarks) {
            String segmentNumber = SabrePassiveSegmentsUtil.getSegmentNumber(remark2.getSegmentId(), segmentsToCreate, segMap);
            if (TextUtil.isBlank((String)segmentNumber)) {
                Set warnings = (Set)ctx.getMandatoryObject((Enum)IBusGdsSabreContextKeys.PASSIVE_SEGMENTS_RESPONSE_WARNINGS);
                warnings.add(MessageHelper.createErrorMessage((String)Messages.sabrePassiveSegmentsSetSegmentNumberError, (Object[])new Object[]{remark2.getText()}));
                hasWarnings = true;
                ctx.putObject((Enum)IBusGdsSabreContextKeys.PASSIVE_SEGMENTS_RESPONSE_STATUS, (Object)"WARNING");
                break;
            }
            remark2.setSegmentNumber(segmentNumber);
        }
        if (!hasWarnings) {
            ctx.putObject((Enum)IBusGdsSabreContextKeys.PASSIVE_SEGMENTS_RESPONSE_STATUS, (Object)"OK");
        }
        ArrayList remarksToAdd = new ArrayList();
        ctx.putObject((Enum)IBusGdsSabreContextKeys.PASSIVE_SEGMENTS_REMARKS_TO_ADD, remarksToAdd);
    }
}

