/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sabre.passivesegments;

import com.gridnine.xtrip.common.model.booking.passive.SabrePassiveAccountingLineData;
import com.gridnine.xtrip.common.model.booking.passive.SabrePassiveAccountingLineType;
import com.gridnine.xtrip.common.model.booking.passive.SabrePassivePassengerData;
import com.gridnine.xtrip.common.model.booking.passive.SabrePassiveRemarkData;
import com.gridnine.xtrip.common.model.booking.passive.SabrePassiveRemarkPersonData;
import com.gridnine.xtrip.common.model.booking.passive.SabrePassiveSegmentData;
import com.gridnine.xtrip.common.model.booking.passive.SabrePassiveSegmentType;
import com.gridnine.xtrip.common.util.LocaleUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.gds.sabre.IBusGdsSabreContextKeys;
import com.gridnine.xtrip.server.gds.sabre.core.IbusGdsSabreCoreContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.sabre.services.res.tir.v310.TravelItineraryReadRS;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class SabrePassiveSegmentsReadItineraryRSParser
extends BaseProcessor {
    public static final DateTimeFormatter DF_DEPARTURE_DATETIME = DateTimeFormat.forPattern((String)"yyyy-MM-dd'T'HH:mm");
    public static final String PATTERN_SEGMENT_TIME = "MM-dd'T'HH:mm";
    public static final String PATTERN_HOTEL_DATE = "MM-dd";

    public void process(MessageContext ctx) throws Exception {
        TravelItineraryReadRS response = (TravelItineraryReadRS)ctx.getMandatoryObject((Enum)IbusGdsSabreCoreContextKeys.SABRE_WS_RESPONSE_PAYLOAD);
        List<SabrePassiveSegmentData> segments = this.parseSegments(response);
        ctx.putObject((Enum)IBusGdsSabreContextKeys.PASSIVE_SEGMENTS_RESPONSE_SEGMENTS, segments);
        List<SabrePassiveRemarkData> remarks = this.parseRemarks(response);
        ctx.putObject((Enum)IBusGdsSabreContextKeys.PASSIVE_SEGMENTS_RESPONSE_REMARKS, remarks);
        List<SabrePassivePassengerData> travelers = this.parseTravelers(response);
        ctx.putObject((Enum)IBusGdsSabreContextKeys.PASSIVE_SEGMENTS_RESPONSE_TRAVELERS, travelers);
        List<SabrePassiveAccountingLineData> lines = this.parseAccountingLines(response);
        ctx.putObject((Enum)IBusGdsSabreContextKeys.PASSIVE_SEGMENTS_RESPONSE_ACCOUNTING_LINES, lines);
        String pcc = "";
        if (response.getTravelItinerary() != null && response.getTravelItinerary().getItineraryRef() != null && response.getTravelItinerary().getItineraryRef().getSource() != null) {
            pcc = response.getTravelItinerary().getItineraryRef().getSource().getPseudoCityCode();
        }
        ctx.putObject((Enum)IBusGdsSabreContextKeys.PASSIVE_SEGMENTS_REQUEST_PCC, (Object)pcc);
        ctx.putObject((Enum)IBusGdsSabreContextKeys.PASSIVE_SEGMENTS_RESPONSE_STATUS, (Object)"OK");
    }

    private List<SabrePassiveAccountingLineData> parseAccountingLines(TravelItineraryReadRS response) {
        ArrayList<SabrePassiveAccountingLineData> result = new ArrayList<SabrePassiveAccountingLineData>();
        if (response.getTravelItinerary() != null && response.getTravelItinerary().getAccountingInfoList() != null) {
            List list = response.getTravelItinerary().getAccountingInfoList();
            for (int i = 0; i < list.size(); ++i) {
                result.add(this.convertAccountingInfo((TravelItineraryReadRS.TravelItinerary.AccountingInfo)list.get(i), i + 1));
            }
        }
        return result;
    }

    private SabrePassiveAccountingLineData convertAccountingInfo(TravelItineraryReadRS.TravelItinerary.AccountingInfo info, int rph) {
        SabrePassiveAccountingLineData result = new SabrePassiveAccountingLineData();
        result.setRph(rph);
        result.setFreeText(info.getText());
        result.setTicketNumber((String)Optional.ofNullable(info.getDocumentInfo()).map(TravelItineraryReadRS.TravelItinerary.AccountingInfo.DocumentInfo::getDocument).map(TravelItineraryReadRS.TravelItinerary.AccountingInfo.DocumentInfo.Document::getNumber).orElse(null));
        if ("RAL".equalsIgnoreCase(info.getChargeCategory())) {
            result.setType(SabrePassiveAccountingLineType.RAILWAY);
        } else if ("HTL".equalsIgnoreCase(info.getChargeCategory())) {
            result.setType(SabrePassiveAccountingLineType.HOTEL);
        } else if (info.getAirline() != null && TextUtil.nonBlank((String)info.getAirline().getCode())) {
            result.setType(SabrePassiveAccountingLineType.AIR);
        }
        if (result.getType() == SabrePassiveAccountingLineType.RAILWAY && TextUtil.isBlank((String)result.getFreeText())) {
            Optional.ofNullable(info.getTicketingInfo()).map(TravelItineraryReadRS.TravelItinerary.AccountingInfo.TicketingInfo::getTicketing).map(TravelItineraryReadRS.TravelItinerary.AccountingInfo.TicketingInfo.Ticketing::getConjunctedCount).filter(s -> s.contains("XXXXXXXX")).ifPresent(s -> result.setFreeText(s.substring(2)));
        }
        return result;
    }

    private List<SabrePassivePassengerData> parseTravelers(TravelItineraryReadRS response) {
        return Optional.ofNullable(response.getTravelItinerary()).map(TravelItineraryReadRS.TravelItinerary::getCustomerInfo).map(TravelItineraryReadRS.TravelItinerary.CustomerInfo::getPersonNameList).map(l -> l.stream().map(this::convertPersonName).collect(Collectors.toList())).orElseGet(Collections::emptyList);
    }

    private SabrePassivePassengerData convertPersonName(TravelItineraryReadRS.TravelItinerary.CustomerInfo.PersonName personName) {
        SabrePassivePassengerData result = new SabrePassivePassengerData();
        result.setFirstName(personName.getGivenName());
        result.setLastName(personName.getSurname());
        result.setNameNumber((String)Optional.ofNullable(personName.getNameNumber()).map(s -> s.replaceFirst("^0+", "").replaceAll("\\.0+", ".")).orElse(null));
        result.setPassengerType(personName.getPassengerType());
        return result;
    }

    private List<SabrePassiveSegmentData> parseSegments(TravelItineraryReadRS response) throws ParseException {
        ArrayList<SabrePassiveSegmentData> res = new ArrayList<SabrePassiveSegmentData>();
        if (response.getTravelItinerary() == null || response.getTravelItinerary().getItineraryInfo() == null || response.getTravelItinerary().getItineraryInfo().getReservationItems() == null || response.getTravelItinerary().getItineraryInfo().getReservationItems().getItemList() == null) {
            return res;
        }
        for (TravelItineraryReadRS.TravelItinerary.ItineraryInfo.ReservationItems.Item item : response.getTravelItinerary().getItineraryInfo().getReservationItems().getItemList()) {
            SabrePassiveSegmentData seg = new SabrePassiveSegmentData();
            seg.setRph(item.getRPH());
            if (item.getFlightSegmentList() != null && !item.getFlightSegmentList().isEmpty()) {
                for (TravelItineraryReadRS.TravelItinerary.ItineraryInfo.ReservationItems.Item.FlightSegment fs : item.getFlightSegmentList()) {
                    seg.setSegmentType(SabrePassiveSegmentType.AIR);
                    seg.setSeatsAmount(Integer.valueOf(fs.getNumberInParty()).toString());
                    seg.setDepartureCode(fs.getOriginLocation().getLocationCode());
                    seg.setArrivalCode(fs.getDestinationLocation().getLocationCode());
                    seg.setStartDate(DF_DEPARTURE_DATETIME.parseDateTime(fs.getDepartureDateTime()).toDate());
                    seg.setClassOfService(fs.getResBookDesigCode());
                }
            } else if (item.getRail() != null) {
                seg.setSegmentType(SabrePassiveSegmentType.RAIL);
                seg.setSeatsAmount(Integer.valueOf(item.getRail().getNumberInParty()).toString());
                if (item.getRail().getOriginLocation() != null && item.getRail().getOriginLocation().getPointList() != null) {
                    if (!item.getRail().getOriginLocation().getPointList().isEmpty()) {
                        seg.setDepartureCode((String)item.getRail().getOriginLocation().getPointList().get(0));
                    }
                    seg.setStartDate(this.getActualDepartureTimeRail(item.getRail().getOriginLocation().getDepartureDate()));
                }
                if (item.getRail().getDestinationLocation() != null && item.getRail().getDestinationLocation().getPointList() != null && !item.getRail().getDestinationLocation().getPointList().isEmpty()) {
                    seg.setArrivalCode((String)item.getRail().getDestinationLocation().getPointList().get(0));
                }
                seg.setClassOfService(item.getRail().getResBookDesigCode());
            } else if (item.getHotel() != null) {
                seg.setSegmentType(SabrePassiveSegmentType.HOTEL);
                if (item.getHotel().getBasicPropertyInfo() != null) {
                    seg.setHotelName(item.getHotel().getBasicPropertyInfo().getHotelName());
                    seg.setHotelCity(!TextUtil.isBlank((String)item.getHotel().getBasicPropertyInfo().getServiceCityName()) ? item.getHotel().getBasicPropertyInfo().getServiceCityName() : item.getHotel().getBasicPropertyInfo().getHotelCityCode());
                }
                if (item.getHotel().getTimeSpan() != null && item.getHotel().getTimeSpan().getStart() != null) {
                    SimpleDateFormat sdf = new SimpleDateFormat(PATTERN_HOTEL_DATE);
                    Date checkInDate = sdf.parse(item.getHotel().getTimeSpan().getStart());
                    seg.setHotelCheckInDate(checkInDate);
                    if (checkInDate != null && !TextUtil.isBlank((String)item.getHotel().getTimeSpan().getDuration())) {
                        try {
                            Calendar cal = Calendar.getInstance();
                            cal.setTime(checkInDate);
                            cal.add(5, Integer.valueOf(item.getHotel().getTimeSpan().getDuration()));
                            seg.setHotelCheckOutDate(cal.getTime());
                        }
                        catch (NumberFormatException e) {
                            this.log.error("Failed to parse hotel duration: " + item.getHotel().getTimeSpan().getDuration());
                        }
                    }
                }
            }
            res.add(seg);
        }
        return res;
    }

    private List<SabrePassiveRemarkData> parseRemarks(TravelItineraryReadRS response) {
        ArrayList<SabrePassiveRemarkData> res = new ArrayList<SabrePassiveRemarkData>();
        if (response.getTravelItinerary().getRemarkInfo() == null) {
            return res;
        }
        for (TravelItineraryReadRS.TravelItinerary.RemarkInfo.Remark item : response.getTravelItinerary().getRemarkInfo().getRemarkList()) {
            SabrePassiveRemarkData remarkData = new SabrePassiveRemarkData();
            remarkData.setCode(item.getCode());
            if (item.getSegmentNumber() != null) {
                remarkData.setSegmentNumber(Integer.valueOf(item.getSegmentNumber()).toString());
            }
            remarkData.setText(item.getText());
            remarkData.setRph(item.getRPH());
            if (item.getPersonNameList() != null) {
                for (TravelItineraryReadRS.TravelItinerary.RemarkInfo.Remark.PersonName pn : item.getPersonNameList()) {
                    SabrePassiveRemarkPersonData nameData = new SabrePassiveRemarkPersonData();
                    nameData.setNumber(pn.getNameNumber());
                    nameData.setName(pn.getString());
                    remarkData.getPersonNameList().add(nameData);
                }
            }
            res.add(remarkData);
        }
        return res;
    }

    private Date getActualDepartureTimeRail(String s) throws ParseException {
        if (TextUtil.isBlank((String)s)) {
            return null;
        }
        SimpleDateFormat sdfDate = new SimpleDateFormat(PATTERN_HOTEL_DATE, LocaleUtil.LOCALE_EN);
        return sdfDate.parse(s);
    }
}

