/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sabre.passivesegments;

import com.gridnine.xtrip.server.gds.sabre.IBusGdsSabreContextKeys;
import com.gridnine.xtrip.server.gds.sabre.core.IbusGdsSabreCoreContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.sabre.webservices.sabrexml.OTACancelRQ;
import java.math.BigInteger;
import java.util.List;
import java.util.stream.Collectors;

public class SabrePassiveSegmentsRemoveSegmentsRQBuilder
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        List segmentNumbers = (List)ctx.getMandatoryObject((Enum)IBusGdsSabreContextKeys.PASSIVE_SEGMENTS_SEGMENTS_TO_REMOVE);
        OTACancelRQ request = this.buildRequest(segmentNumbers);
        ctx.putObject((Enum)IbusGdsSabreCoreContextKeys.SABRE_WS_REQUEST_PAYLOAD, (Object)request);
        ctx.putObject((Enum)IbusGdsSabreCoreContextKeys.SABRE_WS_SERVICE_ACTION_CODE, (Object)"OTA_CancelLLSRQ");
    }

    private OTACancelRQ buildRequest(List<String> segmentNumbers) {
        OTACancelRQ request = new OTACancelRQ();
        request.setVersion("2.0.3");
        request.setReturnHostCommand(Boolean.TRUE);
        request.getSegmentList().addAll(segmentNumbers.stream().map(s -> {
            OTACancelRQ.Segment seg = new OTACancelRQ.Segment();
            seg.setNumber(new BigInteger((String)s));
            return seg;
        }).collect(Collectors.toList()));
        return request;
    }
}

