/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sabre.passivesegments;

import com.gridnine.xtrip.common.model.booking.passive.SabrePassiveSegmentData;
import com.gridnine.xtrip.common.model.booking.passive.SabrePassiveSegmentType;
import com.gridnine.xtrip.common.util.LocaleUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SabrePassiveSegmentsUtil {
    private static Logger log = LoggerFactory.getLogger(SabrePassiveSegmentsUtil.class);
    private static final ThreadLocal<SimpleDateFormat> sdf = ThreadLocal.withInitial(() -> new SimpleDateFormat("ddMMM", LocaleUtil.LOCALE_EN));

    public static String getSegmentNumber(String segmentId, List<SabrePassiveSegmentData> segmentsToCreate, Map<String, List<String>> existedSegmentsMap) {
        for (SabrePassiveSegmentData seg : segmentsToCreate) {
            if (!TextUtil.isSame((String)seg.getId(), (String)segmentId)) continue;
            String key = SabrePassiveSegmentsUtil.buildSegmentKey(seg);
            if (!TextUtil.isBlank((String)key) && existedSegmentsMap.containsKey(key) && !existedSegmentsMap.get(key).isEmpty()) {
                List<String> list = existedSegmentsMap.get(key);
                return list.get(0);
            }
            StringBuilder sb = new StringBuilder();
            sb.append("key = ").append(key).append("\n").append("existed keys:\n");
            existedSegmentsMap.keySet().forEach(k -> sb.append((String)k).append("\n"));
            log.warn(sb.toString());
        }
        return null;
    }

    public static String buildSegmentKey(SabrePassiveSegmentData seg) {
        StringBuilder key = new StringBuilder();
        if (seg.getSegmentType() == null || seg.getSegmentType() == SabrePassiveSegmentType.AIR || seg.getSegmentType() == SabrePassiveSegmentType.RAIL) {
            if (!TextUtil.isBlank((String)seg.getDepartureCode())) {
                key.append(seg.getDepartureCode());
            }
            if (!TextUtil.isBlank((String)seg.getArrivalCode())) {
                key.append(seg.getArrivalCode());
            }
            if (seg.getStartDate() != null) {
                key.append(sdf.get().format(seg.getStartDate()));
            }
            if (!TextUtil.isBlank((String)seg.getSeatsAmount())) {
                key.append(seg.getSeatsAmount());
            }
        } else if (seg.getSegmentType() == SabrePassiveSegmentType.HOTEL) {
            if (!TextUtil.isBlank((String)seg.getHotelCity())) {
                key.append(com.gridnine.xtrip.common.model.gds.sabre.passivesegments.SabrePassiveSegmentsUtil.removeIllegalSymbols((String)com.gridnine.xtrip.common.model.gds.sabre.passivesegments.SabrePassiveSegmentsUtil.getTranslation((String)seg.getHotelCity())));
            }
            if (!TextUtil.isBlank((String)seg.getHotelName())) {
                key.append(com.gridnine.xtrip.common.model.gds.sabre.passivesegments.SabrePassiveSegmentsUtil.removeIllegalSymbols((String)com.gridnine.xtrip.common.model.gds.sabre.passivesegments.SabrePassiveSegmentsUtil.getTranslation((String)seg.getHotelName())));
            }
            if (seg.getHotelCheckInDate() != null) {
                key.append(sdf.get().format(seg.getHotelCheckInDate()));
            }
            if (seg.getHotelCheckOutDate() != null) {
                key.append(sdf.get().format(seg.getHotelCheckOutDate()));
            }
        }
        return key.toString().replaceAll("\\s+", "").toUpperCase();
    }

    public static Map<String, List<String>> createSegmentsMap(List<SabrePassiveSegmentData> segments) {
        HashMap<String, List<String>> segMap = new HashMap<String, List<String>>();
        for (SabrePassiveSegmentData seg : segments) {
            String key = SabrePassiveSegmentsUtil.buildSegmentKey(seg);
            if (TextUtil.isBlank((String)key)) continue;
            if (!segMap.containsKey(key)) {
                segMap.put(key, new ArrayList());
            }
            List list = (List)segMap.get(key);
            list.add(seg.getRph());
        }
        return segMap;
    }
}

