/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sabre.profiles;

import com.gridnine.xtrip.common.model.gds.sabre.ProfileSynchronizationUtil;
import com.gridnine.xtrip.common.model.helpers.MessageHelper;
import com.gridnine.xtrip.common.model.l10n.Messages;
import com.gridnine.xtrip.common.model.profile.PNRBuilder;
import com.gridnine.xtrip.common.model.profile.PNRBuilderSettings;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.server.gds.sabre.IBusGdsSabreContextKeys;
import com.gridnine.xtrip.server.gds.sabre.core.IbusGdsSabreCoreContextKeys;
import com.gridnine.xtrip.server.gds.sabre.profiles.SabreProfileServicesUtil;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.model.synchronization.sabreprofiles.SabreProfilesSynchronizationRequest;
import com.sabre.eps.schemas.SabreOTAProfileCreateRS;
import java.util.ArrayList;
import java.util.List;

public class SabreOTAFilterCreateRSParser
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        SabreOTAProfileCreateRS response = (SabreOTAProfileCreateRS)ctx.getMandatoryObject((Enum)IbusGdsSabreCoreContextKeys.SABRE_WS_RESPONSE_PAYLOAD);
        List errors = (List)ctx.getMandatoryObject((Enum)IBusGdsSabreContextKeys.PROFILE_SYNC_RESPONSE_ERRORS);
        List warnings = (List)ctx.getMandatoryObject((Enum)IBusGdsSabreContextKeys.PROFILE_SYNC_RESPONSE_WARNINGS);
        SabreProfilesSynchronizationRequest synchRequest = (SabreProfilesSynchronizationRequest)ctx.getMandatoryObject((Enum)IBusGdsSabreContextKeys.PROFILE_SYNC_REQUEST);
        ArrayList<Message> localErrors = new ArrayList<Message>();
        ArrayList<Message> localWarnings = new ArrayList<Message>();
        SabreProfileServicesUtil.getMessagesFromResponse(response.getResponseMessage(), localErrors, localWarnings, SabreProfileServicesUtil.getSabreProfilesAssociatedProfileInfo(synchRequest));
        if (!localErrors.isEmpty()) {
            String filterName = response.getChoice() != null && response.getChoice().getFilter() != null && response.getChoice().getFilter().getFilterName() != null ? response.getChoice().getFilter().getFilterName() : "";
            warnings.add(MessageHelper.createWarningMessage((String)Messages.SabreProfiles_failedToCreateFilter, (Object[])new Object[]{filterName, ((Message)localErrors.get(0)).getMessage()}));
        }
        ctx.putObject((Enum)IBusGdsSabreContextKeys.PROFILE_SYNC_RESPONSE_STATUS, (Object)(localErrors.size() > 0 ? "ERROR" : (localWarnings.size() > 0 ? "WARNING" : "OK")));
        PNRBuilderSettings settings = (PNRBuilderSettings)ctx.getMandatoryObject((Enum)IBusGdsSabreContextKeys.PROFILE_SYNC_FILTER_SETTINGS_FOR_CREATE);
        if (response.getChoice() != null && response.getChoice().getFilter() != null && !"*".equals(response.getChoice().getFilter().getFilterID())) {
            ArrayList<PNRBuilder> filters = (ArrayList<PNRBuilder>)ctx.getObject(IBusGdsSabreContextKeys.PROFILE_SYNC_FILTERS_CREATED_OR_UPDATED.name());
            if (filters == null) {
                filters = new ArrayList<PNRBuilder>();
                ctx.putObject(IBusGdsSabreContextKeys.PROFILE_SYNC_FILTERS_CREATED_OR_UPDATED.name(), filters);
            }
            PNRBuilder filter = new PNRBuilder();
            ProfileSynchronizationUtil.setSabreProfilesUniqueID((PNRBuilder)filter, (String)synchRequest.getPcc(), (String)response.getChoice().getFilter().getFilterID());
            filter.setName(response.getChoice().getFilter().getFilterName());
            filter.setType(settings.getType());
            filters.add(filter);
        }
    }
}

