/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sabre.profiles;

import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.gds.sabre.IBusGdsSabreContextKeys;
import com.gridnine.xtrip.server.gds.sabre.core.IbusGdsSabreCoreContextKeys;
import com.gridnine.xtrip.server.gds.sabre.profiles.SabreProfileServicesUtil;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.model.synchronization.sabreprofiles.SabreProfilesAssociatedProfileData;
import com.gridnine.xtrip.server.model.synchronization.sabreprofiles.SabreProfilesSynchronizationRequest;
import com.sabre.eps.schemas.FilterAssociatedProfilesType;
import com.sabre.eps.schemas.SabreOTAProfileReadRS;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class SabreOTAFilterReadRSParserPerson
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        SabreOTAProfileReadRS response = (SabreOTAProfileReadRS)ctx.getMandatoryObject((Enum)IbusGdsSabreCoreContextKeys.SABRE_WS_RESPONSE_PAYLOAD);
        List errors = (List)ctx.getMandatoryObject((Enum)IBusGdsSabreContextKeys.PROFILE_SYNC_RESPONSE_ERRORS);
        List warnings = (List)ctx.getMandatoryObject((Enum)IBusGdsSabreContextKeys.PROFILE_SYNC_RESPONSE_WARNINGS);
        List profileAssociatedProfiles = (List)ctx.getMandatoryObject((Enum)IBusGdsSabreContextKeys.PROFILE_SYNC_PARSED_ASSOCIATED_PROFILES);
        ArrayList<Message> localErrors = new ArrayList<Message>();
        ArrayList<Message> localWarnings = new ArrayList<Message>();
        SabreProfileServicesUtil.getMessagesFromResponse(response.getResponseMessage(), localErrors, localWarnings, SabreProfileServicesUtil.getSabreProfilesAssociatedProfileInfo((SabreProfilesSynchronizationRequest)ctx.getObject((Enum)IBusGdsSabreContextKeys.PROFILE_SYNC_REQUEST)));
        if (response.getChoice() != null && response.getChoice().getFilter() != null && response.getChoice().getFilter().getAssociatedProfileList() != null) {
            List filterAssociatedProfiles = response.getChoice().getFilter().getAssociatedProfileList();
            this.sortProfiles(profileAssociatedProfiles, filterAssociatedProfiles);
        }
        errors.addAll(localErrors);
        warnings.addAll(localWarnings);
    }

    private void sortProfiles(List<SabreProfilesAssociatedProfileData> profileAssociatedProfiles, List<FilterAssociatedProfilesType> filterAssociatedProfiles) {
        SabreProfileServicesUtil.sortByOrderSequenceNumber(filterAssociatedProfiles, FilterAssociatedProfilesType::getOrderSequenceNo);
        List selectedAssociatedProfiles = filterAssociatedProfiles.stream().map(filterProfile -> profileAssociatedProfiles.stream().filter(profile -> TextUtil.isSame((String)filterProfile.getAssocUniqueID(), (String)profile.getUniqueID())).findFirst().orElse(null)).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        Collection notSelectedAssociatedProfiles = CollectionUtil.subtract(profileAssociatedProfiles, selectedAssociatedProfiles, MiscUtil::equals, (boolean)false);
        profileAssociatedProfiles.clear();
        profileAssociatedProfiles.addAll(selectedAssociatedProfiles);
        profileAssociatedProfiles.addAll(notSelectedAssociatedProfiles);
    }
}

