/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sabre.profiles;

import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.gds.sabre.IBusGdsSabreContextKeys;
import com.gridnine.xtrip.server.gds.sabre.core.IbusGdsSabreCoreContextKeys;
import com.gridnine.xtrip.server.gds.sabre.profiles.SabreProfileServicesUtil;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.model.synchronization.sabreprofiles.SabreProfilesSynchronizationRequest;
import com.sabre.eps.schemas.AssociatedFiltersType;
import com.sabre.eps.schemas.ErrorMessageType;
import com.sabre.eps.schemas.ProfileAssociationType;
import com.sabre.eps.schemas.SabreOTAProfileReadRS;
import com.sabre.eps.schemas.YesNoType;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class SabreOTAProfileReadRSParser
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        SabreOTAProfileReadRS response = (SabreOTAProfileReadRS)ctx.getMandatoryObject((Enum)IbusGdsSabreCoreContextKeys.SABRE_WS_RESPONSE_PAYLOAD);
        List errors = (List)ctx.getMandatoryObject((Enum)IBusGdsSabreContextKeys.PROFILE_SYNC_RESPONSE_ERRORS);
        List warnings = (List)ctx.getMandatoryObject((Enum)IBusGdsSabreContextKeys.PROFILE_SYNC_RESPONSE_WARNINGS);
        ArrayList<Message> localErrors = new ArrayList<Message>();
        ArrayList<Message> localWarnings = new ArrayList<Message>();
        ArrayList<MiscUtil.Pair> filtersExisted = new ArrayList<MiscUtil.Pair>();
        ArrayList<String> filtersIDForDelete = new ArrayList<String>();
        if (response.getChoice() != null && response.getChoice().getProfile() != null) {
            ctx.putObject((Enum)IBusGdsSabreContextKeys.PROFILE_SYNC_CREATE_DATE_TIME, (Object)response.getChoice().getProfile().getCreateDateTime());
            ctx.putObject((Enum)IBusGdsSabreContextKeys.PROFILE_SYNC_UPDATE_DATE_TIME, (Object)response.getChoice().getProfile().getUpdateDateTime());
            ctx.putObject((Enum)IBusGdsSabreContextKeys.PROFILE_SYNC_READ_PROFILE, (Object)response.getChoice().getProfile());
            if (response.getChoice().getProfile().getChoice().getTravelAgency() != null && response.getChoice().getProfile().getChoice().getTravelAgency().getAssociatedFilterList() != null) {
                for (AssociatedFiltersType aft : response.getChoice().getProfile().getChoice().getTravelAgency().getAssociatedFilterList()) {
                    filtersExisted.add(new MiscUtil.Pair((Object)aft.getFilterID(), (Object)aft.getFilterName()));
                    filtersIDForDelete.add(aft.getFilterID());
                }
            }
            if (response.getChoice().getProfile().getChoice().getCorporation() != null && response.getChoice().getProfile().getChoice().getCorporation().getAssociatedFilterList() != null) {
                for (AssociatedFiltersType aft : response.getChoice().getProfile().getChoice().getCorporation().getAssociatedFilterList()) {
                    filtersExisted.add(new MiscUtil.Pair((Object)aft.getFilterID(), (Object)aft.getFilterName()));
                    filtersIDForDelete.add(aft.getFilterID());
                }
            }
            if (response.getChoice().getProfile().getChoice().getTraveler() != null && response.getChoice().getProfile().getChoice().getTraveler().getTPAExtensions() != null && response.getChoice().getProfile().getChoice().getTraveler().getTPAExtensions().getAssociatedFilterList() != null) {
                for (AssociatedFiltersType aft : response.getChoice().getProfile().getChoice().getTraveler().getTPAExtensions().getAssociatedFilterList()) {
                    filtersExisted.add(new MiscUtil.Pair((Object)aft.getFilterID(), (Object)aft.getFilterName()));
                    if (aft.getTemplateInheritInd() == YesNoType.Y) continue;
                    filtersIDForDelete.add(aft.getFilterID());
                }
            }
            if (response.getChoice().getProfile().getAssociation() != null) {
                ProfileAssociationType template = response.getChoice().getProfile().getAssociation();
                ctx.putObject((Enum)IBusGdsSabreContextKeys.PROFILE_SYNC_TEMPLATE_ID, (Object)template.getAssociationID());
                ctx.putObject((Enum)IBusGdsSabreContextKeys.PROFILE_SYNC_TEMPLATE_PCC, (Object)template.getDomainID());
            }
        }
        boolean dlStatusFound = false;
        if (response.getResponseMessage().getErrors() != null && response.getResponseMessage().getErrors().getErrorMessageList() != null) {
            Iterator iter = response.getResponseMessage().getErrors().getErrorMessageList().iterator();
            while (iter.hasNext()) {
                ErrorMessageType emt = (ErrorMessageType)iter.next();
                if (!"567".equals(emt.getErrorCode())) continue;
                ctx.putObject((Enum)IBusGdsSabreContextKeys.PROFILE_SYNC_DELETED_PROFILE_FOUND, (Object)Boolean.TRUE);
                dlStatusFound = true;
                iter.remove();
                break;
            }
            if (!dlStatusFound) {
                ctx.putObject((Enum)IBusGdsSabreContextKeys.PROFILE_SYNC_DELETED_PROFILE_FOUND, (Object)Boolean.FALSE);
            }
        }
        SabreProfileServicesUtil.getMessagesFromResponse(response.getResponseMessage(), localErrors, localWarnings, SabreProfileServicesUtil.getSabreProfilesAssociatedProfileInfo((SabreProfilesSynchronizationRequest)ctx.getObject((Enum)IBusGdsSabreContextKeys.PROFILE_SYNC_REQUEST)));
        ctx.putObject((Enum)IBusGdsSabreContextKeys.PROFILE_SYNC_RESPONSE_STATUS, (Object)(localErrors.size() > 0 || dlStatusFound ? "ERROR" : (localWarnings.size() > 0 ? "WARNING" : "OK")));
        ctx.putObject((Enum)IBusGdsSabreContextKeys.PROFILE_SYNC_FILTERS_EXISTED, filtersExisted);
        ctx.putObject((Enum)IBusGdsSabreContextKeys.PROFILE_SYNC_FILTERS_FOR_DELETE, filtersIDForDelete);
        errors.addAll(localErrors);
        warnings.addAll(localWarnings);
    }
}

