/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sabre.profiles;

import com.gridnine.xtrip.common.model.profile.CostCodeInfo;
import com.gridnine.xtrip.common.model.profile.EmploymentInfo;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.server.gds.sabre.IBusGdsSabreContextKeys;
import com.gridnine.xtrip.server.gds.sabre.core.IbusGdsSabreCoreContextKeys;
import com.gridnine.xtrip.server.gds.sabre.profiles.SabreProfileServicesUtil;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.model.synchronization.sabreprofiles.SabreProfilesAssociatedProfileData;
import com.gridnine.xtrip.server.model.synchronization.sabreprofiles.SabreProfilesSynchronizationRequest;
import com.sabre.eps.schemas.ProfileAssociationType;
import com.sabre.eps.schemas.SabreOTAProfileReadRS;
import java.util.ArrayList;
import java.util.List;

public class SabreOTAProfileReadRSPersonParser
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        SabreOTAProfileReadRS response = (SabreOTAProfileReadRS)ctx.getMandatoryObject((Enum)IbusGdsSabreCoreContextKeys.SABRE_WS_RESPONSE_PAYLOAD);
        List errors = (List)ctx.getMandatoryObject((Enum)IBusGdsSabreContextKeys.PROFILE_SYNC_RESPONSE_ERRORS);
        List warnings = (List)ctx.getMandatoryObject((Enum)IBusGdsSabreContextKeys.PROFILE_SYNC_RESPONSE_WARNINGS);
        ArrayList<Message> localErrors = new ArrayList<Message>();
        ArrayList<Message> localWarnings = new ArrayList<Message>();
        if (response.getChoice() != null && response.getChoice().getProfile() != null) {
            if (response.getChoice().getProfile().getTPAIdentity() != null) {
                ctx.putObject((Enum)IBusGdsSabreContextKeys.PROFILE_SYNC_PROFILE_NAME, (Object)response.getChoice().getProfile().getTPAIdentity().getProfileName());
            }
            if (response.getChoice().getProfile().getChoice().getTraveler() != null) {
                ArrayList<SabreProfilesAssociatedProfileData> associatedProfiles = new ArrayList<SabreProfilesAssociatedProfileData>();
                ArrayList<CostCodeInfo> udidValues = new ArrayList<CostCodeInfo>();
                ArrayList<EmploymentInfo> employmentInfo = new ArrayList<EmploymentInfo>();
                Person person = SabreProfileServicesUtil.parseTravelerProfileType(response.getChoice().getProfile().getChoice().getTraveler(), associatedProfiles, udidValues, employmentInfo);
                if (person != null) {
                    person.setSabreProfilesUpdateDate(response.getChoice().getProfile().getUpdateDateTime());
                }
                ctx.putObject((Enum)IBusGdsSabreContextKeys.PROFILE_SYNC_PARSED_PERSON, (Object)person);
                ctx.putObject((Enum)IBusGdsSabreContextKeys.PROFILE_SYNC_PARSED_ASSOCIATED_PROFILES, associatedProfiles);
                ctx.putObject((Enum)IBusGdsSabreContextKeys.PROFILE_SYNC_PARSED_COST_CODES, udidValues);
                ctx.putObject((Enum)IBusGdsSabreContextKeys.PROFILE_SYNC_PARSED_EMPLOYMENT_INFO, employmentInfo);
                if (response.getChoice().getProfile().getChoice().getTraveler().getTPAExtensions() != null && response.getChoice().getProfile().getChoice().getTraveler().getTPAExtensions().getAssociatedFilterList() != null) {
                    ctx.putObject((Enum)IBusGdsSabreContextKeys.PROFILE_SYNC_PARSED_ASSOCIATED_FILTERS, (Object)response.getChoice().getProfile().getChoice().getTraveler().getTPAExtensions().getAssociatedFilterList());
                }
            }
            if (response.getChoice().getProfile().getAssociation() != null) {
                ProfileAssociationType template = response.getChoice().getProfile().getAssociation();
                ctx.putObject((Enum)IBusGdsSabreContextKeys.PROFILE_SYNC_TEMPLATE_ID, (Object)template.getAssociationID());
                ctx.putObject((Enum)IBusGdsSabreContextKeys.PROFILE_SYNC_TEMPLATE_PCC, (Object)template.getDomainID());
            }
        }
        SabreProfileServicesUtil.getMessagesFromResponse(response.getResponseMessage(), localErrors, localWarnings, SabreProfileServicesUtil.getSabreProfilesAssociatedProfileInfo((SabreProfilesSynchronizationRequest)ctx.getObject((Enum)IBusGdsSabreContextKeys.PROFILE_SYNC_REQUEST)));
        ctx.putObject((Enum)IBusGdsSabreContextKeys.PROFILE_SYNC_RESPONSE_STATUS, (Object)(localErrors.size() > 0 ? "ERROR" : (localWarnings.size() > 0 ? "WARNING" : "OK")));
        errors.addAll(localErrors);
        warnings.addAll(localWarnings);
    }
}

