/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sabre.profiles;

import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.server.gds.sabre.IBusGdsSabreContextKeys;
import com.gridnine.xtrip.server.gds.sabre.core.IbusGdsSabreCoreContextKeys;
import com.gridnine.xtrip.server.gds.sabre.profiles.SabreProfileServicesUtil;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.model.synchronization.sabreprofiles.SabreProfilesSynchronizationRequest;
import com.sabre.eps.schemas.SabreOTAProfileSearchRS;
import com.sabre.eps.schemas.SearchProfileType;
import com.sabre.eps.schemas.SearchRSProfileInfoType;
import com.sabre.eps.schemas.StatusType;
import java.util.ArrayList;
import java.util.List;

public class SabreOTAProfileSearchRSParser
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        SearchRSProfileInfoType profilesInfo;
        SabreOTAProfileSearchRS response = (SabreOTAProfileSearchRS)ctx.getMandatoryObject((Enum)IbusGdsSabreCoreContextKeys.SABRE_WS_RESPONSE_PAYLOAD);
        SearchRSProfileInfoType searchRSProfileInfoType = profilesInfo = response.getChoice() != null ? response.getChoice().getProfileInfo() : null;
        if (profilesInfo != null) {
            SearchProfileType spt;
            String uniqueID = null;
            if (profilesInfo.getProfile() != null && profilesInfo.getProfile().getTPAIdentity() != null) {
                uniqueID = profilesInfo.getProfile().getTPAIdentity().getUniqueID();
                if (StatusType.DL == profilesInfo.getProfile().getTPAIdentity().getProfileStatusCode()) {
                    ctx.putObject((Enum)IBusGdsSabreContextKeys.PROFILE_SYNC_DELETED_PROFILE_FOUND, (Object)Boolean.TRUE);
                }
            } else if (profilesInfo.getProfileList() != null && profilesInfo.getProfileList().getProfileList().size() > 0 && (spt = (SearchProfileType)profilesInfo.getProfileList().getProfileList().get(0)).getTPAIdentity() != null) {
                uniqueID = spt.getTPAIdentity().getUniqueID();
                if (StatusType.DL == spt.getTPAIdentity().getProfileStatusCode()) {
                    ctx.putObject((Enum)IBusGdsSabreContextKeys.PROFILE_SYNC_DELETED_PROFILE_FOUND, (Object)Boolean.TRUE);
                }
            }
            ctx.putObject((Enum)IBusGdsSabreContextKeys.PROFILE_SYNC_SEARCH_FIRST_UNIQUE_ID, uniqueID);
        }
        List errors = (List)ctx.getMandatoryObject((Enum)IBusGdsSabreContextKeys.PROFILE_SYNC_RESPONSE_ERRORS);
        List warnings = (List)ctx.getMandatoryObject((Enum)IBusGdsSabreContextKeys.PROFILE_SYNC_RESPONSE_WARNINGS);
        ArrayList<Message> localErrors = new ArrayList<Message>();
        ArrayList<Message> localWarnings = new ArrayList<Message>();
        SabreProfileServicesUtil.getMessagesFromResponse(response.getResponseMessage(), localErrors, localWarnings, SabreProfileServicesUtil.getSabreProfilesAssociatedProfileInfo((SabreProfilesSynchronizationRequest)ctx.getObject((Enum)IBusGdsSabreContextKeys.PROFILE_SYNC_REQUEST)));
        ctx.putObject((Enum)IBusGdsSabreContextKeys.PROFILE_SYNC_RESPONSE_STATUS, (Object)(localErrors.size() > 0 ? "ERROR" : (localWarnings.size() > 0 ? "WARNING" : "OK")));
        errors.addAll(localErrors);
        warnings.addAll(localWarnings);
    }
}

