/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sabre.profiles;

import com.gridnine.xtrip.common.model.profile.SabreProfilesProfileInfo;
import com.gridnine.xtrip.common.model.profile.SabreProfilesProfileType;
import com.gridnine.xtrip.server.gds.sabre.IBusGdsSabreContextKeys;
import com.gridnine.xtrip.server.gds.sabre.core.IbusGdsSabreCoreContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.sabre.eps.schemas.ProfileSearchRSTPAIdentityType;
import com.sabre.eps.schemas.SabreOTAProfileSearchRS;
import com.sabre.eps.schemas.SearchProfileType;
import com.sabre.eps.schemas.SearchRSProfileInfoType;
import com.sabre.eps.schemas.TPAIdentityType;
import com.sabre.eps.schemas.YesNoType;
import java.util.ArrayList;
import java.util.List;

public class SabreOTAProfileSearchRSProfilesParser
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        SabreOTAProfileSearchRS response = (SabreOTAProfileSearchRS)ctx.getMandatoryObject((Enum)IbusGdsSabreCoreContextKeys.SABRE_WS_RESPONSE_PAYLOAD);
        List profilesData = (List)ctx.getMandatoryObject((Enum)IBusGdsSabreContextKeys.PROFILE_SYNC_FOUND_PROFILES);
        SearchRSProfileInfoType profilesInfo = response.getChoice() != null ? response.getChoice().getProfileInfo() : null;
        ArrayList<SabreProfilesProfileInfo> localProfilesData = new ArrayList<SabreProfilesProfileInfo>();
        boolean haveMore = false;
        if (profilesInfo != null) {
            if (profilesInfo.getProfile() != null && profilesInfo.getProfile().getTPAIdentity() != null) {
                localProfilesData.add(this.convert(profilesInfo.getProfile().getTPAIdentity()));
            } else if (profilesInfo.getProfileList() != null && !profilesInfo.getProfileList().getProfileList().isEmpty()) {
                for (SearchProfileType spt : profilesInfo.getProfileList().getProfileList()) {
                    if (spt.getTPAIdentity() == null) continue;
                    localProfilesData.add(this.convert(spt.getTPAIdentity()));
                }
                if (profilesInfo.getProfileList().getHaveMore() == YesNoType.Y) {
                    haveMore = true;
                }
            }
        }
        profilesData.addAll(localProfilesData);
        ctx.putObject((Enum)IBusGdsSabreContextKeys.HAVE_MORE, (Object)haveMore);
    }

    private SabreProfilesProfileInfo convert(TPAIdentityType tpaId) {
        SabreProfilesProfileInfo profileData = new SabreProfilesProfileInfo();
        profileData.setUniqueId(tpaId.getUniqueID());
        profileData.setPcc(tpaId.getDomainID());
        profileData.setName(tpaId.getProfileName());
        profileData.setDescription(tpaId.getProfileDescription());
        if (tpaId.getProfileTypeCode() != null) {
            profileData.setType(SabreProfilesProfileType.valueOf((String)tpaId.getProfileTypeCode().name()));
        }
        return profileData;
    }

    private SabreProfilesProfileInfo convert(ProfileSearchRSTPAIdentityType tpaId) {
        SabreProfilesProfileInfo profileData = new SabreProfilesProfileInfo();
        profileData.setUniqueId(tpaId.getUniqueID());
        profileData.setPcc(tpaId.getDomainID());
        profileData.setName(tpaId.getProfileName());
        profileData.setDescription(tpaId.getProfileDescription());
        if (tpaId.getProfileTypeCode() != null) {
            profileData.setType(SabreProfilesProfileType.valueOf((String)tpaId.getProfileTypeCode().name()));
        }
        return profileData;
    }
}

