/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sabre.profiles;

import com.gridnine.xtrip.common.model.profile.PNRBuilder;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.gds.sabre.IBusGdsSabreContextKeys;
import com.gridnine.xtrip.server.gds.sabre.core.IbusGdsSabreCoreContextKeys;
import com.gridnine.xtrip.server.gds.sabre.profiles.SabreProfileServicesUtil;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.model.synchronization.sabreprofiles.SabreProfilesSynchronizationRequest;
import com.sabre.eps.schemas.ProfileType;
import com.sabre.eps.schemas.SabreOTAProfileUpdateRQ;
import java.util.List;
import java.util.stream.Collectors;

public class SabreOTAProfileUpdateRQPerson
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        SabreProfilesSynchronizationRequest synchRequest = (SabreProfilesSynchronizationRequest)ctx.getMandatoryObject((Enum)IBusGdsSabreContextKeys.PROFILE_SYNC_REQUEST);
        ProfileType readProfileType = (ProfileType)ctx.getMandatoryObject((Enum)IBusGdsSabreContextKeys.PROFILE_SYNC_READ_PROFILE);
        List createdFilters = (List)ctx.getObject((Enum)IBusGdsSabreContextKeys.PROFILE_SYNC_FILTERS_CREATED_OR_UPDATED);
        List existingFilters = (List)ctx.getMandatoryObject((Enum)IBusGdsSabreContextKeys.PROFILE_SYNC_FILTERS_EXISTED);
        List deletedFilters = (List)ctx.getMandatoryObject((Enum)IBusGdsSabreContextKeys.PROFILE_SYNC_FILTERS_FOR_DELETE);
        List<String> filtersToRemain = this.getFiltersToRemain(existingFilters, deletedFilters);
        SabreOTAProfileUpdateRQ request = this.buildRequest(synchRequest, readProfileType, createdFilters, filtersToRemain);
        ctx.putObject((Enum)IbusGdsSabreCoreContextKeys.SABRE_WS_REQUEST_PAYLOAD, (Object)request);
        ctx.putObject((Enum)IbusGdsSabreCoreContextKeys.SABRE_WS_SERVICE_ACTION_CODE, (Object)"EPS_ProfileUpdateRQ");
    }

    private SabreOTAProfileUpdateRQ buildRequest(SabreProfilesSynchronizationRequest synchRequest, ProfileType readProfileType, List<PNRBuilder> createdFilters, List<String> filtersToRemain) {
        SabreOTAProfileUpdateRQ request = SabreProfileServicesUtil.getUpdatePersonRequest(synchRequest, readProfileType, createdFilters, filtersToRemain);
        request.setVersion("2.0.0");
        return request;
    }

    private List<String> getFiltersToRemain(List<MiscUtil.Pair<String, String>> existingFilters, List<String> deletedFilters) {
        return existingFilters.stream().map(MiscUtil.Pair::getFirst).filter(filterId -> !deletedFilters.contains(filterId)).collect(Collectors.toList());
    }
}

