/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sabre.profiles;

import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.server.gds.sabre.IBusGdsSabreContextKeys;
import com.gridnine.xtrip.server.gds.sabre.core.IbusGdsSabreCoreContextKeys;
import com.gridnine.xtrip.server.gds.sabre.profiles.SabreProfileServicesUtil;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.model.synchronization.sabreprofiles.SabreProfilesSynchronizationRequest;
import com.sabre.eps.schemas.SabreOTAProfileUpdateRS;
import java.util.ArrayList;
import java.util.List;

public class SabreOTAProfileUpdateRSParser
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        SabreOTAProfileUpdateRS response = (SabreOTAProfileUpdateRS)ctx.getMandatoryObject((Enum)IbusGdsSabreCoreContextKeys.SABRE_WS_RESPONSE_PAYLOAD);
        List errors = (List)ctx.getMandatoryObject((Enum)IBusGdsSabreContextKeys.PROFILE_SYNC_RESPONSE_ERRORS);
        List warnings = (List)ctx.getMandatoryObject((Enum)IBusGdsSabreContextKeys.PROFILE_SYNC_RESPONSE_WARNINGS);
        ArrayList<Message> localErrors = new ArrayList<Message>();
        ArrayList<Message> localWarnings = new ArrayList<Message>();
        SabreProfileServicesUtil.getMessagesFromResponse(response.getResponseMessage(), localErrors, localWarnings, SabreProfileServicesUtil.getSabreProfilesAssociatedProfileInfo((SabreProfilesSynchronizationRequest)ctx.getObject((Enum)IBusGdsSabreContextKeys.PROFILE_SYNC_REQUEST)));
        ctx.putObject((Enum)IBusGdsSabreContextKeys.PROFILE_SYNC_RESPONSE_STATUS, (Object)(localErrors.size() > 0 ? "ERROR" : (localWarnings.size() > 0 ? "WARNING" : "OK")));
        if (response.getChoice() != null && response.getChoice().getProfile() != null) {
            ctx.putObject((Enum)IBusGdsSabreContextKeys.PROFILE_SYNC_CREATE_UNIQUE_ID, (Object)response.getChoice().getProfile().getUniqueID());
            ctx.putObject((Enum)IBusGdsSabreContextKeys.PROFILE_SYNC_PROFILE_NAME, (Object)response.getChoice().getProfile().getProfileName());
        }
        if (response.getUpdateDateTime() != null) {
            ctx.putObject((Enum)IBusGdsSabreContextKeys.PROFILE_SYNC_UPDATE_DATE_TIME, (Object)response.getUpdateDateTime());
        }
        errors.addAll(localErrors);
        warnings.addAll(localWarnings);
    }
}

