/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sabre.profiles;

import com.gridnine.xtrip.common.l10n.model.L10nString;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.cir.CirHelper;
import com.gridnine.xtrip.common.model.dict.AddressType;
import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.AirlineReference;
import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.model.dict.CarsSupplierReference;
import com.gridnine.xtrip.common.model.dict.CodeSystem;
import com.gridnine.xtrip.common.model.dict.CommunicationType;
import com.gridnine.xtrip.common.model.dict.CostCodeKdsType;
import com.gridnine.xtrip.common.model.dict.CountryReference;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.Gender;
import com.gridnine.xtrip.common.model.dict.GeoLocation;
import com.gridnine.xtrip.common.model.dict.HotelsBrand;
import com.gridnine.xtrip.common.model.dict.HotelsBrandReference;
import com.gridnine.xtrip.common.model.dict.PassportType;
import com.gridnine.xtrip.common.model.dict.PersonTitle;
import com.gridnine.xtrip.common.model.gds.sabre.ProfileSynchronizationConstants;
import com.gridnine.xtrip.common.model.gds.sabre.ProfileSynchronizationUtil;
import com.gridnine.xtrip.common.model.gds.sabre.SabreProfileLineDataProxy;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.MessageHelper;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.helpers.ReasonCodeHelper;
import com.gridnine.xtrip.common.model.helpers.ValidationUtil;
import com.gridnine.xtrip.common.model.profile.Address;
import com.gridnine.xtrip.common.model.profile.AirPreferences;
import com.gridnine.xtrip.common.model.profile.AirlineBonusCard;
import com.gridnine.xtrip.common.model.profile.CarBonusCard;
import com.gridnine.xtrip.common.model.profile.Card;
import com.gridnine.xtrip.common.model.profile.Communication;
import com.gridnine.xtrip.common.model.profile.CostCodeInfo;
import com.gridnine.xtrip.common.model.profile.CwtOrganizationData;
import com.gridnine.xtrip.common.model.profile.CwtPersonData;
import com.gridnine.xtrip.common.model.profile.Discounts;
import com.gridnine.xtrip.common.model.profile.EmploymentInfo;
import com.gridnine.xtrip.common.model.profile.ExternalSystem;
import com.gridnine.xtrip.common.model.profile.HotelBonusCard;
import com.gridnine.xtrip.common.model.profile.HotelDiscount;
import com.gridnine.xtrip.common.model.profile.HotelPreferences;
import com.gridnine.xtrip.common.model.profile.ISuiteCostCodesSyncSettings;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.OrganizationType;
import com.gridnine.xtrip.common.model.profile.PCIDSSServerExchangeSettings;
import com.gridnine.xtrip.common.model.profile.PNRBuilder;
import com.gridnine.xtrip.common.model.profile.PNRBuilderSettings;
import com.gridnine.xtrip.common.model.profile.Passport;
import com.gridnine.xtrip.common.model.profile.PassportCorrelationQualifier;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.PersonAddress;
import com.gridnine.xtrip.common.model.profile.PersonCommunication;
import com.gridnine.xtrip.common.model.profile.PersonEmployment;
import com.gridnine.xtrip.common.model.profile.PreferredSuppliers;
import com.gridnine.xtrip.common.model.profile.RailwayBonusCard;
import com.gridnine.xtrip.common.model.profile.ReasonCodeType;
import com.gridnine.xtrip.common.model.profile.RiskManagementCompany;
import com.gridnine.xtrip.common.model.profile.SabreContactEmail;
import com.gridnine.xtrip.common.model.profile.SabreContactPhone;
import com.gridnine.xtrip.common.model.profile.SabreProfileCommand2Osi;
import com.gridnine.xtrip.common.model.profile.SabreProfileCommand4SSR;
import com.gridnine.xtrip.common.model.profile.SabreProfileLine;
import com.gridnine.xtrip.common.model.profile.SabreProfileLineServiceType;
import com.gridnine.xtrip.common.model.profile.SabreProfileLineType;
import com.gridnine.xtrip.common.model.profile.SabreProfilesCostCodeType;
import com.gridnine.xtrip.common.model.profile.SabreProfilesProfileType;
import com.gridnine.xtrip.common.model.profile.Visa;
import com.gridnine.xtrip.common.model.rules.standard.SabreSynchronizationAdditionalTargets;
import com.gridnine.xtrip.common.model.rules.standard.Targets;
import com.gridnine.xtrip.common.model.system.CardVendor;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.rpc.ServiceException;
import com.gridnine.xtrip.common.util.CaseInsensitive;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.EnumUtil;
import com.gridnine.xtrip.common.util.LocaleUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.model.synchronization.sabreprofiles.SabreProfilesAssociatedProfileData;
import com.gridnine.xtrip.server.model.synchronization.sabreprofiles.SabreProfilesDictionaryData;
import com.gridnine.xtrip.server.model.synchronization.sabreprofiles.SabreProfilesDiscountData;
import com.gridnine.xtrip.server.model.synchronization.sabreprofiles.SabreProfilesPersonInCharge;
import com.gridnine.xtrip.server.model.synchronization.sabreprofiles.SabreProfilesPersonKeyContact;
import com.gridnine.xtrip.server.model.synchronization.sabreprofiles.SabreProfilesSynchronizationRequest;
import com.gridnine.xtrip.server.model.synchronization.sabreprofiles.SabreProfilesSynchronizationUtil;
import com.gridnine.xtrip.server.model.synchronization.sabreprofiles.UdidRemark;
import com.sabre.eps.schemas.AgencyContactNameType;
import com.sabre.eps.schemas.AgencyInfoType;
import com.sabre.eps.schemas.AirMealInfoType;
import com.sabre.eps.schemas.AirlineMealPrefType;
import com.sabre.eps.schemas.AirlinePrefType;
import com.sabre.eps.schemas.AirlineSeatInfoType;
import com.sabre.eps.schemas.AirlineSeatPrefType;
import com.sabre.eps.schemas.AssociatedFiltersType;
import com.sabre.eps.schemas.AssociatedProfilesType;
import com.sabre.eps.schemas.AssociationType;
import com.sabre.eps.schemas.BusinessSystemIdentityInfoType;
import com.sabre.eps.schemas.CardHolderNameType;
import com.sabre.eps.schemas.CategoryCodeType;
import com.sabre.eps.schemas.ContactNameType;
import com.sabre.eps.schemas.ContactType;
import com.sabre.eps.schemas.CorporateInfoType;
import com.sabre.eps.schemas.CorporateProfileType;
import com.sabre.eps.schemas.CreateCustomFieldCodeType;
import com.sabre.eps.schemas.CustLoyaltyType;
import com.sabre.eps.schemas.CustomDefinedDataType;
import com.sabre.eps.schemas.CustomDefinedValuesType;
import com.sabre.eps.schemas.CustomerReferenceInfoType;
import com.sabre.eps.schemas.CustomerType;
import com.sabre.eps.schemas.DeleteFilterType;
import com.sabre.eps.schemas.DeleteProfileType;
import com.sabre.eps.schemas.DeleteTPAIdentityType;
import com.sabre.eps.schemas.DeleteType;
import com.sabre.eps.schemas.DiscountsType;
import com.sabre.eps.schemas.DocHolderNameType;
import com.sabre.eps.schemas.DocumentType;
import com.sabre.eps.schemas.EmailType;
import com.sabre.eps.schemas.EmployeeInfoType;
import com.sabre.eps.schemas.EmploymentInfoType;
import com.sabre.eps.schemas.ErrorMessageType;
import com.sabre.eps.schemas.FilterAddressType;
import com.sabre.eps.schemas.FilterAgencyInfoType;
import com.sabre.eps.schemas.FilterAssociatedProfilesType;
import com.sabre.eps.schemas.FilterCardHolderNameType;
import com.sabre.eps.schemas.FilterCorporateProfileType;
import com.sabre.eps.schemas.FilterCustLoyaltyType;
import com.sabre.eps.schemas.FilterCustomerReferenceInfoType;
import com.sabre.eps.schemas.FilterCustomerType;
import com.sabre.eps.schemas.FilterDiscountsType;
import com.sabre.eps.schemas.FilterDocumentType;
import com.sabre.eps.schemas.FilterEmailType;
import com.sabre.eps.schemas.FilterPaymentCardType;
import com.sabre.eps.schemas.FilterPaymentFormType;
import com.sabre.eps.schemas.FilterPersonNameType;
import com.sabre.eps.schemas.FilterProfileType;
import com.sabre.eps.schemas.FilterRemarkType;
import com.sabre.eps.schemas.FilterTPAExtensionsType;
import com.sabre.eps.schemas.FilterTPAIdentityType;
import com.sabre.eps.schemas.FilterTelephoneType;
import com.sabre.eps.schemas.FilterTravelAgencyProfileType;
import com.sabre.eps.schemas.FilterTravelerProfileType;
import com.sabre.eps.schemas.FilterType;
import com.sabre.eps.schemas.HotelPrefType;
import com.sabre.eps.schemas.NumberOfAssocProfilesType;
import com.sabre.eps.schemas.OSIType;
import com.sabre.eps.schemas.PNRMoveInfoType;
import com.sabre.eps.schemas.ParsedPhoneNumberType;
import com.sabre.eps.schemas.PaymentCardType;
import com.sabre.eps.schemas.PaymentFormType;
import com.sabre.eps.schemas.PersonNameType;
import com.sabre.eps.schemas.PrefCollectionsType;
import com.sabre.eps.schemas.PreferredAirlinesType;
import com.sabre.eps.schemas.PreferredHotelType;
import com.sabre.eps.schemas.PriorityRemarksType;
import com.sabre.eps.schemas.ProfileBaseCriteriaType;
import com.sabre.eps.schemas.ProfileInfoType;
import com.sabre.eps.schemas.ProfileSearchCriteriaType;
import com.sabre.eps.schemas.ProfileType;
import com.sabre.eps.schemas.ProfileTypeInfo;
import com.sabre.eps.schemas.ReadAssociationType;
import com.sabre.eps.schemas.ReadFilterType;
import com.sabre.eps.schemas.ReadProfileType;
import com.sabre.eps.schemas.RemarkType;
import com.sabre.eps.schemas.ResponseMessageType;
import com.sabre.eps.schemas.RestoreProfileType;
import com.sabre.eps.schemas.RestoreType;
import com.sabre.eps.schemas.RetrieveCustomFieldCodesType;
import com.sabre.eps.schemas.SSRType;
import com.sabre.eps.schemas.SabreCorporateTravelPolicyType;
import com.sabre.eps.schemas.SabreOTAProfileCreateRQ;
import com.sabre.eps.schemas.SabreOTAProfileDataSrvRQ;
import com.sabre.eps.schemas.SabreOTAProfileDeleteRQ;
import com.sabre.eps.schemas.SabreOTAProfileReadRQ;
import com.sabre.eps.schemas.SabreOTAProfileSearchRQ;
import com.sabre.eps.schemas.SabreOTAProfileUpdateRQ;
import com.sabre.eps.schemas.SearchAssociatedAssociationType;
import com.sabre.eps.schemas.SearchAssociatedProfilesType;
import com.sabre.eps.schemas.SearchCustomerReferenceInfoType;
import com.sabre.eps.schemas.SearchDocumentType;
import com.sabre.eps.schemas.SearchProfileTypeInfo;
import com.sabre.eps.schemas.SearchTPAIdentityType;
import com.sabre.eps.schemas.SearchTravelerInfoType;
import com.sabre.eps.schemas.TPAExtensionsType;
import com.sabre.eps.schemas.TPAIdentityType;
import com.sabre.eps.schemas.TelephoneType;
import com.sabre.eps.schemas.TravelAgencyProfileType;
import com.sabre.eps.schemas.TravelPolicyType;
import com.sabre.eps.schemas.TravelerProfileType;
import com.sabre.eps.schemas.VITStarLineType;
import com.sabre.eps.schemas.YesNoType;
import com.sabre.webservices.sabrexml.SabreCommandLLSRQ;
import java.io.Serializable;
import java.math.BigInteger;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;

public class SabreProfileServicesUtil {
    public static final String UNIQUE_ID_NEW = "*";
    public static final String CLIENT_CODE = "TN";
    public static final String CLIENT_CONTEXT_CODE = "GDN";
    public static final String SABRE_PROFILES_READ_RETURNED_DL_CODE = "567";
    static final String SP_FILTER_MOM_SUFFIX = "-MOM";
    private static final String SP_FILTER_ANY_STRING = "X";
    private static final String SP_FILTER_ANY_NUMERIC_STRING = "0";
    private static final String SP_FILTER_ANY_CODE = "*";
    private static final String SP_FILTER_ANY_DATE = "123000";
    private static final String GET_THERE = "GetThere";
    private static final String GET_THERE_USER_ID = "UserID";
    public static final Map<String, List<String>> generalCategory2Target = new HashMap<String, List<String>>(){
        {
            this.put("AIR", new ArrayList<String>(){
                {
                    this.add(Targets.PRODUCT_COMMISSION.getId());
                    this.add(Targets.AVIA_SUBSIDIZED.getId());
                }
            });
            this.put("CAR", new ArrayList<String>(){
                {
                    this.add(Targets.CAR.getId());
                    this.add(SabreSynchronizationAdditionalTargets.TRANSFER_DOMESTIC.getId());
                    this.add(SabreSynchronizationAdditionalTargets.TRANSFER_FOREIGN.getId());
                }
            });
            this.put("DOC", new ArrayList<String>(){
                {
                    this.add(SabreSynchronizationAdditionalTargets.INTERNATIONAL_PASSPORT.getId());
                    this.add(SabreSynchronizationAdditionalTargets.VISUM.getId());
                    this.add(SabreSynchronizationAdditionalTargets.INVOICE_DUPLICATE.getId());
                }
            });
            this.put("HOT", new ArrayList<String>(){
                {
                    this.add(Targets.HOTELS_FOREIGN.getId());
                    this.add(Targets.HOTELS_DOMESTIC.getId());
                    this.add(Targets.HOTELS_COMMISSION.getId());
                }
            });
            this.put("INS", new ArrayList<String>(){
                {
                    this.add(Targets.INSURANCE_TOURISTIC_COMMISSION.getId());
                    this.add(Targets.INSURANCE_ACCIDENT_COMMISSION.getId());
                }
            });
            this.put("RAL", new ArrayList<String>(){
                {
                    this.add("RAILWAY_PRODUCT_COMMISSION");
                    this.add(Targets.AEROEXPRESS_COMMISSION.getId());
                }
            });
        }
    };

    public static SabreOTAProfileCreateRQ getCreateOrganizationRequest(SabreProfilesSynchronizationRequest synchRequest, List<PNRBuilder> filters) {
        if (synchRequest == null || synchRequest.getOrganization() == null) {
            return null;
        }
        SabreOTAProfileCreateRQ request = new SabreOTAProfileCreateRQ();
        ProfileType pt = SabreProfileServicesUtil.createOrganizationProfileType(synchRequest, null, null, filters);
        pt.getTPAIdentity().setUniqueID("*");
        request.setProfile(pt);
        return request;
    }

    public static SabreOTAProfileUpdateRQ getUpdateOrganizationRequest(SabreProfilesSynchronizationRequest synchRequest, Date createDateTime, Date updateDateTime, List<PNRBuilder> filters) {
        if (synchRequest == null || synchRequest.getOrganization() == null) {
            return null;
        }
        SabreOTAProfileUpdateRQ request = new SabreOTAProfileUpdateRQ();
        ProfileType pt = SabreProfileServicesUtil.createOrganizationProfileType(synchRequest, createDateTime, updateDateTime, filters);
        ProfileInfoType pit = new ProfileInfoType();
        pit.setProfile(pt);
        request.setProfileInfo(pit);
        return request;
    }

    public static SabreOTAProfileUpdateRQ getUpdateFilterOrganizationRequest(SabreProfilesSynchronizationRequest synchRequest, String filterID, PNRBuilderSettings settings, Date createDateTime, Date updateDateTime) {
        if (synchRequest == null || synchRequest.getOrganization() == null) {
            return null;
        }
        SabreOTAProfileUpdateRQ request = new SabreOTAProfileUpdateRQ();
        FilterType filter = SabreProfileServicesUtil.createOrganizationFilterType(synchRequest, createDateTime, updateDateTime, settings);
        filter.setFilterID(filterID);
        request.setFilter(filter);
        return request;
    }

    public static SabreOTAProfileCreateRQ getCreatePersonRequest(SabreProfilesSynchronizationRequest synchRequest, List<PNRBuilder> filters) {
        if (synchRequest == null || synchRequest.getPerson() == null) {
            return null;
        }
        SabreOTAProfileCreateRQ request = new SabreOTAProfileCreateRQ();
        ProfileType pt = SabreProfileServicesUtil.createPersonProfileType(synchRequest, filters);
        pt.getTPAIdentity().setUniqueID("*");
        request.setProfile(pt);
        return request;
    }

    public static SabreOTAProfileUpdateRQ getUpdatePersonRequest(SabreProfilesSynchronizationRequest synchRequest, ProfileType readProfileType, List<PNRBuilder> createdFilters, List<String> filtersToRemain) {
        if (synchRequest == null || synchRequest.getPerson() == null) {
            return null;
        }
        SabreOTAProfileUpdateRQ request = new SabreOTAProfileUpdateRQ();
        SabreProfileServicesUtil.updatePersonProfileType(synchRequest, readProfileType, createdFilters, filtersToRemain);
        ProfileInfoType pit = new ProfileInfoType();
        pit.setProfile(readProfileType);
        request.setProfileInfo(pit);
        return request;
    }

    public static SabreOTAProfileDeleteRQ getDeletePersonRequest(SabreProfilesSynchronizationRequest synchRequest) {
        if (synchRequest == null || synchRequest.getPerson() == null) {
            return null;
        }
        SabreOTAProfileDeleteRQ request = new SabreOTAProfileDeleteRQ();
        Person per = synchRequest.getPerson();
        DeleteType dt = new DeleteType();
        DeleteProfileType pt = new DeleteProfileType();
        pt.setPurgeDays(SP_FILTER_ANY_NUMERIC_STRING);
        pt.setTPAIdentity(SabreProfileServicesUtil.createDeleteTPAIdentityForProfileType(ProfileSynchronizationUtil.getSabreProfilesUniqueID((Person)per, (String)synchRequest.getPcc()), synchRequest.getPcc(), ProfileTypeInfo.TVL));
        dt.setProfile(pt);
        request.setDelete(dt);
        return request;
    }

    public static SabreOTAProfileDeleteRQ getRestoreProfileRequest(SabreProfilesSynchronizationRequest synchRequest, String uniqueID) {
        ProfileTypeInfo pti;
        if (synchRequest == null) {
            return null;
        }
        SabreOTAProfileDeleteRQ request = new SabreOTAProfileDeleteRQ();
        RestoreType rt = new RestoreType();
        RestoreProfileType pt = new RestoreProfileType();
        ProfileTypeInfo profileTypeInfo = pti = synchRequest.getPerson() != null ? ProfileTypeInfo.TVL : ProfileTypeInfo.CRP;
        if (synchRequest.getOrganization().getTypes().contains(OrganizationType.AGENCY) && !synchRequest.getOrganization().getTypes().contains(OrganizationType.CORPORATE_CLIENT)) {
            pti = ProfileTypeInfo.AGY;
        }
        pt.setTPAIdentity(SabreProfileServicesUtil.createDeleteTPAIdentityForProfileType(uniqueID, synchRequest.getPcc(), pti));
        rt.setProfile(pt);
        request.setRestore(rt);
        return request;
    }

    public static SabreOTAProfileDeleteRQ getDeleteOrganizationRequest(SabreProfilesSynchronizationRequest synchRequest) {
        if (synchRequest == null || synchRequest.getOrganization() == null) {
            return null;
        }
        SabreOTAProfileDeleteRQ request = new SabreOTAProfileDeleteRQ();
        Organization org = synchRequest.getOrganization();
        DeleteType dt = new DeleteType();
        DeleteProfileType pt = new DeleteProfileType();
        pt.setPurgeDays(SP_FILTER_ANY_NUMERIC_STRING);
        ProfileTypeInfo pti = ProfileTypeInfo.CRP;
        if (synchRequest.getOrganization().getTypes().contains(OrganizationType.AGENCY) && !synchRequest.getOrganization().getTypes().contains(OrganizationType.CORPORATE_CLIENT)) {
            pti = ProfileTypeInfo.AGY;
        }
        pt.setTPAIdentity(SabreProfileServicesUtil.createDeleteTPAIdentityForProfileType(ProfileSynchronizationUtil.getSabreProfilesUniqueID((Organization)org, (String)synchRequest.getPcc()), synchRequest.getPcc(), pti));
        dt.setProfile(pt);
        request.setDelete(dt);
        return request;
    }

    public static SabreOTAProfileCreateRQ getCreateFilterOrganizationRequest(SabreProfilesSynchronizationRequest synchRequest, PNRBuilderSettings settings) {
        if (synchRequest == null || synchRequest.getOrganization() == null) {
            return null;
        }
        SabreOTAProfileCreateRQ request = new SabreOTAProfileCreateRQ();
        FilterType filter = SabreProfileServicesUtil.createOrganizationFilterType(synchRequest, null, null, settings);
        filter.setFilterID("*");
        request.setFilter(filter);
        return request;
    }

    public static SabreOTAProfileCreateRQ getCreateFilterPersonRequest(SabreProfilesSynchronizationRequest synchRequest, PNRBuilderSettings settings) {
        if (synchRequest == null || synchRequest.getPerson() == null) {
            return null;
        }
        SabreOTAProfileCreateRQ request = new SabreOTAProfileCreateRQ();
        FilterType filter = SabreProfileServicesUtil.createPersonFilterType(synchRequest, null, null, settings);
        filter.setFilterID("*");
        request.setFilter(filter);
        return request;
    }

    private static FilterType createOrganizationFilterType(SabreProfilesSynchronizationRequest synchRequest, Date createDateTime, Date updateDateTime, PNRBuilderSettings filterSettings) {
        Organization org = synchRequest.getOrganization();
        FilterType ft = new FilterType();
        ft.setCreateDateTime(createDateTime != null ? createDateTime : new Date());
        ft.setUpdateDateTime(updateDateTime != null ? updateDateTime : new Date());
        ft.setClientCode(CLIENT_CODE);
        ft.setClientContextCode(CLIENT_CONTEXT_CODE);
        ft.setDomainID(synchRequest.getPcc());
        ft.setFilterName(filterSettings.getName());
        ft.setFilterDescription(TextUtil.nonEmptyStr((String)filterSettings.getDescription()));
        if (org.getTypes().contains(OrganizationType.AGENCY) && !org.getTypes().contains(OrganizationType.CORPORATE_CLIENT)) {
            ft.setFilterTypeCode(ProfileTypeInfo.AGY);
            FilterProfileType fpt = new FilterProfileType();
            fpt.setTPAIdentity(SabreProfileServicesUtil.createFilterTPAIdentityForProfileType(SP_FILTER_ANY_STRING, ProfileSynchronizationUtil.getEnglishOrNullValue((L10nString)org.getShortName()), ProfileSynchronizationUtil.getEnglishOrNullValue((L10nString)org.getFullName()), synchRequest.getPcc(), ProfileTypeInfo.AGY));
            FilterProfileType.Choice choice = new FilterProfileType.Choice();
            choice.setTravelAgency(SabreProfileServicesUtil.createFilterTravelAgencyProfileType(synchRequest, filterSettings));
            fpt.setChoice(choice);
            ft.setProfile(fpt);
        } else {
            ft.setFilterTypeCode(ProfileTypeInfo.CRP);
            FilterProfileType fpt = new FilterProfileType();
            fpt.setTPAIdentity(SabreProfileServicesUtil.createFilterTPAIdentityForProfileType(SP_FILTER_ANY_STRING, ProfileSynchronizationUtil.getEnglishOrNullValue((L10nString)org.getShortName()), ProfileSynchronizationUtil.getEnglishOrNullValue((L10nString)org.getFullName()), synchRequest.getPcc(), ProfileTypeInfo.CRP));
            FilterProfileType.Choice choice = new FilterProfileType.Choice();
            choice.setCorporation(SabreProfileServicesUtil.createFilterCorporateProfileType(synchRequest, filterSettings));
            fpt.setChoice(choice);
            ft.setProfile(fpt);
            ArrayList<FilterAssociatedProfilesType> assocProfiles = new ArrayList<FilterAssociatedProfilesType>();
            NumberOfAssocProfilesType assocSummary = SabreProfileServicesUtil.createFilterAssociatedProfilesTypes(synchRequest.getAssociatedProfiles(), synchRequest.getPcc(), filterSettings, assocProfiles);
            if (assocProfiles.size() > 0) {
                ft.getAssociatedProfileList().addAll(assocProfiles);
            }
        }
        return ft;
    }

    public static FilterType createPersonFilterType(SabreProfilesSynchronizationRequest synchRequest, Date createDateTime, Date updateDateTime, PNRBuilderSettings filterSettings) {
        Person per = synchRequest.getPerson();
        FilterType ft = new FilterType();
        ft.setCreateDateTime(createDateTime != null ? createDateTime : new Date());
        ft.setUpdateDateTime(updateDateTime != null ? updateDateTime : new Date());
        ft.setClientCode(CLIENT_CODE);
        ft.setClientContextCode(CLIENT_CONTEXT_CODE);
        ft.setDomainID(synchRequest.getPcc());
        ft.setFilterName(filterSettings.getName());
        ft.setFilterDescription(TextUtil.nonEmptyStr((String)filterSettings.getDescription()));
        ft.setFilterTypeCode(ProfileTypeInfo.TVL);
        ft.setMainProfileOrderSeqNo("1");
        FilterProfileType fpt = new FilterProfileType();
        fpt.setTPAIdentity(SabreProfileServicesUtil.createFilterTPAIdentityForProfileType(SP_FILTER_ANY_STRING, SabreProfileServicesUtil.getPersonShortName(per), SabreProfileServicesUtil.getPersonFullName(per), synchRequest.getPcc(), ProfileTypeInfo.TVL));
        FilterProfileType.Choice choice = new FilterProfileType.Choice();
        choice.setTraveler(SabreProfileServicesUtil.createFilterTravelerProfileType(synchRequest, filterSettings));
        fpt.setChoice(choice);
        ft.setProfile(fpt);
        ArrayList<FilterAssociatedProfilesType> assocProfiles = new ArrayList<FilterAssociatedProfilesType>();
        NumberOfAssocProfilesType assocSummary = SabreProfileServicesUtil.createFilterAssociatedProfilesTypes(synchRequest.getAssociatedProfiles(), synchRequest.getPcc(), filterSettings, assocProfiles);
        if (assocProfiles.size() > 0) {
            ft.getAssociatedProfileList().addAll(assocProfiles);
        }
        return ft;
    }

    private static Person parseCustomerType(CustomerType customerType, List<CostCodeInfo> udidValues, List<EmploymentInfo> employmentInfo) throws Exception {
        Person person = new Person();
        SabreProfileServicesUtil.parsePersonNameTypes(person, customerType.getPersonNameList());
        SabreProfileServicesUtil.parseBirthday(person, customerType.getBirthDate());
        SabreProfileServicesUtil.parseGenderCode(person, customerType.getGenderCode());
        SabreProfileServicesUtil.parseTelephoneTypes(person, customerType.getTelephoneList());
        SabreProfileServicesUtil.parseEmailTypes(person, customerType.getEmailList());
        SabreProfileServicesUtil.parseAddressTypes(person, customerType.getAddressList());
        SabreProfileServicesUtil.parseTelephoneTypesSabrePhonesAndEmails(person, customerType.getEmergencyContactPersonList());
        SabreProfileServicesUtil.parseDocumentsTypes(person, customerType.getDocumentList(), customerType.getGenderCode());
        SabreProfileServicesUtil.parseCustLoyaltyTypes(person, customerType.getCustLoyaltyList());
        SabreProfileServicesUtil.parsePaymentFormTypes(person, customerType.getPaymentFormList());
        SabreProfileServicesUtil.parseEmploymentInfoTypes(customerType.getEmploymentInfoList(), udidValues, employmentInfo);
        return person;
    }

    private static ProfileType createOrganizationProfileType(SabreProfilesSynchronizationRequest synchRequest, Date createDateTime, Date updateDateTime, List<PNRBuilder> filters) {
        Organization org = synchRequest.getOrganization();
        ProfileType pt = new ProfileType();
        pt.setCreateDateTime(createDateTime != null ? createDateTime : new Date());
        pt.setUpdateDateTime(updateDateTime != null ? updateDateTime : new Date());
        if (org.getTypes().contains(OrganizationType.AGENCY) && !org.getTypes().contains(OrganizationType.CORPORATE_CLIENT)) {
            pt.setTPAIdentity(SabreProfileServicesUtil.createTPAIdentityForOrganizationProfileType(org, synchRequest.getPcc(), ProfileTypeInfo.AGY));
            ProfileType.Choice choice = new ProfileType.Choice();
            choice.setTravelAgency(SabreProfileServicesUtil.createTravelAgencyProfileType(synchRequest, filters));
            pt.setChoice(choice);
        } else if (org.getTypes().contains(OrganizationType.CORPORATE_CLIENT)) {
            pt.setTPAIdentity(SabreProfileServicesUtil.createTPAIdentityForOrganizationProfileType(org, synchRequest.getPcc(), ProfileTypeInfo.CRP));
            ProfileType.Choice choice = new ProfileType.Choice();
            choice.setCorporation(SabreProfileServicesUtil.createCorporateProfileType(synchRequest, filters));
            pt.setChoice(choice);
        }
        return pt;
    }

    private static TravelAgencyProfileType createTravelAgencyProfileType(SabreProfilesSynchronizationRequest req, List<PNRBuilder> filtersToUse) {
        Organization org = req.getOrganization();
        List orgAddresses = ProfileHelper.getOrganizationAddresses((Organization)org);
        TravelAgencyProfileType tapt = new TravelAgencyProfileType();
        boolean useCir = CirHelper.cirEnabled((PCIDSSServerExchangeSettings)req.getCirSettings());
        tapt.setAgencyInfo(SabreProfileServicesUtil.createAgencyInfoType(org));
        tapt.getAgencyContactNameList().addAll(SabreProfileServicesUtil.createAgencyContactNameTypes(req.getPersonsInCharge()));
        tapt.getAddressList().addAll(SabreProfileServicesUtil.createAddressTypesForAgency(orgAddresses, ProfileSynchronizationUtil.getEnglishOrNullValue((L10nString)org.getShortName())));
        tapt.getTelephoneList().addAll(SabreProfileServicesUtil.createTelephoneTypes(org.getCommunications()));
        tapt.getEmailList().addAll(SabreProfileServicesUtil.createEmailTypes(org.getCommunications(), null));
        tapt.getPaymentFormList().addAll(SabreProfileServicesUtil.updatePaymentFormTypes(null, org.getCards(), useCir));
        PrefCollectionsType pct = new PrefCollectionsType();
        pct.getAirlinePrefList().addAll(SabreProfileServicesUtil.createAirlinePrefTypes(org.getSabreAdditionalProfileLines(), org.getPreferredSuppliers()));
        tapt.setPrefCollections(pct);
        tapt.getDiscountList().addAll(SabreProfileServicesUtil.updateDiscountTypes(null, org.getAirlineBonusCards(), org.getHotelBonusCards(), org.getCarBonusCards(), !TextUtil.isBlank((String)org.getClientID()) ? "A" + org.getClientID() : null, req.isLoadProfilesEnabled()));
        tapt.getCustomerReferenceInfoList().addAll(SabreProfileServicesUtil.createCustomerReferenceInfoTypes(org.getCode()));
        tapt.getPriorityRemarkList().addAll(SabreProfileServicesUtil.createPriorityRemarksTypes(org.getSabreAdditionalProfileLines()));
        tapt.getRemarkList().addAll(SabreProfileServicesUtil.createRemarkTypesOrganization(req.getOrganization(), req.getAccountManagerRemarks(), req.getPaymentsRemarks(), req.getUdidRemarks(), req.getUdidRemarkValues(), req.getContractRemarksMap(), req.getRemarksMap(), org.getRailwayBonusCards(), req.getTransactionFeesForGeneralInfoSection(), useCir));
        List<AssociatedFiltersType> filters = SabreProfileServicesUtil.updateAssociatedFilters(null, req.getPcc(), filtersToUse, null);
        tapt.getAssociatedFilterList().addAll(filters);
        return tapt;
    }

    private static FilterTravelAgencyProfileType createFilterTravelAgencyProfileType(SabreProfilesSynchronizationRequest req, PNRBuilderSettings filterSettings) {
        Organization org = req.getOrganization();
        List orgAddresses = ProfileHelper.getOrganizationAddresses((Organization)org);
        FilterTravelAgencyProfileType tapt = new FilterTravelAgencyProfileType();
        boolean useCir = CirHelper.cirEnabled((PCIDSSServerExchangeSettings)req.getCirSettings());
        tapt.setAgencyInfo(SabreProfileServicesUtil.createFilterAgencyInfoType(org));
        if (filterSettings.isNeedAddresses() || filterSettings.isNeedDeliveryAddresses()) {
            tapt.getAddressList().addAll(SabreProfileServicesUtil.createFilterAddressTypesForAgency(orgAddresses, filterSettings.isNeedAddresses(), filterSettings.isNeedDeliveryAddresses(), ProfileSynchronizationUtil.getEnglishOrNullValue((L10nString)org.getShortName())));
        }
        if (filterSettings.isNeedPhones()) {
            tapt.getTelephoneList().addAll(SabreProfileServicesUtil.createFilterTelephoneTypes(org.getCommunications()));
        }
        if (filterSettings.isNeedEmails()) {
            tapt.getEmailList().addAll(SabreProfileServicesUtil.createFilterEmailTypes(org.getCommunications(), null));
        }
        if (filterSettings.isNeedCreditCards()) {
            tapt.getPaymentFormList().addAll(SabreProfileServicesUtil.createFilterPaymentFormTypes(org.getCards(), useCir));
        }
        String clientId = TextUtil.nonBlank((String)org.getClientID()) && filterSettings.isNeedCID() ? "A" + org.getClientID() : null;
        tapt.getDiscountList().addAll(SabreProfileServicesUtil.createFilterDiscountTypes(filterSettings.isNeedFrequentFlyer() ? org.getAirlineBonusCards() : Collections.emptyList(), org.getHotelBonusCards(), org.getCarBonusCards(), clientId));
        if (filterSettings.isNeedDK()) {
            tapt.setCustomerReferenceInfo(SabreProfileServicesUtil.createFilterCustomerReferenceInfoTypes(org.getCode()));
        }
        tapt.getRemarkList().addAll(SabreProfileServicesUtil.createFilterRemarkTypesOrganization(req.getOrganization(), req.getAccountManagerRemarks(), req.getPaymentsRemarks(), req.getUdidRemarks(), req.getUdidRemarkValues(), req.getContractRemarksMap(), req.getRemarksMap(), filterSettings, useCir));
        return tapt;
    }

    private static List<AgencyContactNameType> createAgencyContactNameTypes(List<SabreProfilesPersonInCharge> list) {
        ArrayList<AgencyContactNameType> res = new ArrayList<AgencyContactNameType>();
        int num = 1;
        for (SabreProfilesPersonInCharge p : list) {
            AgencyContactNameType name = new AgencyContactNameType();
            name.setSurname(p.getLastName());
            name.setGivenName(p.getFirstName());
            name.setNamePrefix(TextUtil.nonEmptyStr((String)p.getTitle()));
            name.setOrderSequenceNo(String.valueOf(num));
            ++num;
            res.add(name);
        }
        return res;
    }

    private static AgencyInfoType createAgencyInfoType(Organization org) {
        AgencyInfoType ait = new AgencyInfoType();
        ait.setTravelAgencyName(TextUtil.isBlank((String)org.getSabreProfilesName()) ? ProfileSynchronizationUtil.getEnglishOrNullValue((L10nString)org.getShortName()) : ProfileSynchronizationUtil.removeIllegalSymbols((String)org.getSabreProfilesName(), (boolean)true));
        ait.setTravelAgencyTypeCode("MAN");
        ait.setTravelAgencyIdentifier(org.getCode());
        return ait;
    }

    private static FilterAgencyInfoType createFilterAgencyInfoType(Organization org) {
        FilterAgencyInfoType ait = new FilterAgencyInfoType();
        ait.setTravelAgencyName(TextUtil.isBlank((String)org.getSabreProfilesName()) ? ProfileSynchronizationUtil.getEnglishOrNullValue((L10nString)org.getShortName()) : ProfileSynchronizationUtil.removeIllegalSymbols((String)org.getSabreProfilesName(), (boolean)true));
        return ait;
    }

    private static CorporateProfileType createCorporateProfileType(SabreProfilesSynchronizationRequest req, List<PNRBuilder> filtersToUse) {
        Organization org = req.getOrganization();
        List orgAddresses = ProfileHelper.getOrganizationAddresses((Organization)org);
        CorporateProfileType cpt = new CorporateProfileType();
        boolean useCir = CirHelper.cirEnabled((PCIDSSServerExchangeSettings)req.getCirSettings());
        cpt.setCorporateInfo(SabreProfileServicesUtil.createCorporateInfoType(org));
        cpt.getContactNameList().addAll(SabreProfileServicesUtil.createContactNameTypes(req.getPersonsInCharge()));
        cpt.getAddressList().addAll(SabreProfileServicesUtil.updateAddressTypes(null, orgAddresses));
        cpt.getTelephoneList().addAll(SabreProfileServicesUtil.createTelephoneTypes(org.getCommunications()));
        cpt.getEmailList().addAll(SabreProfileServicesUtil.createEmailTypes(org.getCommunications(), null));
        cpt.getPaymentFormList().addAll(SabreProfileServicesUtil.updatePaymentFormTypes(null, org.getCards(), useCir));
        PrefCollectionsType pct = new PrefCollectionsType();
        pct.getAirlinePrefList().addAll(SabreProfileServicesUtil.createAirlinePrefTypes(org.getSabreAdditionalProfileLines(), org.getPreferredSuppliers()));
        pct.getHotelPrefList().addAll(SabreProfileServicesUtil.createHotelPrefTypes(org.getPreferredSuppliers()));
        cpt.setPrefCollections(pct);
        cpt.getDiscountList().addAll(SabreProfileServicesUtil.updateDiscountTypes(null, org.getAirlineBonusCards(), org.getHotelBonusCards(), org.getCarBonusCards(), !TextUtil.isBlank((String)org.getClientID()) ? "C" + org.getClientID() : null, req.isLoadProfilesEnabled()));
        cpt.getDiscountList().addAll(SabreProfileServicesUtil.createDiscounts(org.getDiscounts(), cpt.getDiscountList().size()));
        cpt.getDiscountList().addAll(SabreProfileServicesUtil.createDiscountTypesFromTripartiteContracts(req.getDiscountsData()));
        cpt.getCustomerReferenceInfoList().addAll(SabreProfileServicesUtil.createCustomerReferenceInfoTypes(org.getCode()));
        cpt.getPriorityRemarkList().addAll(SabreProfileServicesUtil.createPriorityRemarksTypes(org.getSabreAdditionalProfileLines()));
        cpt.getRemarkList().addAll(SabreProfileServicesUtil.createRemarkTypesOrganization(req.getOrganization(), req.getAccountManagerRemarks(), req.getPaymentsRemarks(), req.getUdidRemarks(), req.getUdidRemarkValues(), req.getContractRemarksMap(), req.getRemarksMap(), org.getRailwayBonusCards(), req.getTransactionFeesForGeneralInfoSection(), useCir));
        String ctp = org.getSabreProfileCTP();
        if (TextUtil.isBlank((String)ctp)) {
            for (SabreProfilesAssociatedProfileData assoc : req.getAssociatedProfiles()) {
                if (assoc.getProfileType() != SabreProfilesProfileType.AGY || TextUtil.isBlank((String)assoc.getSabreProfilesCTP())) continue;
                ctp = assoc.getSabreProfilesCTP();
                break;
            }
        }
        if (!TextUtil.isBlank((String)ctp)) {
            SabreCorporateTravelPolicyType sctpt = new SabreCorporateTravelPolicyType();
            sctpt.setCTPName(ctp);
            TravelPolicyType tpt = new TravelPolicyType();
            tpt.setSabreCorporateTravelPolicy(sctpt);
            cpt.setTravelPolicy(tpt);
        }
        ArrayList<AssociatedProfilesType> assocProfiles = new ArrayList<AssociatedProfilesType>();
        NumberOfAssocProfilesType assocSummary = SabreProfileServicesUtil.createAssociatedProfilesTypes(req.getAssociatedProfiles(), req.getPcc(), assocProfiles);
        if (assocProfiles.size() > 0) {
            cpt.getAssociatedProfileList().addAll(assocProfiles);
            cpt.setNumberOfAssocProfiles(assocSummary);
        }
        List<AssociatedFiltersType> filters = SabreProfileServicesUtil.updateAssociatedFilters(null, req.getPcc(), filtersToUse, null);
        cpt.getAssociatedFilterList().addAll(filters);
        return cpt;
    }

    private static List<AssociatedFiltersType> updateAssociatedFilters(List<AssociatedFiltersType> originalAssociatedFilters, String pcc, List<PNRBuilder> createdFilters, List<String> filtersToRemain) {
        ArrayList<AssociatedFiltersType> res = new ArrayList<AssociatedFiltersType>();
        int num = 1;
        if (CollectionUtil.isNotEmpty(originalAssociatedFilters) && CollectionUtil.isNotEmpty(filtersToRemain)) {
            SabreProfileServicesUtil.sortByOrderSequenceNumber(originalAssociatedFilters, AssociatedFiltersType::getOrderSequenceNo);
            for (AssociatedFiltersType originalFilter : originalAssociatedFilters) {
                if (!filtersToRemain.contains(originalFilter.getFilterID())) continue;
                originalFilter.setOrderSequenceNo(String.valueOf(num++));
                originalFilter.setDisplaySequenceNo(null);
                res.add(originalFilter);
            }
        }
        if (CollectionUtil.isNotEmpty(createdFilters)) {
            for (PNRBuilder filter : createdFilters) {
                AssociatedFiltersType aft = new AssociatedFiltersType();
                aft.setCreateDateTime(new Date());
                aft.setUpdateDateTime(new Date());
                aft.setClientCode(CLIENT_CODE);
                aft.setClientContextCode(CLIENT_CONTEXT_CODE);
                aft.setDomainID(pcc);
                aft.setFilterID(ProfileSynchronizationUtil.getSabreProfilesUniqueID((PNRBuilder)filter, (String)pcc));
                aft.setFilterName(filter.getName());
                aft.setOrderSequenceNo(String.valueOf(num++));
                res.add(aft);
            }
        }
        return res;
    }

    private static FilterCorporateProfileType createFilterCorporateProfileType(SabreProfilesSynchronizationRequest req, PNRBuilderSettings filterSettings) {
        Organization org = req.getOrganization();
        List orgAddresses = ProfileHelper.getOrganizationAddresses((Organization)org);
        FilterCorporateProfileType cpt = new FilterCorporateProfileType();
        boolean useCir = CirHelper.cirEnabled((PCIDSSServerExchangeSettings)req.getCirSettings());
        cpt.getAddressList().addAll(SabreProfileServicesUtil.createFilterAddressTypes(orgAddresses, filterSettings.isNeedAddresses(), filterSettings.isNeedDeliveryAddresses()));
        if (filterSettings.isNeedPhones()) {
            cpt.getTelephoneList().addAll(SabreProfileServicesUtil.createFilterTelephoneTypes(org.getCommunications()));
        }
        if (filterSettings.isNeedEmails()) {
            cpt.getEmailList().addAll(SabreProfileServicesUtil.createFilterEmailTypes(org.getCommunications(), null));
        }
        if (filterSettings.isNeedCreditCards()) {
            cpt.getPaymentFormList().addAll(SabreProfileServicesUtil.createFilterPaymentFormTypes(org.getCards(), useCir));
        }
        String clientId = TextUtil.nonBlank((String)org.getClientID()) && filterSettings.isNeedCID() ? "C" + org.getClientID() : null;
        cpt.getDiscountList().addAll(SabreProfileServicesUtil.createFilterDiscountTypes(filterSettings.isNeedFrequentFlyer() ? org.getAirlineBonusCards() : Collections.emptyList(), org.getHotelBonusCards(), org.getCarBonusCards(), clientId));
        if (filterSettings.isNeedDK()) {
            cpt.setCustomerReferenceInfo(SabreProfileServicesUtil.createFilterCustomerReferenceInfoTypes(org.getCode()));
        }
        cpt.getRemarkList().addAll(SabreProfileServicesUtil.createFilterRemarkTypesOrganization(req.getOrganization(), req.getAccountManagerRemarks(), req.getPaymentsRemarks(), req.getUdidRemarks(), req.getUdidRemarkValues(), req.getContractRemarksMap(), req.getRemarksMap(), filterSettings, useCir));
        return cpt;
    }

    private static FilterTravelerProfileType createFilterTravelerProfileType(SabreProfilesSynchronizationRequest req, PNRBuilderSettings filterSettings) {
        Person per = req.getPerson();
        FilterTravelerProfileType tpt = new FilterTravelerProfileType();
        boolean useCir = CirHelper.cirEnabled((PCIDSSServerExchangeSettings)req.getCirSettings());
        tpt.setCustomer(SabreProfileServicesUtil.createFilterCustomerType(per, req.getOrganization(), filterSettings, req.getDictionaryData(), useCir));
        FilterTPAExtensionsType tpaExt = new FilterTPAExtensionsType();
        tpt.setTPAExtensions(tpaExt);
        tpt.getTPAExtensions().getDiscountList().addAll(SabreProfileServicesUtil.createFilterDiscountTypes(per.getAirlineBonusCards(), per.getHotelBonusCards(), per.getCarBonusCards(), null));
        tpt.getTPAExtensions().getRemarkList().addAll(SabreProfileServicesUtil.createFilterRemarkTypesPerson(req.getPerson(), req.getUdidRemarks(), req.getUdidRemarkValues(), req.getRemarksMap(), filterSettings, req.getOrganization() != null ? req.getOrganization().getRiskManagementCompanies() : new HashSet(), req.getOrganization() != null ? req.getOrganization().getCwtProfileData() : null, useCir));
        return tpt;
    }

    private static List<OSIType> createOSIs(List<SabreProfileCommand2Osi> sabreAdditionalCommand2Lines) {
        ArrayList<OSIType> res = new ArrayList<OSIType>();
        for (SabreProfileCommand2Osi line : sabreAdditionalCommand2Lines) {
            OSIType osi = new OSIType();
            osi.setTypeCode(line.getEntry1());
            osi.setText(line.getEntry2());
            res.add(osi);
        }
        return res;
    }

    private static List<SSRType> createSSRs(List<SabreProfileCommand4SSR> sabreAdditionalCommand4Lines) {
        ArrayList<SSRType> res = new ArrayList<SSRType>();
        for (SabreProfileCommand4SSR line : sabreAdditionalCommand4Lines) {
            SSRType ssrType = new SSRType();
            ssrType.setSSRCode(line.getSsrCode());
            ssrType.setText(line.getSsrInfo());
            ssrType.setVITLineType(VITStarLineType.valueOf((String)line.getLineType().name()));
            res.add(ssrType);
        }
        return res;
    }

    private static ProfileType createPersonProfileType(SabreProfilesSynchronizationRequest synchRequest, List<PNRBuilder> filters) {
        ProfileType pt = new ProfileType();
        Date currentDate = new Date();
        pt.setCreateDateTime(currentDate);
        pt.setUpdateDateTime(currentDate);
        SabreProfileServicesUtil.updatePersonProfileType(synchRequest, pt, filters, null);
        return pt;
    }

    private static void updatePersonProfileType(SabreProfilesSynchronizationRequest synchRequest, ProfileType pt, List<PNRBuilder> createdFilters, List<String> filtersToRemain) {
        Person per = synchRequest.getPerson();
        TPAIdentityType tpaId = pt.getTPAIdentity();
        if (tpaId == null) {
            tpaId = new TPAIdentityType();
            pt.setTPAIdentity(tpaId);
        }
        pt.setTPAIdentity(SabreProfileServicesUtil.updateTPAIdentityForPersonProfileType(tpaId, per, synchRequest.getPcc(), synchRequest.getOrganization()));
        TravelerProfileType tpt = pt.getChoice() != null && pt.getChoice().getTraveler() != null ? pt.getChoice().getTraveler() : new TravelerProfileType();
        SabreProfileServicesUtil.updateTravelerProfileType(tpt, synchRequest, createdFilters, filtersToRemain);
        ProfileType.Choice choice = new ProfileType.Choice();
        choice.setTraveler(tpt);
        pt.setChoice(choice);
    }

    private static void updateTravelerProfileType(TravelerProfileType tpt, SabreProfilesSynchronizationRequest req, List<PNRBuilder> createdFilters, List<String> filtersToRemain) {
        Person person = req.getPerson();
        boolean useCir = CirHelper.cirEnabled((PCIDSSServerExchangeSettings)req.getCirSettings());
        CustomerType ct = tpt.getCustomer();
        if (ct == null) {
            ct = new CustomerType();
            tpt.setCustomer(ct);
        }
        SabreProfileServicesUtil.updateCustomerType(ct, person, req.getOrganization(), req.getAssociatedProfiles(), req.getDictionaryData(), req.getUdidValues(), useCir);
        TPAExtensionsType tpaExt = tpt.getTPAExtensions();
        if (tpaExt == null) {
            tpaExt = new TPAExtensionsType();
            tpt.setTPAExtensions(tpaExt);
        }
        tpaExt.setCustomDefinedDataList(SabreProfileServicesUtil.updateCustomDefinedDataTypes(tpaExt.getCustomDefinedDataList(), req.getUdidValues(), req.getOrganization().getExternalSystem(), req.getISuiteCostCodesSettings(), req.getPcc()));
        tpaExt.setCustomDefinedValueList(SabreProfileServicesUtil.updateCustomDefinedValuesTypes(tpaExt.getCustomDefinedValueList(), req.getUdidValues(), req.getOrganization().getExternalSystem()));
        tpaExt.setBusinessSystemIdentityInfoList(SabreProfileServicesUtil.updateBusinessSystemIdentityInfoTypes(tpaExt.getBusinessSystemIdentityInfoList(), req.getPerson()));
        ArrayList<AssociatedProfilesType> assocProfiles = new ArrayList<AssociatedProfilesType>();
        NumberOfAssocProfilesType assocSummary = SabreProfileServicesUtil.createAssociatedProfilesTypes(req.getAssociatedProfiles(), req.getPcc(), assocProfiles);
        tpaExt.setAssociatedProfileList(assocProfiles);
        if (!assocProfiles.isEmpty()) {
            tpaExt.setNumberOfAssocProfiles(assocSummary);
        } else {
            tpaExt.setNumberOfAssocProfiles(null);
        }
        tpaExt.setRemarkList(SabreProfileServicesUtil.createRemarkTypesPerson(person, req.getUdidRemarks(), req.getUdidRemarkValues(), req.getRemarksMap(), req.getOrganization() != null ? req.getOrganization().getRiskManagementCompanies() : Collections.emptySet(), req.getOrganization() != null ? req.getOrganization().getCwtProfileData() : null, useCir));
        tpaExt.setPriorityRemarkList(SabreProfileServicesUtil.createPriorityRemarksTypes(person.getSabreAdditionalProfileLines()));
        if (!TextUtil.isBlank((String)person.getSabreProfileCTP())) {
            TravelPolicyType travelPolicy = new TravelPolicyType();
            SabreCorporateTravelPolicyType sctp = new SabreCorporateTravelPolicyType();
            sctp.setCTPName(person.getSabreProfileCTP());
            travelPolicy.setSabreCorporateTravelPolicy(sctp);
            tpaExt.setTravelPolicy(travelPolicy);
        } else {
            tpaExt.setTravelPolicy(null);
        }
        tpaExt.setDiscountList(SabreProfileServicesUtil.updateDiscountTypes(tpaExt.getDiscountList(), person.getAirlineBonusCards(), person.getHotelBonusCards(), person.getCarBonusCards(), null, req.isLoadProfilesEnabled()));
        PrefCollectionsType pct = new PrefCollectionsType();
        pct.getAirlinePrefList().addAll(SabreProfileServicesUtil.createAirlinePrefTypes(person.getSabreAdditionalProfileLines(), person.getPreferredSuppliers()));
        pct.getHotelPrefList().addAll(SabreProfileServicesUtil.createHotelPrefTypes(person.getPreferredSuppliers()));
        tpt.setPrefCollections(pct);
        tpaExt.setAssociatedFilterList(SabreProfileServicesUtil.updateAssociatedFilters(tpaExt.getAssociatedFilterList(), req.getPcc(), createdFilters, filtersToRemain));
    }

    static Person parseTravelerProfileType(TravelerProfileType tpt, List<SabreProfilesAssociatedProfileData> associatedProfiles, List<CostCodeInfo> udidValues, List<EmploymentInfo> employmentInfo) throws Exception {
        if (tpt.getCustomer() == null) {
            return null;
        }
        Person person = SabreProfileServicesUtil.parseCustomerType(tpt.getCustomer(), udidValues, employmentInfo);
        if (tpt.getTPAExtensions() != null) {
            associatedProfiles.addAll(SabreProfileServicesUtil.parseAssociatedProfilesTypes(tpt.getTPAExtensions().getAssociatedProfileList()));
            udidValues.addAll(SabreProfileServicesUtil.parseCustomDefinedDataTypes(tpt.getTPAExtensions().getCustomDefinedDataList()));
            udidValues.addAll(SabreProfileServicesUtil.parseCustomDefinedValuesTypes(tpt.getTPAExtensions().getCustomDefinedValueList()));
            SabreProfileServicesUtil.parseBusinessSystemIdentityInfoTypes(tpt.getTPAExtensions().getBusinessSystemIdentityInfoList(), person);
            if (tpt.getTPAExtensions().getTravelPolicy() != null && tpt.getTPAExtensions().getTravelPolicy().getSabreCorporateTravelPolicy() != null && TextUtil.nonBlank((String)tpt.getTPAExtensions().getTravelPolicy().getSabreCorporateTravelPolicy().getCTPName())) {
                person.setSabreProfileCTP(tpt.getTPAExtensions().getTravelPolicy().getSabreCorporateTravelPolicy().getCTPName());
            }
        }
        return person;
    }

    private static void parseBusinessSystemIdentityInfoTypes(List<BusinessSystemIdentityInfoType> businessSystemIdentityInfoList, Person person) {
        if (businessSystemIdentityInfoList != null) {
            businessSystemIdentityInfoList.stream().filter(bsi -> GET_THERE.equals(bsi.getSystemName())).filter(bsi -> GET_THERE_USER_ID.equals(bsi.getIdentifierType())).map(BusinessSystemIdentityInfoType::getID).filter(TextUtil::nonBlank).findFirst().ifPresent(arg_0 -> ((Person)person).setResourceIdForGetThere(arg_0));
        }
    }

    private static List<CustomDefinedDataType> updateCustomDefinedDataTypes(List<CustomDefinedDataType> originalCustomDefinedDataTypes, List<CostCodeInfo> udidValues, ExternalSystem externalSystem, List<ISuiteCostCodesSyncSettings> iSuiteCostCodesSettings, String pcc) {
        if (externalSystem == null || udidValues.isEmpty()) {
            return originalCustomDefinedDataTypes;
        }
        ArrayList<CustomDefinedDataType> res = new ArrayList<CustomDefinedDataType>();
        int num = 1;
        for (CostCodeInfo udid : udidValues) {
            if (udid.getType() != SabreProfilesCostCodeType.REFERENCE_INFORMATION) continue;
            CustomDefinedDataType cddt2 = new CustomDefinedDataType();
            cddt2.setCustomFieldCode(udid.getField());
            cddt2.setOrderSequenceNo(String.valueOf(num++));
            cddt2.setValue(udid.getValue());
            if (externalSystem == ExternalSystem.ISUITE) {
                originalCustomDefinedDataTypes.stream().filter(c -> TextUtil.isSame((String)c.getCustomFieldCode(), (String)udid.getField())).findFirst().ifPresent(originalCddt -> cddt2.setInformationText(originalCddt.getInformationText()));
                cddt2.setDomainID(pcc);
            } else {
                cddt2.setInformationText(udid.getAdditionalInformation());
            }
            res.add(cddt2);
        }
        if (CollectionUtil.isNotEmpty(originalCustomDefinedDataTypes)) {
            List anotherCustomDefinedDataTypes = originalCustomDefinedDataTypes.stream().filter(cddt -> !SabreProfileServicesUtil.isCostCode(cddt, externalSystem, udidValues, iSuiteCostCodesSettings)).collect(Collectors.toList());
            SabreProfileServicesUtil.sortByOrderSequenceNumber(anotherCustomDefinedDataTypes, CustomDefinedDataType::getOrderSequenceNo);
            for (CustomDefinedDataType anotherCustomDefinedDataType : anotherCustomDefinedDataTypes) {
                anotherCustomDefinedDataType.setOrderSequenceNo(String.valueOf(num++));
                anotherCustomDefinedDataType.setDisplaySequenceNo(null);
                res.add(anotherCustomDefinedDataType);
            }
        }
        return res;
    }

    private static List<BusinessSystemIdentityInfoType> updateBusinessSystemIdentityInfoTypes(List<BusinessSystemIdentityInfoType> businessSystemIdentityInfoTypes, Person person) {
        if (TextUtil.isBlank((String)person.getResourceIdForGetThere())) {
            return businessSystemIdentityInfoTypes;
        }
        ArrayList<Object> result = new ArrayList();
        BusinessSystemIdentityInfoType businessSystemIdentityInfoType = null;
        if (businessSystemIdentityInfoTypes != null) {
            result = new ArrayList<BusinessSystemIdentityInfoType>(businessSystemIdentityInfoTypes);
            businessSystemIdentityInfoType = result.stream().filter(bsi -> GET_THERE.equals(bsi.getSystemName())).filter(bsi -> GET_THERE_USER_ID.equals(bsi.getIdentifierType())).findFirst().orElse(null);
        }
        if (businessSystemIdentityInfoType != null) {
            businessSystemIdentityInfoType.setID(person.getResourceIdForGetThere());
        } else {
            businessSystemIdentityInfoType = new BusinessSystemIdentityInfoType();
            businessSystemIdentityInfoType.setSystemName(GET_THERE);
            businessSystemIdentityInfoType.setIdentifierType(GET_THERE_USER_ID);
            businessSystemIdentityInfoType.setID(person.getResourceIdForGetThere());
            result.add(businessSystemIdentityInfoType);
        }
        return result;
    }

    private static boolean isCostCode(CustomDefinedDataType cddt, ExternalSystem externalSystem, List<CostCodeInfo> udidValues, List<ISuiteCostCodesSyncSettings> iSuiteCostCodesSettings) {
        String fieldCode = cddt.getCustomFieldCode();
        switch (externalSystem) {
            case KDS: {
                return TextUtil.isSame((String)"OTH", (String)fieldCode) && Arrays.stream(CostCodeKdsType.values()).anyMatch(type -> cddt.getValue() != null && cddt.getValue().startsWith(type.name()));
            }
            case ION: {
                return TextUtil.isSame((String)"OTH", (String)fieldCode) && udidValues.stream().anyMatch(udid -> TextUtil.nonBlank((String)udid.getValue()) && TextUtil.isSame((String)udid.getValue(), (String)cddt.getValue()));
            }
            case CONCUR: 
            case CONNECT_PROFILE: 
            case RAKETA: {
                return TextUtil.isSame((String)"OTH", (String)fieldCode) && udidValues.stream().anyMatch(udid -> TextUtil.nonBlank((String)udid.getAdditionalInformation()) && TextUtil.isSame((String)udid.getAdditionalInformation(), (String)cddt.getInformationText()));
            }
            case ISUITE: {
                return iSuiteCostCodesSettings.stream().map(ISuiteCostCodesSyncSettings::getField).anyMatch(f -> TextUtil.isSame((String)f, (String)fieldCode));
            }
            case GET_THERE: {
                return false;
            }
        }
        throw Xeption.forDeveloper((String)("unsupported external system: " + externalSystem), (Object[])new Object[0]);
    }

    private static List<CostCodeInfo> parseCustomDefinedDataTypes(List<CustomDefinedDataType> customDefinedDataTypes) {
        if (CollectionUtil.isEmpty(customDefinedDataTypes)) {
            return Collections.emptyList();
        }
        SabreProfileServicesUtil.sortByOrderSequenceNumber(customDefinedDataTypes, CustomDefinedDataType::getOrderSequenceNo);
        ArrayList<CostCodeInfo> res = new ArrayList<CostCodeInfo>();
        for (CustomDefinedDataType cddt : customDefinedDataTypes) {
            CostCodeInfo costCodeInfo = new CostCodeInfo();
            costCodeInfo.setType(SabreProfilesCostCodeType.REFERENCE_INFORMATION);
            costCodeInfo.setField(cddt.getCustomFieldCode());
            costCodeInfo.setValue(cddt.getValue());
            costCodeInfo.setAdditionalInformation(cddt.getInformationText());
            res.add(costCodeInfo);
        }
        return res;
    }

    private static List<CustomDefinedValuesType> updateCustomDefinedValuesTypes(List<CustomDefinedValuesType> originalCustomDefinedValuesTypes, List<CostCodeInfo> udidValues, ExternalSystem externalSystem) {
        if (externalSystem != ExternalSystem.GET_THERE || CollectionUtil.isEmpty(originalCustomDefinedValuesTypes)) {
            return originalCustomDefinedValuesTypes;
        }
        SabreProfileServicesUtil.sortByOrderSequenceNumber(originalCustomDefinedValuesTypes, CustomDefinedValuesType::getOrderSequenceNo);
        ArrayList<CostCodeInfo> udidValuesCopy = new ArrayList<CostCodeInfo>(udidValues);
        for (CustomDefinedValuesType cdvt : originalCustomDefinedValuesTypes) {
            CostCodeInfo sameUdid = udidValuesCopy.stream().filter(udid -> udid.getType() == SabreProfilesCostCodeType.CUSTOM_DEFINED_VALUE).filter(udid -> MiscUtil.equals((Object)udid.getName(), (Object)cdvt.getName())).findFirst().orElse(null);
            if (sameUdid == null) continue;
            cdvt.setValue(sameUdid.getValue());
            udidValuesCopy.remove(sameUdid);
        }
        return originalCustomDefinedValuesTypes;
    }

    private static List<CostCodeInfo> parseCustomDefinedValuesTypes(List<CustomDefinedValuesType> customDefinedDataTypes) {
        if (CollectionUtil.isEmpty(customDefinedDataTypes)) {
            return Collections.emptyList();
        }
        SabreProfileServicesUtil.sortByOrderSequenceNumber(customDefinedDataTypes, CustomDefinedValuesType::getOrderSequenceNo);
        ArrayList<CostCodeInfo> res = new ArrayList<CostCodeInfo>();
        for (CustomDefinedValuesType cdvt : customDefinedDataTypes) {
            CostCodeInfo costCodeInfo = new CostCodeInfo();
            costCodeInfo.setType(SabreProfilesCostCodeType.CUSTOM_DEFINED_VALUE);
            costCodeInfo.setName(cdvt.getName());
            costCodeInfo.setValue(cdvt.getValue());
            res.add(costCodeInfo);
        }
        return res;
    }

    private static List<DiscountsType> createDiscounts(Discounts discounts, int num) {
        if (discounts == null) {
            return Collections.emptyList();
        }
        if (num == 0) {
            ++num;
        }
        ArrayList<DiscountsType> result = new ArrayList<DiscountsType>();
        if (discounts.getHotelDiscounts() != null && !discounts.getHotelDiscounts().isEmpty()) {
            for (HotelDiscount discount : discounts.getHotelDiscounts()) {
                String supplier;
                HotelsBrand resolveReference;
                if (TextUtil.isBlank((String)discount.getDiscountCode())) continue;
                DiscountsType dt = new DiscountsType();
                if (discount.getSupplier() != null && (resolveReference = (HotelsBrand)DictionaryCache.get().resolveReference(discount.getSupplier())) != null && TextUtil.nonBlank((String)(supplier = DictHelper.getCode((BaseDictionary)resolveReference)))) {
                    dt.setVendorCode(supplier);
                }
                dt.setVendorTypeCode("HL");
                dt.setID(discount.getDiscountCode());
                dt.setOrderSequenceNo(String.valueOf(num++));
                result.add(dt);
            }
        }
        return result;
    }

    private static NumberOfAssocProfilesType createAssociatedProfilesTypes(List<SabreProfilesAssociatedProfileData> profiles, String pcc, List<AssociatedProfilesType> assocProfiles) {
        NumberOfAssocProfilesType res = new NumberOfAssocProfilesType();
        HashMap<ProfileTypeInfo, Integer> counts = new HashMap<ProfileTypeInfo, Integer>();
        HashSet<String> idSet = new HashSet<String>();
        for (SabreProfilesAssociatedProfileData profile : profiles) {
            if (idSet.contains(profile.getUniqueID())) continue;
            AssociatedProfilesType apt = new AssociatedProfilesType();
            apt.setAssocFiltersInd(YesNoType.N);
            apt.setAssocProfileDescription(TextUtil.nonEmptyStr((String)ProfileSynchronizationUtil.removeIllegalSymbols((String)profile.getDescription(), (boolean)true)));
            apt.setAssocProfileName(ProfileSynchronizationUtil.removeIllegalSymbols((String)profile.getName(), (boolean)true));
            apt.setAssocProfileTypeCode(ProfileTypeInfo.valueOf((String)profile.getProfileType().name()));
            apt.setAssocUniqueID(profile.getUniqueID());
            apt.setClientCode(CLIENT_CODE);
            apt.setClientContextCode(CLIENT_CONTEXT_CODE);
            apt.setCreditBankIndicator(YesNoType.N);
            apt.setDomainID(pcc);
            apt.setProfileRelationTypeCode("AL");
            if (!counts.containsKey(apt.getAssocProfileTypeCode())) {
                counts.put(apt.getAssocProfileTypeCode(), 1);
            } else {
                counts.put(apt.getAssocProfileTypeCode(), (Integer)counts.get(apt.getAssocProfileTypeCode()) + 1);
            }
            idSet.add(apt.getAssocUniqueID());
            assocProfiles.add(apt);
        }
        SabreProfileServicesUtil.processProfileTypes(res, counts);
        return res;
    }

    public static List<SabreProfilesAssociatedProfileData> parseAssociatedProfilesTypes(List<AssociatedProfilesType> assocProfiles) {
        if (CollectionUtil.isEmpty(assocProfiles)) {
            return Collections.emptyList();
        }
        SabreProfileServicesUtil.sortByOrderSequenceNumber(assocProfiles, AssociatedProfilesType::getOrderSequenceNo);
        ArrayList<SabreProfilesAssociatedProfileData> profiles = new ArrayList<SabreProfilesAssociatedProfileData>();
        for (AssociatedProfilesType assocProfile : assocProfiles) {
            SabreProfilesAssociatedProfileData profile = new SabreProfilesAssociatedProfileData();
            if (assocProfile.getAssocProfileTypeCode() != null) {
                profile.setProfileType(SabreProfilesProfileType.valueOf((String)assocProfile.getAssocProfileTypeCode().name()));
            }
            if (TextUtil.nonBlank((String)assocProfile.getAssocProfileDescription())) {
                profile.setDescription(assocProfile.getAssocProfileDescription());
            }
            if (TextUtil.nonBlank((String)assocProfile.getAssocProfileName())) {
                profile.setName(assocProfile.getAssocProfileName());
            }
            if (TextUtil.nonBlank((String)assocProfile.getDomainID())) {
                profile.setPcc(assocProfile.getDomainID());
            }
            if (TextUtil.nonBlank((String)assocProfile.getAssocUniqueID())) {
                profile.setUniqueID(assocProfile.getAssocUniqueID());
            }
            profiles.add(profile);
        }
        return profiles;
    }

    private static NumberOfAssocProfilesType createFilterAssociatedProfilesTypes(List<SabreProfilesAssociatedProfileData> profiles, String pcc, PNRBuilderSettings filterSettings, List<FilterAssociatedProfilesType> assocProfiles) {
        NumberOfAssocProfilesType res = new NumberOfAssocProfilesType();
        HashMap<ProfileTypeInfo, Integer> counts = new HashMap<ProfileTypeInfo, Integer>();
        HashSet<String> idSet = new HashSet<String>();
        int orderNumber = 2;
        for (SabreProfilesAssociatedProfileData profile : profiles) {
            boolean profileFound = SabreProfilesSynchronizationUtil.acceptProfile((SabreProfilesAssociatedProfileData)profile, (PNRBuilderSettings)filterSettings);
            if (!profileFound || idSet.contains(profile.getUniqueID())) continue;
            FilterAssociatedProfilesType apt = new FilterAssociatedProfilesType();
            apt.setAssocProfileDescription(TextUtil.nonEmptyStr((String)ProfileSynchronizationUtil.removeIllegalSymbols((String)profile.getDescription(), (boolean)true)));
            apt.setAssocProfileName(ProfileSynchronizationUtil.removeIllegalSymbols((String)profile.getName(), (boolean)true));
            apt.setAssocProfileTypeCode(ProfileTypeInfo.valueOf((String)profile.getProfileType().name()));
            apt.setAssocUniqueID(profile.getUniqueID());
            apt.setClientCode(CLIENT_CODE);
            apt.setClientContextCode(CLIENT_CONTEXT_CODE);
            apt.setDomainID(pcc);
            if (!counts.containsKey(apt.getAssocProfileTypeCode())) {
                counts.put(apt.getAssocProfileTypeCode(), 1);
            } else {
                counts.put(apt.getAssocProfileTypeCode(), (Integer)counts.get(apt.getAssocProfileTypeCode()) + 1);
            }
            for (PNRBuilder builder : profile.getPnrBuilders()) {
                if (!TextUtil.isSame((String)filterSettings.getType(), (String)builder.getType(), (boolean)true, (boolean)true)) continue;
                PNRMoveInfoType pnrMoveInfo = new PNRMoveInfoType();
                pnrMoveInfo.setAssocProfileFilterID(ProfileSynchronizationUtil.getSabreProfilesUniqueID((PNRBuilder)builder, (String)pcc));
                pnrMoveInfo.setAssocProfileFilterName(builder.getName());
                apt.setPNRMoveInfo(pnrMoveInfo);
                break;
            }
            idSet.add(apt.getAssocUniqueID());
            apt.setOrderSequenceNo(String.valueOf(orderNumber));
            apt.setDisplaySequenceNo(String.valueOf(orderNumber));
            ++orderNumber;
            assocProfiles.add(apt);
        }
        SabreProfileServicesUtil.processProfileTypes(res, counts);
        return res;
    }

    protected static void processProfileTypes(NumberOfAssocProfilesType res, Map<ProfileTypeInfo, Integer> counts) {
        for (Map.Entry<ProfileTypeInfo, Integer> entry : counts.entrySet()) {
            ProfileTypeInfo type = entry.getKey();
            Integer value = entry.getValue();
            if (type == ProfileTypeInfo.AGY) {
                res.setTravelAgency(value.toString());
                continue;
            }
            if (type == ProfileTypeInfo.CRP) {
                res.setCorporation(value.toString());
                continue;
            }
            if (type != ProfileTypeInfo.TVL) continue;
            res.setTraveler(value.toString());
        }
    }

    private static void updateCustomerType(CustomerType ct, Person per, Organization org, List<SabreProfilesAssociatedProfileData> assocProfiles, SabreProfilesDictionaryData dictionaryData, List<CostCodeInfo> udidValues, boolean useCir) {
        ct.setPersonNameList(SabreProfileServicesUtil.createPersonNameTypes(per));
        ct.setTelephoneList(SabreProfileServicesUtil.createTelephoneTypes(per.getCommunications()));
        ct.setEmailList(SabreProfileServicesUtil.createEmailTypes(per.getCommunications(), per.getPreferredLocale()));
        ct.setAddressList(SabreProfileServicesUtil.updateAddressTypes(ct.getAddressList(), per.getAddresses()));
        ct.setPaymentFormList(SabreProfileServicesUtil.updatePaymentFormTypes(ct.getPaymentFormList(), per.getCards(), useCir));
        ct.setEmergencyContactPersonList(SabreProfileServicesUtil.updateTelephoneTypesSabrePhonesAndEmails(ct.getEmergencyContactPersonList(), per.getSabrePhoneContacts(), per.getSabreEmailContacts()));
        ct.setDocumentList(SabreProfileServicesUtil.updateDocumentTypes(ct.getDocumentList(), per.getPassports(), per.getVisas(), per.getLastName(), per.getFirstName(), per.getMiddleName(), per.getSecondName()));
        ct.setCustLoyaltyList(SabreProfileServicesUtil.updateCustLoyaltyTypes(ct.getCustLoyaltyList(), per.getAirlineBonusCards(), per.getHotelBonusCards(), per.getCarBonusCards(), per.getRailwayBonusCards(), dictionaryData));
        ct.setEmploymentInfoList(SabreProfileServicesUtil.updateEmploymentInfoTypes(ct.getEmploymentInfoList(), SabreProfileServicesUtil.getPersonFullName(per), per.getEmployments(), assocProfiles, org, udidValues));
        Date perBirthday = ProfileHelper.getPersonBirthday((Person)per);
        ct.setBirthDate(MiscUtil.toSqlDate((Date)perBirthday));
        if (per.getGender() != null) {
            if (per.getGender() == Gender.MALE) {
                if (ProfileHelper.isPersonInfant((Person)per)) {
                    ct.setGenderCode("MI");
                } else {
                    ct.setGenderCode("M");
                }
            } else if (ProfileHelper.isPersonInfant((Person)per)) {
                ct.setGenderCode("FI");
            } else {
                ct.setGenderCode("F");
            }
        }
        if (ProfileHelper.isPersonChild((Person)per)) {
            ct.setChildIndicator(YesNoType.Y);
            ct.setLapInfantIndicator(YesNoType.N);
            ct.setSeniorIndicator(YesNoType.N);
        } else if (ProfileHelper.isPersonInfant((Person)per)) {
            ct.setLapInfantIndicator(YesNoType.Y);
            ct.setChildIndicator(YesNoType.N);
            ct.setSeniorIndicator(YesNoType.N);
        } else {
            ct.setLapInfantIndicator(YesNoType.N);
            ct.setChildIndicator(YesNoType.N);
        }
    }

    private static FilterCustomerType createFilterCustomerType(Person per, Organization organization, PNRBuilderSettings filterSettings, SabreProfilesDictionaryData dictionaryData, boolean useCir) {
        FilterCustomerType ct = new FilterCustomerType();
        if (filterSettings.isNeedTravelerName()) {
            ct.setPersonName(SabreProfileServicesUtil.createFilterPersonNameType(per));
        }
        if (ProfileHelper.isPersonInfant((Person)per)) {
            ct.setLapInfantIndicator(YesNoType.Y);
        } else {
            ct.setLapInfantIndicator(YesNoType.N);
        }
        if (filterSettings.isNeedPhones()) {
            ct.getTelephoneList().addAll(SabreProfileServicesUtil.createFilterTelephoneTypes(per.getCommunications()));
        }
        if (filterSettings.isNeedEmails()) {
            ct.getEmailList().addAll(SabreProfileServicesUtil.createFilterEmailTypes(per.getCommunications(), per.getPreferredLocale()));
        }
        ct.getAddressList().addAll(SabreProfileServicesUtil.createFilterAddressTypes(per.getAddresses(), filterSettings.isNeedAddresses(), filterSettings.isNeedDeliveryAddresses()));
        if (filterSettings.isNeedCreditCards()) {
            ct.getPaymentFormList().addAll(SabreProfileServicesUtil.createFilterPaymentFormTypes(per.getCards(), useCir));
        }
        if (filterSettings.isNeedDOCS()) {
            ct.setDocument(SabreProfileServicesUtil.createFilterDocumentType());
        }
        ct.getCustLoyaltyList().addAll(SabreProfileServicesUtil.createFilterCustLoyaltyTypes(filterSettings.isNeedFrequentFlyer() ? per.getAirlineBonusCards() : Collections.emptyList(), per.getHotelBonusCards(), per.getCarBonusCards(), dictionaryData));
        return ct;
    }

    private static List<DocumentType> updateVisaDocumentTypes(List<DocumentType> originalDocumentTypes, List<Visa> visas, L10nString lastName, L10nString firstName, L10nString middleName, L10nString secondName, int passportNum) {
        ArrayList<DocumentType> res = new ArrayList<DocumentType>();
        int num = passportNum;
        DictionaryCache cache = DictionaryCache.get();
        for (Visa v : visas) {
            GeoLocation city;
            if (v == null) continue;
            DocumentType dt = SabreProfileServicesUtil.findDocumentType(originalDocumentTypes, v);
            if (dt == null) {
                dt = new DocumentType();
            }
            ++num;
            DocHolderNameType dhnt = dt.getDocHolder();
            if (dhnt == null) {
                dhnt = new DocHolderNameType();
                dt.setDocHolder(dhnt);
            }
            SabreProfileServicesUtil.updateDocHolderNameType(dhnt, ProfileSynchronizationUtil.removeSpacesSlashesAndHyphens((String)ProfileSynchronizationUtil.getEnglishOrNullValue((L10nString)lastName)), ProfileSynchronizationUtil.removeSlashesAndHyphens((String)ProfileSynchronizationUtil.getEnglishOrNullValue((L10nString)firstName)), ProfileSynchronizationUtil.removeSlashesAndHyphens((String)ProfileSynchronizationUtil.getEnglishOrNullValue((L10nString)middleName)), ProfileSynchronizationUtil.removeSlashesAndHyphens((String)ProfileSynchronizationUtil.getEnglishOrNullValue((L10nString)secondName)));
            if (v.getIssueCity() != null && (city = (GeoLocation)cache.resolveReference(v.getIssueCity())) != null && !TextUtil.isBlank((String)((String)city.getTranslations().get(LocaleUtil.LOCALE_EN)))) {
                dt.setDocIssueLocation((String)city.getTranslations().get(LocaleUtil.LOCALE_EN));
            }
            if (v.getCountry() != null) {
                dt.setDocIssueCountryCode(v.getCountry().getCode());
            } else {
                dt.setDocIssueCountryCode(null);
            }
            dt.setDocID(TextUtil.nonEmptyStr((String)v.getNumber()));
            dt.setDocTypeCode("VISA");
            dt.setExpireDate(MiscUtil.toSqlDate((Date)v.getEndDate()));
            dt.setEffectiveDate(MiscUtil.toSqlDate((Date)v.getStartDate()));
            dt.setDisplaySequenceNo(String.valueOf(num));
            dt.setOrderSequenceNo(String.valueOf(num));
            if (v.getBirthPlace() != null) {
                dt.setBirthCountryCode(v.getBirthPlace().getCode());
            } else {
                dt.setBirthCountryCode(null);
            }
            res.add(dt);
        }
        return res;
    }

    private static Visa parseVisaDocumentType(DocumentType documentType) {
        Visa visa = new Visa();
        if (TextUtil.nonBlank((String)documentType.getDocIssueLocation())) {
            visa.setIssueCity(DictHelper.findCityByName((String)documentType.getDocIssueLocation()));
        }
        visa.setCountry((DictionaryReference)new CountryReference(documentType.getDocIssueCountryCode()));
        if (TextUtil.nonBlank((String)documentType.getDocID())) {
            visa.setNumber(documentType.getDocID());
        }
        visa.setStartDate(MiscUtil.cloneDate((Date)documentType.getEffectiveDate()));
        visa.setEndDate(MiscUtil.cloneDate((Date)documentType.getExpireDate()));
        if (TextUtil.nonBlank((String)documentType.getBirthCountryCode())) {
            visa.setBirthPlace((DictionaryReference)new CountryReference(documentType.getBirthCountryCode()));
        }
        return visa;
    }

    private static TPAIdentityType updateTPAIdentityForPersonProfileType(TPAIdentityType originalTpaId, Person per, String pcc, Organization organization) {
        String uniqueID = ProfileSynchronizationUtil.getSabreProfilesUniqueID((Person)per, (String)pcc);
        originalTpaId.setUniqueID(TextUtil.isBlank((String)uniqueID) ? "*" : uniqueID);
        originalTpaId.setProfileTypeCode(ProfileTypeInfo.TVL);
        originalTpaId.setClientCode(CLIENT_CODE);
        originalTpaId.setClientContextCode(CLIENT_CONTEXT_CODE);
        originalTpaId.setDomainID(pcc);
        originalTpaId.setProfileDescription(TextUtil.nonEmptyStr((String)SabreProfileServicesUtil.getPersonFullName(per)));
        if (TextUtil.isBlank((String)originalTpaId.getProfileName()) || organization == null || organization.getExternalSystem() != ExternalSystem.CONNECT_PROFILE) {
            originalTpaId.setProfileName(SabreProfileServicesUtil.getPersonShortName(per));
        }
        return originalTpaId;
    }

    private static TPAIdentityType createTPAIdentityForOrganizationProfileType(Organization org, String pcc, ProfileTypeInfo ptype) {
        TPAIdentityType tpaId = new TPAIdentityType();
        String uniqueID = ProfileSynchronizationUtil.getSabreProfilesUniqueID((Organization)org, (String)pcc);
        tpaId.setUniqueID(TextUtil.isBlank((String)uniqueID) ? "*" : uniqueID);
        tpaId.setProfileTypeCode(ptype);
        tpaId.setClientCode(CLIENT_CODE);
        tpaId.setClientContextCode(CLIENT_CONTEXT_CODE);
        tpaId.setDomainID(pcc);
        tpaId.setProfileName(ProfileSynchronizationUtil.getEnglishOrNullValue((L10nString)org.getShortName()));
        tpaId.setProfileDescription(TextUtil.nonEmptyStr((String)ProfileSynchronizationUtil.getEnglishOrNullValue((L10nString)org.getFullName())));
        return tpaId;
    }

    private static DeleteTPAIdentityType createDeleteTPAIdentityForProfileType(String uniqueID, String pcc, ProfileTypeInfo ptype) {
        DeleteTPAIdentityType tpaId = new DeleteTPAIdentityType();
        tpaId.setUniqueID(uniqueID);
        tpaId.setProfileTypeCode(ptype);
        tpaId.setClientCode(CLIENT_CODE);
        tpaId.setClientContextCode(CLIENT_CONTEXT_CODE);
        tpaId.setDomainID(pcc);
        return tpaId;
    }

    private static FilterTPAIdentityType createFilterTPAIdentityForProfileType(String uniqueID, String name, String description, String pcc, ProfileTypeInfo ptype) {
        FilterTPAIdentityType tpaId = new FilterTPAIdentityType();
        tpaId.setUniqueID(TextUtil.isBlank((String)uniqueID) ? "*" : uniqueID);
        tpaId.setProfileTypeCode(ptype);
        tpaId.setClientCode(CLIENT_CODE);
        tpaId.setClientContextCode(CLIENT_CONTEXT_CODE);
        tpaId.setDomainID(pcc);
        tpaId.setProfileName(name);
        tpaId.setProfileDescription(TextUtil.nonEmptyStr((String)description));
        return tpaId;
    }

    private static SearchTPAIdentityType createTPAIdentityForSearchProfileType(String name, String pcc, String ptype) {
        SearchTPAIdentityType tpaId = new SearchTPAIdentityType();
        tpaId.setProfileTypeCode(ptype);
        tpaId.setClientCode(CLIENT_CODE);
        tpaId.setClientContextCode(CLIENT_CONTEXT_CODE);
        tpaId.setDomainID(pcc);
        tpaId.setProfileName(name);
        return tpaId;
    }

    static TPAIdentityType createTPAIdentityForReadProfileType(String uniqueID, String name, String description, String pcc, ProfileTypeInfo ptype) {
        TPAIdentityType tpaId = new TPAIdentityType();
        tpaId.setUniqueID(TextUtil.isBlank((String)uniqueID) ? "*" : uniqueID);
        tpaId.setProfileTypeCode(ptype);
        tpaId.setClientCode(CLIENT_CODE);
        tpaId.setClientContextCode(CLIENT_CONTEXT_CODE);
        tpaId.setDomainID(pcc);
        tpaId.setProfileName(name);
        tpaId.setProfileDescription(TextUtil.nonEmptyStr((String)description));
        return tpaId;
    }

    private static List<EmploymentInfoType> updateEmploymentInfoTypes(List<EmploymentInfoType> originalEmploymentInfoTypes, String name, List<PersonEmployment> employments, List<SabreProfilesAssociatedProfileData> assocProfiles, Organization org, List<CostCodeInfo> udidValues) {
        ArrayList<EmploymentInfoType> res = new ArrayList<EmploymentInfoType>();
        SabreProfileServicesUtil.sortByOrderSequenceNumber(originalEmploymentInfoTypes, EmploymentInfoType::getOrderSequenceNo);
        if (org.getExternalSystem() == ExternalSystem.CONCUR || org.getExternalSystem() == ExternalSystem.CONNECT_PROFILE || org.getExternalSystem() == ExternalSystem.GET_THERE || org.getExternalSystem() == ExternalSystem.RAKETA) {
            List positions;
            Date hireDate;
            EmploymentInfoType e = originalEmploymentInfoTypes != null && !originalEmploymentInfoTypes.isEmpty() ? originalEmploymentInfoTypes.get(0) : new EmploymentInfoType();
            EmployeeInfoType eit = e.getEmployeeInfo();
            if (eit == null) {
                eit = new EmployeeInfoType();
                e.setEmployeeInfo(eit);
            }
            SabreProfileServicesUtil.addUdid(e, udidValues, SabreProfilesCostCodeType.INFORMATION_TEXT, EmploymentInfoType::setInformationText);
            SabreProfileServicesUtil.addUdid(eit, udidValues, SabreProfilesCostCodeType.EMPLOYEE_ID, EmployeeInfoType::setEmployeeId);
            SabreProfileServicesUtil.addUdid(eit, udidValues, SabreProfilesCostCodeType.EMPLOYEE_TITLE, EmployeeInfoType::setEmployeeTitle);
            SabreProfileServicesUtil.addUdid(eit, udidValues, SabreProfilesCostCodeType.COST_CENTER, EmployeeInfoType::setEmployeeCostCenter);
            SabreProfileServicesUtil.addUdid(eit, udidValues, SabreProfilesCostCodeType.DIVISION, EmployeeInfoType::setDivision);
            SabreProfileServicesUtil.addUdid(eit, udidValues, SabreProfilesCostCodeType.COMPANY, EmployeeInfoType::setCompany);
            SabreProfileServicesUtil.addUdid(eit, udidValues, SabreProfilesCostCodeType.COST_CENTER, EmployeeInfoType::setEmployeeCostCenter);
            SabreProfileServicesUtil.addUdid(eit, udidValues, SabreProfilesCostCodeType.INDUSTRY_TYPE_CODE, EmployeeInfoType::setIndustryTypeCode);
            SabreProfileServicesUtil.addUdid(eit, udidValues, SabreProfilesCostCodeType.DEPARTMENT, EmployeeInfoType::setDepartment);
            SabreProfileServicesUtil.addUdid(eit, udidValues, SabreProfilesCostCodeType.EMPLOYEE_NAME, EmployeeInfoType::setEmployeeName);
            SabreProfileServicesUtil.addUdid(eit, udidValues, SabreProfilesCostCodeType.SUBSIDIARY, EmployeeInfoType::setSubsidiary);
            SabreProfileServicesUtil.addUdid(eit, udidValues, SabreProfilesCostCodeType.BUSUNESS_UNIT, EmployeeInfoType::setBusinessUnit);
            SabreProfileServicesUtil.addUdid(eit, udidValues, SabreProfilesCostCodeType.OPERATING_UNIT, EmployeeInfoType::setOperatingUnit);
            SabreProfileServicesUtil.addUdid(eit, udidValues, SabreProfilesCostCodeType.PROJECT_ID, EmployeeInfoType::setProjectID);
            SabreProfileServicesUtil.addUdid(eit, udidValues, SabreProfilesCostCodeType.ACCOUNTING_CD, EmployeeInfoType::setAccountingCd);
            SabreProfileServicesUtil.addUdid(eit, udidValues, SabreProfilesCostCodeType.LOCATION_CD, EmployeeInfoType::setLocationCd);
            SabreProfileServicesUtil.addUdid(eit, udidValues, SabreProfilesCostCodeType.REGION_CD, EmployeeInfoType::setRegionCd);
            SabreProfileServicesUtil.addUdid(eit, udidValues, SabreProfilesCostCodeType.BRANCH_ID, EmployeeInfoType::setBranchID);
            SabreProfileServicesUtil.addUdid(eit, udidValues, SabreProfilesCostCodeType.GENERAL_LEDGER_CD, EmployeeInfoType::setGeneralLedgerCd);
            SabreProfileServicesUtil.addUdid(eit, udidValues, SabreProfilesCostCodeType.COUNTRY_CODE, EmployeeInfoType::setCountryCode);
            SabreProfileServicesUtil.addUdid(eit, udidValues, SabreProfilesCostCodeType.FORM_OF_EMPLOYMENT, EmployeeInfoType::setFormOfEmployment);
            SabreProfileServicesUtil.addUdid(eit, udidValues, SabreProfilesCostCodeType.EMPLOYEE_RANK_CD, EmployeeInfoType::setEmployeeRankCd);
            SabreProfileServicesUtil.addUdid(eit, udidValues, SabreProfilesCostCodeType.NETWORK_ID, EmployeeInfoType::setNetworkID);
            SabreProfileServicesUtil.addUdid(eit, udidValues, SabreProfilesCostCodeType.BADGE_NO, EmployeeInfoType::setBadgeNo);
            SabreProfileServicesUtil.addUdid(eit, udidValues, SabreProfilesCostCodeType.ALTERNATE_EMPLOYEE_ID, EmployeeInfoType::setAlternateEmployeeId);
            SabreProfileServicesUtil.addUdid(eit, udidValues, SabreProfilesCostCodeType.PAYROLL_CD, EmployeeInfoType::setPayrollCd);
            SabreProfileServicesUtil.addUdid(eit, udidValues, SabreProfilesCostCodeType.ORGANIZATION, EmployeeInfoType::setOrganization);
            SabreProfileServicesUtil.addUdid(eit, udidValues, SabreProfilesCostCodeType.POSITION_CD, EmployeeInfoType::setPositionCd);
            SabreProfileServicesUtil.addUdid(eit, udidValues, SabreProfilesCostCodeType.EMPLOYEE_GRADE_LEVEL, EmployeeInfoType::setEmployeeGradeLevel);
            SabreProfileServicesUtil.addUdid(eit, udidValues, SabreProfilesCostCodeType.MARKETING_UNIT, EmployeeInfoType::setMarketingUnit);
            SabreProfileServicesUtil.addUdid(eit, udidValues, SabreProfilesCostCodeType.ENTITY, EmployeeInfoType::setEntity);
            SabreProfileServicesUtil.addUdid(eit, udidValues, SabreProfilesCostCodeType.PERSON_TYPE, EmployeeInfoType::setPersonType);
            String hireDateString = udidValues.stream().filter(udid -> udid.getType() == SabreProfilesCostCodeType.HIRE_DATE).map(CostCodeInfo::getValue).filter(TextUtil::nonBlank).findFirst().orElse(null);
            if (hireDateString != null) {
                try {
                    hireDate = new SimpleDateFormat("yyyy-MM-dd").parse(hireDateString);
                }
                catch (ParseException exc) {
                    throw new IllegalArgumentException("Unsupported hire date format: " + hireDateString, exc);
                }
            } else {
                hireDate = null;
            }
            eit.setHireDate(MiscUtil.toSqlDate(hireDate));
            e.setOrderSequenceNo(String.valueOf(1));
            if (org.getExternalSystem() == ExternalSystem.GET_THERE && (positions = employments.stream().map(PersonEmployment::getPosition).filter(Objects::nonNull).distinct().collect(Collectors.toList())).size() == 1) {
                eit.setEmployeeTitle(((DictionaryReference)positions.get(0)).getCaption());
            }
            res.add(e);
        } else {
            for (int i = 0; i < employments.size(); ++i) {
                EmployeeInfoType eit;
                PersonEmployment pe = employments.get(i);
                EmploymentInfoType e = originalEmploymentInfoTypes != null && i < originalEmploymentInfoTypes.size() ? originalEmploymentInfoTypes.get(i) : new EmploymentInfoType();
                String nameFromAssocProfile = null;
                if (i < assocProfiles.size() && assocProfiles.get(i) != null) {
                    nameFromAssocProfile = assocProfiles.get(i).getName();
                }
                if ((eit = e.getEmployeeInfo()) == null) {
                    eit = new EmployeeInfoType();
                    e.setEmployeeInfo(eit);
                }
                SabreProfileServicesUtil.updateEmployeeInfoType(eit, name, nameFromAssocProfile, pe);
                e.setOrderSequenceNo(String.valueOf(i + 1));
                res.add(e);
            }
        }
        return res;
    }

    private static void updateEmployeeInfoType(EmployeeInfoType eit, String name, String nameFromAssocProfile, PersonEmployment pe) {
        eit.setHireDate(MiscUtil.toSqlDate((Date)pe.getOpened()));
        eit.setDepartment(TextUtil.nonBlank((String)pe.getDepartmentSuffix()) ? pe.getDepartmentSuffix() : null);
        eit.setEmployeeName(name);
        if (nameFromAssocProfile != null) {
            eit.setCompany(nameFromAssocProfile);
        } else {
            eit.setCompany(pe.getOrganization() != null ? pe.getOrganization().getCaption() : " ");
        }
        if (pe.getPosition() != null) {
            eit.setEmployeeTitle(pe.getPosition().getCaption());
        } else {
            eit.setEmployeeTitle(null);
        }
    }

    private static <T> void addUdid(T employeeInfoType, List<CostCodeInfo> udidValues, SabreProfilesCostCodeType udidType, BiConsumer<T, String> setter) {
        String value = udidValues.stream().filter(udid -> udid.getType() == udidType).map(CostCodeInfo::getValue).filter(TextUtil::nonBlank).findFirst().orElse(null);
        if (TextUtil.nonBlank((String)value)) {
            setter.accept(employeeInfoType, value);
        }
    }

    private static void parseEmploymentInfoTypes(List<EmploymentInfoType> employeeInfoTypes, List<CostCodeInfo> udidValues, List<EmploymentInfo> employmentInfo) {
        if (CollectionUtil.isEmpty(employeeInfoTypes)) {
            return;
        }
        SabreProfileServicesUtil.sortByOrderSequenceNumber(employeeInfoTypes, EmploymentInfoType::getOrderSequenceNo);
        employeeInfoTypes.stream().map(EmploymentInfoType::getEmployeeInfo).filter(Objects::nonNull).map(eit -> {
            EmploymentInfo info = new EmploymentInfo();
            info.setCompany(eit.getCompany());
            info.setEmployeeTitle(eit.getEmployeeTitle());
            return info;
        }).forEach(employmentInfo::add);
        EmploymentInfoType employmentInfoType = employeeInfoTypes.get(0);
        EmployeeInfoType employeeInfoType = employmentInfoType.getEmployeeInfo();
        if (employeeInfoType == null) {
            return;
        }
        ArrayList<CostCodeInfo> result = new ArrayList<CostCodeInfo>();
        if (TextUtil.nonBlank((String)employmentInfoType.getInformationText())) {
            result.add(SabreProfileServicesUtil.createCostCodeInfo(SabreProfilesCostCodeType.INFORMATION_TEXT, employmentInfoType.getInformationText()));
        }
        if (employeeInfoType.getHireDate() != null) {
            result.add(SabreProfileServicesUtil.createCostCodeInfo(SabreProfilesCostCodeType.HIRE_DATE, new SimpleDateFormat("yyyy-MM-dd").format(employeeInfoType.getHireDate())));
        }
        Stream.of(SabreProfileServicesUtil.parseUdid(employeeInfoType, SabreProfilesCostCodeType.EMPLOYEE_ID, EmployeeInfoType::getEmployeeId), SabreProfileServicesUtil.parseUdid(employeeInfoType, SabreProfilesCostCodeType.EMPLOYEE_TITLE, EmployeeInfoType::getEmployeeTitle), SabreProfileServicesUtil.parseUdid(employeeInfoType, SabreProfilesCostCodeType.COST_CENTER, EmployeeInfoType::getEmployeeCostCenter), SabreProfileServicesUtil.parseUdid(employeeInfoType, SabreProfilesCostCodeType.DIVISION, EmployeeInfoType::getDivision), SabreProfileServicesUtil.parseUdid(employeeInfoType, SabreProfilesCostCodeType.COMPANY, EmployeeInfoType::getCompany), SabreProfileServicesUtil.parseUdid(employeeInfoType, SabreProfilesCostCodeType.INDUSTRY_TYPE_CODE, EmployeeInfoType::getIndustryTypeCode), SabreProfileServicesUtil.parseUdid(employeeInfoType, SabreProfilesCostCodeType.DEPARTMENT, EmployeeInfoType::getDepartment), SabreProfileServicesUtil.parseUdid(employeeInfoType, SabreProfilesCostCodeType.EMPLOYEE_NAME, EmployeeInfoType::getEmployeeName), SabreProfileServicesUtil.parseUdid(employeeInfoType, SabreProfilesCostCodeType.SUBSIDIARY, EmployeeInfoType::getSubsidiary), SabreProfileServicesUtil.parseUdid(employeeInfoType, SabreProfilesCostCodeType.BUSUNESS_UNIT, EmployeeInfoType::getBusinessUnit), SabreProfileServicesUtil.parseUdid(employeeInfoType, SabreProfilesCostCodeType.OPERATING_UNIT, EmployeeInfoType::getOperatingUnit), SabreProfileServicesUtil.parseUdid(employeeInfoType, SabreProfilesCostCodeType.PROJECT_ID, EmployeeInfoType::getProjectID), SabreProfileServicesUtil.parseUdid(employeeInfoType, SabreProfilesCostCodeType.ACCOUNTING_CD, EmployeeInfoType::getAccountingCd), SabreProfileServicesUtil.parseUdid(employeeInfoType, SabreProfilesCostCodeType.LOCATION_CD, EmployeeInfoType::getLocationCd), SabreProfileServicesUtil.parseUdid(employeeInfoType, SabreProfilesCostCodeType.REGION_CD, EmployeeInfoType::getRegionCd), SabreProfileServicesUtil.parseUdid(employeeInfoType, SabreProfilesCostCodeType.BRANCH_ID, EmployeeInfoType::getBranchID), SabreProfileServicesUtil.parseUdid(employeeInfoType, SabreProfilesCostCodeType.GENERAL_LEDGER_CD, EmployeeInfoType::getGeneralLedgerCd), SabreProfileServicesUtil.parseUdid(employeeInfoType, SabreProfilesCostCodeType.COUNTRY_CODE, EmployeeInfoType::getCountryCode), SabreProfileServicesUtil.parseUdid(employeeInfoType, SabreProfilesCostCodeType.FORM_OF_EMPLOYMENT, EmployeeInfoType::getFormOfEmployment), SabreProfileServicesUtil.parseUdid(employeeInfoType, SabreProfilesCostCodeType.EMPLOYEE_RANK_CD, EmployeeInfoType::getEmployeeRankCd), SabreProfileServicesUtil.parseUdid(employeeInfoType, SabreProfilesCostCodeType.NETWORK_ID, EmployeeInfoType::getNetworkID), SabreProfileServicesUtil.parseUdid(employeeInfoType, SabreProfilesCostCodeType.BADGE_NO, EmployeeInfoType::getBadgeNo), SabreProfileServicesUtil.parseUdid(employeeInfoType, SabreProfilesCostCodeType.ALTERNATE_EMPLOYEE_ID, EmployeeInfoType::getAlternateEmployeeId), SabreProfileServicesUtil.parseUdid(employeeInfoType, SabreProfilesCostCodeType.PAYROLL_CD, EmployeeInfoType::getPayrollCd), SabreProfileServicesUtil.parseUdid(employeeInfoType, SabreProfilesCostCodeType.ORGANIZATION, EmployeeInfoType::getOrganization), SabreProfileServicesUtil.parseUdid(employeeInfoType, SabreProfilesCostCodeType.POSITION_CD, EmployeeInfoType::getPositionCd), SabreProfileServicesUtil.parseUdid(employeeInfoType, SabreProfilesCostCodeType.EMPLOYEE_GRADE_LEVEL, EmployeeInfoType::getEmployeeGradeLevel), SabreProfileServicesUtil.parseUdid(employeeInfoType, SabreProfilesCostCodeType.MARKETING_UNIT, EmployeeInfoType::getMarketingUnit), SabreProfileServicesUtil.parseUdid(employeeInfoType, SabreProfilesCostCodeType.ENTITY, EmployeeInfoType::getEntity), SabreProfileServicesUtil.parseUdid(employeeInfoType, SabreProfilesCostCodeType.PERSON_TYPE, EmployeeInfoType::getPersonType)).filter(Objects::nonNull).forEach(result::add);
        udidValues.addAll(result);
    }

    private static <T> CostCodeInfo parseUdid(T employeeInfoType, SabreProfilesCostCodeType udidType, Function<T, String> getter) {
        String value = getter.apply(employeeInfoType);
        if (TextUtil.isBlank((String)value)) {
            return null;
        }
        return SabreProfileServicesUtil.createCostCodeInfo(udidType, value);
    }

    private static CostCodeInfo createCostCodeInfo(SabreProfilesCostCodeType udidType, String value) {
        CostCodeInfo result = new CostCodeInfo();
        result.setType(udidType);
        result.setValue(value);
        return result;
    }

    private static List<CustLoyaltyType> updateCustLoyaltyTypes(List<CustLoyaltyType> originalCustLoyaltyTypes, List<AirlineBonusCard> airlineCards, List<HotelBonusCard> hotelBonusCards, List<CarBonusCard> carCards, List<RailwayBonusCard> railwayBonusCards, SabreProfilesDictionaryData dictionaryData) {
        CustLoyaltyType clt;
        ArrayList<CustLoyaltyType> res = new ArrayList<CustLoyaltyType>();
        int num = 1;
        for (AirlineBonusCard airlineBonusCard : airlineCards) {
            String airlineCode;
            Airline airline;
            if (TextUtil.isBlank((String)airlineBonusCard.getNumber()) || airlineBonusCard.getAirline() == null || dictionaryData == null || ValidationUtil.containsNonOnlyLatinLettersOrNumbers((String)airlineBonusCard.getNumber()) || (airline = (Airline)dictionaryData.resolve(airlineBonusCard.getAirline())) == null || TextUtil.isBlank((String)(airlineCode = DictHelper.getCodeVariant((BaseDictionary)airline, (CodeSystem)CodeSystem.IATA))) || airlineCode.length() > 2) continue;
            CustLoyaltyType clt2 = SabreProfileServicesUtil.findCustLoyaltyType(originalCustLoyaltyTypes, airlineBonusCard.getNumber(), "AL");
            if (clt2 == null) {
                clt2 = new CustLoyaltyType();
            }
            clt2.setMembershipID(airlineBonusCard.getNumber());
            clt2.setVendorCode(airlineCode);
            clt2.setVendorTypeCode("AL");
            clt2.setOrderSequenceNo(String.valueOf(num++));
            res.add(clt2);
        }
        for (HotelBonusCard hotelBonusCard : hotelBonusCards) {
            if (TextUtil.isBlank((String)hotelBonusCard.getNumber()) || hotelBonusCard.getHotelBrand() == null || TextUtil.isBlank((String)hotelBonusCard.getHotelBrand().getCode()) || hotelBonusCard.getHotelBrand().getCode().length() > 2) continue;
            clt = SabreProfileServicesUtil.findCustLoyaltyType(originalCustLoyaltyTypes, hotelBonusCard.getNumber(), "HL");
            if (clt == null) {
                clt = new CustLoyaltyType();
            }
            clt.setMembershipID(hotelBonusCard.getNumber());
            clt.setVendorCode(hotelBonusCard.getHotelBrand().getCode());
            clt.setVendorTypeCode("HL");
            clt.setOrderSequenceNo(String.valueOf(num++));
            res.add(clt);
        }
        for (CarBonusCard carBonusCard : carCards) {
            if (TextUtil.isBlank((String)carBonusCard.getNumber()) || carBonusCard.getCarSupplier() == null || TextUtil.isBlank((String)carBonusCard.getCarSupplier().getCode()) || carBonusCard.getCarSupplier().getCode().length() > 2) continue;
            clt = SabreProfileServicesUtil.findCustLoyaltyType(originalCustLoyaltyTypes, carBonusCard.getNumber(), "CR");
            if (clt == null) {
                clt = new CustLoyaltyType();
            }
            clt.setMembershipID(carBonusCard.getNumber());
            clt.setVendorCode(carBonusCard.getCarSupplier().getCode());
            clt.setVendorTypeCode("CR");
            clt.setOrderSequenceNo(String.valueOf(num++));
            res.add(clt);
        }
        for (RailwayBonusCard railwayBonusCard : railwayBonusCards) {
            CustLoyaltyType clt3;
            String vendorCode;
            if (TextUtil.isBlank((String)railwayBonusCard.getNumber()) || railwayBonusCard.getRailwayCarrierCode() == null || TextUtil.isBlank((String)(vendorCode = railwayBonusCard.getRailwayCarrierCode())) || vendorCode.length() > 2) continue;
            if (TextUtil.containsCyrillicLetter((String)vendorCode)) {
                if (!"\u0420\u0416\u0414".equals(vendorCode)) continue;
                vendorCode = "RZD";
            }
            if ((clt3 = SabreProfileServicesUtil.findCustLoyaltyType(originalCustLoyaltyTypes, railwayBonusCard.getNumber(), "RL")) == null) {
                clt3 = new CustLoyaltyType();
            }
            clt3.setMembershipID(railwayBonusCard.getNumber());
            clt3.setVendorCode(vendorCode);
            clt3.setVendorTypeCode("RL");
            clt3.setOrderSequenceNo(String.valueOf(num++));
            res.add(clt3);
            break;
        }
        if (CollectionUtil.isNotEmpty(originalCustLoyaltyTypes)) {
            List<String> supportedVendorTypes = Arrays.asList("AL", "HL", "CR", "RL");
            SabreProfileServicesUtil.sortByOrderSequenceNumber(originalCustLoyaltyTypes, CustLoyaltyType::getOrderSequenceNo);
            for (CustLoyaltyType originalCustLoyaltyType : originalCustLoyaltyTypes) {
                if (supportedVendorTypes.contains(originalCustLoyaltyType.getVendorTypeCode())) continue;
                originalCustLoyaltyType.setOrderSequenceNo(String.valueOf(num++));
                originalCustLoyaltyType.setDisplaySequenceNo(null);
                res.add(originalCustLoyaltyType);
            }
        }
        return res;
    }

    private static CustLoyaltyType findCustLoyaltyType(List<CustLoyaltyType> custLoyaltyTypes, String membershipID, String vendorTypeCode) {
        if (custLoyaltyTypes == null) {
            return null;
        }
        Iterator<CustLoyaltyType> iterator = custLoyaltyTypes.iterator();
        while (iterator.hasNext()) {
            CustLoyaltyType custLoyaltyType = iterator.next();
            if (!MiscUtil.equals((Object)custLoyaltyType.getMembershipID(), (Object)membershipID) || !MiscUtil.equals((Object)custLoyaltyType.getVendorTypeCode(), (Object)vendorTypeCode)) continue;
            iterator.remove();
            return custLoyaltyType;
        }
        return null;
    }

    private static void parseCustLoyaltyTypes(Person person, List<CustLoyaltyType> custLoyaltyTypes) {
        if (CollectionUtil.isEmpty(custLoyaltyTypes)) {
            return;
        }
        SabreProfileServicesUtil.sortByOrderSequenceNumber(custLoyaltyTypes, CustLoyaltyType::getOrderSequenceNo);
        ArrayList<AirlineBonusCard> airlineBonusCards = new ArrayList<AirlineBonusCard>();
        ArrayList<AirlineBonusCard> hotelBonusCards = new ArrayList<AirlineBonusCard>();
        ArrayList<AirlineBonusCard> carBonusCards = new ArrayList<AirlineBonusCard>();
        ArrayList<AirlineBonusCard> railwayBonusCards = new ArrayList<AirlineBonusCard>();
        for (CustLoyaltyType custLoyaltyType : custLoyaltyTypes) {
            if (TextUtil.isBlank((String)custLoyaltyType.getVendorTypeCode())) continue;
            switch (custLoyaltyType.getVendorTypeCode()) {
                case "AL": {
                    AirlineBonusCard card = new AirlineBonusCard();
                    if (TextUtil.nonBlank((String)custLoyaltyType.getMembershipID())) {
                        card.setNumber(custLoyaltyType.getMembershipID());
                    }
                    if (TextUtil.nonBlank((String)custLoyaltyType.getVendorCode())) {
                        card.setAirline((DictionaryReference)new AirlineReference(custLoyaltyType.getVendorCode()));
                    }
                    airlineBonusCards.add(card);
                    break;
                }
                case "HL": {
                    AirlineBonusCard card = new HotelBonusCard();
                    if (TextUtil.nonBlank((String)custLoyaltyType.getMembershipID())) {
                        card.setNumber(custLoyaltyType.getMembershipID());
                    }
                    if (TextUtil.nonBlank((String)custLoyaltyType.getVendorCode())) {
                        card.setHotelBrand((DictionaryReference)new HotelsBrandReference(custLoyaltyType.getVendorCode()));
                    }
                    hotelBonusCards.add(card);
                    break;
                }
                case "CR": {
                    AirlineBonusCard card = new CarBonusCard();
                    if (TextUtil.nonBlank((String)custLoyaltyType.getMembershipID())) {
                        card.setNumber(custLoyaltyType.getMembershipID());
                    }
                    if (TextUtil.nonBlank((String)custLoyaltyType.getVendorCode())) {
                        card.setCarSupplier((DictionaryReference)new CarsSupplierReference(custLoyaltyType.getVendorCode()));
                    }
                    carBonusCards.add(card);
                    break;
                }
                case "RL": {
                    AirlineBonusCard card = new RailwayBonusCard();
                    if (TextUtil.nonBlank((String)custLoyaltyType.getMembershipID())) {
                        card.setNumber(custLoyaltyType.getMembershipID());
                    }
                    if (TextUtil.nonBlank((String)custLoyaltyType.getVendorCode())) {
                        if ("RZD".equals(custLoyaltyType.getVendorCode())) {
                            card.setRailwayCarrierCode("\u0420\u0416\u0414");
                        } else {
                            card.setRailwayCarrierCode(custLoyaltyType.getVendorCode());
                        }
                    }
                    railwayBonusCards.add(card);
                    break;
                }
            }
        }
        person.getAirlineBonusCards().addAll(airlineBonusCards);
        person.getHotelBonusCards().addAll(hotelBonusCards);
        person.getCarBonusCards().addAll(carBonusCards);
        person.getRailwayBonusCards().addAll(railwayBonusCards);
    }

    private static Collection<FilterCustLoyaltyType> createFilterCustLoyaltyTypes(List<AirlineBonusCard> airlineBonusCards, List<HotelBonusCard> hotelBonusCards, List<CarBonusCard> carBonusCards, SabreProfilesDictionaryData dictionaryData) {
        ArrayList<FilterCustLoyaltyType> res = new ArrayList<FilterCustLoyaltyType>();
        int num = 1;
        for (AirlineBonusCard card : airlineBonusCards) {
            String airlineCode;
            Airline airline;
            if (TextUtil.isBlank((String)card.getNumber()) || card.getAirline() == null || dictionaryData == null || ValidationUtil.containsNonOnlyLatinLettersOrNumbers((String)card.getNumber()) || (airline = (Airline)dictionaryData.resolve(card.getAirline())) == null || TextUtil.isBlank((String)(airlineCode = DictHelper.getCodeVariant((BaseDictionary)airline, (CodeSystem)CodeSystem.IATA))) || airlineCode.length() > 2) continue;
            FilterCustLoyaltyType clt = new FilterCustLoyaltyType();
            clt.setMembershipID(SP_FILTER_ANY_STRING);
            clt.setVendorCode("*");
            clt.setVendorTypeCode("AL");
            clt.setOrderSequenceNo(String.valueOf(num++));
            res.add(clt);
        }
        return res;
    }

    private static List<DocumentType> updateDocumentTypes(List<DocumentType> originalDocumentTypes, List<Passport> passports, List<Visa> visas, L10nString personLastName, L10nString personFirstName, L10nString personMiddleName, L10nString personSecondName) {
        List<DocumentType> res = SabreProfileServicesUtil.updatePassportDocumentTypes(originalDocumentTypes, passports, personLastName, personFirstName);
        res.addAll(SabreProfileServicesUtil.updateVisaDocumentTypes(originalDocumentTypes, visas, personLastName, personFirstName, personMiddleName, personSecondName, res.size()));
        return res;
    }

    private static List<DocumentType> updatePassportDocumentTypes(List<DocumentType> originalDocumentTypes, List<Passport> passports, L10nString personLastName, L10nString personFirstName) {
        ArrayList<DocumentType> res = new ArrayList<DocumentType>();
        int num = 0;
        HashSet<String> uniquePassports = new HashSet<String>();
        for (Passport p : passports) {
            String mainPassportData;
            if (p == null || TextUtil.isBlank((String)p.getNumber()) || p.getGender() == null || p.getCorrelationId() != null && PassportCorrelationQualifier.CYRILLIC == p.getCorrelationQualifier()) continue;
            DocumentType dt = SabreProfileServicesUtil.findDocumentType(originalDocumentTypes, p);
            if (dt == null) {
                dt = new DocumentType();
            }
            String lastName = ProfileSynchronizationUtil.preparePassportName((L10nString)personLastName, (String)p.getLastName(), (boolean)true, (boolean)true);
            String firstName = ProfileSynchronizationUtil.preparePassportName((L10nString)personFirstName, (String)p.getFirstName(), (boolean)true, (boolean)false);
            if (TextUtil.isBlank((String)lastName) || TextUtil.isBlank((String)firstName)) continue;
            String secondName = ProfileSynchronizationUtil.preparePassportName(null, (String)p.getSecondName(), (boolean)true, (boolean)false);
            String middleName = ProfileSynchronizationUtil.preparePassportName(null, (String)p.getMiddleName(), (boolean)true, (boolean)false);
            DocHolderNameType dhnt = dt.getDocHolder();
            if (dhnt == null) {
                dhnt = new DocHolderNameType();
                dt.setDocHolder(dhnt);
            }
            SabreProfileServicesUtil.updateDocHolderNameType(dhnt, lastName, firstName, middleName, secondName);
            dt.setDocIssueLocation(TextUtil.nullOrNonBlankString((String)p.getIssueCity()));
            if (p.getOriginCountry() != null) {
                dt.setDocIssueCountryCode(p.getOriginCountry().getCode());
            } else {
                dt.setDocIssueCountryCode(null);
            }
            dt.setDocID(p.getNumber());
            if (p.getType() != null) {
                String docTypeCode = p.getType() == PassportType.OTHER && TextUtil.nonBlank((String)p.getSabreProfilesType()) ? p.getSabreProfilesType() : ProfileSynchronizationUtil.getCodeByDocType((PassportType)p.getType());
                dt.setDocTypeCode(docTypeCode);
            }
            if (uniquePassports.contains(mainPassportData = TextUtil.nonNullStr((String)dt.getDocTypeCode()) + TextUtil.nonNullStr((String)dt.getDocID()))) continue;
            uniquePassports.add(mainPassportData);
            ++num;
            dt.setBirthDate(MiscUtil.toSqlDate((Date)p.getBirthday()));
            dt.setEffectiveDate(MiscUtil.toSqlDate((Date)p.getIssued()));
            java.sql.Date expirationDate = ProfileSynchronizationUtil.calculateExpirationDocumentDate((Passport)p);
            if (expirationDate == null || MiscUtil.clearTime((Date)new Date()).after(expirationDate)) continue;
            dt.setExpireDate(expirationDate);
            dt.setDisplaySequenceNo(String.valueOf(num));
            dt.setOrderSequenceNo(String.valueOf(num));
            if (!TextUtil.isBlank((String)p.getBirthPlace()) && !ProfileSynchronizationUtil.checkIllegalSymbols((String)p.getBirthPlace(), (boolean)false)) {
                if (p.getBirthPlace().length() > 20) {
                    dt.setBirthPlace(p.getBirthPlace().substring(0, 20));
                } else {
                    dt.setBirthPlace(p.getBirthPlace());
                }
            } else {
                dt.setBirthPlace(null);
            }
            if (p.getCitizenship() != null) {
                dt.setDocHolderNationalityCode(p.getCitizenship().getCode());
            } else {
                dt.setDocHolderNationalityCode(null);
            }
            dt.setGenderCode(p.getGender() == Gender.FEMALE ? "F" : "M");
            dt.setInformationText(TextUtil.nullOrNonBlankString((String)p.getRemarks()));
            res.add(dt);
        }
        return res;
    }

    private static DocumentType findDocumentType(List<DocumentType> documentTypes, Passport passport) {
        if (documentTypes == null) {
            return null;
        }
        Iterator<DocumentType> iterator = documentTypes.iterator();
        while (iterator.hasNext()) {
            DocumentType documentType = iterator.next();
            if (SabreProfileServicesUtil.isVisa(documentType) || !TextUtil.isSame((String)documentType.getDocID(), (String)passport.getNumber())) continue;
            iterator.remove();
            return documentType;
        }
        return null;
    }

    private static DocumentType findDocumentType(List<DocumentType> documentTypes, Visa visa) {
        if (documentTypes == null) {
            return null;
        }
        Iterator<DocumentType> iterator = documentTypes.iterator();
        while (iterator.hasNext()) {
            DocumentType documentType = iterator.next();
            if (!SabreProfileServicesUtil.isVisa(documentType) || !TextUtil.isSame((String)documentType.getDocID(), (String)visa.getNumber())) continue;
            iterator.remove();
            return documentType;
        }
        return null;
    }

    private static void parseDocumentsTypes(Person person, List<DocumentType> documentTypes, String genderCode) {
        if (CollectionUtil.isEmpty(documentTypes)) {
            return;
        }
        SabreProfileServicesUtil.sortByOrderSequenceNumber(documentTypes, DocumentType::getOrderSequenceNo);
        ArrayList<Passport> passports = new ArrayList<Passport>();
        ArrayList<Visa> visas = new ArrayList<Visa>();
        for (DocumentType documentType : documentTypes) {
            if (SabreProfileServicesUtil.isVisa(documentType)) {
                visas.add(SabreProfileServicesUtil.parseVisaDocumentType(documentType));
                continue;
            }
            passports.add(SabreProfileServicesUtil.parsePassportType(documentType, genderCode));
        }
        person.getPassports().addAll(passports);
        person.getVisas().addAll(visas);
    }

    private static boolean isVisa(DocumentType documentType) {
        return "VISA".equals(documentType.getDocTypeCode());
    }

    private static Passport parsePassportType(DocumentType documentType, String genderCode) {
        Passport passport = new Passport();
        SabreProfileServicesUtil.parseDocHolderNameType(passport, documentType.getDocHolder());
        if (TextUtil.nonBlank((String)documentType.getDocIssueLocation())) {
            passport.setIssueCity(documentType.getDocIssueLocation());
        }
        if (TextUtil.nonBlank((String)documentType.getDocIssueCountryCode())) {
            passport.setOriginCountry((DictionaryReference)new CountryReference(documentType.getDocIssueCountryCode()));
        }
        if (TextUtil.nonBlank((String)documentType.getDocHolderNationalityCode())) {
            passport.setCitizenship((DictionaryReference)new CountryReference(documentType.getDocHolderNationalityCode()));
        }
        if (TextUtil.nonBlank((String)documentType.getDocID())) {
            passport.setNumber(documentType.getDocID());
        }
        if (TextUtil.nonBlank((String)documentType.getBirthPlace())) {
            passport.setBirthPlace(documentType.getBirthPlace());
        }
        if (TextUtil.nonBlank((String)documentType.getInformationText())) {
            passport.setRemarks(documentType.getInformationText());
        }
        passport.setSabreProfilesType(documentType.getDocTypeCode());
        passport.setType(ProfileSynchronizationUtil.getDocTypeByCode((String)documentType.getDocTypeCode()));
        passport.setBirthday(MiscUtil.cloneDate((Date)documentType.getBirthDate()));
        passport.setIssued(MiscUtil.cloneDate((Date)documentType.getEffectiveDate()));
        passport.setExpired(MiscUtil.cloneDate((Date)documentType.getExpireDate()));
        if (documentType.getGenderCode() != null) {
            passport.setGender("F".equals(documentType.getGenderCode()) ? Gender.FEMALE : Gender.MALE);
        } else if (TextUtil.nonBlank((String)genderCode)) {
            passport.setGender("F".equals(genderCode) || "FI".equals(genderCode) ? Gender.FEMALE : Gender.MALE);
        }
        return passport;
    }

    private static SearchDocumentType createSearchDocumentType(List<Passport> passports) {
        for (Passport p : passports) {
            if (p == null || p.getGender() == null) continue;
            SearchDocumentType dt = new SearchDocumentType();
            if (p.getOriginCountry() != null) {
                dt.setDocIssueCountryCode(p.getOriginCountry().getCode());
            }
            if (p.getType() != null) {
                String docTypeCode = p.getType() == PassportType.OTHER && TextUtil.nonBlank((String)p.getSabreProfilesType()) ? p.getSabreProfilesType() : ProfileSynchronizationUtil.getCodeByDocType((PassportType)p.getType());
                dt.setDocTypeCode(docTypeCode);
            }
            if (TextUtil.isBlank((String)p.getNumber())) continue;
            dt.setDocID(p.getNumber());
            return dt;
        }
        return null;
    }

    private static FilterDocumentType createFilterDocumentType() {
        FilterDocumentType dt = new FilterDocumentType();
        DocHolderNameType dhnt = new DocHolderNameType();
        SabreProfileServicesUtil.updateDocHolderNameType(dhnt, SP_FILTER_ANY_STRING, "Y", "Z", "Z");
        dt.setDocHolder(dhnt);
        dt.setDisplaySequenceNo("1");
        dt.setOrderSequenceNo("1");
        return dt;
    }

    private static void updateDocHolderNameType(DocHolderNameType dhnt, String lastName, String firstName, String middleName, String secondName) {
        if (!TextUtil.isBlank((String)firstName)) {
            if (!TextUtil.isBlank((String)secondName)) {
                dhnt.setGivenName(firstName.trim() + " " + secondName.trim());
            } else {
                dhnt.setGivenName(firstName.trim());
            }
        } else {
            dhnt.setGivenName(" ");
        }
        dhnt.setSurName(TextUtil.nonEmptyStr((String)lastName));
        dhnt.setMiddleName(TextUtil.nonEmptyStr((String)middleName));
    }

    private static void parseDocHolderNameType(Passport document, DocHolderNameType docHolderNameType) {
        if (docHolderNameType == null) {
            return;
        }
        if (TextUtil.nonBlank((String)docHolderNameType.getSurName())) {
            document.setLastName(docHolderNameType.getSurName());
        }
        if (TextUtil.nonBlank((String)docHolderNameType.getGivenName())) {
            document.setFirstName(docHolderNameType.getGivenName());
        }
        if (TextUtil.nonBlank((String)docHolderNameType.getMiddleName())) {
            document.setMiddleName(docHolderNameType.getMiddleName());
        }
    }

    private static List<PaymentFormType> updatePaymentFormTypes(List<PaymentFormType> originalPaymentFormTypes, List<Card> cards, boolean useCir) {
        ArrayList<PaymentFormType> res = new ArrayList<PaymentFormType>();
        int num = 1;
        for (Card c : cards) {
            if (TextUtil.isBlank((String)c.getNumber()) || !ProfileSynchronizationConstants.Card2Abbr.containsKey(c.getVendor()) && !TextUtil.nonBlank((String)c.getSabreVendorCode())) continue;
            PaymentFormType pft = new PaymentFormType();
            pft.setDisplaySequenceNo(String.valueOf(num));
            pft.setOrderSequenceNo(String.valueOf(num++));
            pft.setServiceUsageTypeCode("AL");
            pft.setTripTypeCode("AZ");
            pft.setInformationText(SabreProfileServicesUtil.createCardInformationTextString(c.isSof(), c.isBta(), c.getRemarks()));
            PaymentFormType.Choice choice = new PaymentFormType.Choice();
            choice.setPaymentCard(SabreProfileServicesUtil.createPaymentCard(c, useCir));
            pft.setChoice(choice);
            res.add(pft);
        }
        if (CollectionUtil.isNotEmpty(originalPaymentFormTypes)) {
            List otherPaymentForms = originalPaymentFormTypes.stream().filter(type -> type.getChoice() != null && !type.getChoice().ifPaymentCard()).collect(Collectors.toList());
            SabreProfileServicesUtil.sortByOrderSequenceNumber(otherPaymentForms, PaymentFormType::getOrderSequenceNo);
            for (PaymentFormType otherPft : otherPaymentForms) {
                otherPft.setDisplaySequenceNo(String.valueOf(num));
                otherPft.setOrderSequenceNo(String.valueOf(num++));
                res.add(otherPft);
            }
        }
        return res;
    }

    private static void parsePaymentFormTypes(Person person, List<PaymentFormType> paymentFormTypes) throws Exception {
        if (CollectionUtil.isEmpty(paymentFormTypes)) {
            return;
        }
        SabreProfileServicesUtil.sortByOrderSequenceNumber(paymentFormTypes, PaymentFormType::getOrderSequenceNo);
        ArrayList<Card> cards = new ArrayList<Card>();
        SimpleDateFormat expirationDateFormat = new SimpleDateFormat("MMyyyy", LocaleUtil.LOCALE_EN);
        for (PaymentFormType pft : paymentFormTypes) {
            PaymentCardType pc;
            if (pft.getChoice() == null || pft.getChoice().getPaymentCard() == null) continue;
            Card card = new Card();
            if (TextUtil.nonBlank((String)pft.getInformationText())) {
                String informationText = pft.getInformationText();
                if (informationText.contains("SOF")) {
                    card.setSof(true);
                    informationText = informationText.replaceAll("/?SOF/?", "");
                }
                if (informationText.contains("BTA")) {
                    card.setBta(true);
                    informationText = informationText.replaceAll("/?BTA/?", "");
                }
                card.setRemarks(informationText);
            }
            if (TextUtil.nonBlank((String)(pc = pft.getChoice().getPaymentCard()).getCardNumber())) {
                if ("NOACCESS".equals(pc.getCardNumber())) {
                    throw new ServiceException("Access to credit cards in Sabre Profiles is denied");
                }
                if (pc.getCardNumber().contains("|")) {
                    String[] splitNumber = pc.getCardNumber().split("\\|");
                    card.setCirUid(splitNumber[0]);
                    card.setNumber(splitNumber[1]);
                } else {
                    card.setNumber(pc.getCardNumber());
                }
            }
            if (pc.getCardHolderName() != null && TextUtil.nonBlank((String)pc.getCardHolderName().getCardHolderFullName())) {
                card.setNameOnCard(pc.getCardHolderName().getCardHolderFullName());
            }
            if (TextUtil.nonBlank((String)pc.getExpireDate())) {
                card.setExpiration(expirationDateFormat.parse(pc.getExpireDate()));
            }
            card.setSabreVendorCode(pc.getBankCardVendorCode());
            card.setVendor((CardVendor)ProfileSynchronizationConstants.Abbr2Card.get(pc.getBankCardVendorCode()));
            cards.add(card);
        }
        person.getCards().clear();
        person.getCards().addAll(cards);
    }

    private static Collection<FilterPaymentFormType> createFilterPaymentFormTypes(List<Card> cards, boolean useCir) {
        ArrayList<FilterPaymentFormType> res = new ArrayList<FilterPaymentFormType>();
        int num = 1;
        for (Card c : cards) {
            if (TextUtil.isBlank((String)c.getNumber()) || !ProfileSynchronizationConstants.Card2Abbr.containsKey(c.getVendor()) && !TextUtil.nonBlank((String)c.getSabreVendorCode())) continue;
            FilterPaymentFormType pft = new FilterPaymentFormType();
            pft.setDisplaySequenceNo(String.valueOf(num));
            pft.setOrderSequenceNo(String.valueOf(num++));
            pft.setServiceUsageTypeCode("AL");
            pft.setTripTypeCode("AZ");
            FilterPaymentFormType.Choice choice = new FilterPaymentFormType.Choice();
            choice.setPaymentCard(SabreProfileServicesUtil.createFilterPaymentCard(c, useCir));
            pft.setChoice(choice);
            res.add(pft);
        }
        return res;
    }

    private static PaymentCardType createPaymentCard(Card c, boolean useCir) {
        PaymentCardType res = new PaymentCardType();
        if (!TextUtil.isBlank((String)c.getNameOnCard())) {
            res.setCardHolderName(SabreProfileServicesUtil.createCardHolderNameType(c.getNameOnCard()));
        } else {
            res.setCardHolderName(SabreProfileServicesUtil.createCardHolderNameType(" "));
        }
        String vendorCode = (String)ProfileSynchronizationConstants.Card2Abbr.get(c.getVendor());
        if (TextUtil.isBlank((String)vendorCode)) {
            vendorCode = c.getSabreVendorCode();
        }
        res.setBankCardVendorCode(vendorCode);
        if (useCir) {
            TextUtil.requireNonBlank((String)c.getCirUid(), () -> "Cir UID is absent for card " + c.getNumber());
            res.setCardNumber("{uid:" + c.getCirUid() + "}");
        } else {
            res.setCardNumber(c.getNumber());
        }
        if (c.getNumber().length() > 3) {
            res.setMaskedCardNumber(c.getNumber().substring(c.getNumber().length() - 4));
        }
        if (c.getExpiration() != null) {
            SimpleDateFormat sdf = new SimpleDateFormat("MMyyyy", LocaleUtil.LOCALE_EN);
            res.setExpireDate(sdf.format(c.getExpiration()));
        }
        return res;
    }

    private static FilterPaymentCardType createFilterPaymentCard(Card c, boolean useCir) {
        FilterPaymentCardType res = new FilterPaymentCardType();
        res.setCardHolderName(SabreProfileServicesUtil.createFilterCardHolderNameType(SP_FILTER_ANY_STRING));
        res.setBankCardVendorCode("*");
        res.setCardNumber(SP_FILTER_ANY_STRING);
        res.setExpireDate(SP_FILTER_ANY_DATE);
        res.setDisableCCAuthInd(YesNoType.Y);
        return res;
    }

    private static String createCardInformationTextString(boolean sof, boolean bta, String remarks) {
        StringBuilder result = new StringBuilder();
        if (sof) {
            result.append("SOF");
        }
        if (bta) {
            if (result.length() > 0) {
                result.append("/");
            }
            result.append("BTA");
        }
        if (TextUtil.nonBlank((String)remarks)) {
            if (result.length() > 0) {
                result.append("/");
            }
            result.append(remarks.toUpperCase());
        }
        return result.length() > 0 ? result.toString() : null;
    }

    private static CardHolderNameType createCardHolderNameType(String nameOnCard) {
        CardHolderNameType res = new CardHolderNameType();
        res.setCardHolderFullName(nameOnCard);
        return res;
    }

    private static FilterCardHolderNameType createFilterCardHolderNameType(String nameOnCard) {
        FilterCardHolderNameType res = new FilterCardHolderNameType();
        res.setCardHolderFullName(nameOnCard);
        return res;
    }

    private static List<PersonNameType> createPersonNameTypes(Person per) {
        ArrayList<PersonNameType> res = new ArrayList<PersonNameType>();
        PersonNameType pnt = new PersonNameType();
        String namePrefix = SabreProfileServicesUtil.createTitle(per);
        pnt.setNamePrefix(namePrefix);
        String firstName = ProfileSynchronizationUtil.removeSlashesAndHyphens((String)ProfileSynchronizationUtil.getEnglishOrNullValue((L10nString)per.getFirstName()));
        String lastName = ProfileSynchronizationUtil.getEnglishOrNullValue((L10nString)per.getLastName());
        String middleName = ProfileSynchronizationUtil.removeSlashesAndHyphens((String)ProfileSynchronizationUtil.getEnglishOrNullValue((L10nString)per.getMiddleName()));
        String secondName = ProfileSynchronizationUtil.removeSlashesAndHyphens((String)ProfileSynchronizationUtil.getEnglishOrNullValue((L10nString)per.getSecondName()));
        if (!TextUtil.isBlank((String)firstName)) {
            pnt.setPreferredFirstName(firstName.trim());
        }
        if (!TextUtil.isBlank((String)lastName)) {
            pnt.setPreferredSurname(ProfileSynchronizationUtil.removeSlashesAndHyphens((String)lastName).trim());
        }
        SabreProfileServicesUtil.cropNames(namePrefix, lastName, firstName, middleName, secondName, croppedLastName -> pnt.setSurName(croppedLastName), (croppedFirstName, croppedSecondName) -> {
            if (!TextUtil.isBlank((String)croppedFirstName)) {
                pnt.setGivenName(croppedFirstName.trim() + (!TextUtil.isBlank((String)croppedSecondName) ? " " + croppedSecondName.trim() : ""));
            }
        }, croppedMiddleName -> {
            if (!TextUtil.isBlank((String)croppedMiddleName)) {
                pnt.setMiddleName(croppedMiddleName.trim());
            }
        });
        pnt.setDisplaySequenceNo("1");
        pnt.setOrderSequenceNo("1");
        res.add(pnt);
        return res;
    }

    public static String createTitle(Person person) {
        String res = " ";
        if (person.getTitle() != null) {
            res = person.getTitle().name();
        } else if (person.getGender() != null && person.getGender().equals((Object)Gender.MALE)) {
            res = "MR";
        } else if (person.getGender() != null && person.getGender().equals((Object)Gender.FEMALE)) {
            res = "MRS";
        }
        return res;
    }

    private static void cropNames(String namePrefix, String lastName, String firstName, String middleName, String secondName, Consumer<String> lastNameSetter, BiConsumer<String, String> firstSecondNameSetter, Consumer<String> middleNameSetter) {
        if (!TextUtil.isBlank((String)lastName)) {
            if ((lastName = ProfileSynchronizationUtil.removeSpacesSlashesAndHyphens((String)lastName)).length() > 29) {
                lastName = lastName.substring(0, 29);
            }
            lastNameSetter.accept(lastName);
        }
        String otherNames = TextUtil.nonNullStr((String)firstName) + TextUtil.nonNullStr((String)secondName) + TextUtil.nonNullStr((String)middleName);
        int count = 29 - namePrefix.trim().length();
        while (otherNames.length() > count) {
            if (middleName != null && middleName.length() > 1) {
                middleName = middleName.substring(0, 1);
            } else if (!TextUtil.isBlank((String)secondName)) {
                secondName = "";
            } else {
                if (TextUtil.isBlank((String)firstName)) break;
                firstName = firstName.substring(0, firstName.length() - 1);
            }
            otherNames = TextUtil.nonNullStr((String)firstName) + TextUtil.nonNullStr((String)secondName) + TextUtil.nonNullStr((String)middleName);
        }
        firstSecondNameSetter.accept(firstName, secondName);
        middleNameSetter.accept(middleName);
    }

    private static void parsePersonNameTypes(Person person, List<PersonNameType> personNameTypes) {
        if (CollectionUtil.isEmpty(personNameTypes)) {
            return;
        }
        SabreProfileServicesUtil.sortByOrderSequenceNumber(personNameTypes, PersonNameType::getOrderSequenceNo);
        PersonNameType personNameType = personNameTypes.get(0);
        if (TextUtil.nonBlank((String)personNameType.getNamePrefix())) {
            person.setTitle((PersonTitle)EnumUtil.fromNameSafe(PersonTitle.class, (String)personNameType.getNamePrefix().trim(), (CaseInsensitive)CaseInsensitive.YES, null));
        }
        ProfileSynchronizationUtil.setEnglishValue((L10nString)person.getLastName(), (String)personNameType.getSurName());
        ProfileSynchronizationUtil.setEnglishValue((L10nString)person.getFirstName(), (String)personNameType.getGivenName());
        ProfileSynchronizationUtil.setEnglishValue((L10nString)person.getMiddleName(), (String)personNameType.getMiddleName());
    }

    private static void parseBirthday(Person person, java.sql.Date birthday) {
        person.setBirthday(MiscUtil.cloneDate((Date)birthday));
    }

    private static void parseGenderCode(Person person, String genderCode) {
        if (TextUtil.isBlank((String)genderCode)) {
            return;
        }
        switch (genderCode) {
            case "M": 
            case "MI": {
                person.setGender(Gender.MALE);
                break;
            }
            case "F": 
            case "FI": {
                person.setGender(Gender.FEMALE);
            }
        }
    }

    private static FilterPersonNameType createFilterPersonNameType(Person per) {
        FilterPersonNameType pnt = new FilterPersonNameType();
        pnt.setNamePrefix(SabreProfileServicesUtil.createTitle(per));
        if (!TextUtil.isBlank((String)ProfileSynchronizationUtil.removeSlashesAndHyphens((String)ProfileSynchronizationUtil.getEnglishOrNullValue((L10nString)per.getFirstName())))) {
            if (!TextUtil.isBlank((String)ProfileSynchronizationUtil.removeSlashesAndHyphens((String)ProfileSynchronizationUtil.getEnglishOrNullValue((L10nString)per.getSecondName())))) {
                pnt.setGivenName(ProfileSynchronizationUtil.removeSlashesAndHyphens((String)ProfileSynchronizationUtil.getEnglishOrNullValue((L10nString)per.getFirstName())) + " " + ProfileSynchronizationUtil.removeSlashesAndHyphens((String)ProfileSynchronizationUtil.getEnglishOrNullValue((L10nString)per.getSecondName())));
            } else {
                pnt.setGivenName(ProfileSynchronizationUtil.removeSlashesAndHyphens((String)ProfileSynchronizationUtil.getEnglishOrNullValue((L10nString)per.getFirstName())));
            }
        }
        if (!TextUtil.isBlank((String)ProfileSynchronizationUtil.removeSlashesAndHyphens((String)ProfileSynchronizationUtil.getEnglishOrNullValue((L10nString)per.getLastName())))) {
            pnt.setSurName(ProfileSynchronizationUtil.removeSlashesAndHyphens((String)ProfileSynchronizationUtil.getEnglishOrNullValue((L10nString)per.getLastName())));
        }
        pnt.setDisplaySequenceNo("1");
        pnt.setOrderSequenceNo("1");
        return pnt;
    }

    private static List<CustomerReferenceInfoType> createCustomerReferenceInfoTypes(String dkNumber) {
        ArrayList<CustomerReferenceInfoType> res = new ArrayList<CustomerReferenceInfoType>();
        int num = 1;
        CustomerReferenceInfoType crit = new CustomerReferenceInfoType();
        crit.setReferenceID(dkNumber);
        crit.setOrderSequenceNo(String.valueOf(num++));
        res.add(crit);
        return res;
    }

    private static FilterCustomerReferenceInfoType createFilterCustomerReferenceInfoTypes(String code) {
        FilterCustomerReferenceInfoType res = new FilterCustomerReferenceInfoType();
        int num = 1;
        res.setReferenceID(SP_FILTER_ANY_STRING);
        res.setBranchID(SP_FILTER_ANY_STRING);
        res.setOrderSequenceNo(String.valueOf(num));
        return res;
    }

    private static List<DiscountsType> createDiscountTypesFromTripartiteContracts(List<SabreProfilesDiscountData> data) {
        ArrayList<DiscountsType> res = new ArrayList<DiscountsType>();
        AtomicInteger num = new AtomicInteger(1);
        data.forEach(discountData -> {
            if (TextUtil.nonBlank((String)discountData.getVendorCode()) && discountData.getDiscountType() != null) {
                DiscountsType dt = new DiscountsType();
                dt.setID(discountData.getDiscountCode());
                dt.setEffectiveDate(MiscUtil.toSqlDate((Date)discountData.getEffectiveDate()));
                dt.setExpiryDate(MiscUtil.toSqlDate((Date)discountData.getExpiryDate()));
                dt.setVendorCode(discountData.getVendorCode());
                dt.setVendorTypeCode("AL");
                dt.setTypeCode(discountData.getDiscountType().name());
                dt.setOrderSequenceNo(String.valueOf(num.getAndIncrement()));
                dt.setInformationText(discountData.getInformationText());
                res.add(dt);
            }
        });
        return res;
    }

    private static List<DiscountsType> updateDiscountTypes(List<DiscountsType> originalDiscountsTypes, List<AirlineBonusCard> airlineBonusCards, List<HotelBonusCard> hotelBonusCards, List<CarBonusCard> carBonusCards, String clientID, boolean loadProfilesEnabled) {
        ArrayList<DiscountsType> res = new ArrayList<DiscountsType>();
        int num = 1;
        if (TextUtil.nonBlank((String)clientID)) {
            DiscountsType dt = new DiscountsType();
            dt.setID(clientID);
            dt.setOrderSequenceNo(String.valueOf(num++));
            dt.setTypeCode("CID");
            dt.setVendorCode("1S");
            dt.setVendorTypeCode("GD");
            res.add(dt);
        }
        for (AirlineBonusCard card : airlineBonusCards) {
            if (TextUtil.isBlank((String)card.getNumber()) || ValidationUtil.containsNonOnlyLatinLettersOrNumbers((String)card.getNumber())) continue;
            DiscountsType dt = SabreProfileServicesUtil.findDiscountType(originalDiscountsTypes, card.getNumber(), "AL");
            if (dt == null) {
                dt = new DiscountsType();
            }
            if (card.getAirline() != null) {
                dt.setVendorCode(card.getAirline().getCode());
            } else {
                dt.setVendorCode(null);
            }
            dt.setID(card.getNumber());
            dt.setVendorTypeCode("AL");
            dt.setOrderSequenceNo(String.valueOf(num++));
            res.add(dt);
        }
        if (CollectionUtil.isNotEmpty(originalDiscountsTypes)) {
            List<String> supportedVendorTypes = Arrays.asList("AL", "HL", "CR");
            SabreProfileServicesUtil.sortByOrderSequenceNumber(originalDiscountsTypes, DiscountsType::getOrderSequenceNo);
            for (DiscountsType originalDiscountsType : originalDiscountsTypes) {
                if (!loadProfilesEnabled && supportedVendorTypes.contains(originalDiscountsType.getVendorTypeCode())) continue;
                originalDiscountsType.setOrderSequenceNo(String.valueOf(num++));
                originalDiscountsType.setDisplaySequenceNo(null);
                res.add(originalDiscountsType);
            }
        }
        return res;
    }

    private static DiscountsType findDiscountType(List<DiscountsType> discountTypes, String membershipID, String vendorTypeCode) {
        if (discountTypes == null) {
            return null;
        }
        Iterator<DiscountsType> iterator = discountTypes.iterator();
        while (iterator.hasNext()) {
            DiscountsType discountsType = iterator.next();
            if (!MiscUtil.equals((Object)discountsType.getID(), (Object)membershipID) || !MiscUtil.equals((Object)discountsType.getVendorTypeCode(), (Object)vendorTypeCode)) continue;
            iterator.remove();
            return discountsType;
        }
        return null;
    }

    private static void parseDiscountTypes(Person person, List<DiscountsType> discountsTypes) {
        if (CollectionUtil.isEmpty(discountsTypes)) {
            return;
        }
        SabreProfileServicesUtil.sortByOrderSequenceNumber(discountsTypes, DiscountsType::getOrderSequenceNo);
        List airlineBonusCards = person.getAirlineBonusCards();
        List hotelBonusCards = person.getHotelBonusCards();
        List carBonusCards = person.getCarBonusCards();
        List railwayBonusCards = person.getRailwayBonusCards();
        for (DiscountsType discountsType : discountsTypes) {
            if (TextUtil.isBlank((String)discountsType.getVendorTypeCode())) continue;
            switch (discountsType.getVendorTypeCode()) {
                case "AL": {
                    if (airlineBonusCards.stream().anyMatch(d -> TextUtil.isSame((String)d.getNumber(), (String)discountsType.getID()))) break;
                    AirlineBonusCard card = new AirlineBonusCard();
                    if (TextUtil.nonBlank((String)discountsType.getID())) {
                        card.setNumber(discountsType.getID());
                    }
                    if (TextUtil.nonBlank((String)discountsType.getVendorCode())) {
                        card.setAirline((DictionaryReference)new AirlineReference(discountsType.getVendorCode()));
                    }
                    airlineBonusCards.add(card);
                    break;
                }
                case "HL": {
                    if (hotelBonusCards.stream().anyMatch(d -> TextUtil.isSame((String)d.getNumber(), (String)discountsType.getID()))) break;
                    AirlineBonusCard card = new HotelBonusCard();
                    if (TextUtil.nonBlank((String)discountsType.getID())) {
                        card.setNumber(discountsType.getID());
                    }
                    if (TextUtil.nonBlank((String)discountsType.getVendorCode())) {
                        card.setHotelBrand((DictionaryReference)new HotelsBrandReference(discountsType.getVendorCode()));
                    }
                    hotelBonusCards.add(card);
                    break;
                }
                case "CR": {
                    if (carBonusCards.stream().anyMatch(d -> TextUtil.isSame((String)d.getNumber(), (String)discountsType.getID()))) break;
                    AirlineBonusCard card = new CarBonusCard();
                    if (TextUtil.nonBlank((String)discountsType.getID())) {
                        card.setNumber(discountsType.getID());
                    }
                    if (TextUtil.nonBlank((String)discountsType.getVendorCode())) {
                        card.setCarSupplier((DictionaryReference)new CarsSupplierReference(discountsType.getVendorCode()));
                    }
                    carBonusCards.add(card);
                    break;
                }
                case "RL": {
                    if (railwayBonusCards.stream().anyMatch(d -> TextUtil.isSame((String)d.getNumber(), (String)discountsType.getID()))) break;
                    AirlineBonusCard card = new RailwayBonusCard();
                    if (TextUtil.nonBlank((String)discountsType.getID())) {
                        card.setNumber(discountsType.getID());
                    }
                    if (TextUtil.nonBlank((String)discountsType.getVendorCode())) {
                        card.setRailwayCarrierCode(discountsType.getVendorCode());
                    }
                    railwayBonusCards.add(card);
                    break;
                }
            }
        }
    }

    private static Collection<FilterDiscountsType> createFilterDiscountTypes(List<AirlineBonusCard> airlineBonusCards, List<HotelBonusCard> hotelBonusCards, List<CarBonusCard> carBonusCards, String clientID) {
        FilterDiscountsType dt;
        ArrayList<FilterDiscountsType> res = new ArrayList<FilterDiscountsType>();
        int num = 1;
        if (TextUtil.nonBlank((String)clientID)) {
            FilterDiscountsType dt2 = new FilterDiscountsType();
            dt2.setID(clientID);
            dt2.setOrderSequenceNo(String.valueOf(num++));
            dt2.setVendorCode("1S");
            res.add(dt2);
        }
        for (AirlineBonusCard airlineBonusCard : airlineBonusCards) {
            if (TextUtil.isBlank((String)airlineBonusCard.getNumber()) || ValidationUtil.containsNonOnlyLatinLettersOrNumbers((String)airlineBonusCard.getNumber())) continue;
            dt = new FilterDiscountsType();
            if (airlineBonusCard.getAirline() != null) {
                dt.setVendorCode(airlineBonusCard.getAirline().getCode());
            }
            dt.setID(airlineBonusCard.getNumber());
            dt.setOrderSequenceNo(String.valueOf(num++));
            res.add(dt);
        }
        for (HotelBonusCard hotelBonusCard : hotelBonusCards) {
            if (TextUtil.isBlank((String)hotelBonusCard.getNumber())) continue;
            dt = new FilterDiscountsType();
            if (hotelBonusCard.getHotelBrand() != null) {
                dt.setVendorCode(hotelBonusCard.getHotelBrand().getCode());
            }
            dt.setID(hotelBonusCard.getNumber());
            dt.setOrderSequenceNo(String.valueOf(num++));
            res.add(dt);
        }
        for (CarBonusCard carBonusCard : carBonusCards) {
            if (TextUtil.isBlank((String)carBonusCard.getNumber())) continue;
            dt = new FilterDiscountsType();
            if (carBonusCard.getCarSupplier() != null) {
                dt.setVendorCode(carBonusCard.getCarSupplier().getCode());
            }
            dt.setID(carBonusCard.getNumber());
            dt.setOrderSequenceNo(String.valueOf(num++));
            res.add(dt);
        }
        return res;
    }

    private static List<AirlinePrefType> createAirlinePrefTypes(List<SabreProfileLine> remarks, PreferredSuppliers suppliers) {
        AirlinePrefType apt;
        ArrayList<AirlinePrefType> res = new ArrayList<AirlinePrefType>();
        ArrayList<String> mealPrefs = new ArrayList<String>();
        ArrayList<String> seatPrefs = new ArrayList<String>();
        for (SabreProfileLine remark : remarks) {
            if (remark.getLineServiceType() == SabreProfileLineServiceType.M && !TextUtil.isBlank((String)remark.getLineSubsection())) {
                mealPrefs.add(remark.getLineSubsection());
            }
            if (remark.getLineServiceType() != SabreProfileLineServiceType.S || TextUtil.isBlank((String)remark.getLineSubsection())) continue;
            seatPrefs.add(remark.getLineSubsection());
        }
        int num = 1;
        for (String pref : mealPrefs) {
            apt = new AirlinePrefType();
            AirlineMealPrefType ampt = new AirlineMealPrefType();
            AirMealInfoType amit = new AirMealInfoType();
            amit.setMealTypeCode(pref.length() > 3 ? pref.substring(0, 4) : pref);
            ampt.setMealInfo(amit);
            apt.getAirlineMealPrefList().add(ampt);
            apt.setOrderSequenceNo(String.valueOf(num++));
            apt.setTripTypeCode("AZ");
            res.add(apt);
        }
        for (String pref : seatPrefs) {
            apt = new AirlinePrefType();
            AirlineSeatPrefType aspt = new AirlineSeatPrefType();
            AirlineSeatInfoType asit = new AirlineSeatInfoType();
            asit.setSeatPreferenceCode(pref.length() > 3 ? pref.substring(0, 4) : pref);
            aspt.setSeatInfo(asit);
            apt.getAirlineSeatPrefList().add(aspt);
            apt.setOrderSequenceNo(String.valueOf(num++));
            apt.setTripTypeCode("AZ");
            res.add(apt);
        }
        if (suppliers != null) {
            for (AirPreferences apt2 : suppliers.getAirPreferences()) {
                String vendor;
                Airline airline;
                if (apt2 == null || apt2.getSupplier() == null || (airline = (Airline)DictionaryCache.get().resolveReference(apt2.getSupplier())) == null || TextUtil.isBlank((String)(vendor = DictHelper.getCodeVariant((BaseDictionary)airline, (CodeSystem)CodeSystem.IATA))) || vendor.length() > 2) continue;
                PreferredAirlinesType prefType = new PreferredAirlinesType();
                prefType.setVendorCode(vendor);
                AirlinePrefType airlinePrefType = new AirlinePrefType();
                airlinePrefType.getPreferredAirlineList().add(prefType);
                airlinePrefType.setOrderSequenceNo(String.valueOf(num++));
                airlinePrefType.setTripTypeCode("AZ");
                res.add(airlinePrefType);
            }
        }
        return res;
    }

    private static List<HotelPrefType> createHotelPrefTypes(PreferredSuppliers suppliers) {
        ArrayList<HotelPrefType> res = new ArrayList<HotelPrefType>();
        int num = 1;
        if (suppliers != null) {
            for (HotelPreferences hpt : suppliers.getHotelPreferences()) {
                String vendor;
                HotelsBrand hotelsBrand;
                if (hpt == null || hpt.getSupplier() == null || (hotelsBrand = (HotelsBrand)DictionaryCache.get().resolveReference(hpt.getSupplier())) == null || TextUtil.isBlank((String)(vendor = DictHelper.getCode((BaseDictionary)hotelsBrand))) || vendor.length() > 2) continue;
                PreferredHotelType prefType = new PreferredHotelType();
                prefType.setHotelVendorCode(vendor);
                HotelPrefType hotelPrefType = new HotelPrefType();
                hotelPrefType.getPreferredHotelList().add(prefType);
                hotelPrefType.setOrderSequenceNo(String.valueOf(num++));
                hotelPrefType.setTripTypeCode("AZ");
                res.add(hotelPrefType);
            }
        }
        return res;
    }

    private static CorporateInfoType createCorporateInfoType(Organization org) {
        CorporateInfoType cit = new CorporateInfoType();
        cit.setCorporationName(TextUtil.isBlank((String)org.getSabreProfilesName()) ? ProfileSynchronizationUtil.getEnglishOrNullValue((L10nString)org.getShortName()) : ProfileSynchronizationUtil.removeIllegalSymbols((String)org.getSabreProfilesName(), (boolean)true));
        cit.setCorporationIdentifier(org.getCode());
        cit.setCorporationTypeCode("LRG");
        return cit;
    }

    private static List<PriorityRemarksType> createPriorityRemarksTypes(List<SabreProfileLine> remarks) {
        ArrayList<PriorityRemarksType> res = new ArrayList<PriorityRemarksType>();
        PriorityRemarksType remark = new PriorityRemarksType();
        for (SabreProfileLine r : remarks) {
            if (SabreProfileLineType.P != r.getLineType() || TextUtil.isBlank((String)r.getLineBody())) continue;
            String text = remark.getText() == null ? "" : remark.getText() + "&#10;";
            remark.setText(text + r.getLineBody());
        }
        if (remark.getText() != null) {
            res.add(remark);
        }
        return res;
    }

    private static boolean supportOldUdidRemarks(List<String> oldUdidRemarks, List<UdidRemark> udidRemarks) {
        if (udidRemarks.isEmpty()) {
            oldUdidRemarks.stream().map(remark -> {
                UdidRemark udidRemark = new UdidRemark();
                udidRemark.setValue(remark);
                return udidRemark;
            }).forEach(udidRemarks::add);
            return true;
        }
        return false;
    }

    private static Collection<? extends RemarkType> createRemarkTypesOrganization(Organization org, List<String> accountManagerRemarks, List<String> payersRemarks, List<String> oldUdidRemarks, List<UdidRemark> udidRemarks, Map<String, List<String>> contractRemarksMap, Map<String, List<String>> remarksMap, List<RailwayBonusCard> railwayBonusCards, List<SabreProfilesSynchronizationRequest.TransactionFeeGeneralRemark> transactionFeesForGeneralInfo, boolean useCir) {
        RemarkType remark;
        ArrayList<RemarkType> res = new ArrayList<RemarkType>();
        SabreProfileServicesUtil.supportOldUdidRemarks(oldUdidRemarks, udidRemarks);
        List<SabreProfileLineDataProxy> lines = SabreProfileServicesUtil.getOrganizationSabreProfileLines(org, accountManagerRemarks, payersRemarks, udidRemarks, contractRemarksMap, remarksMap, useCir);
        int num = 1;
        for (SabreProfileLineDataProxy line : lines) {
            if ("P".equals(line.getLineType())) continue;
            remark = new RemarkType();
            remark.setText(line.getLine());
            remark.setVITLineType(VITStarLineType.valueOf((String)line.getLineType()));
            remark.setCategoryCode("PNR");
            remark.setTypeCode("OT");
            remark.setOrderSequenceNo(String.valueOf(num));
            remark.setDisplaySequenceNo(String.valueOf(num));
            remark.setVITOrderNmbr(String.valueOf(num));
            ++num;
            res.add(remark);
        }
        num = 1;
        for (RailwayBonusCard card : railwayBonusCards) {
            if (TextUtil.isBlank((String)card.getNumber())) continue;
            remark = new RemarkType();
            remark.setTypeCode("DF");
            remark.setCategoryCode("RAL");
            remark.setOrderSequenceNo(String.valueOf(num));
            StringBuilder text = new StringBuilder();
            if (!TextUtil.isBlank((String)card.getRailwayCarrierCode())) {
                text.append(card.getRailwayCarrierCode());
            }
            text.append(card.getNumber());
            remark.setText(text.toString());
            ++num;
            res.add(remark);
        }
        for (SabreProfilesSynchronizationRequest.TransactionFeeGeneralRemark trFee : transactionFeesForGeneralInfo) {
            if (TextUtil.isBlank((String)trFee.getRemark())) continue;
            remark = new RemarkType();
            remark.setTypeCode("OS");
            remark.setCategoryCode(SabreProfileServicesUtil.getGeneralInfoCategoryForTarget(trFee.getTarget()));
            remark.setOrderSequenceNo(String.valueOf(num));
            remark.setText(trFee.getRemark());
            ++num;
            res.add(remark);
        }
        return res;
    }

    private static Collection<FilterRemarkType> createFilterRemarkTypesOrganization(Organization org, List<String> accountManagerRemarks, List<String> payersRemarks, List<String> oldUdidRemarks, List<UdidRemark> udidRemarks, Map<String, List<String>> contractRemarksMap, Map<String, List<String>> remarksMap, PNRBuilderSettings filterSettings, boolean useCir) {
        ArrayList<FilterRemarkType> res = new ArrayList<FilterRemarkType>();
        boolean useOldUdidRemarks = SabreProfileServicesUtil.supportOldUdidRemarks(oldUdidRemarks, udidRemarks);
        List<SabreProfileLineDataProxy> lines = SabreProfileServicesUtil.getOrganizationSabreProfileLines(org, accountManagerRemarks, payersRemarks, udidRemarks, contractRemarksMap, remarksMap, useCir);
        int num = 1;
        for (SabreProfileLineDataProxy line : lines) {
            if (SabreProfileServicesUtil.isRemarkAcceptable(line, filterSettings, useOldUdidRemarks)) {
                FilterRemarkType remark = new FilterRemarkType();
                remark.setText(SP_FILTER_ANY_STRING);
                remark.setCategoryCode("PNR");
                remark.setTypeCode("OT");
                remark.setOrderSequenceNo(String.valueOf(num));
                res.add(remark);
            }
            if ("P".equals(line.getLineType())) continue;
            ++num;
        }
        return res;
    }

    private static boolean isRemarkAcceptable(SabreProfileLineDataProxy lineProxy, PNRBuilderSettings filterSettings, boolean useOldUdidRemarks) {
        String line = lineProxy.getLine();
        String lineType = lineProxy.getLineType();
        if (line == null) {
            return false;
        }
        if (line.contains("PAYER") && filterSettings.isNeedPayers()) {
            return true;
        }
        if (line.startsWith("3DOCS") && filterSettings.isNeedDOCS()) {
            return true;
        }
        if (!line.contains("PAYER") && !line.startsWith("3DOCS") && filterSettings.isNeedOnlyAlwaysMoveRemarks() && "A".equals(lineType)) {
            if (lineProxy.isUdidRemark() && !useOldUdidRemarks) {
                return filterSettings.getUdidRemarks().contains(lineProxy.getUid());
            }
            return true;
        }
        if (!line.contains("PAYER") && !line.startsWith("3DOCS") && filterSettings.isNeedAllRemarks()) {
            if (lineProxy.isUdidRemark() && !useOldUdidRemarks) {
                return filterSettings.getUdidRemarks().contains(lineProxy.getUid());
            }
            return true;
        }
        return false;
    }

    private static List<SabreProfileLineDataProxy> getOrganizationSabreProfileLines(Organization org, List<String> accountManagerRemarks, List<String> payersRemarks, List<UdidRemark> udidRemarks, Map<String, List<String>> contractRemarksMap, Map<String, List<String>> remarksMap, boolean useCir) {
        String remark;
        List reasonCodeNoHotelList;
        List<String> contractList;
        ArrayList<SabreProfileLineDataProxy> lines = new ArrayList<SabreProfileLineDataProxy>();
        String keyForNoServiceList = "AAA";
        String brandCodeOwner = ProfileSynchronizationUtil.getBrandCodeOwnerString((Organization)org);
        String brandCodeValue = ProfileSynchronizationUtil.getBrandCodeValueString((Organization)org);
        if (!TextUtil.isBlank((String)brandCodeOwner)) {
            lines.add(new SabreProfileLineDataProxy("A", ProfileSynchronizationUtil.createBrandCodeOwnerRemark((String)brandCodeOwner)));
        }
        if (!TextUtil.isBlank((String)brandCodeValue)) {
            lines.add(new SabreProfileLineDataProxy("A", ProfileSynchronizationUtil.createBrandCodeValueRemark((String)brandCodeValue)));
        }
        List workModeList = ProfileSynchronizationUtil.createWorkModeLines((List)org.getWorkModes());
        for (String string : workModeList) {
            lines.add(new SabreProfileLineDataProxy("A", string));
        }
        if (accountManagerRemarks != null) {
            for (String string : accountManagerRemarks) {
                lines.add(new SabreProfileLineDataProxy("A", string));
            }
        }
        List platformsList = ProfileSynchronizationUtil.createServicePlatformList((List)org.getMetadata(), (String)"KEY_ORGANIZATION_SERVICE_PLATFORM");
        for (Object str : platformsList) {
            lines.add(new SabreProfileLineDataProxy("A", (String)str));
        }
        lines.addAll(ProfileSynchronizationUtil.createRemarkList(remarksMap, (String)ProfileSynchronizationUtil.getLineServiceTypeString((SabreProfileLineServiceType)SabreProfileLineServiceType.T), (String)keyForNoServiceList, (boolean)false));
        List list = ProfileSynchronizationUtil.createCreditCardList((List)org.getCards(), (boolean)useCir);
        for (Object str : list) {
            lines.add(new SabreProfileLineDataProxy("A", (String)str));
        }
        List carBonusCardsList = ProfileSynchronizationUtil.createCarBonusCardList((Collection)org.getCarBonusCards(), (boolean)false);
        for (Object str : carBonusCardsList) {
            lines.add(new SabreProfileLineDataProxy("A", (String)str));
        }
        List hotelBonusCardsList = ProfileSynchronizationUtil.createHotelBonusCardList((Collection)org.getHotelBonusCards(), (boolean)false);
        for (Iterator<UdidRemark> str : hotelBonusCardsList) {
            lines.add(new SabreProfileLineDataProxy("A", (String)((Object)str)));
        }
        List railwayBonusCardsList = ProfileSynchronizationUtil.createRailwayBonusCardList((Collection)org.getRailwayBonusCards(), (boolean)false);
        for (String str : railwayBonusCardsList) {
            lines.add(new SabreProfileLineDataProxy("A", str));
        }
        if (udidRemarks.size() > 0 && org.getTypes().contains(OrganizationType.CORPORATE_CLIENT)) {
            for (UdidRemark udidRemark : udidRemarks) {
                if (udidRemark.getValue() == null || udidRemark.getValue().contains("FOR UDID SCRIPT")) continue;
                SabreProfileLineDataProxy line = new SabreProfileLineDataProxy("A", udidRemark.getValue());
                line.setUdidRemark(true);
                line.setUid(udidRemark.getUid());
                lines.add(line);
            }
        }
        if ((contractList = contractRemarksMap.get("TRANSACTION FEES")) != null) {
            for (String str : contractList) {
                lines.add(new SabreProfileLineDataProxy("A", str));
            }
        }
        lines.addAll(ProfileSynchronizationUtil.createRemarkList(remarksMap, (String)ProfileSynchronizationUtil.getLineServiceTypeString((SabreProfileLineServiceType)SabreProfileLineServiceType.F), (String)keyForNoServiceList, (boolean)false));
        lines.addAll(ProfileSynchronizationUtil.createRemarkList(remarksMap, (String)ProfileSynchronizationUtil.getLineServiceTypeString((SabreProfileLineServiceType)SabreProfileLineServiceType.A), (String)keyForNoServiceList, (boolean)false));
        ArrayList sortedReasonCodes = new ArrayList(org.getReasonCodes());
        sortedReasonCodes.sort(ReasonCodeHelper.REASON_CODE_COMPARATOR);
        List reasonCodeAirList = ProfileSynchronizationUtil.createReasonCodeList(sortedReasonCodes, (ReasonCodeType)ReasonCodeType.REASON_CODE_AIR, (String)org.getAfsSettings());
        List reasonCodeDeclinedList = ProfileSynchronizationUtil.createReasonCodeList(sortedReasonCodes, (ReasonCodeType)ReasonCodeType.REASON_CODE_DECLINED, null);
        if (reasonCodeAirList.size() > 0 || reasonCodeDeclinedList.size() > 0) {
            if (!org.getTypes().contains(OrganizationType.CORPORATE_CLIENT) && reasonCodeAirList.size() > 0) {
                reasonCodeAirList.remove(0);
            }
            for (Object str : reasonCodeAirList) {
                lines.add(new SabreProfileLineDataProxy("A", (String)str));
            }
            for (Object str : reasonCodeDeclinedList) {
                lines.add(new SabreProfileLineDataProxy("A", (String)str));
            }
        }
        if ((reasonCodeNoHotelList = ProfileSynchronizationUtil.createReasonCodeList(sortedReasonCodes, (ReasonCodeType)ReasonCodeType.REASON_CODE_NO_HOTEL, null)).size() > 0) {
            for (Object str : reasonCodeNoHotelList) {
                lines.add(new SabreProfileLineDataProxy("A", (String)str));
            }
        }
        lines.addAll(ProfileSynchronizationUtil.createRemarkList(remarksMap, (String)ProfileSynchronizationUtil.getLineServiceTypeString((SabreProfileLineServiceType)SabreProfileLineServiceType.H), (String)keyForNoServiceList, (boolean)false));
        List reasonCodeHotelList = ProfileSynchronizationUtil.createReasonCodeList(sortedReasonCodes, (ReasonCodeType)ReasonCodeType.REASON_CODE_HOTEL, null);
        if (reasonCodeHotelList.size() > 0) {
            if (!org.getTypes().contains(OrganizationType.CORPORATE_CLIENT) && reasonCodeHotelList.size() > 0) {
                reasonCodeHotelList.remove(0);
            }
            for (Object str : reasonCodeHotelList) {
                lines.add(new SabreProfileLineDataProxy("A", (String)str));
            }
        }
        lines.addAll(ProfileSynchronizationUtil.createRemarkList(remarksMap, (String)ProfileSynchronizationUtil.getLineServiceTypeString((SabreProfileLineServiceType)SabreProfileLineServiceType.C), (String)keyForNoServiceList, (boolean)false));
        List reasonCodeCarList = ProfileSynchronizationUtil.createReasonCodeList(sortedReasonCodes, (ReasonCodeType)ReasonCodeType.REASON_CODE_CAR, null);
        if (reasonCodeCarList.size() > 0) {
            for (Object str : reasonCodeCarList) {
                lines.add(new SabreProfileLineDataProxy("A", (String)str));
            }
        }
        List railLines = ProfileSynchronizationUtil.createRemarkList(remarksMap, (String)ProfileSynchronizationUtil.getLineServiceTypeString((SabreProfileLineServiceType)SabreProfileLineServiceType.R), (String)keyForNoServiceList, (boolean)false);
        lines.addAll(railLines);
        if (railLines.size() > 0 && reasonCodeNoHotelList.size() > 0) {
            for (String str : reasonCodeNoHotelList) {
                lines.add(new SabreProfileLineDataProxy("A", str));
            }
        }
        lines.addAll(ProfileSynchronizationUtil.createRemarkList(remarksMap, (String)ProfileSynchronizationUtil.getLineServiceTypeString((SabreProfileLineServiceType)SabreProfileLineServiceType.G), (String)keyForNoServiceList, (boolean)false));
        lines.addAll(ProfileSynchronizationUtil.createRemarkList(remarksMap, (String)ProfileSynchronizationUtil.getLineServiceTypeString((SabreProfileLineServiceType)SabreProfileLineServiceType.E), (String)keyForNoServiceList, (boolean)false));
        lines.addAll(ProfileSynchronizationUtil.createRemarkList(remarksMap, (String)ProfileSynchronizationUtil.getLineServiceTypeString((SabreProfileLineServiceType)SabreProfileLineServiceType.N), (String)keyForNoServiceList, (boolean)false));
        lines.addAll(ProfileSynchronizationUtil.createRemarkList(remarksMap, (String)ProfileSynchronizationUtil.getLineServiceTypeString((SabreProfileLineServiceType)SabreProfileLineServiceType.D), (String)keyForNoServiceList, (boolean)false));
        List<String> paymentList = contractRemarksMap.get("PAYMENT");
        List paymentRemarks = ProfileSynchronizationUtil.createRemarkList(remarksMap, (String)ProfileSynchronizationUtil.getLineServiceTypeString((SabreProfileLineServiceType)SabreProfileLineServiceType.P), (String)keyForNoServiceList, (boolean)false);
        if (paymentList != null && paymentList.size() > 0 || paymentRemarks.size() > 0 || payersRemarks.size() > 0) {
            if (paymentList != null) {
                for (String string : paymentList) {
                    lines.add(new SabreProfileLineDataProxy("A", string));
                }
            }
            for (String string : payersRemarks) {
                StringBuilder sb = new StringBuilder(string);
                ProfileSynchronizationUtil.checkSymbols((StringBuilder)sb, (boolean)true);
                lines.add(new SabreProfileLineDataProxy("A", sb.toString()));
            }
            lines.addAll(paymentRemarks);
        }
        if (org.getTypes().contains(OrganizationType.CORPORATE_CLIENT)) {
            List seatCodes = ProfileSynchronizationUtil.createPreferencesCodeList((List)org.getSabreAdditionalProfileLines(), null, (SabreProfileLineServiceType)SabreProfileLineServiceType.S, null, (boolean)false);
            for (Iterator str : seatCodes) {
                lines.add(new SabreProfileLineDataProxy("A", (String)((Object)str)));
            }
        }
        lines.addAll(ProfileSynchronizationUtil.createRemarkList(remarksMap, (String)ProfileSynchronizationUtil.getLineServiceTypeString((SabreProfileLineServiceType)SabreProfileLineServiceType.O), (String)keyForNoServiceList, (boolean)true));
        List phones3OSI = ProfileSynchronizationUtil.createPhonesAndEmails3OSIs((Organization)org);
        phones3OSI.forEach(ssr -> lines.add(new SabreProfileLineDataProxy("A", ssr)));
        lines.addAll(ProfileSynchronizationUtil.createRemarkList(remarksMap, (String)ProfileSynchronizationUtil.getLineServiceTypeString((SabreProfileLineServiceType)SabreProfileLineServiceType.K), (String)keyForNoServiceList, (boolean)false));
        lines.addAll(ProfileSynchronizationUtil.createRemarkList(remarksMap, (String)ProfileSynchronizationUtil.getLineServiceTypeString((SabreProfileLineServiceType)SabreProfileLineServiceType.J), (String)keyForNoServiceList, (boolean)false));
        lines.addAll(ProfileSynchronizationUtil.createRemarkList(remarksMap, (String)ProfileSynchronizationUtil.getLineServiceTypeString((SabreProfileLineServiceType)SabreProfileLineServiceType.V), (String)keyForNoServiceList, (boolean)false));
        lines.addAll(ProfileSynchronizationUtil.createRemarkList(remarksMap, (String)ProfileSynchronizationUtil.getLineServiceTypeString((SabreProfileLineServiceType)SabreProfileLineServiceType.B), (String)keyForNoServiceList, (boolean)false));
        lines.addAll(ProfileSynchronizationUtil.createRemarkList(remarksMap, (String)ProfileSynchronizationUtil.getLineServiceTypeString((SabreProfileLineServiceType)SabreProfileLineServiceType.I), (String)keyForNoServiceList, (boolean)false));
        lines.addAll(ProfileSynchronizationUtil.createRemarkList(remarksMap, (String)ProfileSynchronizationUtil.getLineServiceTypeString((SabreProfileLineServiceType)SabreProfileLineServiceType.L), (String)keyForNoServiceList, (boolean)false));
        lines.addAll(ProfileSynchronizationUtil.createRemarkList(remarksMap, (String)ProfileSynchronizationUtil.getLineServiceTypeString((SabreProfileLineServiceType)SabreProfileLineServiceType.Q), (String)keyForNoServiceList, (boolean)false));
        lines.addAll(ProfileSynchronizationUtil.createRemarkList(remarksMap, (String)ProfileSynchronizationUtil.getLineServiceTypeString((SabreProfileLineServiceType)SabreProfileLineServiceType.W), (String)keyForNoServiceList, (boolean)false));
        lines.addAll(ProfileSynchronizationUtil.createRemarkList(remarksMap, (String)ProfileSynchronizationUtil.getLineServiceTypeString((SabreProfileLineServiceType)SabreProfileLineServiceType.Y), (String)keyForNoServiceList, (boolean)false));
        lines.addAll(ProfileSynchronizationUtil.createRemarkList(remarksMap, (String)ProfileSynchronizationUtil.getLineServiceTypeString((SabreProfileLineServiceType)SabreProfileLineServiceType.Z), (String)keyForNoServiceList, (boolean)false));
        lines.addAll(ProfileSynchronizationUtil.createRemarkList(remarksMap, (String)keyForNoServiceList, (String)keyForNoServiceList, (boolean)false));
        lines.addAll(ProfileSynchronizationUtil.createFreeTextRemarksList((List)org.getSabreFreeTextRemarks()));
        List list2 = ProfileSynchronizationUtil.createSabreAdditionalCommands((List)org.getSabreAdditionalCommand1Lines(), (List)org.getSabreAdditionalCommand2Lines(), (List)org.getSabreAdditionalCommand3Lines(), (List)org.getSabreAdditionalCommand4Lines());
        for (Object line : list2) {
            lines.add((SabreProfileLineDataProxy)line);
        }
        if (!TextUtil.isBlank((String)org.getSabreNotes())) {
            for (Object line : ProfileSynchronizationUtil.splitStringBySpace((String)org.getSabreNotes(), (int)55)) {
                remark = ProfileSynchronizationUtil.prepareRemarkForSabre((String)line, (String)"", (String)"5", (boolean)true);
                remark = remark.replaceAll("_", "");
                lines.add(new SabreProfileLineDataProxy("A", remark));
            }
        }
        if (!TextUtil.isBlank((String)org.getSabreNotesOptional())) {
            for (Object line : ProfileSynchronizationUtil.splitStringBySpace((String)org.getSabreNotesOptional(), (int)55)) {
                remark = ProfileSynchronizationUtil.prepareRemarkForSabre((String)line, (String)"", (String)"5", (boolean)true);
                remark = remark.replaceAll("_", "");
                lines.add(new SabreProfileLineDataProxy("O", remark));
            }
        }
        if (org.getCwtProfileData() != null && org.getCwtProfileData().isUseCwtPassiveSegmentScheme()) {
            String remark2 = ProfileSynchronizationUtil.prepareRemarkForSabre((String)"CWTCLIENT", (String)"", (String)"5.X*", (boolean)false);
            lines.add(new SabreProfileLineDataProxy("A", remark2));
        }
        if (org.getTypes().contains(OrganizationType.CORPORATE_CLIENT)) {
            String afsTimeWindow = ProfileSynchronizationUtil.createAfsTimeWindow((Organization)org);
            String afsAirports = ProfileSynchronizationUtil.createAfsAirports((Organization)org);
            if (afsTimeWindow != null) {
                lines.add(new SabreProfileLineDataProxy("A", afsTimeWindow));
            }
            if (afsAirports != null) {
                lines.add(new SabreProfileLineDataProxy("A", afsAirports));
            }
        }
        return lines;
    }

    private static List<RemarkType> createRemarkTypesPerson(Person per, List<String> oldUdidRemarks, List<UdidRemark> udidRemarks, Map<String, List<String>> remarksMap, Set<RiskManagementCompany> riskManagementCompanies, CwtOrganizationData cwtOrgData, boolean useCir) {
        RemarkType remark;
        ArrayList<RemarkType> res = new ArrayList<RemarkType>();
        SabreProfileServicesUtil.supportOldUdidRemarks(oldUdidRemarks, udidRemarks);
        List<SabreProfileLineDataProxy> lines = SabreProfileServicesUtil.getPersonSabreAdditionalProfileLines(per, udidRemarks, remarksMap, riskManagementCompanies, cwtOrgData, useCir);
        int num = 1;
        for (SabreProfileLineDataProxy line : lines) {
            if ("P".equals(line.getLineType())) continue;
            remark = new RemarkType();
            remark.setText(line.getLine());
            remark.setVITLineType(VITStarLineType.valueOf((String)line.getLineType()));
            remark.setCategoryCode("PNR");
            remark.setTypeCode("OT");
            remark.setOrderSequenceNo(String.valueOf(num));
            remark.setDisplaySequenceNo(String.valueOf(num));
            remark.setVITOrderNmbr(String.valueOf(num));
            ++num;
            res.add(remark);
        }
        num = 1;
        for (RailwayBonusCard card : per.getRailwayBonusCards()) {
            if (TextUtil.isBlank((String)card.getNumber())) continue;
            remark = new RemarkType();
            remark.setTypeCode("DF");
            remark.setCategoryCode("RAL");
            remark.setOrderSequenceNo(String.valueOf(num));
            StringBuilder text = new StringBuilder();
            if (!TextUtil.isBlank((String)card.getRailwayCarrierCode())) {
                text.append(card.getRailwayCarrierCode());
            }
            text.append(card.getNumber());
            remark.setText(text.toString());
            ++num;
            res.add(remark);
        }
        return res;
    }

    private static List<SabreProfileLineDataProxy> getPersonSabreAdditionalProfileLines(Person per, List<UdidRemark> udidRemarks, Map<String, List<String>> remarksMap, Set<RiskManagementCompany> riskManagementCompanies, CwtOrganizationData cwtOrgData, boolean useCir) {
        Map passportMap;
        ArrayList<SabreProfileLineDataProxy> lines = new ArrayList<SabreProfileLineDataProxy>();
        String keyForNoServiceList = "AAA";
        String lastName = ProfileSynchronizationUtil.getEnglishOrNullValue((L10nString)per.getLastName());
        String firstName = ProfileSynchronizationUtil.getEnglishOrNullValue((L10nString)per.getFirstName());
        String salutation = ProfileSynchronizationUtil.createSalutation((Person)per);
        boolean isInfant = ProfileHelper.isPersonInfant((Person)per);
        String nameLine = ProfileSynchronizationUtil.createPersonNameLine((String)lastName, (String)firstName, (String)salutation, (boolean)isInfant);
        Map map = passportMap = ProfileHelper.isPersonInfant((Person)per) ? ProfileSynchronizationUtil.createPassportStringsInfant((Person)per) : ProfileSynchronizationUtil.createPassportStrings((Person)per, (boolean)false);
        if (passportMap.containsKey(nameLine)) {
            List mainList = (List)passportMap.get(nameLine);
            for (String passportLine : mainList) {
                lines.add(new SabreProfileLineDataProxy("A", passportLine));
            }
        }
        SabreProfileServicesUtil.processPassportMap(lines, nameLine, passportMap);
        if (!isInfant) {
            List mealSSR = ProfileSynchronizationUtil.createSpecialServiceSSRs((Person)per, (SabreProfileLineServiceType)SabreProfileLineServiceType.M);
            for (Object ssr : mealSSR) {
                lines.add(new SabreProfileLineDataProxy("A", (String)ssr));
            }
        }
        if (!isInfant) {
            List phoneAndEmailSSR = ProfileSynchronizationUtil.createPhonesAndEmailsSSRs((Person)per);
            for (Object ssr : phoneAndEmailSSR) {
                lines.add(new SabreProfileLineDataProxy("A", (String)ssr));
            }
        }
        if (!riskManagementCompanies.isEmpty()) {
            List phoneAndEmailRiskManagement = ProfileSynchronizationUtil.createPhonesAndEmailsForRiskManagementCompanies((Person)per, riskManagementCompanies);
            for (Object ssr : phoneAndEmailRiskManagement) {
                lines.add(new SabreProfileLineDataProxy("A", (String)ssr));
            }
        }
        List phones3OSI = ProfileSynchronizationUtil.createPhonesAndEmails3OSIs((Person)per);
        for (Object ssr : phones3OSI) {
            lines.add(new SabreProfileLineDataProxy("A", (String)ssr));
        }
        List visaCommands = ProfileSynchronizationUtil.createVisasList((Person)per, (boolean)false);
        for (Object str : visaCommands) {
            lines.add(new SabreProfileLineDataProxy("A", (String)str));
        }
        lines.addAll(ProfileSynchronizationUtil.createRemarkList(remarksMap, (String)ProfileSynchronizationUtil.getLineServiceTypeString((SabreProfileLineServiceType)SabreProfileLineServiceType.K), (String)keyForNoServiceList, (boolean)false));
        List carBonusCardsList = ProfileSynchronizationUtil.createCarBonusCardList((Collection)per.getCarBonusCards(), (boolean)true);
        for (Object str : carBonusCardsList) {
            lines.add(new SabreProfileLineDataProxy("A", (String)str));
        }
        List hotelBonusCardsList = ProfileSynchronizationUtil.createHotelBonusCardList((Collection)per.getHotelBonusCards(), (boolean)true);
        for (Iterator<UdidRemark> str : hotelBonusCardsList) {
            lines.add(new SabreProfileLineDataProxy("A", (String)((Object)str)));
        }
        List railwayBonusCardsList = ProfileSynchronizationUtil.createRailwayBonusCardList((Collection)per.getRailwayBonusCards(), (boolean)true);
        for (String string : railwayBonusCardsList) {
            lines.add(new SabreProfileLineDataProxy("A", string));
        }
        for (UdidRemark udidRemark : udidRemarks) {
            if (udidRemark.getValue() == null || udidRemark.getValue().contains("FOR UDID SCRIPT")) continue;
            SabreProfileLineDataProxy line = new SabreProfileLineDataProxy("A", udidRemark.getValue());
            line.setUdidRemark(true);
            line.setUid(udidRemark.getUid());
            lines.add(line);
        }
        if (!TextUtil.isBlank((String)per.getCode())) {
            lines.add(new SabreProfileLineDataProxy("A", "5.X*TRAVELERID*" + per.getCode() + "*"));
        }
        List visaRemarks = ProfileSynchronizationUtil.createVisaRemarksList((List)per.getSabreAdditionalProfileLines());
        for (String str : visaRemarks) {
            lines.add(new SabreProfileLineDataProxy("O", str));
        }
        ArrayList arrayList = new ArrayList();
        ArrayList sabreContactsEmails = new ArrayList();
        ProfileSynchronizationUtil.createSabreContactsAsRemarksList((Person)per, arrayList, sabreContactsEmails);
        lines.addAll(ProfileSynchronizationUtil.createRemarkList(remarksMap, (String)ProfileSynchronizationUtil.getLineServiceTypeString((SabreProfileLineServiceType)SabreProfileLineServiceType.A), (String)keyForNoServiceList, (boolean)false));
        lines.addAll(ProfileSynchronizationUtil.createRemarkList(remarksMap, (String)ProfileSynchronizationUtil.getLineServiceTypeString((SabreProfileLineServiceType)SabreProfileLineServiceType.B), (String)keyForNoServiceList, (boolean)false));
        lines.addAll(ProfileSynchronizationUtil.createRemarkList(remarksMap, (String)ProfileSynchronizationUtil.getLineServiceTypeString((SabreProfileLineServiceType)SabreProfileLineServiceType.C), (String)keyForNoServiceList, (boolean)false));
        lines.addAll(ProfileSynchronizationUtil.createRemarkList(remarksMap, (String)ProfileSynchronizationUtil.getLineServiceTypeString((SabreProfileLineServiceType)SabreProfileLineServiceType.D), (String)keyForNoServiceList, (boolean)false));
        lines.addAll(ProfileSynchronizationUtil.createRemarkList(remarksMap, (String)ProfileSynchronizationUtil.getLineServiceTypeString((SabreProfileLineServiceType)SabreProfileLineServiceType.E), (String)keyForNoServiceList, (boolean)false));
        lines.addAll(ProfileSynchronizationUtil.createRemarkList(remarksMap, (String)ProfileSynchronizationUtil.getLineServiceTypeString((SabreProfileLineServiceType)SabreProfileLineServiceType.F), (String)keyForNoServiceList, (boolean)false));
        lines.addAll(ProfileSynchronizationUtil.createRemarkList(remarksMap, (String)ProfileSynchronizationUtil.getLineServiceTypeString((SabreProfileLineServiceType)SabreProfileLineServiceType.G), (String)keyForNoServiceList, (boolean)false));
        lines.addAll(ProfileSynchronizationUtil.createRemarkList(remarksMap, (String)ProfileSynchronizationUtil.getLineServiceTypeString((SabreProfileLineServiceType)SabreProfileLineServiceType.H), (String)keyForNoServiceList, (boolean)false));
        lines.addAll(ProfileSynchronizationUtil.createRemarkList(remarksMap, (String)ProfileSynchronizationUtil.getLineServiceTypeString((SabreProfileLineServiceType)SabreProfileLineServiceType.I), (String)keyForNoServiceList, (boolean)false));
        lines.addAll(ProfileSynchronizationUtil.createRemarkList(remarksMap, (String)ProfileSynchronizationUtil.getLineServiceTypeString((SabreProfileLineServiceType)SabreProfileLineServiceType.J), (String)keyForNoServiceList, (boolean)false));
        lines.addAll(arrayList);
        lines.addAll(ProfileSynchronizationUtil.createRemarkList(remarksMap, (String)ProfileSynchronizationUtil.getLineServiceTypeString((SabreProfileLineServiceType)SabreProfileLineServiceType.L), (String)keyForNoServiceList, (boolean)false));
        lines.addAll(ProfileSynchronizationUtil.createRemarkList(remarksMap, (String)ProfileSynchronizationUtil.getLineServiceTypeString((SabreProfileLineServiceType)SabreProfileLineServiceType.N), (String)keyForNoServiceList, (boolean)false));
        lines.addAll(ProfileSynchronizationUtil.createRemarkList(remarksMap, (String)ProfileSynchronizationUtil.getLineServiceTypeString((SabreProfileLineServiceType)SabreProfileLineServiceType.O), (String)keyForNoServiceList, (boolean)false));
        lines.addAll(ProfileSynchronizationUtil.createRemarkList(remarksMap, (String)ProfileSynchronizationUtil.getLineServiceTypeString((SabreProfileLineServiceType)SabreProfileLineServiceType.P), (String)keyForNoServiceList, (boolean)false));
        List cwtDataList = ProfileSynchronizationUtil.createCWTPersonRemarks((CwtOrganizationData)cwtOrgData, (CwtPersonData)per.getCwtProfileData());
        for (Object str : cwtDataList) {
            lines.add(new SabreProfileLineDataProxy("A", (String)str));
        }
        lines.addAll(ProfileSynchronizationUtil.createRemarkList(remarksMap, (String)ProfileSynchronizationUtil.getLineServiceTypeString((SabreProfileLineServiceType)SabreProfileLineServiceType.Q), (String)keyForNoServiceList, (boolean)false));
        List mealCodes = ProfileSynchronizationUtil.createPreferencesCodeList((List)per.getSabreAdditionalProfileLines(), (String)nameLine, (SabreProfileLineServiceType)SabreProfileLineServiceType.M, (String)"MEAL.CODE.*", (boolean)true);
        if (mealCodes.size() > 0) {
            for (Object str : mealCodes) {
                lines.add(new SabreProfileLineDataProxy("A", (String)str));
            }
        } else {
            Object str;
            str = ProfileSynchronizationUtil.prepareRemarkForSabre((String)"SKIP MEAL", (String)ProfileSynchronizationUtil.getLineServiceTypeString((SabreProfileLineServiceType)SabreProfileLineServiceType.M), (String)"5", (boolean)true);
            lines.add(new SabreProfileLineDataProxy("A", (String)str));
        }
        lines.addAll(ProfileSynchronizationUtil.createRemarkList(remarksMap, (String)ProfileSynchronizationUtil.getLineServiceTypeString((SabreProfileLineServiceType)SabreProfileLineServiceType.R), (String)keyForNoServiceList, (boolean)false));
        List seatCodes = ProfileSynchronizationUtil.createPreferencesCodeList((List)per.getSabreAdditionalProfileLines(), (String)nameLine, (SabreProfileLineServiceType)SabreProfileLineServiceType.S, (String)"SEAT.CODE.*", (boolean)true);
        if (seatCodes.size() > 0) {
            for (String str : seatCodes) {
                lines.add(new SabreProfileLineDataProxy("A", str));
            }
        } else {
            Object str;
            str = ProfileSynchronizationUtil.prepareRemarkForSabre((String)"SKIP SEAT", (String)ProfileSynchronizationUtil.getLineServiceTypeString((SabreProfileLineServiceType)SabreProfileLineServiceType.S), (String)"5", (boolean)true);
            lines.add(new SabreProfileLineDataProxy("A", (String)str));
        }
        lines.addAll(ProfileSynchronizationUtil.createRemarkList(remarksMap, (String)ProfileSynchronizationUtil.getLineServiceTypeString((SabreProfileLineServiceType)SabreProfileLineServiceType.T), (String)keyForNoServiceList, (boolean)false));
        lines.addAll(ProfileSynchronizationUtil.createRemarkList(remarksMap, (String)ProfileSynchronizationUtil.getLineServiceTypeString((SabreProfileLineServiceType)SabreProfileLineServiceType.W), (String)keyForNoServiceList, (boolean)false));
        lines.addAll(sabreContactsEmails);
        lines.addAll(ProfileSynchronizationUtil.createRemarkList(remarksMap, (String)ProfileSynchronizationUtil.getLineServiceTypeString((SabreProfileLineServiceType)SabreProfileLineServiceType.Y), (String)keyForNoServiceList, (boolean)false));
        lines.addAll(ProfileSynchronizationUtil.createRemarkList(remarksMap, (String)ProfileSynchronizationUtil.getLineServiceTypeString((SabreProfileLineServiceType)SabreProfileLineServiceType.Z), (String)keyForNoServiceList, (boolean)false));
        lines.addAll(ProfileSynchronizationUtil.createRemarkList(remarksMap, (String)keyForNoServiceList, (String)keyForNoServiceList, (boolean)false));
        lines.addAll(ProfileSynchronizationUtil.createFreeTextRemarksList((List)per.getSabreFreeTextRemarks()));
        List additionalCommands = ProfileSynchronizationUtil.createSabreAdditionalCommands(Collections.emptyList(), (List)per.getSabreAdditionalCommand2Lines(), Collections.emptyList(), (List)per.getSabreAdditionalCommand4Lines());
        for (SabreProfileLineDataProxy line : additionalCommands) {
            lines.add(line);
        }
        return lines;
    }

    protected static void processPassportMap(List<SabreProfileLineDataProxy> lines, String nameLine, Map<String, List<String>> passportMap) {
        for (Map.Entry<String, List<String>> entry : passportMap.entrySet()) {
            List<String> value;
            String key = entry.getKey();
            if (key.equals(nameLine)) continue;
            List<String> altList = value = entry.getValue();
            for (String passportLine : altList) {
                lines.add(new SabreProfileLineDataProxy("A", passportLine));
            }
        }
    }

    private static Collection<FilterRemarkType> createFilterRemarkTypesPerson(Person per, List<String> oldUdidRemarks, List<UdidRemark> udidRemarks, Map<String, List<String>> remarksMap, PNRBuilderSettings filterSettings, Set<RiskManagementCompany> riskManagementCompanies, CwtOrganizationData cwtOrgData, boolean useCir) {
        ArrayList<FilterRemarkType> res = new ArrayList<FilterRemarkType>();
        boolean useOldUdidRemarks = SabreProfileServicesUtil.supportOldUdidRemarks(oldUdidRemarks, udidRemarks);
        List<SabreProfileLineDataProxy> lines = SabreProfileServicesUtil.getPersonSabreAdditionalProfileLines(per, udidRemarks, remarksMap, riskManagementCompanies, cwtOrgData, useCir);
        int num = 1;
        for (SabreProfileLineDataProxy line : lines) {
            if (SabreProfileServicesUtil.isRemarkAcceptable(line, filterSettings, useOldUdidRemarks)) {
                FilterRemarkType remark = new FilterRemarkType();
                remark.setText(SP_FILTER_ANY_STRING);
                remark.setCategoryCode("PNR");
                remark.setTypeCode("OT");
                remark.setOrderSequenceNo(String.valueOf(num));
                res.add(remark);
            }
            if ("P".equals(line.getLineType())) continue;
            ++num;
        }
        return res;
    }

    private static List<ContactType> createContactTypes(List<SabreProfilesPersonKeyContact> list) {
        ArrayList<ContactType> res = new ArrayList<ContactType>();
        int num = 1;
        for (SabreProfilesPersonKeyContact p : list) {
            if (TextUtil.isBlank((String)SabreProfileServicesUtil.checkSymbols(p.getPhone(), false, false)) && TextUtil.isBlank((String)SabreProfileServicesUtil.checkSymbols(p.getEmail(), false, false))) continue;
            ContactType contact = new ContactType();
            if (!TextUtil.isBlank((String)SabreProfileServicesUtil.checkSymbols(p.getPhone(), false, false))) {
                TelephoneType phone = new TelephoneType();
                phone.setDeviceTypeCode(SabreProfileServicesUtil.getDeviceTypeCodeByCommType(p.getPhoneType()));
                phone.setLocationTypeCode(SabreProfileServicesUtil.getLocationTypeCodeByCommType(p.getPhoneType()));
                phone.setFullPhoneNumber(SabreProfileServicesUtil.checkSymbols(p.getPhone(), false, false));
                contact.getTelephoneList().add(phone);
            }
            if (!TextUtil.isBlank((String)SabreProfileServicesUtil.checkSymbols(p.getEmail(), false, false))) {
                EmailType email = new EmailType();
                email.setEmailAddress(SabreProfileServicesUtil.checkSymbols(p.getEmail(), false, false));
                email.setEmailTypeCode("EMG");
                contact.getEmailList().add(email);
            }
            if (!TextUtil.isBlank((String)SabreProfileServicesUtil.checkSymbols(p.getFirstName(), false, false))) {
                contact.setGivenName(SabreProfileServicesUtil.checkSymbols(p.getFirstName(), false, false));
            } else {
                contact.setGivenName(" ");
            }
            if (!TextUtil.isBlank((String)SabreProfileServicesUtil.checkSymbols(p.getLastName(), false, false))) {
                contact.setSurName(SabreProfileServicesUtil.checkSymbols(p.getLastName(), false, false));
            } else {
                contact.setSurName(" ");
            }
            if (!TextUtil.isBlank((String)SabreProfileServicesUtil.checkSymbols(p.getPosition(), false, false))) {
                contact.setInformationText(SabreProfileServicesUtil.checkSymbols(p.getPosition(), false, false));
            }
            contact.setOrderSequenceNo(String.valueOf(num++));
            res.add(contact);
        }
        return res;
    }

    private static List<EmailType> createEmailTypes(List<? extends Communication> communications, Locale locale) {
        ArrayList<EmailType> res = new ArrayList<EmailType>();
        int num = 1;
        for (Communication communication : communications) {
            String remarks;
            if (CommunicationType.EMAIL != communication.getType() || TextUtil.isBlank((String)ProfileSynchronizationUtil.removeIllegalSymbolsEmail((String)communication.getSense()))) continue;
            EmailType email = new EmailType();
            email.setEmailAddress(ProfileSynchronizationUtil.removeIllegalSymbolsEmail((String)communication.getSense()));
            email.setEmailTypeCode(SabreProfileServicesUtil.getLocationTypeCodeByCommType(communication.getType()));
            String loc = locale != null ? ProfileSynchronizationUtil.getLanguageForEmailNewChangeSign((Locale)locale) : "";
            String string = remarks = communication.getRemarks() != null ? communication.getRemarks().trim() : "";
            if (!TextUtil.isBlank((String)SabreProfileServicesUtil.checkSymbols(remarks, true, false)) || !TextUtil.isBlank((String)loc)) {
                email.setEmailRemark(SabreProfileServicesUtil.checkSymbols(remarks, true, false) + loc);
            }
            email.setOrderSequenceNo(String.valueOf(num++));
            res.add(email);
        }
        return res;
    }

    private static void parseEmailTypes(Person person, List<EmailType> emailTypes) {
        if (CollectionUtil.isEmpty(emailTypes)) {
            return;
        }
        SabreProfileServicesUtil.sortByOrderSequenceNumber(emailTypes, EmailType::getOrderSequenceNo);
        ArrayList<PersonCommunication> emails = new ArrayList<PersonCommunication>();
        for (EmailType emailType : emailTypes) {
            if (TextUtil.isBlank((String)emailType.getEmailAddress())) continue;
            PersonCommunication email = new PersonCommunication();
            email.setType(CommunicationType.EMAIL);
            email.setSense(emailType.getEmailAddress());
            String remark = emailType.getEmailRemark();
            if (remark != null && remark.contains(String.valueOf('\u00a4'))) {
                remark = remark.substring(0, remark.indexOf(164));
            }
            email.setRemarks(remark);
            emails.add(email);
        }
        person.getCommunications().addAll(emails);
    }

    private static Collection<FilterEmailType> createFilterEmailTypes(List<? extends Communication> communications, Locale locale) {
        ArrayList<FilterEmailType> res = new ArrayList<FilterEmailType>();
        int num = 1;
        for (Communication communication : communications) {
            String remarks;
            if (CommunicationType.EMAIL != communication.getType() || TextUtil.isBlank((String)SabreProfileServicesUtil.checkSymbols(communication.getSense(), true, false))) continue;
            FilterEmailType email = new FilterEmailType();
            email.setEmailAddress(SabreProfileServicesUtil.checkSymbols(communication.getSense(), true, false));
            email.setEmailTypeCode(SabreProfileServicesUtil.getLocationTypeCodeByCommType(communication.getType()));
            String loc = locale != null ? ProfileSynchronizationUtil.getLanguageForEmailNewChangeSign((Locale)locale) : "";
            String string = remarks = communication.getRemarks() != null ? communication.getRemarks().trim() : "";
            if (!TextUtil.isBlank((String)SabreProfileServicesUtil.checkSymbols(remarks, true, false)) || !TextUtil.isBlank((String)loc)) {
                email.setEmailRemark(SabreProfileServicesUtil.checkSymbols(remarks, true, false) + loc);
            }
            email.setOrderSequenceNo(String.valueOf(num++));
            res.add(email);
        }
        return res;
    }

    private static List<TelephoneType> createTelephoneTypes(List<? extends Communication> communications) {
        ArrayList<TelephoneType> res = new ArrayList<TelephoneType>();
        int num = 1;
        for (Communication communication : communications) {
            if (communication.getType() == null || communication.getType() == CommunicationType.EMAIL || communication.getType() == CommunicationType.WEB || !TextUtil.nonBlank((String)communication.getSense())) continue;
            TelephoneType phone = new TelephoneType();
            phone.setDeviceTypeCode(SabreProfileServicesUtil.getDeviceTypeCodeByCommType(communication.getType()));
            phone.setLocationTypeCode(SabreProfileServicesUtil.getLocationTypeCodeByCommType(communication.getType()));
            ParsedPhoneNumberType number = new ParsedPhoneNumberType();
            number.setPhoneNumber(SabreProfileServicesUtil.checkSymbolsNumbers(communication.getSense()));
            if (!TextUtil.isBlank((String)SabreProfileServicesUtil.checkSymbolsNumbers(communication.getCountryCode()))) {
                if (!communication.getCountryCode().matches("[0-9]{1,5}")) continue;
                number.setCountryCd(SabreProfileServicesUtil.checkSymbolsNumbers(communication.getCountryCode()));
            }
            if (!TextUtil.isBlank((String)SabreProfileServicesUtil.checkSymbolsNumbers(communication.getCityCode()))) {
                number.setAreaCd(SabreProfileServicesUtil.checkSymbolsNumbers(communication.getCityCode()));
            }
            if (!TextUtil.isBlank((String)SabreProfileServicesUtil.checkSymbolsNumbers(communication.getInternalNumber()))) {
                number.setExtension(SabreProfileServicesUtil.checkSymbolsNumbers(communication.getInternalNumber()));
            }
            phone.setParsedPhoneNumber(number);
            if (!TextUtil.isBlank((String)SabreProfileServicesUtil.checkSymbols(communication.getRemarks(), true, false))) {
                phone.setInformationText(SabreProfileServicesUtil.checkSymbols(communication.getRemarks(), true, false));
            }
            phone.setOrderSequenceNo(String.valueOf(num++));
            phone.setPNRTelephoneTagIndicator(YesNoType.Y);
            res.add(phone);
        }
        return res;
    }

    private static void parseTelephoneTypes(Person person, List<TelephoneType> telephoneTypes) {
        if (CollectionUtil.isEmpty(telephoneTypes)) {
            return;
        }
        SabreProfileServicesUtil.sortByOrderSequenceNumber(telephoneTypes, TelephoneType::getOrderSequenceNo);
        ArrayList<PersonCommunication> phones = new ArrayList<PersonCommunication>();
        for (TelephoneType telephoneType : telephoneTypes) {
            PersonCommunication phone = new PersonCommunication();
            ParsedPhoneNumberType parsedPhoneNumber = telephoneType.getParsedPhoneNumber();
            if (parsedPhoneNumber != null) {
                phone.setCountryCode(parsedPhoneNumber.getCountryCd());
                phone.setCityCode(parsedPhoneNumber.getAreaCd());
                phone.setSense(parsedPhoneNumber.getPhoneNumber());
                phone.setInternalNumber(parsedPhoneNumber.getExtension());
            } else {
                phone.setSense(telephoneType.getFullPhoneNumber());
            }
            phone.setType(SabreProfileServicesUtil.getCommTypeByLocationTypeCode(telephoneType.getLocationTypeCode()));
            phone.setRemarks(telephoneType.getInformationText());
            phones.add(phone);
        }
        person.getCommunications().addAll(phones);
    }

    private static Collection<FilterTelephoneType> createFilterTelephoneTypes(List<? extends Communication> communications) {
        ArrayList<FilterTelephoneType> res = new ArrayList<FilterTelephoneType>();
        int num = 1;
        for (Communication communication : communications) {
            if (communication.getType() == null || communication.getType() == CommunicationType.EMAIL || communication.getType() == CommunicationType.WEB || TextUtil.isBlank((String)communication.getSense())) continue;
            FilterTelephoneType phone = new FilterTelephoneType();
            phone.setLocationTypeCode(SabreProfileServicesUtil.getLocationTypeCodeByCommType(communication.getType()));
            ParsedPhoneNumberType number = new ParsedPhoneNumberType();
            number.setPhoneNumber(SP_FILTER_ANY_STRING);
            number.setAreaCd(SP_FILTER_ANY_NUMERIC_STRING);
            number.setCountryCd(SP_FILTER_ANY_NUMERIC_STRING);
            number.setExtension(SP_FILTER_ANY_NUMERIC_STRING);
            phone.setParsedPhoneNumber(number);
            if (!TextUtil.isBlank((String)SabreProfileServicesUtil.checkSymbols(communication.getRemarks(), true, false))) {
                phone.setInformationText(SabreProfileServicesUtil.checkSymbols(communication.getRemarks(), true, false));
            }
            phone.setOrderSequenceNo(String.valueOf(num++));
            phone.setPNRTelephoneTagIndicator(YesNoType.Y);
            res.add(phone);
        }
        return res;
    }

    private static ContactType findPhoneContactType(List<ContactType> contactTypes, String phone) {
        if (contactTypes == null) {
            return null;
        }
        for (ContactType contactType : contactTypes) {
            if (contactType.getTelephoneList() == null) continue;
            Iterator iterator = contactType.getTelephoneList().iterator();
            while (iterator.hasNext()) {
                TelephoneType telephoneType = (TelephoneType)iterator.next();
                if (!TextUtil.isSame((String)phone, (String)SabreProfileServicesUtil.getPhoneNumber(telephoneType))) continue;
                ContactType result = SabreProfileServicesUtil.copyFrom(contactType);
                result.getTelephoneList().add(telephoneType);
                iterator.remove();
                return result;
            }
        }
        return null;
    }

    private static ContactType findEmailContactType(List<ContactType> contactTypes, String email) {
        if (contactTypes == null) {
            return null;
        }
        for (ContactType contactType : contactTypes) {
            if (contactType.getEmailList() == null) continue;
            Iterator iterator = contactType.getEmailList().iterator();
            while (iterator.hasNext()) {
                EmailType emailType = (EmailType)iterator.next();
                if (!TextUtil.isSame((String)email, (String)emailType.getEmailAddress())) continue;
                ContactType result = SabreProfileServicesUtil.copyFrom(contactType);
                result.getEmailList().add(emailType);
                iterator.remove();
                return result;
            }
        }
        return null;
    }

    private static ContactType copyFrom(ContactType contactType) {
        ContactType result = new ContactType();
        result.setNamePrefix(contactType.getNamePrefix());
        result.setGivenName(contactType.getGivenName());
        result.setSurName(contactType.getSurName());
        result.setMiddleName(contactType.getMiddleName());
        result.setNameSuffix(contactType.getNameSuffix());
        result.setDataSource(contactType.getDataSource());
        result.setTransactionalData(contactType.getTransactionalData());
        result.setRelationType(contactType.getRelationType());
        result.setRelationTypeCode(contactType.getRelationTypeCode());
        result.setBirthDate(contactType.getBirthDate());
        result.setDisplaySequenceNo(contactType.getDisplaySequenceNo());
        return result;
    }

    private static String getPhoneNumber(TelephoneType telephoneType) {
        if (telephoneType.getParsedPhoneNumber() != null) {
            ParsedPhoneNumberType parsedPhoneNumber = telephoneType.getParsedPhoneNumber();
            String result = "";
            if (TextUtil.nonBlank((String)parsedPhoneNumber.getCountryCd())) {
                result = result + parsedPhoneNumber.getCountryCd().trim();
            }
            if (TextUtil.nonBlank((String)parsedPhoneNumber.getAreaCd())) {
                result = result + parsedPhoneNumber.getAreaCd().trim();
            }
            if (TextUtil.nonBlank((String)parsedPhoneNumber.getPhoneNumber())) {
                result = result + parsedPhoneNumber.getPhoneNumber().trim();
            }
            if (TextUtil.nonBlank((String)parsedPhoneNumber.getExtension())) {
                result = result + parsedPhoneNumber.getExtension().trim();
            }
            return result;
        }
        return telephoneType.getFullPhoneNumber();
    }

    private static List<ContactType> updateTelephoneTypesSabrePhonesAndEmails(List<ContactType> originalEmergencyContacts, List<SabreContactPhone> phones, List<SabreContactEmail> emails) {
        ArrayList<ContactType> res = new ArrayList<ContactType>();
        int maxContactTypesCount = 10;
        int num = 1;
        for (SabreContactPhone sabreContactPhone : phones) {
            TelephoneType tt;
            if (sabreContactPhone.getType() == null || sabreContactPhone.getType() == CommunicationType.EMAIL || sabreContactPhone.getType() == CommunicationType.WEB || TextUtil.isBlank((String)sabreContactPhone.getSense()) || num > 10) continue;
            String fullNumber = ProfileSynchronizationUtil.getFullNumber((SabreContactPhone)sabreContactPhone);
            ContactType ct = SabreProfileServicesUtil.findPhoneContactType(originalEmergencyContacts, fullNumber);
            if (ct == null) {
                ct = new ContactType();
                tt = new TelephoneType();
                tt.setFullPhoneNumber(fullNumber);
                ct.getTelephoneList().add(tt);
            } else {
                tt = (TelephoneType)ct.getTelephoneList().get(0);
            }
            if (TextUtil.nonBlank((String)sabreContactPhone.getContactName())) {
                ct.setSurName(sabreContactPhone.getContactName());
            } else {
                ct.setSurName(" ");
            }
            if (TextUtil.nonBlank((String)sabreContactPhone.getContactFirstName())) {
                ct.setGivenName(sabreContactPhone.getContactFirstName());
            } else {
                ct.setGivenName(null);
            }
            tt.setDeviceTypeCode(SabreProfileServicesUtil.getDeviceTypeCodeByCommType(sabreContactPhone.getType()));
            tt.setLocationTypeCode(SabreProfileServicesUtil.getLocationTypeCodeByCommType(sabreContactPhone.getType()));
            tt.setPNRTelephoneTagIndicator(YesNoType.Y);
            ct.setOrderSequenceNo(String.valueOf(num++));
            res.add(ct);
        }
        for (SabreContactEmail sabreContactEmail : emails) {
            EmailType email;
            if (TextUtil.isBlank((String)sabreContactEmail.getSense()) || num > 10) continue;
            ContactType ct = SabreProfileServicesUtil.findEmailContactType(originalEmergencyContacts, sabreContactEmail.getSense());
            if (ct == null) {
                ct = new ContactType();
                email = new EmailType();
                email.setEmailAddress(sabreContactEmail.getSense());
                ct.getEmailList().add(email);
            } else {
                email = (EmailType)ct.getEmailList().get(0);
            }
            if (TextUtil.nonBlank((String)sabreContactEmail.getContactName())) {
                ct.setSurName(sabreContactEmail.getContactName());
            } else {
                ct.setSurName(" ");
            }
            if (TextUtil.nonBlank((String)sabreContactEmail.getContactFirstName())) {
                ct.setGivenName(sabreContactEmail.getContactFirstName());
            } else {
                ct.setGivenName(null);
            }
            email.setEmailAddress(sabreContactEmail.getSense());
            email.setEmailTypeCode("MOB");
            ct.setOrderSequenceNo(String.valueOf(num++));
            res.add(ct);
        }
        if (CollectionUtil.isNotEmpty(originalEmergencyContacts)) {
            SabreProfileServicesUtil.sortByOrderSequenceNumber(originalEmergencyContacts, ContactType::getOrderSequenceNo);
            for (ContactType contactType : originalEmergencyContacts) {
                if (num > 10 || CollectionUtil.isEmpty((Collection)contactType.getAddressList())) continue;
                if (CollectionUtil.isNotEmpty((Collection)contactType.getEmailList())) {
                    contactType.getEmailList().clear();
                }
                if (CollectionUtil.isNotEmpty((Collection)contactType.getTelephoneList())) {
                    contactType.getTelephoneList().clear();
                }
                contactType.setOrderSequenceNo(String.valueOf(num++));
                contactType.setDisplaySequenceNo(null);
                res.add(contactType);
            }
        }
        return res;
    }

    private static void parseTelephoneTypesSabrePhonesAndEmails(Person person, List<ContactType> contactTypes) {
        if (CollectionUtil.isEmpty(contactTypes)) {
            return;
        }
        SabreProfileServicesUtil.sortByOrderSequenceNumber(contactTypes, ContactType::getOrderSequenceNo);
        ArrayList<SabreContactPhone> phones = new ArrayList<SabreContactPhone>();
        ArrayList<SabreContactEmail> emails = new ArrayList<SabreContactEmail>();
        for (ContactType ct : contactTypes) {
            if (CollectionUtil.isNotEmpty((Collection)ct.getTelephoneList())) {
                for (TelephoneType tt : ct.getTelephoneList()) {
                    SabreContactPhone phone = new SabreContactPhone();
                    ParsedPhoneNumberType parsedPhoneNumber = tt.getParsedPhoneNumber();
                    if (parsedPhoneNumber != null) {
                        phone.setCountryCode(parsedPhoneNumber.getCountryCd());
                        phone.setCityCode(parsedPhoneNumber.getAreaCd());
                        phone.setSense(parsedPhoneNumber.getPhoneNumber());
                        phone.setInternalNumber(parsedPhoneNumber.getExtension());
                    } else {
                        phone.setSense(tt.getFullPhoneNumber());
                    }
                    phone.setType(SabreProfileServicesUtil.getCommTypeByLocationTypeCode(tt.getLocationTypeCode()));
                    if (TextUtil.nonBlank((String)ct.getGivenName())) {
                        phone.setContactFirstName(ct.getGivenName());
                    }
                    if (TextUtil.nonBlank((String)ct.getSurName())) {
                        phone.setContactName(ct.getSurName());
                    }
                    phones.add(phone);
                }
            }
            if (!CollectionUtil.isNotEmpty((Collection)ct.getEmailList())) continue;
            for (EmailType et : ct.getEmailList()) {
                if (TextUtil.isBlank((String)et.getEmailAddress())) continue;
                SabreContactEmail email = new SabreContactEmail();
                email.setSense(et.getEmailAddress());
                if (TextUtil.nonBlank((String)ct.getGivenName())) {
                    email.setContactFirstName(ct.getGivenName());
                }
                if (TextUtil.nonBlank((String)ct.getSurName())) {
                    email.setContactName(ct.getSurName());
                }
                emails.add(email);
            }
        }
        person.getSabrePhoneContacts().addAll(phones);
        person.getSabreEmailContacts().addAll(emails);
    }

    private static List<com.sabre.eps.schemas.AddressType> createAddressTypesForAgency(List<? extends Address> addresses, String agencyName) {
        List<com.sabre.eps.schemas.AddressType> res = SabreProfileServicesUtil.updateAddressTypes(null, addresses);
        for (com.sabre.eps.schemas.AddressType at : res) {
            if (at.getLocationTypeCode().equals("BUS")) {
                at.setLocationTypeCode("AGY");
            }
            at.setAttention(agencyName);
        }
        return res;
    }

    private static List<com.sabre.eps.schemas.AddressType> updateAddressTypes(List<com.sabre.eps.schemas.AddressType> originalAddressTypes, List<? extends Address> addresses) {
        ArrayList<com.sabre.eps.schemas.AddressType> res = new ArrayList<com.sabre.eps.schemas.AddressType>();
        int num = 1;
        for (Address address : addresses) {
            if (address.getAddressType() != AddressType.FACTUAL && address.getAddressType() != AddressType.DELIVERY && (!(address instanceof PersonAddress) || address.getAddressType() != AddressType.BUSINESS)) continue;
            com.sabre.eps.schemas.AddressType addr = new com.sabre.eps.schemas.AddressType();
            addr.setOrderSequenceNo(String.valueOf(num));
            ++num;
            if (address.getCountry() != null) {
                addr.setCountryCode(address.getCountry().getCode());
            }
            if (!TextUtil.isBlank((String)SabreProfileServicesUtil.checkSymbols(address.getZip(), true, false))) {
                addr.setPostalCd(SabreProfileServicesUtil.checkSymbols(address.getZip(), true, false));
            }
            addr.setCityName(TextUtil.nonEmptyStr((String)ProfileSynchronizationUtil.createCityLine((Address)address)));
            addr.getAddressLineList().addAll(ProfileSynchronizationUtil.createAddressLines((Address)address));
            if (!TextUtil.isBlank((String)SabreProfileServicesUtil.checkSymbols(address.getNotes(), true, false))) {
                addr.setContactRemark(SabreProfileServicesUtil.checkSymbols(address.getNotes(), true, false));
            }
            if (address.getAddressType() == AddressType.DELIVERY) {
                addr.setLocationTypeCode("DEL");
            } else {
                addr.setAddressUsageTypeCode("BUS");
                addr.setLocationTypeCode("BUS");
            }
            res.add(addr);
        }
        if (CollectionUtil.isNotEmpty(originalAddressTypes)) {
            SabreProfileServicesUtil.sortByOrderSequenceNumber(originalAddressTypes, com.sabre.eps.schemas.AddressType::getOrderSequenceNo);
            for (com.sabre.eps.schemas.AddressType addressType : originalAddressTypes) {
                if (SabreProfileServicesUtil.isSupportedAddressLocationTypeCode(addressType.getLocationTypeCode())) continue;
                addressType.setOrderSequenceNo(String.valueOf(num));
                addressType.setDisplaySequenceNo(null);
            }
        }
        return res;
    }

    private static boolean isSupportedAddressLocationTypeCode(String addressLocationTypeCode) {
        return "DEL".equals(addressLocationTypeCode) || "BUS".equals(addressLocationTypeCode);
    }

    private static void parseAddressTypes(Person person, List<com.sabre.eps.schemas.AddressType> addressTypes) {
        if (CollectionUtil.isEmpty(addressTypes)) {
            return;
        }
        SabreProfileServicesUtil.sortByOrderSequenceNumber(addressTypes, com.sabre.eps.schemas.AddressType::getOrderSequenceNo);
        ArrayList<PersonAddress> addresses = new ArrayList<PersonAddress>();
        for (com.sabre.eps.schemas.AddressType addressType : addressTypes) {
            String addressLine;
            if (!SabreProfileServicesUtil.isSupportedAddressLocationTypeCode(addressType.getLocationTypeCode())) continue;
            PersonAddress address = new PersonAddress();
            if ("DEL".equals(addressType.getLocationTypeCode())) {
                address.setAddressType(AddressType.DELIVERY);
            } else if ("BUS".equals(addressType.getLocationTypeCode())) {
                address.setAddressType(AddressType.BUSINESS);
            } else {
                throw new IllegalArgumentException("Unsupported address type: " + addressType.getLocationTypeCode());
            }
            if (TextUtil.nonBlank((String)addressType.getCountryCode())) {
                address.setCountry((DictionaryReference)new CountryReference(addressType.getCountryCode()));
            }
            address.setZip(addressType.getPostalCd());
            address.setNotes(addressType.getContactRemark());
            if (TextUtil.nonBlank((String)addressType.getCityName())) {
                ProfileSynchronizationUtil.setEnglishValue((L10nString)address.getTown(), (String)addressType.getCityName());
            }
            if (CollectionUtil.isNotEmpty((Collection)addressType.getAddressLineList()) && TextUtil.nonBlank((String)(addressLine = addressType.getAddressLineList().stream().filter(TextUtil::nonBlank).collect(Collectors.joining(" "))))) {
                ProfileSynchronizationUtil.setEnglishValue((L10nString)address.getAddress(), (String)addressLine);
            }
            addresses.add(address);
        }
        person.getAddresses().addAll(addresses);
    }

    private static Collection<FilterAddressType> createFilterAddressTypesForAgency(List<? extends Address> addresses, boolean needGeneralAddresses, boolean needDeliveryAddresses, String agencyName) {
        Collection<FilterAddressType> res = SabreProfileServicesUtil.createFilterAddressTypes(addresses, needGeneralAddresses, needDeliveryAddresses);
        boolean isFirst = true;
        Iterator<FilterAddressType> iterator = res.iterator();
        while (iterator.hasNext()) {
            FilterAddressType at = iterator.next();
            if (at.getLocationTypeCode().equals("BUS")) {
                if (isFirst) {
                    at.setLocationTypeCode("AGY");
                    isFirst = false;
                } else {
                    iterator.remove();
                    continue;
                }
            }
            at.setAttention(agencyName);
        }
        return res;
    }

    private static Collection<FilterAddressType> createFilterAddressTypes(List<? extends Address> addresses, boolean needGeneralAddresses, boolean needDeliveryAddresses) {
        ArrayList<FilterAddressType> res = new ArrayList<FilterAddressType>();
        int num = 1;
        for (Address address : addresses) {
            if (!(address.getAddressType() == AddressType.FACTUAL && needGeneralAddresses || address.getAddressType() == AddressType.DELIVERY && needDeliveryAddresses) && (!(address instanceof PersonAddress) || address.getAddressType() != AddressType.BUSINESS || !needGeneralAddresses)) continue;
            FilterAddressType addr = new FilterAddressType();
            addr.setOrderSequenceNo(String.valueOf(num));
            ++num;
            if (address.getCountry() != null) {
                addr.setCountryCode(address.getCountry().getCode());
            }
            if (!TextUtil.isBlank((String)SabreProfileServicesUtil.checkSymbols(address.getZip(), true, false))) {
                addr.setPostalCd(SabreProfileServicesUtil.checkSymbols(address.getZip(), true, false));
            }
            addr.setCityName(TextUtil.nonEmptyStr((String)ProfileSynchronizationUtil.createCityLine((Address)address)));
            addr.getAddressLineList().addAll(ProfileSynchronizationUtil.createAddressLines((Address)address));
            if (address.getAddressType() == AddressType.DELIVERY) {
                addr.setLocationTypeCode("DEL");
            } else {
                addr.setAddressUsageTypeCode("BUS");
                addr.setLocationTypeCode("BUS");
            }
            res.add(addr);
        }
        return res;
    }

    private static List<ContactNameType> createContactNameTypes(List<SabreProfilesPersonInCharge> list) {
        ArrayList<ContactNameType> res = new ArrayList<ContactNameType>();
        int num = 1;
        for (SabreProfilesPersonInCharge p : list) {
            ContactNameType name = new ContactNameType();
            name.setSurName(p.getLastName());
            name.setGivenName(p.getFirstName());
            name.setNamePrefix(TextUtil.nonEmptyStr((String)p.getTitle()));
            name.setOrderSequenceNo(String.valueOf(num));
            ++num;
            res.add(name);
        }
        return res;
    }

    public static SabreOTAProfileSearchRQ getSearchOrganizationRequest(SabreProfilesSynchronizationRequest synchRequest) {
        SabreOTAProfileSearchRQ request = new SabreOTAProfileSearchRQ();
        ProfileSearchCriteriaType psc = new ProfileSearchCriteriaType();
        Organization org = synchRequest.getOrganization();
        SearchTPAIdentityType tpaId = SabreProfileServicesUtil.createTPAIdentityForSearchProfileType(ProfileSynchronizationUtil.getEnglishOrNullValue((L10nString)org.getShortName()), synchRequest.getPcc(), org.getTypes().contains(OrganizationType.AGENCY) && !org.getTypes().contains(OrganizationType.CORPORATE_CLIENT) ? ProfileTypeInfo.AGY.toString() : ProfileTypeInfo.CRP.toString());
        psc.setTPAIdentity(tpaId);
        psc.setProfileNameOnly(YesNoType.Y);
        SearchCustomerReferenceInfoType crit = new SearchCustomerReferenceInfoType();
        crit.setReferenceID(org.getCode());
        psc.setCustomerReferenceInfo(crit);
        request.setProfileSearchCriteria(psc);
        return request;
    }

    public static SabreOTAProfileSearchRQ getSearchPersonRequest(SabreProfilesSynchronizationRequest synchRequest) {
        SabreOTAProfileSearchRQ request = new SabreOTAProfileSearchRQ();
        ProfileSearchCriteriaType psc = new ProfileSearchCriteriaType();
        Person per = synchRequest.getPerson();
        SearchTPAIdentityType tpaId = SabreProfileServicesUtil.createTPAIdentityForSearchProfileType(null, synchRequest.getPcc(), ProfileTypeInfo.TVL.toString());
        psc.setTPAIdentity(tpaId);
        psc.setProfileNameOnly(YesNoType.Y);
        psc.setDocument(SabreProfileServicesUtil.createSearchDocumentType(per.getPassports()));
        SearchTravelerInfoType traveler = new SearchTravelerInfoType();
        String namePrefix = SabreProfileServicesUtil.createTitle(per);
        String lastName = ProfileSynchronizationUtil.getEnglishOrNullValue((L10nString)per.getLastName());
        String firstName = ProfileSynchronizationUtil.removeSlashesAndHyphens((String)ProfileSynchronizationUtil.getEnglishOrNullValue((L10nString)per.getFirstName()));
        String middleName = ProfileSynchronizationUtil.removeSlashesAndHyphens((String)ProfileSynchronizationUtil.getEnglishOrNullValue((L10nString)per.getMiddleName()));
        String secondName = ProfileSynchronizationUtil.removeSlashesAndHyphens((String)ProfileSynchronizationUtil.getEnglishOrNullValue((L10nString)per.getSecondName()));
        SabreProfileServicesUtil.cropNames(namePrefix, lastName, firstName, middleName, secondName, croppedLastName -> traveler.setSurname(croppedLastName), (croppedFirstName, croppedSecondName) -> {
            if (!TextUtil.isBlank((String)croppedFirstName)) {
                traveler.setGivenName(croppedFirstName.trim() + (!TextUtil.isBlank((String)croppedSecondName) ? " " + croppedSecondName.trim() : ""));
            }
        }, croppedMiddleName -> {});
        Date perBirthday = ProfileHelper.getPersonBirthday((Person)per);
        traveler.setBirthDate(MiscUtil.toSqlDate((Date)perBirthday));
        SearchAssociatedProfilesType assocProfile = SabreProfileServicesUtil.createSearchAssociatedProfileType(synchRequest.getAssociatedProfiles(), synchRequest.getPcc());
        if (assocProfile != null) {
            psc.setAssociatedProfiles(assocProfile);
        }
        ProfileBaseCriteriaType.Choice choice = new ProfileBaseCriteriaType.Choice();
        choice.setTraveler(traveler);
        psc.setChoice(choice);
        request.setProfileSearchCriteria(psc);
        return request;
    }

    public static SabreOTAProfileSearchRQ getSearchTravellersRequest(String pcc, String templateId, int pageNumber) {
        SabreOTAProfileSearchRQ request = new SabreOTAProfileSearchRQ();
        ProfileSearchCriteriaType psc = new ProfileSearchCriteriaType();
        psc.setReturnCount(BigInteger.valueOf(250L));
        psc.setPageNumber(Integer.toString(pageNumber));
        psc.setExcludeDeletedProfiles(YesNoType.Y);
        SearchTPAIdentityType tpaId = SabreProfileServicesUtil.createTPAIdentityForSearchProfileType(null, pcc, ProfileTypeInfo.TVL.toString());
        psc.setTPAIdentity(tpaId);
        SearchAssociatedAssociationType searchAssociatedAssociationType = new SearchAssociatedAssociationType();
        searchAssociatedAssociationType.setAssociationID(templateId);
        psc.setAssociation(searchAssociatedAssociationType);
        request.setProfileSearchCriteria(psc);
        return request;
    }

    private static SearchAssociatedProfilesType createSearchAssociatedProfileType(List<SabreProfilesAssociatedProfileData> associatedProfiles, String pcc) {
        for (SabreProfilesAssociatedProfileData profile : associatedProfiles) {
            if (profile.getProfileType() != SabreProfilesProfileType.CRP) continue;
            SearchAssociatedProfilesType res = new SearchAssociatedProfilesType();
            res.setAssocProfileName(ProfileSynchronizationUtil.removeIllegalSymbols((String)profile.getName(), (boolean)true));
            res.setAssocUniqueID(profile.getUniqueID());
            res.setCreditBankIndicator(YesNoType.N);
            res.setDomainID(pcc);
            res.setProfileRelationTypeCode("AL");
            res.setAssocProfileType(SearchProfileTypeInfo.CRP);
            return res;
        }
        return null;
    }

    public static SabreCommandLLSRQ prepareRequest(String sabreCommandString, SabreCommandLLSRQ.Output outputFormat, boolean cdata) {
        SabreCommandLLSRQ sabreCommandRQ = new SabreCommandLLSRQ();
        sabreCommandRQ.setVersion("2.0.0");
        sabreCommandRQ.setRequestOutput(outputFormat);
        sabreCommandRQ.setRequestHostCommand(sabreCommandString);
        if (cdata) {
            sabreCommandRQ.setRequestCDATA(Boolean.TRUE.toString());
        }
        return sabreCommandRQ;
    }

    public static String getPersonShortName(Person per) {
        if (per == null || per.getLastName() == null || per.getLastName().getValues().isEmpty()) {
            return null;
        }
        StringBuilder sb = new StringBuilder(ProfileSynchronizationUtil.removeSlashesAndHyphens((String)ProfileSynchronizationUtil.getEnglishOrNullValue((L10nString)per.getLastName())));
        String firstName = ProfileSynchronizationUtil.removeSlashesAndHyphens((String)ProfileSynchronizationUtil.getEnglishOrNullValue((L10nString)per.getFirstName()));
        if (firstName != null && firstName.length() > 0) {
            sb.append(" ");
            sb.append(firstName);
        }
        return sb.toString();
    }

    public static String getPersonFullName(Person per) {
        String middleName;
        String secondName;
        String firstName;
        if (per == null || per.getLastName() == null || per.getLastName().getValues().isEmpty()) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        String lastName = ProfileSynchronizationUtil.removeSlashesAndHyphens((String)ProfileSynchronizationUtil.getEnglishOrNullValue((L10nString)per.getLastName()));
        if (lastName != null) {
            sb.append(lastName);
        }
        if ((firstName = ProfileSynchronizationUtil.removeSlashesAndHyphens((String)ProfileSynchronizationUtil.getEnglishOrNullValue((L10nString)per.getFirstName()))) != null) {
            sb.append(" ");
            sb.append(firstName);
        }
        if ((secondName = ProfileSynchronizationUtil.removeSlashesAndHyphens((String)ProfileSynchronizationUtil.getEnglishOrNullValue((L10nString)per.getSecondName()))) != null) {
            sb.append(" ");
            sb.append(secondName);
        }
        if ((middleName = ProfileSynchronizationUtil.removeSlashesAndHyphens((String)ProfileSynchronizationUtil.getEnglishOrNullValue((L10nString)per.getMiddleName()))) != null) {
            sb.append(" ");
            sb.append(middleName);
        }
        return sb.toString();
    }

    private static XMLGregorianCalendar getXMLGregorianCalendar(Date date) {
        if (date == null) {
            return null;
        }
        GregorianCalendar c = new GregorianCalendar();
        c.setTime(date);
        XMLGregorianCalendar res = null;
        try {
            res = DatatypeFactory.newInstance().newXMLGregorianCalendar(c);
        }
        catch (DatatypeConfigurationException datatypeConfigurationException) {
            // empty catch block
        }
        return res;
    }

    public static void getMessagesFromResponse(ResponseMessageType rmt, List<Message> errors, List<Message> warnings, List<SabreProfilesAssociatedProfileInfo> info) {
        StringBuilder sb;
        if (rmt == null) {
            return;
        }
        if (rmt.getErrors() != null && rmt.getErrors().getErrorMessageList() != null) {
            for (ErrorMessageType emt : rmt.getErrors().getErrorMessageList()) {
                sb = new StringBuilder();
                if (emt.getErrorCode() != null) {
                    sb.append(emt.getErrorCode());
                }
                if (TextUtil.nonBlank((String)emt.getString())) {
                    sb.append(" - ").append(emt.getString());
                }
                if (emt.getErrorCode() != null) {
                    switch (emt.getErrorCode()) {
                        case "149": {
                            SabreProfileServicesUtil.appendAssociatedProfileInfo(sb, info);
                        }
                    }
                }
                errors.add(MessageHelper.createErrorMessage((String)sb.toString(), (Object[])new Object[0]));
            }
        }
        if (rmt.getWarnings() != null && rmt.getWarnings().getWarningMessageList() != null) {
            for (ErrorMessageType emt : rmt.getWarnings().getWarningMessageList()) {
                sb = new StringBuilder();
                if (emt.getWarningCode() != null) {
                    sb.append(emt.getWarningCode());
                }
                if (!TextUtil.isBlank((String)emt.getString())) {
                    sb.append(" - ").append(emt.getString());
                }
                warnings.add(MessageHelper.createWarningMessage((String)sb.toString(), (Object[])new Object[0]));
            }
        }
    }

    private static void appendAssociatedProfileInfo(StringBuilder sb, List<SabreProfilesAssociatedProfileInfo> info) {
        if (!info.isEmpty()) {
            sb.append(". Associated Profiles -");
            info.forEach(associatedProfileInfo -> sb.append(" ID: ").append(associatedProfileInfo.getId()).append(", ").append("Name: ").append(associatedProfileInfo.getName()).append(", ").append("Type: ").append(associatedProfileInfo.getType()).append(", ").append("PCC: ").append(associatedProfileInfo.getPcc()).append("."));
        }
    }

    public static List<SabreProfilesAssociatedProfileInfo> getSabreProfilesAssociatedProfileInfo(SabreProfilesSynchronizationRequest syncRequest) {
        if (syncRequest == null || syncRequest.getAssociatedProfiles().isEmpty()) {
            return Collections.emptyList();
        }
        return syncRequest.getAssociatedProfiles().stream().map(profile -> {
            SabreProfilesAssociatedProfileInfo associatedProfileInfo = new SabreProfilesAssociatedProfileInfo();
            associatedProfileInfo.setPcc(syncRequest.getPcc());
            associatedProfileInfo.setId(profile.getUniqueID());
            associatedProfileInfo.setName(profile.getName());
            associatedProfileInfo.setType(profile.getProfileType().name());
            return associatedProfileInfo;
        }).collect(Collectors.toList());
    }

    public static SabreOTAProfileReadRQ getReadOrganizationRequest(SabreProfilesSynchronizationRequest synchRequest) {
        if (synchRequest == null || synchRequest.getOrganization() == null) {
            return null;
        }
        SabreOTAProfileReadRQ request = new SabreOTAProfileReadRQ();
        Organization org = synchRequest.getOrganization();
        ReadProfileType rpt = new ReadProfileType();
        rpt.setTPAIdentity(SabreProfileServicesUtil.createTPAIdentityForReadProfileType(ProfileSynchronizationUtil.getSabreProfilesUniqueID((Organization)org, (String)synchRequest.getPcc()), ProfileSynchronizationUtil.getEnglishOrNullValue((L10nString)org.getShortName()), ProfileSynchronizationUtil.getEnglishOrNullValue((L10nString)org.getFullName()), synchRequest.getPcc(), org.getTypes().contains(OrganizationType.AGENCY) && !org.getTypes().contains(OrganizationType.CORPORATE_CLIENT) ? ProfileTypeInfo.AGY : ProfileTypeInfo.CRP));
        request.setProfile(rpt);
        return request;
    }

    public static SabreOTAProfileReadRQ getReadPersonRequest(SabreProfilesSynchronizationRequest synchRequest) {
        if (synchRequest == null) {
            return null;
        }
        SabreOTAProfileReadRQ request = new SabreOTAProfileReadRQ();
        Person per = synchRequest.getPerson();
        ReadProfileType rpt = new ReadProfileType();
        rpt.setTPAIdentity(SabreProfileServicesUtil.createTPAIdentityForReadProfileType(ProfileSynchronizationUtil.getSabreProfilesUniqueID((Person)per, (String)synchRequest.getPcc()), SabreProfileServicesUtil.getPersonShortName(per), SabreProfileServicesUtil.getPersonFullName(per), synchRequest.getPcc(), ProfileTypeInfo.TVL));
        request.setProfile(rpt);
        return request;
    }

    public static SabreOTAProfileReadRQ getReadTemplateRequest(String pcc, String uniqueID) {
        SabreOTAProfileReadRQ request = new SabreOTAProfileReadRQ();
        ReadAssociationType rat = new ReadAssociationType();
        rat.setDomainID(pcc);
        rat.setAssociationID(uniqueID);
        rat.setClientCode(CLIENT_CODE);
        rat.setClientContextCode(CLIENT_CONTEXT_CODE);
        request.setAssociation(rat);
        return request;
    }

    private static String checkSymbols(String str, boolean strict, boolean returnNull) {
        if (returnNull) {
            return ProfileSynchronizationUtil.checkIllegalSymbols((String)str, (boolean)strict) ? null : str;
        }
        return ProfileSynchronizationUtil.removeIllegalSymbols((String)str, (boolean)strict);
    }

    private static String checkSymbolsNumbers(String str) {
        if (TextUtil.isBlank((String)str)) {
            return str;
        }
        return str.replaceAll("[^0-9]+", "");
    }

    public static SabreOTAProfileDeleteRQ getDeleteFilterRequest(String pcc, String filterID) {
        SabreOTAProfileDeleteRQ request = new SabreOTAProfileDeleteRQ();
        DeleteType dt = new DeleteType();
        DeleteFilterType dft = new DeleteFilterType();
        dft.setFilterID(filterID);
        dft.setClientCode(CLIENT_CODE);
        dft.setClientContextCode(CLIENT_CONTEXT_CODE);
        dft.setDomainID(pcc);
        dft.setPurgeDays("1");
        dt.setFilter(dft);
        request.setDelete(dt);
        return request;
    }

    public static SabreOTAProfileReadRQ getReadFilterRequest(String pcc, String filterID) {
        SabreOTAProfileReadRQ request = new SabreOTAProfileReadRQ();
        ReadFilterType filter = new ReadFilterType();
        filter.setFilterID(filterID);
        filter.setClientCode(CLIENT_CODE);
        filter.setClientContextCode(CLIENT_CONTEXT_CODE);
        filter.setDomainID(pcc);
        request.setFilter(filter);
        return request;
    }

    public static String getGeneralInfoCategoryForTarget(String target) {
        String res = "GEN";
        for (Map.Entry<String, List<String>> entry : generalCategory2Target.entrySet()) {
            if (!entry.getValue().contains(target)) continue;
            res = entry.getKey();
            break;
        }
        return res;
    }

    public static SabreOTAProfileCreateRQ getCreateAssociationForOrganizationRequest(SabreProfilesSynchronizationRequest synchRequest) {
        if (synchRequest == null || synchRequest.getOrganization() == null) {
            return null;
        }
        SabreOTAProfileCreateRQ request = new SabreOTAProfileCreateRQ();
        AssociationType at = SabreProfileServicesUtil.createOrganizationAssociationType(synchRequest);
        request.setAssociation(at);
        return request;
    }

    public static SabreOTAProfileUpdateRQ getUpdateAssociationForOrganizationRequest(SabreProfilesSynchronizationRequest synchRequest) {
        if (synchRequest == null || synchRequest.getOrganization() == null) {
            return null;
        }
        SabreOTAProfileUpdateRQ request = new SabreOTAProfileUpdateRQ();
        AssociationType at = SabreProfileServicesUtil.createOrganizationAssociationType(synchRequest);
        request.setAssociation(at);
        return request;
    }

    private static AssociationType createOrganizationAssociationType(SabreProfilesSynchronizationRequest synchRequest) {
        Organization org = synchRequest.getOrganization();
        AssociationType at = new AssociationType();
        at.setAssociationName("ASSOC_" + ProfileSynchronizationUtil.getEnglishOrNullValue((L10nString)org.getShortName()));
        at.setAssociationDescription("ASSOC_" + ProfileSynchronizationUtil.getEnglishOrNullValue((L10nString)org.getFullName()));
        String assocID = null;
        at.setAssociationID(TextUtil.isBlank(assocID) ? "*" : assocID);
        at.setClientCode(CLIENT_CODE);
        at.setClientContextCode(CLIENT_CONTEXT_CODE);
        at.setDomainID(synchRequest.getPcc());
        if (org.getTypes().contains(OrganizationType.AGENCY) && !org.getTypes().contains(OrganizationType.CORPORATE_CLIENT)) {
            at.setProfileTypeCode(ProfileTypeInfo.CRP);
            AssociatedProfilesType aptSelf = SabreProfileServicesUtil.createAssociatedProfilesType(ProfileSynchronizationUtil.getSabreProfilesUniqueID((Organization)org, (String)synchRequest.getPcc()), ProfileTypeInfo.AGY, synchRequest.getPcc(), "1");
            at.getAssociatedProfileList().add(aptSelf);
        } else if (org.getTypes().contains(OrganizationType.CORPORATE_CLIENT)) {
            at.setProfileTypeCode(ProfileTypeInfo.TVL);
            AssociatedProfilesType aptSelf = SabreProfileServicesUtil.createAssociatedProfilesType(ProfileSynchronizationUtil.getSabreProfilesUniqueID((Organization)org, (String)synchRequest.getPcc()), ProfileTypeInfo.CRP, synchRequest.getPcc(), "1");
            at.getAssociatedProfileList().add(aptSelf);
            for (SabreProfilesAssociatedProfileData assocProfile : synchRequest.getAssociatedProfiles()) {
                if (assocProfile.getProfileType() != SabreProfilesProfileType.AGY) continue;
                AssociatedProfilesType aptAgency = SabreProfileServicesUtil.createAssociatedProfilesType(assocProfile.getUniqueID(), ProfileTypeInfo.AGY, synchRequest.getPcc(), "2");
                at.getAssociatedProfileList().add(aptAgency);
            }
        }
        return at;
    }

    private static AssociatedProfilesType createAssociatedProfilesType(String profileUniqueID, ProfileTypeInfo pti, String pcc, String orderNo) {
        AssociatedProfilesType apt = new AssociatedProfilesType();
        apt.setAssocProfileTypeCode(pti);
        apt.setClientCode(CLIENT_CODE);
        apt.setDomainID(pcc);
        apt.setOrderSequenceNo(orderNo);
        apt.setAssocUniqueID(profileUniqueID);
        return apt;
    }

    static SabreOTAProfileDataSrvRQ getRetrieveCustomFieldCodesRequest(String pcc) {
        SabreOTAProfileDataSrvRQ request = new SabreOTAProfileDataSrvRQ();
        RetrieveCustomFieldCodesType rcfct = new RetrieveCustomFieldCodesType();
        rcfct.setClientCode(CLIENT_CODE);
        rcfct.setClientContextCode(CLIENT_CONTEXT_CODE);
        rcfct.setDomainID(pcc);
        request.setRetrieveCustomFieldCodes(rcfct);
        return request;
    }

    static SabreOTAProfileDataSrvRQ getCreateCustomFieldCodesRequest(String pcc, List<String> customFieldCodes) {
        SabreOTAProfileDataSrvRQ request = new SabreOTAProfileDataSrvRQ();
        CreateCustomFieldCodeType ccfct = new CreateCustomFieldCodeType();
        customFieldCodes.stream().map(code -> {
            CategoryCodeType cct = new CategoryCodeType();
            cct.setCustomFieldCode(code);
            cct.setDomainID(pcc);
            return cct;
        }).forEach(ccfct.getCategoryCodeList()::add);
        request.setCreateCustomFieldCode(ccfct);
        return request;
    }

    private static String getDeviceTypeCodeByCommType(CommunicationType type) {
        if (type == null) {
            return "MO";
        }
        switch (type) {
            case FAX: {
                return "FX";
            }
        }
        return "MO";
    }

    private static String getLocationTypeCodeByCommType(CommunicationType type) {
        if (type == null) {
            return "UNK";
        }
        switch (type) {
            case AGENCY: {
                return "AGY";
            }
            case HOME_PHONE: {
                return "HOM";
            }
            case CELL: {
                return "CEL";
            }
            case MOBILE: {
                return "MOB";
            }
            case EMERGENCY: {
                return "EMG";
            }
            case FAX: {
                return "FAX";
            }
            case WORK_PHONE: 
            case EMAIL: {
                return "BUS";
            }
        }
        return "UNK";
    }

    private static CommunicationType getCommTypeByLocationTypeCode(String type) {
        if (type == null) {
            return null;
        }
        switch (type) {
            case "AGY": {
                return CommunicationType.AGENCY;
            }
            case "HOM": {
                return CommunicationType.HOME_PHONE;
            }
            case "CEL": {
                return CommunicationType.CELL;
            }
            case "MOB": {
                return CommunicationType.MOBILE;
            }
            case "EMG": {
                return CommunicationType.EMERGENCY;
            }
            case "FAX": {
                return CommunicationType.FAX;
            }
            case "BUS": {
                return CommunicationType.WORK_PHONE;
            }
        }
        return null;
    }

    static <T extends Serializable> void sortByOrderSequenceNumber(List<T> objects, Function<T, String> orderSequenceNumberGetter) {
        if (CollectionUtil.isEmpty(objects)) {
            return;
        }
        boolean hasValuesWithoutOrderSequenceNumber = objects.stream().map(orderSequenceNumberGetter).anyMatch(number -> TextUtil.isBlank((String)number) || !number.matches("\\d{1,3}"));
        if (hasValuesWithoutOrderSequenceNumber) {
            return;
        }
        objects.sort(Comparator.comparingInt(e -> Integer.parseInt((String)orderSequenceNumberGetter.apply(e))));
    }

    static class SabreProfilesAssociatedProfileInfo {
        private String pcc;
        private String id;
        private String name;
        private String type;

        SabreProfilesAssociatedProfileInfo() {
        }

        public String getPcc() {
            return this.pcc;
        }

        public String getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public String getType() {
            return this.type;
        }

        public void setPcc(String pcc) {
            this.pcc = pcc;
        }

        public void setId(String id) {
            this.id = id;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setType(String type) {
            this.type = type;
        }
    }
}

