/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sabre.profiles;

import com.gridnine.xtrip.common.model.profile.PNRBuilderSettings;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.gds.sabre.IBusGdsSabreContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.List;

public class SabreProfilesRenameFiltersToCreate
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        List existingFilters = (List)ctx.getMandatoryObject((Enum)IBusGdsSabreContextKeys.PROFILE_SYNC_FILTERS_EXISTED);
        List filtersToCreate = (List)ctx.getMandatoryObject((Enum)IBusGdsSabreContextKeys.PROFILE_SYNC_FILTERS_FOR_CREATE);
        List filtersToDelete = (List)ctx.getMandatoryObject((Enum)IBusGdsSabreContextKeys.PROFILE_SYNC_FILTERS_FOR_DELETE);
        if (filtersToCreate.isEmpty() || existingFilters.isEmpty()) {
            return;
        }
        for (PNRBuilderSettings filterToCreate : filtersToCreate) {
            boolean hasFilterWithSameName = existingFilters.stream().filter(filter -> this.isNotForDelete((String)filter.getFirst(), filtersToDelete)).anyMatch(filter -> TextUtil.isSame((String)((String)filter.getSecond()), (String)filterToCreate.getName()));
            if (!hasFilterWithSameName) continue;
            filterToCreate.setName(filterToCreate.getName() + "-MOM");
        }
    }

    private boolean isNotForDelete(String filterId, List<String> filtersToDelete) {
        return filtersToDelete.stream().noneMatch(id -> TextUtil.isSame((String)id, (String)filterId));
    }
}

