/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sabre.profiles;

import com.gridnine.xtrip.common.model.profile.SabreProfilesSearchTemplateInfo;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.gds.sabre.IBusGdsSabreContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.model.synchronization.sabreprofiles.SabreProfilesSynchronizationRequest;
import java.util.Collection;
import java.util.Objects;

public class SabreProfilesSearchByTemplatesValidateProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        SabreProfilesSynchronizationRequest synchRequest = (SabreProfilesSynchronizationRequest)ctx.getMandatoryObject((Enum)IBusGdsSabreContextKeys.PROFILE_SYNC_REQUEST);
        Objects.requireNonNull(synchRequest.getSearchInfo(), "Search info objects is null");
        CollectionUtil.requireNonEmpty((Collection)synchRequest.getSearchInfo().getTemplates(), (String)"Templates are absent");
        CollectionUtil.requireNonEmpty((Collection)synchRequest.getSearchInfo().getProfilesPcc(), (String)"Profiles pcc are absent");
        synchRequest.getSearchInfo().getTemplates().stream().map(SabreProfilesSearchTemplateInfo::getTemplateId).filter(TextUtil::isBlank).findAny().ifPresent(t -> {
            throw new IllegalArgumentException("Template id is blank");
        });
        synchRequest.getSearchInfo().getProfilesPcc().stream().filter(TextUtil::isBlank).findAny().ifPresent(t -> {
            throw new IllegalArgumentException("Profile pcc is blank");
        });
    }
}

