/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sabre.profiles;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.gds.sabre.SabreProfilesAccessAccounts;
import com.gridnine.xtrip.common.gds.sabre.SabreProfilesAccessSettings;
import com.gridnine.xtrip.common.gds.sabre.model.SabreGdsAccount;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.IntegrationBusException;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.MessageHelper;
import com.gridnine.xtrip.common.model.l10n.Messages;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.PersonIndex;
import com.gridnine.xtrip.common.model.system.BasicSystemSettingsIndex;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.XSerializable;
import com.gridnine.xtrip.server.gds.sabre.IBusGdsSabreContextKeys;
import com.gridnine.xtrip.server.ibus.IntegrationBusAdapter;
import com.gridnine.xtrip.server.ibus.IntegrationBusFacade;
import com.gridnine.xtrip.server.model.synchronization.SynchronizationHandler;
import com.gridnine.xtrip.server.model.synchronization.SynchronizationRequest;
import com.gridnine.xtrip.server.model.synchronization.SynchronizationResponse;
import com.gridnine.xtrip.server.model.synchronization.sabreprofiles.SabreProfilesLoadProfileData;
import com.gridnine.xtrip.server.model.synchronization.sabreprofiles.SabreProfilesSynchronizationRequest;
import com.gridnine.xtrip.server.model.synchronization.sabreprofiles.SabreProfilesSynchronizationResponse;
import com.gridnine.xtrip.server.model.synchronization.sabreprofiles.SabreProfilesSynchronizationResponseType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jibx.ws.soap.SoapFaultException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SabreProfilesSynchronizationHandler
implements SynchronizationHandler<SabreProfilesSynchronizationRequest, SabreProfilesSynchronizationResponse> {
    protected final transient Logger log = LoggerFactory.getLogger(this.getClass());

    public String getOperationId() {
        return "sabre-profiles-synch";
    }

    public SynchronizationResponse<SabreProfilesSynchronizationResponse> process(SynchronizationRequest<SabreProfilesSynchronizationRequest> request) throws Exception {
        SynchronizationResponse result = new SynchronizationResponse();
        SabreProfilesSynchronizationResponse synchResponse = new SabreProfilesSynchronizationResponse();
        result.setData((XSerializable)synchResponse);
        if (request == null || request.getData() == null || ((SabreProfilesSynchronizationRequest)request.getData()).getRequestType() == null) {
            this.log.error("process() : request is null or request.getData() is null or request.getData().getRequestType() is null. UNKNOWN status is set.");
            synchResponse.setResponseType(SabreProfilesSynchronizationResponseType.ERROR);
            return result;
        }
        ArrayList<Message> messages = new ArrayList<Message>();
        SabreProfilesSynchronizationRequest synchRequest = (SabreProfilesSynchronizationRequest)request.getData();
        SabreProfilesAccessSettings accessSettings = SabreProfilesSynchronizationHandler.getSabreProfilesAccessSettings();
        SalesContext salesContext = null;
        if (accessSettings == null || !accessSettings.isActive()) {
            messages.add(MessageHelper.createErrorMessage((String)"sabreProfilesAccessNotFoundOrNotActive", (Object[])new Object[0]));
            this.log.error("Sabre Profiles Access settings not found or not active");
            synchResponse.setResponseType(SabreProfilesSynchronizationResponseType.ERROR);
        } else if (accessSettings.getGdsAccount() == null) {
            messages.add(MessageHelper.createErrorMessage((String)"sabreProfilesAccessGDSAccountNotSet", (Object[])new Object[0]));
            this.log.error("Reservation system account is not set in Sabre Profiles Access settings");
            synchResponse.setResponseType(SabreProfilesSynchronizationResponseType.ERROR);
        } else {
            salesContext = this.createSalesContextAndCheckPCC(synchRequest.getPcc(), synchRequest.getPassword(), synchRequest.getCurrentUser(), accessSettings, messages);
        }
        if (salesContext == null) {
            synchResponse.setResponseType(SabreProfilesSynchronizationResponseType.ERROR);
        } else {
            Map<String, Object> data = this.prepareIbusContext(synchRequest, salesContext, (EntityReference<SabreGdsAccount>)accessSettings.getGdsAccount());
            try {
                Date profileUpdateDate;
                List employmentInfo;
                List udidValues;
                List associatedProfiles;
                Collection iBusMessages;
                List filters;
                String profileName;
                String newAssocId;
                SabreProfilesSynchronizationHandler.getAdapter("gds:sabre:sync-profiles:sync-profiles-route").processSync(data);
                String status = (String)data.get(IBusGdsSabreContextKeys.PROFILE_SYNC_RESPONSE_STATUS.name());
                String newUniqueId = (String)data.get(IBusGdsSabreContextKeys.PROFILE_SYNC_CREATE_UNIQUE_ID.name());
                if (!TextUtil.isBlank((String)newUniqueId)) {
                    synchResponse.setUniqueID(newUniqueId);
                }
                if (!TextUtil.isBlank((String)(newAssocId = (String)data.get(IBusGdsSabreContextKeys.PROFILE_SYNC_CREATE_ASSOCIATION_ID.name())))) {
                    synchResponse.setAssocID(newAssocId);
                }
                if (!TextUtil.isBlank((String)(profileName = (String)data.get(IBusGdsSabreContextKeys.PROFILE_SYNC_PROFILE_NAME.name())))) {
                    synchResponse.setProfileName(profileName);
                }
                if ((filters = (List)data.get(IBusGdsSabreContextKeys.PROFILE_SYNC_FILTERS_CREATED_OR_UPDATED.name())) != null) {
                    synchResponse.getPnrBuilders().addAll(filters);
                }
                if ((iBusMessages = ((Map)data.get("messages")).values()) != null) {
                    messages.addAll(iBusMessages);
                }
                SabreProfilesLoadProfileData loadProfileData = new SabreProfilesLoadProfileData();
                Person person = (Person)data.get(IBusGdsSabreContextKeys.PROFILE_SYNC_PARSED_PERSON.name());
                if (person != null) {
                    loadProfileData.setPerson(person);
                }
                if ((associatedProfiles = (List)data.get(IBusGdsSabreContextKeys.PROFILE_SYNC_PARSED_ASSOCIATED_PROFILES.name())) != null) {
                    loadProfileData.getAssociatedProfiles().addAll(associatedProfiles);
                }
                if ((udidValues = (List)data.get(IBusGdsSabreContextKeys.PROFILE_SYNC_PARSED_COST_CODES.name())) != null) {
                    loadProfileData.getUdidValues().addAll(udidValues);
                }
                if ((employmentInfo = (List)data.get(IBusGdsSabreContextKeys.PROFILE_SYNC_PARSED_EMPLOYMENT_INFO.name())) != null) {
                    loadProfileData.getEmploymentInfo().addAll(employmentInfo);
                }
                synchResponse.setLoadProfileData(loadProfileData);
                List profilesBaseData = (List)data.get(IBusGdsSabreContextKeys.PROFILE_SYNC_FOUND_PROFILES.name());
                if (profilesBaseData != null) {
                    synchResponse.getFoundProfiles().addAll(profilesBaseData);
                }
                if ((profileUpdateDate = (Date)data.get(IBusGdsSabreContextKeys.PROFILE_SYNC_UPDATE_DATE_TIME.name())) != null) {
                    synchResponse.setUpdateDate(profileUpdateDate);
                }
                Collection errors = (Collection)data.get(IBusGdsSabreContextKeys.PROFILE_SYNC_RESPONSE_ERRORS.name());
                Collection warnings = (Collection)data.get(IBusGdsSabreContextKeys.PROFILE_SYNC_RESPONSE_WARNINGS.name());
                if (errors != null) {
                    messages.addAll(errors);
                }
                if (warnings != null) {
                    messages.addAll(warnings);
                }
                if (!errors.isEmpty()) {
                    synchResponse.setResponseType(SabreProfilesSynchronizationResponseType.ERROR);
                } else if (!warnings.isEmpty()) {
                    synchResponse.setResponseType(SabreProfilesSynchronizationResponseType.WARNING);
                } else {
                    synchResponse.setResponseType(SabreProfilesSynchronizationResponseType.SUCCESS);
                }
            }
            catch (IntegrationBusException ibe) {
                this.log.error("process() : exception happened: " + ibe.toString());
                if (ibe.getCause() instanceof SoapFaultException && ibe.getMessage().contains("Authentication failed")) {
                    EntityContainer gdsAccountCont = (EntityContainer)data.get(IBusMidofficeContextKeys.GDS_ACCOUNT.name());
                    String ipcc = gdsAccountCont != null ? ((SabreGdsAccount)gdsAccountCont.getEntity()).getPrimaryPCC() : "";
                    messages.add(MessageHelper.createErrorMessage((String)Messages.sabreProfilesIPCCConnectionFailed, (Object[])new Object[]{ipcc}));
                }
                messages.add(MessageHelper.createExceptonMessage((String)Messages.sabreProfilesGeneralException, (Throwable)ibe, (Object[])new Object[0]));
            }
        }
        result.getMessages().addAll(messages);
        result.setDate(new Date());
        return result;
    }

    private static SabreProfilesAccessSettings getSabreProfilesAccessSettings() {
        SabreProfilesAccessSettings res = null;
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)BasicSystemSettingsIndex.Property.installationId.name(), (Object)"sabre-profiles-access-settings-uid"));
        List indices = EntityStorage.get().search(BasicSystemSettingsIndex.class, query).getData();
        if (indices == null) {
            return res;
        }
        for (BasicSystemSettingsIndex ind : indices) {
            EntityContainer setCont = EntityStorage.get().resolve(ind.getSource());
            if (setCont == null || !(setCont.getEntity() instanceof SabreProfilesAccessSettings) || !((SabreProfilesAccessSettings)setCont.getEntity()).isActive()) continue;
            res = (SabreProfilesAccessSettings)setCont.getEntity();
            break;
        }
        return res;
    }

    private Map<String, Object> prepareIbusContext(SabreProfilesSynchronizationRequest synchRequest, SalesContext salesContext, EntityReference<SabreGdsAccount> gdsAccount) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        EntityContainer gdsAccountCont = EntityStorage.get().resolve(gdsAccount);
        data.put(IBusGdsSabreContextKeys.PROFILE_SYNC_REQUEST.name(), synchRequest);
        data.put(IBusGdsSabreContextKeys.PROFILE_SYNC_TYPE.name(), synchRequest.getRequestType().name());
        data.put(IBusMidofficeContextKeys.GDS_ACCOUNT.name(), gdsAccountCont);
        data.put(IBusMidofficeContextKeys.SALES_CONTEXT.name(), salesContext);
        data.put(IBusGdsSabreContextKeys.CIR_SETTINGS.name(), synchRequest.getCirSettings());
        data.put(IBusGdsSabreContextKeys.CIR_AGENCY_TOKEN_REF.name(), synchRequest.getCirTokenAgencyRef());
        data.put(IBusGdsSabreContextKeys.CIR_ENDPOINT.name(), "sabreProfiles");
        return data;
    }

    private SalesContext createSalesContextAndCheckPCC(String pcc, String password, String currentUser, SabreProfilesAccessSettings accessSettings, List<Message> messages) {
        EntityReference<Person> customerRef = SabreProfilesSynchronizationHandler.findOrCreateCustomer(currentUser);
        boolean pccFound = false;
        boolean passwordCorrect = false;
        for (SabreProfilesAccessAccounts account : accessSettings.getUserAccounts()) {
            if (account == null || TextUtil.isBlank((String)account.getPcc()) || !pcc.equalsIgnoreCase(account.getPcc())) continue;
            pccFound = true;
            if (!TextUtil.isSame((String)password, (String)account.getPassword())) continue;
            passwordCorrect = true;
            break;
        }
        if (!pccFound) {
            messages.add(MessageHelper.createErrorMessage((String)"pccForSabreProfilesSynchNotFound", (Object[])new Object[]{pcc}));
            this.log.error("No pcc found for code: " + pcc + " in Sabre Profiles settings");
            return null;
        }
        if (!passwordCorrect) {
            messages.add(MessageHelper.createErrorMessage((String)"passwordForSabreProfilesSynchIsWrong", (Object[])new Object[]{pcc}));
            this.log.error("Incorrect password for pcc : " + pcc);
            return null;
        }
        SalesContext salesContext = new SalesContext();
        salesContext.setCustomer(customerRef);
        salesContext.setAgent(customerRef);
        return salesContext;
    }

    public static EntityReference<Person> findOrCreateCustomer(String loginName) {
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)PersonIndex.Property.loginName.name(), (Object)loginName));
        List lst = EntityStorage.get().search(PersonIndex.class, query).getData();
        EntityReference agent = null;
        if (!lst.isEmpty()) {
            agent = ((PersonIndex)lst.get(0)).getSource();
        }
        return agent;
    }

    private static IntegrationBusAdapter getAdapter(String adapterId) throws Exception {
        IntegrationBusAdapter adapter = IntegrationBusFacade.get().getRequestReplyAdapter(adapterId);
        if (adapter == null) {
            throw new IllegalArgumentException(String.format("no adapter with id '%s' found", adapterId));
        }
        return adapter;
    }
}

